<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if(!isset($_SESSION['user_id']) && !isset($_SESSION['email']))
{
	am_goto_page('/login');exit;
}

if (is_file('addons/windcave-payment-main/autoload.php')) {
    require_once 'addons/windcave-payment-main/autoload.php';
}

use WindcavePayment\HIT\HITClient;
include('addons/windcave-payment-main/src/HIT/HITClient.php'); 

use WindcavePayment\HIT\HITRequest;
include('addons/windcave-payment-main/src/HIT/HITRequest.php'); 

$Url    = "https://uat.windcave.com/pxmi3/pos.aspx";
$Userid = "LookSharpStoreHIT_Dev";
$Key    = "b55437cef6ab5494ae69cf527f93e9d6c9d17a1d75c2977d66806dda3508baf9";
$station = "3422430050";
$HIT = new HITClient( $Url, $Userid, $Key );
$order_id = base64_decode($_REQUEST['id']);


include('comman/top_header.php'); 
$data = get_order($order_id);
$cart_list = get_cart($_SESSION['store_id']);
 // echo"<pre>";print_r($cart_list[0]['cart_id']);exit;
// print_r($_POST);exit;

$type = isset($_GET['type']) ? $_GET['type'] : '';
$request = new HITRequest($station, $type);

switch (strtolower($type)) {
  case "refund":
      $result = refund();
      break;
  case "status":
      $result = status();
      break;
  case "ui":
      $result = button();
      break;
  case "receipt":
      $result = receipt();
      break;
  default:
      $result = purchase();
}

print <<<HTMLEOF
<html>
<head>
<title>Windcave HIT $type result</title>
</head>
<body>
<h1>Windcave HIT $type result</h1>
<table border=1>
<tr><th>Name</th><th>Value</th></tr>
HTMLEOF;

foreach ($result as $value) {
    if (isset($value['value'])) {
        echo "<tr><td>" . $value['tag'] . "</td><td>" . $value['value'] . "</td></tr>";
    }
}

print <<<HTMLEOF
</table>
</body>
</html>
HTMLEOF;

/**
 * purchase request
 */
function purchase(){
    global $HIT, $request;

    $http_host   = getenv("HTTP_HOST");
    $request_uri = getenv("SCRIPT_NAME");
    $server_url  = "http://$http_host";
    #$script_url  = "$server_url/$request_uri"; //using this code before PHP version 4.3.4
    #$script_url  = "$server_url$request_uri"; //Using this code after PHP version 4.3.4
    //  $script_url = (version_compare(PHP_VERSION, "4.3.4", ">=")) ?"$server_url$request_uri" : "$server_url/$request_uri";
    // $fail_url = (version_compare(PHP_VERSION, "4.3.4", ">=")) ?"$server_url$request_uri?rel=store_cart" : "$server_url/$request_uri";
    $fail_url = (version_compare(PHP_VERSION, "4.3.4", ">=")) ?"$server_url$request_uri?rel=payment_failed" : "$server_url/$request_uri";
    $script_url = (version_compare(PHP_VERSION, "4.3.4", ">=")) ?"$server_url$request_uri?rel=order_success" : "$server_url/$request_uri";
    $_SESSION['order_success'] = 1;

    $request->setAmount('10.00');
    $request->setCur('NZD');
    $request->setTxnRef("123");
    $request->setCur("NZD");
    $request->setDeviceId("Device 1");
    $request->setPosName("POS 1");
    $request->setPosVersion("Pos V1");
    $request->setVendorId("PXVendor");
    $request->setMRef("My Reference");
    $request->setUrlFail($script_url);
    $request->setUrlSuccess($script_url);

    // Call makeRequest function to obtain input XML
    $response = $HIT->makeRequest($request);

    // Parse output XML
    $complete = $response->get_element_text("Complete");
    $valid = $response->getXmlValue();
    return $valid;
}


/**
 * refund request
 */
function refund()
{
    global $HIT, $request;

    $http_host   = getenv("HTTP_HOST");
    $request_uri = getenv("SCRIPT_NAME");
    $server_url  = "http://$http_host";
    $script_url = (version_compare(PHP_VERSION, "4.3.4", ">=")) ?"$server_url$request_uri" : "$server_url/$request_uri";

    $request->setAmount('10.00');
    $request->setCur('NZD');
    $request->setTxnRef("123");
    $request->setDpsTxnRef("0000005400911209"); // if set, it means 'Matched refunds initiated via HIT request'. if not set, it means 'Unmatched refunds with refund card'
    $request->setCur("NZD");
    $request->setDeviceId("Device 1");
    $request->setPosName("POS 1");
    $request->setPosVersion("Pos V1");
    $request->setVendorId("PXVendor");
    $request->setMRef("My Reference");
    $request->setUrlFail($script_url);
    $request->setUrlSuccess($script_url);

    // Call makeRequest function to obtain input XML
    $response = $HIT->makeRequest($request);

    // Parse output XML
    $complete = $response->get_element_text("Complete");
    $valid = $response->getXmlValue();
    return $valid;
}

/**
 * status request
 */
function status()
{
    global $HIT, $request;

    $request->setTxnRef("123");

    // Call makeRequest function to obtain input XML
    $response = $HIT->makeRequest($request);
    // Parse output XML
    $complete = $response->get_element_text("Complete");
    $valid = $response->getXmlValue();
    return $valid;
}

/**
 * button request
 */
function button()
{
    global $HIT, $request;

    $request->setUiType("Bn");
    $request->setName("B1");
    $request->setVal("YES");
    $request->setTxnRef("12345678");

    // Call makeRequest function to obtain input XML
    $response = $HIT->makeRequest($request);

    // Parse output XML
    $complete = $response->get_element_text("Complete");
    $valid = $response->getXmlValue();
    return $valid;
}

/**
 * receipt request
 */
function receipt()
{
    global $HIT, $request;

    $request->setTxnRef("123");
    $request->setDuplicateFlag(0);
    $request->ReceiptType(2);

    // Call makeRequest function to obtain input XML
    $response = $HIT->makeRequest($request);

    // Parse output XML
    $complete = $response->get_element_text("Complete");
    $valid = $response->getXmlValue();
    return $valid;
}

?>

<div id="content">
    <?php include('comman/leftside_menu.php');?>
    Dynamic Payment message here...
</div>
