<?php
class InventoryWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        
        //$this->CronWrapper = new CronWrapper();
        

    }

	public function uploadPath()
	{
		return Config::$baseUrl."/upload";
	}
	
	public  function setTimeZone($merchant_id='')
	{
		$website_timezone=$this->functions->getOptionAdmin('website_timezone');
	    if (!empty($website_timezone)){
	 	   date_default_timezone_set($website_timezone);
	    }	
	    if(!empty($merchant_id)){
	    	$mt_timezone=$this->functions->getOption("merchant_timezone", (integer) $merchant_id);			
	    	if (!empty($mt_timezone)){
	    		date_default_timezone_set($mt_timezone);
	    	}    	
	    }
	}
	
	
	
	
	public function userType()
	{
		return array(
		  'merchant'=>"Merchant",
		  'admin'=>"Administrator",		  
		);
	}
	
	public function getPageTitle($page_id='')
	{						
		$page_title = array(
    '404' => "Page not found",
    'index' => "Login",
    'dashboard' => "Dashboard",
    'admin_merchant_list' => "Merchant list",
    'admin_access_rights' => "Access rights",
    'admin_create_role' => "Create role",
    'admin_low_stock_logs' => "Low stock",
    'admin_general' => "General settings",
    'admin_settings_reports' => "Settings reports",
    'admin_databaseupdate' => "Settings database",
    'admin_cronjobs' => "Settings cron jobs",
    'settings' => "Settings",
    'merchant_list' => "Merchant List",
    'item_list' => "Item list",
    'item_item_new' => "Item new",
    'item_category_list' => "Category list",
    'item_category_add' => "Category add/update",
    'item_addon_category_list' => "Addon list",
    'item_addon_category_add' => "Addon add/update",
    'item_size_list' => "Size List",
    'item_size_list_add' => "Size add/update",
    'item_ingredients_list' => "Ingredients",
    'item_ingredients_add' => "Ingredients add/update",
    'item_cooking_list' => "Cooking Reference",
    'item_cooking_add' => "Cooking Reference add/update",
    'item_addon_item_list' => "Addon item",
    'item_addon_add' => "Addon item add/update",
    'stocks_adjustment_list' => "Stock adjustments",
    'reports_sales_summary' => "Sales summary",
    'reports_sales_item' => "Sales by item",
    'reports_sales_category' => "Sales by category",
    'reports_sales_payment_type' => "Sales by payment type",
    'reports_sales_receipt' => "Receipts",
    'reports_sales_by_addon' => "Sales by addon",
    'stocks_order_list' => "Purchase order",
    'stocks_purchase_new' => "Create purchase order",
    'stocks_adjustment_new' => "Create stock adjustments",
    'stocks_supplier_list' => "Supplier",
    'stocks_supplier_new' => "Create supplier",
    'stocks_history' => "Inventory history",
    'stocks_valuation' => "Inventory valuation",
    'reports_userlist' => "User list",
    'reports_add_user' => "Create user",
    'reports_access_rights' => "Access rights",
    'reports_create_role' => "Add role",
    'reports_general' => "Settings",
    'reports_settings_reports' => "Reports",
    'reports_databaseupdate' => "Database update",
    'reports_cronjobs' => "Cron jobs",
    'profile' => "Profile",
    'admin_update_data' => "Update data"
);

		if(array_key_exists($page_id,$page_title)){
			return $page_title[$page_id];
		}
		return false;
	}
	
	
	
	
	
	public function prettyQuantity($qty=0)
	{
		if(is_numeric($qty)){
			return number_format($qty,0,0,',');
		}
		return 0;
	}
	
	public  function prettySKU($sku='')
	{
		if(!empty($sku)){
		  return "SKU"." ".$sku;
		}
		return false;
	}
	
	public function prettyItemName($item_name='',$size='',$sku='')
	{
		if(!empty($item_name)){
			if(!empty($size)){
				$item_name.=" ($size)";
			}
			return $item_name."<div class=\"text-muted\">".$this->prettySKU($sku)."</div>";
		}
		return false;
	}
	
	public function dropdownFormat($data=array(),$value='', $label='', $default_value=array())
	{				
		$list = array();
		if(is_array($default_value) && count($default_value)>=1){
			$list = $default_value;
		} else $list['']='';		
		if(is_array($data) && count($data)>=1){
			foreach ($data as $val) {
				if(isset($val[$value]) && isset($val[$label])){
			 	   $list[ $val[$value] ] = ($val[$label]);
				}
			}
		}
		return $list;
	}



    public  function prepareReceipt($order_id='')
    {
        $_GET['backend']=true; $print = array();        
        if ( $data = $this->functions->getReceiptByID($order_id)){
            
            
            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $this->functions->getCurrencyCode() ;
            
            
            if ( $json_details !=false){
                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               
               /* Custom code 13 starts */
               'promo_id'=>$data['promo_id'],
               /* Custom code 13 ends */
               
               'tax_set'=>isset($data['tax'])?$data['tax']:'',
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
              ),$json_details,true,$order_id);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>$this->functions->translation("default","ABN"),
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>$this->functions->translation("default","Telephone"),'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];
        
            $print[]=array('label'=>$this->functions->translation("default","Address"),'value'=>$full_merchant_address);
            
            $print[]=array('label'=>$this->functions->translation("default","TRN Type"),'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Payment Type"),
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>$this->functions->translation("default","Card#"),'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>$this->functions->translation("default","Paypal Transaction ID"),
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>$this->functions->translation("default","Reference #"),
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            
            if($data['request_from']=="pos" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );
            
            
            
            }
            
            
            
            if($data['request_from']=="webappv2" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );

            
            }
            
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Payment Ref"),
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Card #"),
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>$this->functions->translation("default","TRN Date"),
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>$this->functions->translation("default","Delivery Date"),
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$this->functions->translation("default","Delivery Time"),
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?t("Yes"):'';
                        $print[]=array(
                         'label'=>$this->functions->translation("default","Deliver ASAP"),
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Deliver to"),
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Delivery Instruction"),
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Location Name"),
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                //  Custom code 12 starts
                    if($data['car_park_enable']== 1 && isset($data['number_plate']) && !empty($data['number_plate'])){
                        $print[]=array('label'=>"Car Park Delivery",'value'=>"Yes");
                        $print[]=array('label'=>"Number Plate",'value'=>$data['number_plate']); 
                     }
                //  Custom code 12 ends
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            return array(
             'merchant_id'=>$merchant_id,
             'print'=>$print,
             'raw'=>$displayOrderHTML['raw'],
             'data'=>$data,
             'additional_details'=>""
            );
            
        } else throw new Exception( ("order not found"));
    }

	
	
	
	
			
	public function insertInventorySale($order_id = '', $status = '', $merchant_id = '')
{
    $merchant_id = (integer) $merchant_id;

    $accepted_status = $this->functions->getOptionAdmin('inventory_accepted_order_status');
    $cancel_status = $this->functions->getOptionAdmin('inventory_cancel_order_status');

    $accepted_status = !empty($accepted_status) ? json_decode($accepted_status, true) : array('pending', 'paid');
    $cancel_status = !empty($cancel_status) ? json_decode($cancel_status, true) : array('cancelled', 'decline', 'cancel');

    $transaction_type = '';

    

    if (in_array($status, (array)$accepted_status)) {
        $transaction_type = 'sale';
    }
    if (in_array($status, (array)$cancel_status)) {
        $transaction_type = 'cancelled';
    }

    $merge_status = array_merge((array)$accepted_status, (array)$cancel_status);

    $order_id = (integer) $order_id;
    if ($order_id > 0) {

        // Check if record exists
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_inventory_sales 
            WHERE order_id = :order_id AND transaction_type = :transaction_type
            LIMIT 1
        ");
        $stmt->execute([
            ':order_id' => $order_id,
            ':transaction_type' => $transaction_type,
        ]);

        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {

             
            if (in_array($status, (array)$merge_status)) {

                $params = array(
                    'order_id' => $order_id,
                    'transaction_type' => $transaction_type,
                    'order_status' => trim($status),
                    'created_at' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                );

                // Use the existing insertData function for insertion
                $last_insert_id = $this->functions->insertData('mt_inventory_sales', $params);
                if ($last_insert_id !== false) {
                    //CronWrapper::processInventorySale();
                    $this->CronWrapper = new CronWrapper();
                    $this->CronWrapper->processInventorySale();
                    return true;
                } else {
                    throw new Exception("Failed, cannot insert records");
                }
            } else {
                throw new Exception("Status not accepted");
            }
        }
    } else {
        throw new Exception("Invalid order id");
    }
}

	
	public function prettyDate($date = '', $date_format = '[M] d,Y')
{
    if (!empty($date)) {
        if (empty($date_format)) {
            $date_format = "[M] d,Y";
        }
        $date = date($date_format, strtotime($date));

        $date = strtr($date, array(
            '[Jan]' => "Jan",
            '[Feb]' => "Feb",
            '[Mar]' => "Mar",
            '[Apr]' => "Apr",
            '[May]' => "May",
            '[Jun]' => "Jun",
            '[Jul]' => "Jul",
            '[Aug]' => "Aug",
            '[Sep]' => "Sep",
            '[Oct]' => "Oct",
            '[Nov]' => "Nov",
            '[Dec]' => "Dec",
        ));

        return $date;
    }
    return false;
}

	
	public  function reportsRange()
	{
		return 7;
	}
	
	public function dateRangeTrans()
{
    return array(
        'format' => "MMM DD, Y",
        'separator' => " - ",
        'applyLabel' => "Apply",
        'cancelLabel' => "Cancel",
        'fromLabel' => "From",
        'toLabel' => "To",
        'customRangeLabel' => "Custom",
        'weekLabel' => "W",
        'daysOfWeek' => array("Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"),
        'monthNames' => array(
            "January", "February", "March", "April",
            "May", "June", "July", "August", "September",
            "October", "November", "December"
        )
    );
}

	
	public  function datetimeDefaultLanguage()
	{
		return 'en';		
	}
	
	public  function validDate($date) {
       $tempDate = explode('-', $date);  
       return checkdate($tempDate[1], $tempDate[2], $tempDate[0]);
    }
    
  public function getOrderList($merchant_id = '')
{
    try {
        if ($merchant_id <= 0) {
            $stmt = "
                SELECT * FROM mt_order_status
                WHERE merchant_id IN ('0')
                ORDER BY description ASC
            ";
        } else {
            $stmt = "
                SELECT * FROM mt_order_status
                WHERE merchant_id IN ('0', :merchant_id)
                ORDER BY description ASC
            ";
        }

        $query = $this->db->prepare($stmt);

        if ($merchant_id > 0) {
            $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
        }

        $query->execute();
        $resp = $query->fetchAll(PDO::FETCH_ASSOC);

        return $resp ?: false;
    } catch (PDOException $e) {
        // Handle exception if needed
        return false;
    }
}

    
    
    
    public function getRemainingStocks($merchant_id = 0, $item_id = 0)
{
    try {
        $data = array();
        
        $stmt = "
            SELECT item_id, with_size, size_id, size_name, track_stock, available_stocks
            FROM mt_view_item_stocks
            WHERE merchant_id = :merchant_id AND item_id = :item_id
            ORDER BY item_size_id ASC
        ";
        
        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
        $query->bindValue(':item_id', (int)$item_id, PDO::PARAM_INT);
        $query->execute();
        
        $resp = $query->fetchAll(PDO::FETCH_ASSOC);
        
        return $resp ?: false;
    } catch (PDOException $e) {
        // Handle exception if needed
        return false;
    }
}
       
    
    public  function hideItemOutStocks($merchant_id='')
    {
    	$hide = $this->functions->getOptionAdmin('inventory_hide_out_stock');
    	if($hide!=1){    		
    		$hide = $this->functions->getOption('inventory_hide_out_stock',$merchant_id);
    	}
    	if($hide==1){
    		return true;
    	} else return false;    	
    }
    
    public  function allowNegativeStock($merchant_id='')
    {
    	$allow = $this->functions->getOptionAdmin('inventory_allow_negative_order');
    	if($allow!=1){    		
    		$allow = $this->functions->getOption( 'inventory_allow_negative_order',(integer) $merchant_id);
    	}
    	if($allow==1){
    		return true;
    	} else return false;    	
    }
    
  			
	    
}
/*END CLASS*/