<?php
class OrderWrapper
{

    public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();

        $this->FoodItemWrapper=new FoodItemWrapper();
        
        //$this->CronWrapper = new CronWrapper();
        

    }


   public function getAllOrder($today_order = true, $order_type = '', $merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    $order_by = 'ORDER BY order_id ASC';
    $todays_date = date("Y-m-d");
    $merchant_id = (int)$merchant_id;
    $start = (int)$start;
    $total_rows = (int)$total_rows;

    if (!empty($search_string)) {
        $search_string_escaped = addslashes($search_string);
        $and .= "
            AND (
                a.order_id = " . (int)$search_string . "
                OR b.first_name LIKE '" . $search_string_escaped . "%'
            )
        ";
    }

    if (!empty($order_type)) {
        switch ($order_type) {
            case "incoming":
                $stats = $this->getStatusFromSettings('order_incoming_status', ['pending', 'paid']);
                $and .= " AND a.status IN ($stats) AND request_cancel='2'";
                $and .= " AND CAST(a.date_created as DATE) BETWEEN '$todays_date' AND '$todays_date'";
                break;

            case "outgoing":
                $stats = $this->getStatusFromSettings('order_outgoing_status', ['accepted', 'delayed']);
                $and .= " AND a.status IN ($stats) AND request_cancel='2'";
                $and .= " AND CAST(a.delivery_date as DATE) BETWEEN '$todays_date' AND '$todays_date'";
                break;

            case "ready":
                $stats = $this->getStatusFromSettings('order_ready_status', ['ready for delivery']);
                $and .= " AND a.status IN ($stats) AND request_cancel='2'";
                $and .= " AND CAST(a.delivery_date as DATE) BETWEEN '$todays_date' AND '$todays_date'";
                break;

            case "cancel_order":
                $and .= " AND a.status NOT IN ('initial_order') AND request_cancel = '1'";
                break;

            case "all":
                $and .= " AND a.status NOT IN ('initial_order')";
                $order_by = 'ORDER BY order_id DESC';
                break;
        }
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.order_id, a.merchant_id, a.total_w_tax AS total_order_amount,
            a.status, a.status AS status_raw, a.trans_type, a.trans_type AS trans_type_raw,
            a.date_created,
            a.delivery_date, a.delivery_time,
            a.request_cancel,
            a.date_modified,
            a.delivery_asap,
            CONCAT(b.first_name, ' ', b.last_name) AS customer_name,  
            b.estimated_time, b.estimated_date_time,
            b.used_currency,
            b.base_currency,
            b.exchange_rate,
            (
                SELECT COUNT(*) FROM mt_order_details
                WHERE order_id = a.order_id
            ) AS total_items
        FROM mt_order a
        LEFT JOIN mt_order_delivery_address b ON a.order_id = b.order_id
        WHERE a.merchant_id = $merchant_id
        AND a.request_from != 'pos'
        $and
        $order_by
        LIMIT $start, $total_rows
    ";

    $query = $this->db->query($stmt);
    if ($query) {
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    return false;
}
       


  public function getAllOrder_print($today_order = true, $order_type = '', $merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    $order_by = 'ORDER BY order_id ASC';
    $todays_date = date("Y-m-d");

    if (!empty($search_string)) {
        $and .= "
        AND (
            a.order_id = :search_id
            OR
            b.first_name LIKE :search_string
        )";
    }

    $stats = $this->getStatusFromSettings('order_incoming_status', ['pending', 'paid']);
    $and .= " AND a.status IN ($stats)
              AND request_cancel = '2' 
              AND a.auto_print = 0";
    $and .= " AND CAST(a.date_created as DATE) BETWEEN :todays_date AND :todays_date";

    $stmt = $this->db->prepare("
        SELECT SQL_CALC_FOUND_ROWS 
            a.order_id, 
            a.merchant_id,
            a.total_w_tax AS total_order_amount,
            a.status,
            a.status AS status_raw,
            a.trans_type, 
            a.trans_type AS trans_type_raw,
            a.date_created,
            a.delivery_date,
            a.delivery_time,
            a.request_cancel,
            a.date_modified,
            a.delivery_asap,
            a.*,
            CONCAT(b.first_name, ' ', b.last_name) AS customer_name,  
            b.estimated_time, 
            b.estimated_date_time,
            b.used_currency,
            b.base_currency,
            b.exchange_rate,
            (
                SELECT COUNT(*) 
                FROM mt_order_details 
                WHERE order_id = a.order_id
            ) AS total_items
        FROM mt_order a
        LEFT JOIN mt_order_delivery_address b 
        ON a.order_id = b.order_id
        WHERE a.merchant_id = :merchant_id
        $and
        $order_by
        LIMIT 1
    ");

    $stmt->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':todays_date', $todays_date, PDO::PARAM_STR);

    if (!empty($search_string)) {
        $stmt->bindValue(':search_id', (int)$search_string, PDO::PARAM_INT);
        $stmt->bindValue(':search_string', $search_string . '%', PDO::PARAM_STR);
    }

    if ($stmt->execute()) {
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    return false;
}

    
    public  function getActionStatus($action='')
    {
        $status='';
        switch ($action) {
            case "accept":              
                $order_action_accepted_status = $this->functions->getOptionAdmin('order_action_accepted_status');
                $status = !empty($order_action_accepted_status)?$order_action_accepted_status:'accepted';
                break;
            case "ready_for_delivery":
                $status = 'ready for delivery';
                break;
                
            case "decline_order":
            case "decline": 
                //$status = 'decline';
                $stats = $this->functions->getOptionAdmin('order_action_decline_status');
                $status = !empty($stats)?$stats:'decline';
                break;
                
            case "cancel_order":    
                //$status = 'cancelled';
                $stats = $this->functions->getOptionAdmin('order_action_cancel_status');
                $status = !empty($stats)?$stats:'cancelled';
                break;
            
            case "food_is_done":
                //$status = 'ready for delivery';
                $stats = $this->functions->getOptionAdmin('order_action_food_done_status');
                $status = !empty($stats)?$stats:'ready for delivery';
                break;
                
            case "delay_order": 
                //$status = 'delayed';
                $stats = $this->functions->getOptionAdmin('order_action_delayed_status');
                $status = !empty($stats)?$stats:'delayed';
                break;
                
            case "complete_order":  
                //$status = 'completed';
                $stats = $this->functions->getOptionAdmin('order_action_completed_status');
                $status = !empty($stats)?$stats:'completed';
                break;
                    
            case "approved_cancel_order":    
               //$status = 'cancelled';
               $stats = $this->functions->getOptionAdmin('order_action_approved_cancel_order');
               $status = !empty($stats)?$stats:'cancelled';
               break;
               
            case "decline_cancel_order":
                //$status = 'pending';
                $stats = $this->functions->getOptionAdmin('order_action_decline_cancel_order');
               $status = !empty($stats)?$stats:'pending';
                break;  
               
            default:
                $status = 'unknow status';
                break;
        }
        return $status;
    }


   public function validateOrder($merchant_id = '', $order_id = '')
{
    $stmt = $this->db->prepare("SELECT order_id, delivery_date, delivery_time, date_created 
                               FROM mt_order 
                               WHERE merchant_id = :merchant_id AND order_id = :order_id 
                               LIMIT 1");
    
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':order_id', $order_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }
    return false;
}

public function getOrder($merchant_id = '', $order_id = '')
{
    $stmt = $this->db->prepare("SELECT order_id, status 
                               FROM mt_order 
                               WHERE merchant_id = :merchant_id AND order_id = :order_id 
                               LIMIT 1");
    
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':order_id', $order_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }
    throw new Exception("Order id not found");
}


public  function updateOrderHistory($order_id='',$merchant_id,$params=array(),$params2=array())
    {       
        if($order_id>0){
            if($this->validateOrder($merchant_id,$order_id)){
                if ( $this->functions->insertData("mt_order_history",$params)){
                    
                    $up=$this->functions->updateData("mt_order",$params2,'order_id',$order_id);
                    return true;
                } else throw new Exception( "Failed cannot insert records" );
            } else throw new Exception( "Order id not found" );
        }
        throw new Exception( "Invalid order id" );
    }
    
    public function orderStatusList($merchant_id = '', $remove_cancel = false)
{
    $data = array();
    $and = "";

    if ($remove_cancel) {
        $remove_cancel_status = $this->functions->getOptionAdmin('merchantapp_remove_cancel_status');
        if ($remove_cancel_status == 1) {
            $cancel_status = $this->getActionStatus('cancel_order');
            $and .= " AND description NOT IN ($cancel_status)";
        }
    }

    $stmt = $this->db->prepare("
        SELECT description 
        FROM mt_order_status
        WHERE merchant_id IN ('0', :merchant_id)
        $and
        ORDER BY description ASC
    ");
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($res as $val) {
            $data[] = array(
                'value' => $val['description'],
                'label' => $val['description'],
            );
        }
        return $data;
    }

    return false;
}


public function orderStatusListPaginate($merchant_id = '', $start = 0, $total_rows = 10, $search_string = '')
{
    $data = array();
    
    $stmt = $this->db->prepare("
        SELECT description 
        FROM mt_order_status
        WHERE merchant_id IN ('0', :merchant_id)
        ORDER BY description ASC
        LIMIT :start, :total_rows
    ");
    
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':start', (int)$start, PDO::PARAM_INT);
    $stmt->bindValue(':total_rows', (int)$total_rows, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($res as $val) {
            $data[] = array(
                'value' => $val['description'],
                'label' => $val['description'],
            );
        }
        return $data;
    }
    
    return false;
}

    
    public function AllOrderStatus()
{
    $stmt = $this->db->prepare("
        SELECT description 
        FROM mt_order_status
        ORDER BY description ASC
    ");
    
    if ($stmt->execute()) {
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    return false;
}


public function updateEstimationTime($order_id = '', $estimation_delay = 0)
{
    // Check if order exists
    $stmt = $this->db->prepare("
        SELECT order_id, estimated_time 
        FROM mt_order_delivery_address 
        WHERE order_id = :order_id 
        LIMIT 1
    ");
    $stmt->bindValue(':order_id', (int)$order_id, PDO::PARAM_INT);
    $stmt->execute();
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        // Calculate new estimated time
        $estimated_date_time = date("Y-m-d H:i:s", strtotime("+$estimation_delay minutes"));
        
        // Parameters for update
        $params = array(
            'estimated_date_time' => $estimated_date_time,
            'ip_address' => $_SERVER['REMOTE_ADDR']
        );

        // Update the mt_order_delivery_address table
        $this->functions->updateData("mt_order_delivery_address", $params, 'order_id', $order_id);

        return true;
    }

    return false;
}

public function getReceiptByID($order_id = 0, $client_id = 0)
{
    $and = '';
    $order_id = (int)$order_id;
    $client_id = (int)$client_id;

    if ($client_id > 0) {
        $and = " AND a.client_id = :client_id ";
    }

    // Main query to fetch order receipt details
    $stmt = $this->db->prepare("
        SELECT a.*,
            CONCAT(b.first_name,' ',b.last_name) AS full_name,
            b.location_name,
            CONCAT(b.street,' ',b.area_name,' ',b.city,' ',b.state,' ',b.zipcode) AS full_address,
            b.contact_phone,
            b.contact_phone AS customer_phone,
            b.opt_contact_delivery,
            b.contact_email AS email_address,
            b.contact_email AS customer_email,
            b.estimated_time, 
            b.estimated_date_time,
            b.google_lat AS location_lat, 
            b.google_lng AS location_lng,
            b.used_currency,
            b.base_currency,
            b.exchange_rate,
            b.service_fee,
            b.service_fee_applytax,
            c.restaurant_name AS merchant_name,
            c.restaurant_phone AS merchant_contact_phone,
            CONCAT(c.street,' ',c.city,' ',c.state,' ',c.post_code) AS merchant_address,
            c.street AS merchant_street,    
            c.city AS merchant_city,    
            c.state AS merchant_state,  
            c.post_code AS merchant_post_code,
            c.merchant_print,
            c.merchant_print_customreceipt_after_accept
        FROM mt_order a
        LEFT JOIN mt_order_delivery_address b ON a.order_id = b.order_id
        LEFT JOIN mt_merchant c ON a.merchant_id = c.merchant_id
        WHERE a.order_id = :order_id
        $and
        LIMIT 1
    ");
    
    // Bind values
    $stmt->bindValue(':order_id', $order_id, PDO::PARAM_INT);
    if ($client_id > 0) {
        $stmt->bindValue(':client_id', $client_id, PDO::PARAM_INT);
    }

    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // Fixed old data: If full name is empty, get it from mt_client
        if (empty(trim($res['full_name']))) {
            $stmt2 = $this->db->prepare("
                SELECT CONCAT(first_name,' ',last_name) AS full_name, contact_phone
                FROM mt_client
                WHERE client_id = :client_id
            ");
            $stmt2->bindValue(':client_id', $res['client_id'], PDO::PARAM_INT);
            $stmt2->execute();
            $res2 = $stmt2->fetch(PDO::FETCH_ASSOC);
            
            if ($res2) {
                $res['full_name'] = $res2['full_name'];
                $res['contact_phone'] = $res2['contact_phone'];
            }
        }

        return $res;
    }

    return false;
}



public  function prepareReceipt($order_id='', $with_symbol = true)
    {       
        $details_details = array(); $data = array(); $order_details=array();
        
        $default_currency = $this->functions->getCurrencyCode();
        $enabled_trans = $this->functions->multipleField();


        
        if ($data=$this->getReceiptByID($order_id)){


                    
            /*MC*/
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $default_currency;
            
                            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;

            if ( $json_details !=false){

                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
               'promo_id'=>$data['promo_id'],
               'tax_set'=>$data['tax'],
             ),$json_details,true,$order_id);


            }   
            
            //custom code 9 starts
            $data['merchant_tax_number']=$this->functions->getOption('merchant_tax_number',$merchant_id); 
            //custom code 9 ends
            
            $details_details['order_id']=$data['order_id'];
            $details_details['merchant_name']= $this->functions->clearString($data['merchant_name']);         
            $details_details['merchant_contact_phone']= $this->functions->clearString($data['merchant_contact_phone']);
            $details_details['merchant_address']= $this->functions->clearString($data['merchant_address']);
            
            $details_details['request_cancel']=$data['request_cancel'];
            $details_details['customer_name']=$data['full_name'];           
            $details_details['date_created']=$this->functions->prettyDate($data['date_created'])." ".$this->functions->prettyTime($data['date_created']);     
            $details_details['payment_type_raw'] = $data['payment_type'];
// custom disable   $details_details['payment_type']=self::prettyPaymentType($data['payment_type'],$data['trans_type']);

            // Custom code 9 starts 
            
				  //$details_details['payment_type']="Paid";

                 

                  if($data['payment_type']=="pyr"){
                    $type_payment='pyr_merchant_slip';
                  }else{
                    $type_payment=$data['payment_type'];
                  }

                  $details_details['payment_type']=$this->functions->payment_translations($data['trans_type'],$type_payment,$data['is_sop']);
                  
    




                
			
            // Custom code 9 ends   
                
            $details_details['trans_type'] = ($data['trans_type']);
            $details_details['trans_type_raw'] = $data['trans_type'];
            
            $details_details['status']=($data['status']);
            $details_details['status_raw']=$data['status'];
            
                        
            $details_details['estimated_time']=$data['estimated_time'];
            $details_details['estimated_date_time']=$data['estimated_date_time'];
            
            /* custom code 12 starts */
            $details_details['car_park_enable']=$data['car_park_enable'];
            $details_details['number_plate']=$data['number_plate'];
            /* custom code 12 ends */
            
            $details_details['sub_total']=$data['sub_total'];
            $details_details['total']=$this->functions->prettyPrice($data['total_w_tax'], $with_symbol);
            $details_details['delivery_address']=$data['full_address'];
            $details_details['location_lat']=!empty($data['location_lat'])?$data['location_lat']:'';
            $details_details['location_lng']=!empty($data['location_lng'])?$data['location_lng']:'';
            
            $details_details['contact_phone']=$data['contact_phone'];
            $details_details['delivery_date']=$this->functions->prettyDate($data['delivery_date']);
            $details_details['delivery_time']=$this->functions->prettyTime($data['delivery_time']);
            
            $date_now = date('Ymd'); $pre_order = 0; $pre_order_msg='';
            $delivery_date=$data['delivery_date'];
            $delivery_date=date("Ymd",strtotime($delivery_date));           
            if($delivery_date>$date_now){
                $pre_order = 1;
                $dtime = !empty($data['delivery_time'])?date("g:ia",strtotime($data['delivery_time'])):'';
                

                 $pre_order_msg = "This is advance order on ".$this->functions->prettyDate($data['delivery_date']);

            }
            
            $details_details['pre_order']=$pre_order;
            $details_details['pre_order_msg']=$pre_order_msg;
            
            $details_details['delivery_asap']=$data['delivery_asap'];
            $details_details['delivery_instruction']=$data['delivery_instruction'];
            $details_details['location_name']=$data['location_name'];
            $details_details['order_change_raw']=$data['order_change'];
            $details_details['order_change']=$this->functions->prettyPrice($data['order_change'],$with_symbol);
            
            $details_details['payment_gateway_ref']=$data['payment_gateway_ref'];
            $details_details['dinein_number_of_guest']=$data['dinein_number_of_guest'];
            $details_details['dinein_special_instruction']=$data['dinein_special_instruction'];
            $details_details['dinein_table_number']=$data['dinein_table_number'];
            
            $details_details['opt_contact_delivery']=$data['opt_contact_delivery'];
            if($data['opt_contact_delivery']>=1){
                $details_details['opt_contact']=array(
                  'label'=>"Delivery options",
                  'value'=>"Leave order at the door or gate"
                );
            }
            
            if($data['payment_type']=="ocr"){
                if($creditcard_info = $this->functions->getCreditCardInfo($data['client_id'],$data['cc_id'])){
                    $details_details['card_information']=array(
                      'card_name'=>$creditcard_info['card_name'],
                      'mask_card_number'=>$creditcard_info['credit_card_number'],
                      'expiration'=>$creditcard_info['expiration_month']."/".$creditcard_info['expiration_yr'],
                      'billing_address'=>$creditcard_info['billing_address']
                    );
                }
            }
                        
            $raw = $displayOrderHTML['raw'];           
                        
            foreach ($raw['item'] as $item){
                $price = $item['normal_price']; $qty = $item['qty']; $addon_total=0;
                if($item['discount']>0){
                   $price = $item['discounted_price']; 
                }
                
                /* Custom code 13 starts */
                $promo_id = $item['promo_id'];
                /* Custom code 13 ends */
                
                $item_total = (integer)$qty* (float) $price; 
                
                $item_name=''; $line_items = array(); 
                                
                $item_name = $this->functions->qTranslate($item['item_name'],'item_name',
                $item['item_name_trans'],$enabled_trans);                
                
                $size_name = $this->functions->qTranslate($item['size_words'],'size_name',
                isset($item['size_name_trans'])?$item['size_name_trans']:array(),$enabled_trans);               
                
                if(!empty($item['size_words'])){

                   

                   $item_name = $item_name."(".$size_name.")";



                } else $item_name = $item['item_name'];
                
                /*SUB*/             
                $line_sub_item=array(); $subitem =array();
                if(isset($item['new_sub_item'])){
                    if(is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
                        foreach ($item['new_sub_item'] as $sub_item_cat => $sub_item){  
                            $subitem = array();
                            foreach ($sub_item as $sub_item_val) {
                                $sub_item_total = (float)$sub_item_val['addon_qty']*(float)$sub_item_val['addon_price'];
                                
                                $addon_name =  $this->functions->qTranslate($sub_item_val['addon_name'],'sub_item_name',
                                isset($sub_item_val['sub_item_name_trans'])?$sub_item_val['sub_item_name_trans']:array(),
                                $enabled_trans);   
                                
                                $addon_category = $this->functions->qTranslate($sub_item_cat,'subcategory_name',
                                isset($sub_item_val['subcategory_name_trans'])?$sub_item_val['subcategory_name_trans']:array(),
                                $enabled_trans);  
                                
                                $subitem[] = array(
                                  'name'=>$addon_name,
                                  'qty'=>$sub_item_val['addon_qty'],
                                  'price'=>$this->functions->prettyPrice($sub_item_val['addon_price'],$with_symbol),
                                  'sub_item_total'=>$this->functions->prettyPrice($sub_item_total,$with_symbol),
                                );
                                $line_sub_item[$sub_item_cat]= array(
                                  'addon_category'=>$addon_category,
                                  'item'=>$subitem
                                );
                            }
                        }                                               
                    }
                }
                                
                $item_total_price = (float)$qty*(float)$price;
                
                $cooking_ref = $this->functions->qTranslate($item['cooking_ref'],'cooking_name',
                isset($item['cooking_name_trans'])?$item['cooking_name_trans']:array(),$enabled_trans);
                
                $ingredients = array();  $resp_ingredients='';
                if(isset($item['ingredients'])){
                   if(is_array($item['ingredients']) && count($item['ingredients'])>=1){
                      foreach ($item['ingredients'] as $ingredients_name) {
                         if(!$resp_ingredients = $this->FoodItemWrapper->getIngredientsByName($ingredients_name,$enabled_trans)){
                            $resp_ingredients = stripslashes($ingredients_name);
                         }
                         $ingredients[]=$resp_ingredients;
                      }
                   }
                }
                
                
                $line_items[]=array(
                  'name'=>$item_name,
                  'qty'=>$qty,
                  'price'=>$this->functions->prettyPrice($item['normal_price'],$with_symbol),
                  'discount'=>$item['discount'],
                  'price_after_discount'=>$this->functions->prettyPrice($price,$with_symbol),
                  'item_total_price'=>$this->functions->prettyPrice($item_total_price,$with_symbol),
                  'cooking_ref'=>$cooking_ref,
                  'order_notes'=>$item['order_notes'],
                  'ingredients'=>$ingredients,
                  
                  /* Custom code 13 starts */
                  'promo_id'=>$promo_id,
                  /* custom code 13 ends */
                  
                  'sub_item'=>$line_sub_item
                );
                
                $category_name = $this->functions->qTranslate($item['category_name'],'category_name',
                isset($item['category_name_trans'])?$item['category_name_trans']:array()
                ,$enabled_trans);   
                
                $order_details[]=array(
                  'category_name'=>$category_name,
                  'item'=>$line_items
                );
            }           
            
            /*TOTAL*/
            $total_details = array();
            $total = $raw['total'];
            
            $total_details['apply_food_tax'] = $data['apply_food_tax'];
            
            /*EURO TAX*/
            if($data['apply_food_tax']==1 && $data['tax']>0){    

              
                                        
                $grand_total = isset($total['subtotal'])?(float)$total['subtotal']:0;
                $grand_total+= isset($total['delivery_charges'])?(float)$total['delivery_charges']:0;
                $grand_total+= isset($total['merchant_packaging_charge'])?(float)$total['merchant_packaging_charge']:0;
                $grand_total+= isset($total['service_fee'])?(float)$total['service_fee']:0;
                $grand_total+= isset($total['card_fee'])?(float)$total['card_fee']:0;
                $grand_total+= isset($total['tips'])?(float)$total['tips']:0;               
                
                
                $new_sub_total = $grand_total/($data['tax']+1);             
                //$taxable_total = (float)$grand_total - (float)$new_sub_total;

                $taxable_total=$data['taxable_total'];               
                $taxable_total=round($taxable_total,2);
                $total['subtotal'] = $new_sub_total;
                $total['taxable_total'] = $taxable_total;
                $total['total'] = $grand_total; 
            }
            
            
            if($total['less_voucher']>0){
                $total_details['less_voucher']=$this->functions->prettyPrice($total['less_voucher'],$with_symbol);
            }
            if($total['pts_redeem_amt']>0){
                $total_details['pts_redeem_amt']=$this->functions->prettyPrice($total['pts_redeem_amt'],$with_symbol);
            }
            
            if($total['discounted_amount']>0){
                $total_details['discounted_amount']=$this->functions->prettyPrice($total['discounted_amount'],$with_symbol);
                $total_details['merchant_discount_amount']=$total['merchant_discount_amount']."%";
            }
            
            if($total['subtotal']>0){
                $total_details['subtotal']=$this->functions->prettyPrice($total['subtotal'],$with_symbol);
            }
            if($total['delivery_charges']>0){
                $total_details['delivery_charges']=$this->functions->prettyPrice($total['delivery_charges'],$with_symbol);
            }
            
            if(isset($total['service_fee'])){
            if($total['service_fee']>0){
                $total_details['service_fee']=$this->functions->prettyPrice($total['service_fee'],$with_symbol);
            }
            }
            
            if($total['merchant_packaging_charge']>0){
                $total_details['packaging_charge']=$this->functions->prettyPrice($total['merchant_packaging_charge'],$with_symbol);
            }
            if($total['taxable_total']>0){
                $total_details['tax']=array(
                  'taxable_total'=>$this->functions->prettyPrice($total['taxable_total'],$with_symbol),
                  'tax_label'=>"Tax %".$this->functions->normalPrettyPrice($total['tax']*100)
                );

            }
            if($total['tips_percent']>0){
                $total_details['tips']=array(
                  'value'=>$this->functions->prettyPrice($total['tips'],$with_symbol),
                  'label'=>"Tips ".$total['tips_percent']
                );

            }
            
            if(isset($total['card_fee'])){
            if($total['card_fee']>0){
                $total_details['card_fee']=$this->functions->prettyPrice($total['card_fee'],$with_symbol);
            }
            }
            
            if($total['total']>0){
                $total_details['total'] = $this->functions->prettyPrice($total['total'],$with_symbol);
            }
                                    
            return array(
              'order_data'=>$details_details,
              'order_details'=>$order_details,
              'total_details'=>$total_details,
              //custom code 9 Starts
              'data'=>$data 
              //custom code 9 ends
            );
            
        } else throw new Exception( ("order not found"));
    }
	
	public  function prepareReceipt_auto($order_id='', $with_symbol = true)
    {       
        $details_details = array(); $data = array(); $order_details=array();
        
        $default_currency = $this->functions->getCurrencyCode();
        $enabled_trans = $this->functions->multipleField();


        
        if ($data=$this->getReceiptByID($order_id)){


                    
            /*MC*/
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $default_currency;
            
                            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;

            if ( $json_details !=false){

                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
               'promo_id'=>$data['promo_id'],
               'tax_set'=>$data['tax'],
             ),$json_details,true,$order_id);


            }   
            
            //custom code 9 starts
            $data['merchant_tax_number']=$this->functions->getOption('merchant_tax_number',$merchant_id); 
            //custom code 9 ends
            
            $details_details['order_id']=$data['order_id'];
            $details_details['merchant_name']= $this->functions->clearString($data['merchant_name']);         
            $details_details['merchant_contact_phone']= $this->functions->clearString($data['merchant_contact_phone']);
            $details_details['merchant_address']= $this->functions->clearString($data['merchant_address']);
            
            $details_details['request_cancel']=$data['request_cancel'];
            $details_details['customer_name']=$data['full_name'];           
            $details_details['date_created']=$this->functions->prettyDate($data['date_created'])." ".$this->functions->prettyTime($data['date_created']);     
            $details_details['payment_type_raw'] = $data['payment_type'];
// custom disable   $details_details['payment_type']=self::prettyPaymentType($data['payment_type'],$data['trans_type']);

            // Custom code 9 starts 
            //$details_details['payment_type']= $this->functions->prettyPaymentType('payment_order',$data['payment_type'], $data['order_id'],$data['trans_type']);

			 //$details_details['payment_type']="Paid";
			 
			  
			 
              if($data['payment_type']=="pyr"){
                    $type_payment='pyr_merchant_slip';
                  }else{
                    $type_payment=$data['payment_type'];
                  }

                  $details_details['payment_type']=$this->functions->payment_translations($data['trans_type'],$type_payment,$data['is_sop']);
			
            // Custom code 9 ends   
                
            $details_details['trans_type'] = ($data['trans_type']);
            $details_details['trans_type_raw'] = $data['trans_type'];
            
            $details_details['status']=($data['status']);
            $details_details['status_raw']=$data['status'];
            
                        
            $details_details['estimated_time']=$data['estimated_time'];
            $details_details['estimated_date_time']=$data['estimated_date_time'];
            
            /* custom code 12 starts */
            $details_details['car_park_enable']=$data['car_park_enable'];
            $details_details['number_plate']=$data['number_plate'];
            /* custom code 12 ends */
            
            $details_details['sub_total']=$data['sub_total'];
            $details_details['total']=$this->functions->prettyPrice($data['total_w_tax'], $with_symbol);
            $details_details['delivery_address']=$data['full_address'];
            $details_details['location_lat']=!empty($data['location_lat'])?$data['location_lat']:'';
            $details_details['location_lng']=!empty($data['location_lng'])?$data['location_lng']:'';
            
            $details_details['contact_phone']=$data['contact_phone'];
            $details_details['delivery_date']=$this->functions->prettyDate($data['delivery_date']);
            $details_details['delivery_time']=$this->functions->prettyTime($data['delivery_time']);
            
            $date_now = date('Ymd'); $pre_order = 0; $pre_order_msg='';
            $delivery_date=$data['delivery_date'];
            $delivery_date=date("Ymd",strtotime($delivery_date));           
            if($delivery_date>$date_now){
                $pre_order = 1;
                $dtime = !empty($data['delivery_time'])?date("g:ia",strtotime($data['delivery_time'])):'';
                

                 $pre_order_msg = "This is advance order on ".$this->functions->prettyDate($data['delivery_date']);

            }
            
            $details_details['pre_order']=$pre_order;
            $details_details['pre_order_msg']=$pre_order_msg;
            
            $details_details['delivery_asap']=$data['delivery_asap'];
            $details_details['delivery_instruction']=$data['delivery_instruction'];
            $details_details['location_name']=$data['location_name'];
            $details_details['order_change_raw']=$data['order_change'];
            $details_details['order_change']=$this->functions->prettyPrice($data['order_change'],$with_symbol);
            
            $details_details['payment_gateway_ref']=$data['payment_gateway_ref'];
            $details_details['dinein_number_of_guest']=$data['dinein_number_of_guest'];
            $details_details['dinein_special_instruction']=$data['dinein_special_instruction'];
            $details_details['dinein_table_number']=$data['dinein_table_number'];
            
            $details_details['opt_contact_delivery']=$data['opt_contact_delivery'];
            if($data['opt_contact_delivery']>=1){
                $details_details['opt_contact']=array(
                  'label'=>"Delivery options",
                  'value'=>"Leave order at the door or gate"
                );
            }
            
            if($data['payment_type']=="ocr"){
                if($creditcard_info = $this->functions->getCreditCardInfo($data['client_id'],$data['cc_id'])){
                    $details_details['card_information']=array(
                      'card_name'=>$creditcard_info['card_name'],
                      'mask_card_number'=>$creditcard_info['credit_card_number'],
                      'expiration'=>$creditcard_info['expiration_month']."/".$creditcard_info['expiration_yr'],
                      'billing_address'=>$creditcard_info['billing_address']
                    );
                }
            }
                        
            $raw = $displayOrderHTML['raw'];           
                        
            foreach ($raw['item'] as $item){
                $price = $item['normal_price']; $qty = $item['qty']; $addon_total=0;
                if($item['discount']>0){
                   $price = $item['discounted_price']; 
                }
                
                /* Custom code 13 starts */
                $promo_id = $item['promo_id'];
                /* Custom code 13 ends */
                
                $item_total = (integer)$qty* (float) $price; 
                
                $item_name=''; $line_items = array(); 
                                
                $item_name = $this->functions->qTranslate($item['item_name'],'item_name',
                $item['item_name_trans'],$enabled_trans);                
                
                $size_name = $this->functions->qTranslate($item['size_words'],'size_name',
                isset($item['size_name_trans'])?$item['size_name_trans']:array(),$enabled_trans);               
                
                if(!empty($item['size_words'])){

                   

                   $item_name = "Item name ".$item_name." size_words ".$size_name;

                } else $item_name = $item['item_name'];
                
                /*SUB*/             
                $line_sub_item=array(); $subitem =array();
                if(isset($item['new_sub_item'])){
                    if(is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
                        foreach ($item['new_sub_item'] as $sub_item_cat => $sub_item){  
                            $subitem = array();
                            foreach ($sub_item as $sub_item_val) {
                                $sub_item_total = (float)$sub_item_val['addon_qty']*(float)$sub_item_val['addon_price'];
                                
                                $addon_name =  $this->functions->qTranslate($sub_item_val['addon_name'],'sub_item_name',
                                isset($sub_item_val['sub_item_name_trans'])?$sub_item_val['sub_item_name_trans']:array(),
                                $enabled_trans);   
                                
                                $addon_category = $this->functions->qTranslate($sub_item_cat,'subcategory_name',
                                isset($sub_item_val['subcategory_name_trans'])?$sub_item_val['subcategory_name_trans']:array(),
                                $enabled_trans);  
                                
                                $subitem[] = array(
                                  'name'=>$addon_name,
                                  'qty'=>$sub_item_val['addon_qty'],
                                  'price'=>$this->functions->prettyPrice($sub_item_val['addon_price'],$with_symbol),
                                  'sub_item_total'=>$this->functions->prettyPrice($sub_item_total,$with_symbol),
                                );
                                $line_sub_item[$sub_item_cat]= array(
                                  'addon_category'=>$addon_category,
                                  'item'=>$subitem
                                );
                            }
                        }                                               
                    }
                }
                                
                $item_total_price = (float)$qty*(float)$price;
                
                $cooking_ref = $this->functions->qTranslate($item['cooking_ref'],'cooking_name',
                isset($item['cooking_name_trans'])?$item['cooking_name_trans']:array(),$enabled_trans);
                
                $ingredients = array();  $resp_ingredients='';
                if(isset($item['ingredients'])){
                   if(is_array($item['ingredients']) && count($item['ingredients'])>=1){
                      foreach ($item['ingredients'] as $ingredients_name) {
                         if(!$resp_ingredients = $this->FoodItemWrapper->getIngredientsByName($ingredients_name,$enabled_trans)){
                            $resp_ingredients = stripslashes($ingredients_name);
                         }
                         $ingredients[]=$resp_ingredients;
                      }
                   }
                }
                
                
                $line_items[]=array(
                  'name'=>$item_name,
                  'qty'=>$qty,
                  'price'=>$this->functions->prettyPrice($item['normal_price'],$with_symbol),
                  'discount'=>$item['discount'],
                  'price_after_discount'=>$this->functions->prettyPrice($price,$with_symbol),
                  'item_total_price'=>$this->functions->prettyPrice($item_total_price,$with_symbol),
                  'cooking_ref'=>$cooking_ref,
                  'order_notes'=>$item['order_notes'],
                  'ingredients'=>$ingredients,
                  
                  /* Custom code 13 starts */
                  'promo_id'=>$promo_id,
                  /* custom code 13 ends */
                  
                  'sub_item'=>$line_sub_item
                );
                
                $category_name = $this->functions->qTranslate($item['category_name'],'category_name',
                isset($item['category_name_trans'])?$item['category_name_trans']:array()
                ,$enabled_trans);   
                
                $order_details[]=array(
                  'category_name'=>$category_name,
                  'item'=>$line_items
                );
            }           
            
            /*TOTAL*/
            $total_details = array();
            $total = $raw['total'];
            
            $total_details['apply_food_tax'] = $data['apply_food_tax'];
            
            /*EURO TAX*/
            if($data['apply_food_tax']==1 && $data['tax']>0){    

              
                                        
                $grand_total = isset($total['subtotal'])?(float)$total['subtotal']:0;
                $grand_total+= isset($total['delivery_charges'])?(float)$total['delivery_charges']:0;
                $grand_total+= isset($total['merchant_packaging_charge'])?(float)$total['merchant_packaging_charge']:0;
                $grand_total+= isset($total['service_fee'])?(float)$total['service_fee']:0;
                $grand_total+= isset($total['card_fee'])?(float)$total['card_fee']:0;
                $grand_total+= isset($total['tips'])?(float)$total['tips']:0;               
                
                
                $new_sub_total = $grand_total/($data['tax']+1);             
                //$taxable_total = (float)$grand_total - (float)$new_sub_total;

                $taxable_total=$data['taxable_total'];               
                $taxable_total=round($taxable_total,2);
                $total['subtotal'] = $new_sub_total;
                $total['taxable_total'] = $taxable_total;
                $total['total'] = $grand_total; 
            }
            
            
            if($total['less_voucher']>0){
                $total_details['less_voucher']=$this->functions->prettyPrice($total['less_voucher'],$with_symbol);
            }
            if($total['pts_redeem_amt']>0){
                $total_details['pts_redeem_amt']=$this->functions->prettyPrice($total['pts_redeem_amt'],$with_symbol);
            }
            
            if($total['discounted_amount']>0){
                $total_details['discounted_amount']=$this->functions->prettyPrice($total['discounted_amount'],$with_symbol);
                $total_details['merchant_discount_amount']=$total['merchant_discount_amount']."%";
            }
            
            if($total['subtotal']>0){
                $total_details['subtotal']=$this->functions->prettyPrice($total['subtotal'],$with_symbol);
            }
            if($total['delivery_charges']>0){
                $total_details['delivery_charges']=$this->functions->prettyPrice($total['delivery_charges'],$with_symbol);
            }
            
            if(isset($total['service_fee'])){
            if($total['service_fee']>0){
                $total_details['service_fee']=$this->functions->prettyPrice($total['service_fee'],$with_symbol);
            }
            }
            
            if($total['merchant_packaging_charge']>0){
                $total_details['packaging_charge']=$this->functions->prettyPrice($total['merchant_packaging_charge'],$with_symbol);
            }
            if($total['taxable_total']>0){
                $total_details['tax']=array(
                  'taxable_total'=>$this->functions->prettyPrice($total['taxable_total'],$with_symbol),
                  'tax_label'=>"Tax %".$this->functions->normalPrettyPrice($total['tax']*100)
                );

            }
            if($total['tips_percent']>0){
                $total_details['tips']=array(
                  'value'=>$this->functions->prettyPrice($total['tips'],$with_symbol),
                  'label'=>"Tips ".$total['tips_percent']
                );

            }
            
            if(isset($total['card_fee'])){
            if($total['card_fee']>0){
                $total_details['card_fee']=$this->functions->prettyPrice($total['card_fee'],$with_symbol);
            }
            }
            
            if($total['total']>0){
                $total_details['total'] = $this->functions->prettyPrice($total['total'],$with_symbol);
            }
                                    
            return array(
              'order_data'=>$details_details,
              'order_details'=>$order_details,
              'total_details'=>$total_details,
              //custom code 9 Starts
              'data'=>$data 
              //custom code 9 ends
            );
            
        } else throw new Exception( ("order not found"));
    }


    public  function prettyPaymentType($code='',$transaction_type='')
    {
        $list = $this->functions->PaymentOptionList();       
        if(array_key_exists($code,$list)){
            switch ($transaction_type) {
                case "pickup":      
                    if($code=="cod"){   
                       $data= ("Cash on pickup");                  
                    } else {
                        if(isset($list[$code])){
                           $data = ($list[$code]);
                        } else $data = $code;
                    }
                    break;
            
                case "dinein":                          
                    if($code=="cod"){   
                       $data= ("Pay in person");          
                    } else {
                        if(isset($list[$code])){
                           $data = ($list[$code]);
                        } else $data = $code;
                    }
                    break;
                        
                default:
                    if(isset($list[$code])){
                       $data = ($list[$code]);
                    } else $data = $code;
                    break;
            }           
        }
        return $data;
    }


    public  function getStatusFromSettings($option_name='', $status = array())
    {
        $status_new = '';
        $order_incoming_status = $this->functions->getOptionAdmin($option_name);
        if(!empty($order_incoming_status)){
            if($order_incoming_status = json_decode($order_incoming_status,true)){
               $status = $order_incoming_status;
            }
        }
        
        if(is_array($status) && count($status)>=1){
            foreach ($status as $val) {
                

               $status_new .= "'" . $val . "',";
            }
            $status_new = substr($status_new,0,-1);
        }       
        return $status_new;     
    }

  public function getNewestOrder($order_ids = '', $merchant_id = '')
{
    $todays_date = date("Y-m-d");
    $status = $this->getStatusFromSettings('order_incoming_status', array('pending', 'paid'));

    if (!empty($order_ids)) {
        $stmt = "
        SELECT order_id 
        FROM mt_order              
        WHERE CAST(date_created as DATE) BETWEEN :todays_date AND :todays_date            
        AND order_id NOT IN ($order_ids)
        AND status IN ($status)
        AND request_cancel = '2'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':todays_date', $todays_date);
        $command->bindParam(':merchant_id', $merchant_id);

        if ($command->execute()) {
            if ($res = $command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    } else {
        $stmt = "
        SELECT order_id 
        FROM mt_order              
        WHERE CAST(date_created as DATE) BETWEEN :todays_date AND :todays_date            
        AND status IN ($status)
        AND request_cancel = '2'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':todays_date', $todays_date);
        $command->bindParam(':merchant_id', $merchant_id);

        if ($command->execute()) {
            if ($res = $command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    }

    return false;
}

public function reheckNewestOrder($order_ids = '', $merchant_id = '')
{
    $todays_date = date("Y-m-d");
    $status = $this->getStatusFromSettings('order_incoming_status', array('pending', 'paid'));

    if (!empty($order_ids)) {
        $stmt = "
        SELECT order_id 
        FROM mt_order              
        WHERE CAST(date_created as DATE) BETWEEN :todays_date AND :todays_date            
        AND order_id IN ($order_ids)
        AND status IN ($status)
        AND request_cancel = '2'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':todays_date', $todays_date);
        $command->bindParam(':merchant_id', $merchant_id);

        if ($command->execute()) {
            if (!$command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    }

    return false;
}

public function getNewestCancel($order_ids = '', $merchant_id = '')
{
    if (!empty($order_ids)) {
        $stmt = "
        SELECT order_id 
        FROM mt_order  
        WHERE order_id NOT IN ($order_ids)
        AND request_cancel = '1'
        AND request_cancel_viewed = '2'
        AND request_cancel_status = 'pending'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':merchant_id', $merchant_id);

        if ($command->execute()) {
            if ($command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    } else {
        $stmt = "
        SELECT order_id 
        FROM mt_order              
        WHERE 1
        AND request_cancel = '1'
        AND request_cancel_viewed = '2'
        AND request_cancel_status = 'pending'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':merchant_id', $merchant_id);

        if ($command->execute()) {
            if ($command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    }

    return false;
}


public function verifyNewestOrder($order_ids = '')
{
    if (!empty($order_ids)) {
        $stmt = "
        SELECT order_id 
        FROM mt_order  
        WHERE order_id IN ($order_ids)
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);

        if ($command->execute()) {
            if ($command->fetch(PDO::FETCH_ASSOC)) {
                return true;
            }
        }
    }

    return false;
}

    
   public function getOrderHistory($order_id = 0)
{
    $stmt = "
    SELECT order_id, status, remarks, date_created, remarks2, remarks_args
    FROM mt_order_history
    WHERE order_id = :order_id
    ORDER BY id ASC
    ";

    $command = $this->db->prepare($stmt);
    $command->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    if ($command->execute()) {
        $resp = $command->fetchAll(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }

    return false;
}

public  function prettyDateTime($date_time='')
    {
        if(!empty($date_time)){
           return $this->functions->prettyDate($date_time)." ".$this->functions->prettyTime($date_time);
        }
        return '-';
    }
    
    public  function dateDifference($date_1 , $date_2 , $differenceFormat = '%a' )
    {
        $datetime1 = date_create($date_1);
        $datetime2 = date_create($date_2);     
        $interval = date_diff($datetime1, $datetime2);     
        return $interval->format($differenceFormat);      
    }


   public function InsertOrderTrigger($order_id = '', $status = '', $remarks = '', $trigger_type = 'order')
{
    $order_id = (integer) $order_id;
    $lang = "en";

    if ($order_id > 0) {
        $stmt = "
        SELECT order_id 
        FROM mt_merchantapp_order_trigger
        WHERE order_id = :order_id
        AND order_status = :order_status
        AND status = 'pending'
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $command->bindParam(':order_status', $status, PDO::PARAM_STR);

        if (!$command->execute() || !$command->fetch(PDO::FETCH_ASSOC)) {
            $params = array(
                'order_id' => $order_id,
                'order_status' => $status,
                'remarks' => $remarks,
                'language' => $lang,
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'trigger_type' => $trigger_type
            );

            // Use existing insertData function
            $this->functions->insertData("mt_merchantapp_order_trigger", $params);

            // Use existing consumeUrl function
            $this->functions->consumeUrl(Config::$baseUrl . "/merchantappv2/cron/trigger_order");

            if ($trigger_type == "booking") {
                $this->functions->consumeUrl(Config::$baseUrl . "/merchantappv2/cron/trigger_order_booking");
            }
        }
    }
}


public function getOrderLocation($order_id = '')
{
    $stmt = "
    SELECT 
        a.order_id,
        a.google_lat AS delivery_lat,
        a.google_lng AS delivery_lng,
        b.merchant_id,
        c.latitude AS merchant_lat,
        c.lontitude AS merchant_lng
    FROM mt_order_delivery_address a
    LEFT JOIN mt_order b ON a.order_id = b.order_id
    LEFT JOIN mt_merchant c ON b.merchant_id = c.merchant_id
    WHERE a.order_id = :order_id
    ";

    $command = $this->db->prepare($stmt);
    $command->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    if ($command->execute()) {
        if ($resp = $command->fetch(PDO::FETCH_ASSOC)) {
            return $resp;
        }
    }

    throw new Exception("Order id not found");
}


public function getUpdatedReadyOrder($order_ids = '', $merchant_id = '')
{
    $todays_date = date("Y-m-d");
    $start = date("Y-m-d H:i:s", strtotime("-2 minutes"));
    $status = $this->getStatusFromSettings('order_ready_status', array('pending', 'paid'));

    if (!empty($order_ids)) {
        $stmt = "
        SELECT order_id 
        FROM mt_order
        WHERE CAST(date_created AS DATE) BETWEEN :todays_date AND :todays_date
        AND order_id IN ($order_ids)
        AND status NOT IN ($status)
        AND request_cancel = '2'
        AND merchant_id = :merchant_id
        AND :start < date_modified
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':todays_date', $todays_date, PDO::PARAM_STR);
        $command->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $command->bindParam(':start', $start, PDO::PARAM_STR);

        if ($command->execute() && $command->fetch(PDO::FETCH_ASSOC)) {
            return true;
        }
    } else {
        $stmt = "
        SELECT order_id 
        FROM mt_order
        WHERE CAST(date_created AS DATE) BETWEEN :todays_date AND :todays_date
        AND status IN ($status)
        AND request_cancel = '2'
        AND merchant_id = :merchant_id
        LIMIT 1
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':todays_date', $todays_date, PDO::PARAM_STR);
        $command->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        if ($command->execute() && $command->fetch(PDO::FETCH_ASSOC)) {
            return true;
        }
    }

    return false;
}


public  function prettyPrice($amount=0, $with_symbol=true)
    {
        if($with_symbol){
            return $this->functions->prettyPrice($amount);
            //return Merchant_utility::formatNumber($amount);
        } else {
            $amount = $amount>0?$amount:0;
            return $this->functions->normalPrettyPrice($amount);
        }
    }


    public  function canChangeOrderStatus($order=array())
    {
        
        
        $datenow=date('Y-m-d g:i:s a');  
        $edit_days = (integer) $this->functions->getOptionAdmin('merchant_days_can_edit_status');
        $edit_times =  $this->functions->getOptionAdmin('merchant_time_can_edit_status');

        if($edit_days>0 || !empty($edit_times)){
            $base_option=$this->functions->getOptionAdmin('merchant_days_can_edit_status_basedon');
            if ( $base_option==2){                          
                if(!empty($order['delivery_time'])){
                   $date_created=date("Y-m-d g:i:s a",strtotime($order['delivery_date']." ".$order['delivery_time']));
                } else $date_created=date("Y-m-d g:i:s a",strtotime($order['delivery_date']." ".$order['date_created']));
            } else $date_created=date("Y-m-d g:i:s a",strtotime($order['date_created']));           
            
            $date_interval=$this->functions->dateDifference($date_created,$datenow);           
            if (is_array($date_interval) && count($date_interval)>=1){
                if ( $date_interval['days']>$edit_days){
                    return false;
                }
                                
                if(!empty($edit_times)){
                    $times = explode(":",$edit_times);                                                          
                    $hour = isset($times[0])?(integer)$times[0]:0;                          
                    $minute = isset($times[1])?(integer)$times[1]:0;
                    if($hour>0){
                        if($date_interval['hours']>$hour){
                            return false;
                        }                           
                    } else {                                
                        if($date_interval['minutes']>$minute){
                            return false;
                        }                           
                    }                       
                }
            }
        }
        return true;
    }



    public function validateChangeStatus($order_id = '', $status = '')
{
    $stmt = "
    SELECT id, order_id, status 
    FROM mt_order_history
    WHERE order_id = :order_id
    ORDER BY id DESC
    LIMIT 1
    ";

    $command = $this->db->prepare($stmt);
    $command->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    $command->execute();

    if ($res = $command->fetch(PDO::FETCH_ASSOC)) {
        if ($status == $res['status']) {
            return true;
        }
    }
    return false;
}



   




    















 

    





        
        
}
/*END CLASS*/