<?php
class ApiController extends Controller
{
    
    public $data;
    public $code=2;
    public $msg='';
    public $details='';
    public $paginate_limit = 1000;
    public $merchant_id='';
    public $device_id='';
    public $merchant_name='';
    public $device_uiid;


    
    
    public function __construct()
    {




            
        $this->functions = new Functions();
        $this->SingleAppClass_pos = new SingleAppClass_pos();
        
        $this->InventoryWrapper=new InventoryWrapper();
        $this->StocksWrapper=new StocksWrapper();
        
        $this->LocationWrapper=new LocationWrapper();
        $this->CheckoutWrapperTemp=new CheckoutWrapperTemp();

        $this->PointsProgram=new PointsProgram();

        
        $this->MapsWrapperTemp=new MapsWrapperTemp();

        $this->Validator = new Validator();


        $model = Model::getInstance();
        
        $this->db = $model->getDb();

        $this->data=$_GET;
        $this->getGETData();


        if(isset($_GET['post'])){
            $this->data=$_POST;     
            $this->getPOSTData();
        }   

        $current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
$current_url .= "://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

if (strpos($current_url, 'addToCart') !== false) {
    $this->data = $_POST;
    $this->getPOSTData();
    
} else {
    
}

                                        
        $lang='en'; 

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");   
        date_default_timezone_set($website_timezone);


        //print_r($this->data);die();

      
       $pos_keys = isset($this->data['pos_keys'])?trim($this->data['pos_keys']):$_REQUEST['pos_keys'];  



        if(empty($pos_keys)){
            $this->code = 10;   
            $this->msg = "Invalid merchant keys";
            $this->output();
            return false;
        }


        if(!$resp=$this->SingleAppClass_pos->validateKeys($pos_keys)){
            $this->code = 10;       
            $this->msg = "Invalid merchant keys";
            $this->output();
            return false;
        }

        if($resp['status']!="active"){
            $this->code = 11;       
            $this->msg = ("Failed merchant is no longer active");
            $this->output();
            return false;
        }


            
        $this->merchant_id = $resp['merchant_id'];;

        $this->paginate_limit=50;


       $disabled_single_app_modules = $this->functions->getOption('disabled_single_app_modules',$this->merchant_id);
        if($disabled_single_app_modules==1){
            $this->code = 11;       
            $this->msg = "Failed merchant module is disabled";
            $this->output();
            return false;
        }
        
        $this->merchant_name = isset($resp['restaurant_name'])?$resp['restaurant_name']:'';
        $this->device_id = isset($this->data['device_id'])?$this->data['device_id']:'';
        return true;
                
            

     



    }

    public function output()
{
    // Allow cross-origin access
    header('Access-Control-Allow-Origin: *');
    header('Content-type: application/javascript;charset=utf-8');
    
    // Prepare the response array
    $resp = array(
        'code' => $this->code,
        'msg' => $this->msg,
        'details' => $this->details,
        'get' => $_GET,
        'post' => $_POST
    );
    
    // Check if 'callback' exists in GET request, else set it to an empty string
    if (!isset($_GET['callback'])) {
        $_GET['callback'] = '';
    }
    
    // If jsonp is requested, wrap the response in the callback function
    if (isset($_GET['jsonp']) && $_GET['jsonp'] == true) {
        echo $_GET['callback'] . '(' . json_encode($resp) . ')';
    } else {
        // Otherwise, just return the JSON response
        echo json_encode($resp);
    }

    // End the script execution (optional, depending on your use case)
    exit();
}
    
    
    public function Index(){
        echo "API IS WORKING";
    }   

    
    
    
    public function getGETData()
    {
        

        if(isset($_GET['code_version']) || isset($_POST['code_version'])){
            $this->device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';        
        } else {
            $this->device_uiid = isset($this->data['device_id'])?$this->data['device_id']:'';        
        }   
    }

    public function getPOSTData()
    {
        

        if(isset($_GET['code_version']) || isset($_POST['code_version'])){
            $this->device_uiid = isset($_POST['device_uiid'])?$_POST['device_uiid']:'';        
        } else {
            $this->device_uiid = isset($_POST['device_id'])?$_POST['device_id']:'';        
        }

    }


    public function setMerchantTimezone(){
        $merchant_id = isset($this->merchant_id)?$this->merchant_id:'';
        if($merchant_id>0){         
            $mt_timezone=$this->functions->getOption("merchant_timezone",$this->merchant_id);           
            if (!empty($mt_timezone)){
                date_default_timezone_set($website_timezone);
            }       
        }
    }
    


    public function loadCategory()
    {
        $this->setMerchantTimezone();
         $this->paginate_limit=30;
        if (isset($this->data['page'])){ 
            $page = $this->data['page'] * $this->paginate_limit;
        } else  $page = 0;  
        
        if ($resp = $this->SingleAppClass_pos->getCategory($this->merchant_id, $page , $this->paginate_limit)){
        //if ($resp = $this->SingleAppClass_pos->getCategory($this->merchant_id,0,0,true)){ 

        //+++was custom code
            array_walk_recursive($resp, function (&$value) {
        if (is_null($value)) {
            $value = "";
        }
    });

              if (is_array($resp)) {
    foreach ($resp as &$row) {
        if (isset($row['dish']) && is_string($row['dish'])) {
            $temp = json_decode($row['dish'], true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($temp)) {
                $row['dish'] = '';
            }
        }
    }
}
    //---was custom code
          

       






            $this->code = 1; $this->msg = 'OK';  
            $this->details = array('data'=>$resp);
        } else {
            $this->code = 6;
            $this->msg = "end of records";
            $this->details = array(
              'title'=>"No Category found",
              'sub_title'=>"This restaurant has not published their menu yet"
            );  
        }   
        $this->output();
    }



    public function loadItemByCategory()
    {


        if (isset($this->data['page'])){
    $page = $this->data['page'] * $this->paginate_limit;
} else  $page = 0;  

/*dump($this->merchant_id);
dump($this->data);*/

$new_data = array();
$item_details = array();

$trans = $this->functions->getOptionAdmin('enabled_multiple_translation'); 

$category_id = isset($this->data['cat_id'])?$this->data['cat_id']:'';

$delivery_type = isset($this->data['order_type'])?$this->data['order_type']:'';
//$delivery_type ='dinein';
$and='';

$food_option_not_available = $this->functions->getOption('food_option_not_available',$this->merchant_id);
if($food_option_not_available==1){
    $and = "AND not_available !='2' ";
}   


$like = "'%\"$category_id\"%'";
$stmt="
SELECT 
item_id,
packaging_fee,
packaging_incremental,
item_name,
item_description,is_variable_price,quantity,
price,barcode,price_dinein,
discount,
dish,
photo,
item_name_trans,
item_description_trans ,cooking_ref,addon_item
FROM
mt_item 
WHERE
category like $like
AND
status IN ('publish','published')               
AND merchant_id = ".($this->merchant_id)."      
$and        
ORDER BY sequence ASC
LIMIT $page,$this->paginate_limit
";      

if($this->SingleAppClass_pos->inventoryEnabled($this->merchant_id)){
    
    if($this->InventoryWrapper->hideItemOutStocks($this->merchant_id)){

        

        $stmt="SELECT 
        item_id,
        item_name,
        packaging_fee,
packaging_incremental,
        item_description,
        price,barcode,is_variable_price,quantity,price_dinein,
        discount,
        dish,
        photo,
        item_name_trans,
        item_description_trans ,cooking_ref,addon_item
        
        FROM
        mt_item a
        WHERE
        
        category LIKE '%\"$category_id\"%'
        AND
        status IN ('publish','published')   
        AND merchant_id = ".($this->merchant_id)."  
        AND item_id IN (
                  select item_id from mt_view_item_stocks_status
                  where available ='1'
                  and track_stock='1'
                  and stock_status not in ('Out of stocks')     
                  and item_id = a.item_id                 
                )                                                   
        ORDER BY sequence ASC
        LIMIT $page,$this->paginate_limit
        ";              
    } else {                
       if($food_option_not_available==1):
       
         $stmt="SELECT 
            item_id,
            item_name,
            packaging_fee,
packaging_incremental,
            item_description,
            price,barcode,is_variable_price,quantity,price_dinein,
            discount,
            dish,
            photo,
            item_name_trans,
            item_description_trans,cooking_ref,addon_item
            
            FROM
            mt_item a
            WHERE
           
            category LIKE '%\"$category_id\"%'
            AND
            status IN ('publish','published')   
            AND merchant_id = ".($this->merchant_id)."  
            AND item_id IN (
                      select item_id from mt_view_item_stocks_status
                      where available ='1'                            
                      and item_id = a.item_id                 
                    )                                                   
            ORDER BY sequence ASC
            LIMIT $page,$this->paginate_limit
            ";              
       endif;
    }       
}

$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);


if($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)){
            
            foreach ($res as $val) {            
                 $val['single_item'] = 2;       
                if ( $trans==2){
                    $item_name_trans = json_decode($val['item_name_trans'],true);
                    $val['item_name_trans']=$item_name_trans;
                    $val['item_name']=$this->functions->qTranslate($val['item_name'],'item_name',$val); 
                    
                    $item_description_trans = json_decode($val['item_description_trans'],true);
                    $val['item_description_trans']=$item_description_trans;
                    $val['item_description']=$this->functions->qTranslate($val['item_description'],'item_description',$val); 
                }
                    
                $val['item_name']= ($val['item_name']);
                $val['item_description']= ($val['item_description']);
                
                if(!empty($val['photo'])){
                  $val['photo_url'] = $this->SingleAppClass_pos->getImage($val['photo']);
                } else $val['photo_url'] =$this->SingleAppClass_pos->getImage($this->functions->getOption('singleapp_default_image',$this->merchant_id),'default_cuisine.png');
                                                
                //$val['prices'] = SingleAppClass::getPrices($val['price'],$val['discount']);
                
                $val['quantity']=!empty($val['quantity'])?json_decode($val['quantity'],true):[];
                
                
                
                if($delivery_type=='dinein'){
                    $val['prices'] = $this->SingleAppClass_pos->getPrices_variablers_price($val['price_dinein'],$val['discount'],$val['is_variable_price'],$val['quantity']);   
                    
                }else{
                $val['prices'] = $this->SingleAppClass_pos->getPrices_variablers_price($val['price'],$val['discount'],$val['is_variable_price'],$val['quantity']);
                
               /*  $val['prices_dinein'] = $this->SingleAppClass_pos->getPrices_variablers_price($val['price_dinein'],$val['discount'],$val['is_variable_price'],$val['quantity']);*/
                
                }
                
                        
                        
                    $val['is_variable_price']=$val['is_variable_price'];
                        
                /*GET DISH*/
                $icon_dish= array();
                if(!empty($val['dish'])){               
                           
                       $icon_dish = $this->functions->getDishIcon($val['dish']);
                    
                } else $icon_dish='';
                
                $val['icon_dish'] = $icon_dish;
                            

                $addon_item=isset($val['addon_item'])?(array)json_decode($val['addon_item']):false; 

                
                    if($delivery_type=='dinein'){
                $price=isset($val['price_dinein'])?(array)json_decode($val['price_dinein']):false;  
                
                    }else{
                        $price=isset($val['price'])?(array)json_decode($val['price']):false;    
                        
                    }
                
                
                
                $cooking_ref_selected=isset($val['cooking_ref'])?(array)json_decode($val['cooking_ref']):false;

                            
                if(is_array($cooking_ref_selected) && count($cooking_ref_selected)>=1){
                    $val['single_item'] = 1;
                }
                
                if(is_array($addon_item) && count($addon_item)>=1){
                    $val['single_item'] = 1;
                }
            
                
                if(is_array($price) && count($price)>1){
                    $val['single_item'] = 1;
                }
                
unset($val['price']);                       
                                                
                                                
                $val['item_details']=$this->loadItemDetails_was($val['item_id'],$delivery_type);
                $val['item_details']['single_item']=$val['single_item'];
                $val['item_details']['packaging_incremental']=$val['packaging_incremental'];
                $val['item_details']['packaging_fee']=$val['packaging_fee'];
                $new_data[]=$val;

                

                //$item_details[]=$this->loadItemDetails_was($val['item_id']);

            }
            
           
           // Assuming $new_data is already populated and is an array
foreach ($new_data as $k => &$item) {
    if (is_array($item)) {
        foreach ($item as $key => &$val) {
            if (is_null($val)) {
                $val = "";
            } elseif (is_array($val)) {
                foreach ($val as $sub_key => &$sub_val) {
                    if (is_null($sub_val)) {
                        $sub_val = "";
                    }
                }
                unset($sub_val);
            }
        }
        unset($val);
    }
}
unset($item);



            $this->code = 1; $this->msg="OK";
            $this->details = array(
              'cat_id'=>$category_id,
              //'item_details'=>$item_details,
              'data'=>$new_data
            );



        } else {
            $this->msg = ("No item found in this category");
            $this->code = 6;
            $this->details = array(
              'title'=>("No item found"),
              'sub_title'=>("No item found in this category")
            );  
        }   
        
        $this->output();
    }


       public function loadItemDetails_was($item_id="",$delivery_type)
    {       
        
        /*CHECK IF ORDERING IS DISABLED*/
        $this->data['item_id']=$item_id;
        $ordering_disabled=false; $ordering_msg='';
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by admin");
            $ordering_disabled=true;            
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by merchant");
            $ordering_disabled=true;
        }
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $ordering_msg = ("Merchant is now close and not accepting any orders");
            $ordering_disabled=true;
        }
        
        
        //$delivery_type = "";
        //$delivery_type ='dinein';


        
        
        $cart_data=array();
        


      

        
        $trans=$this->functions->getOptionAdmin('enabled_multiple_translation'); 
        
        if(is_numeric($item_id)){
            
            if($delivery_type=='dinein'){
            
            $res=$this->functions->getItemById_dine($this->data['item_id']);
            }else{  


            
            $res=$this->functions->getItemById_pos($this->data['item_id']);
            }


            
            if ($res){
                $res = $res[0]; 
                                
                /*TRANSLATE ADDON*/
                if($trans==2){
                    $new_addon = array();
                    if(is_array($res['addon_item']) && count($res['addon_item'])>=1){
                        foreach ($res['addon_item'] as $add_val) {                          
                            $add_val['subcat_name']=$this->functions->qTranslate($add_val['subcat_name'],'subcat_name',$add_val);
                                                                                    
                            if(is_array($add_val['sub_item']) && count($add_val['sub_item'])>=1){
                                $new_sub_item = array();
                                foreach ($add_val['sub_item'] as $sub_item_val) {
                                    $sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'],'sub_item_name',$sub_item_val);
                                    $sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'],'item_description',$sub_item_val);                                   
                                    $new_sub_item[]=$sub_item_val;
                                }
                                $add_val['sub_item']=$new_sub_item;
                            }                                                   
                                                        
                            $new_addon[]=$add_val;
                        }
                        
                        $res['addon_item']=$new_addon;
                    }               
                }                               
                /*END TRANSLATE ADDON*/
                
                /*$food_option_not_available = getOption($this->merchant_id,'food_option_not_available');       
                if($food_option_not_available==2){*/
                    if($res['not_available']==2){               
                       $ordering_msg = ("Sorry but this item is not available");
                       $ordering_disabled=true;
                    }
                //} 
                
                $res['item_name']=$this->functions->qTranslate($res['item_name'],'item_name',$res);         
                $res['item_description']=$this->functions->qTranslate($res['item_description'],'item_description',$res);
                
                
                $res['item_name'] = ($res['item_name']);
                $res['barcode'] = $res['barcode'];
                
                
                $res['item_description'] = ($res['item_description']);
                $res['item_name_trans'] = ($res['item_name_trans']);
                $res['item_description_trans'] = ($res['item_description_trans']);
                
                if(!empty($res['photo'])){
                    $res['photo'] = $this->SingleAppClass_pos->getImage($res['photo']);
                } else $res['photo'] = $this->SingleAppClass_pos->getImage($this->functions->getOption('singleapp_default_image',$this->merchant_id),'default_cuisine.png');
                
                /*GET DISH*/
                $icon_dish= array();
                if(!empty($res['dish'])){               
                           
                       $icon_dish = $this->functions->getDishIcon($res['dish']);
                    
                } else $icon_dish='';
                
                $res['dish_list'] = $icon_dish;
                                
                /*GALLERY*/
                $res['gallery']=array();
                if(!empty($res['gallery_photo'])){
                    $new_gallery_photo=array();
                    $gallery_photo = json_decode($res['gallery_photo'],true);
                    if(is_array($gallery_photo) && count((array)$gallery_photo)>=1){
                        foreach ($gallery_photo as $gallery_photo_val) {
                            $new_gallery_photo[]= $this->SingleAppClass_pos->getImage($gallery_photo_val);
                        }
                        $res['gallery']=$new_gallery_photo;                 
                    }           
                }
                
                /*CHECK IF MULTIPLE PRICE*/
                $res['multiple_price'] = false;
                
                $res['quantity']=!empty($res['quantity'])?json_decode($res['quantity'],true):false;     
                
                if(is_array($res['prices']) && count($res['prices'])>=2){   
                    $new_price = array();
                    foreach ($res['prices'] as $keyss=>$prices) {
                        $prices['size']=$this->functions->qTranslate($prices['size'],'size',$prices);       
                        
                        if($res['is_variable_price']==2){$prices['variableprice']=$res['quantity'][$keyss];}
                        else{$prices['variableprice']="0";}
                        
                        $new_price[]=$prices;
                    }
                    $res['prices']=$new_price;                  
                    $res['multiple_price'] = true;
                } else {                
                    /*FIXED FOR SINGLE PRICE WITH ONLY 1 SIZE*/ 
                    if(isset($res['prices'][0])){
                        
                            
                        if($res['is_variable_price']==2){
                            $res['prices'][0]['variableprice']=$res['quantity'][0];
                        }else{$res['prices'][0]['variableprice']="0";}
                        
                        
                        
                        
                        
                        if( $res['prices'][0]['size_id']>0 ){
                            $res['multiple_price'] = true;
                        }                   
                    }                                   
                }   

                $row = isset($this->data['row'])?$this->data['row']:'';
                if(is_numeric($row)){

                    $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
                    
                    if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
                        $cart=json_decode($resp['cart'],true);
                        if(array_key_exists($row,(array)$cart)){
                            $cart[$row]['row']=$row;
                            $cart_data = isset($cart[$row])?$cart[$row]:'';
                        }
                    }
                } else $cart_data='';
                
                // GET FAVORITE
                $is_favorite = false;
                
                
                $inventory_enabled = $this->SingleAppClass_pos->inventoryEnabled($this->merchant_id);
                                            
               

               //+++was custom code
                if (isset($res) && is_array($res)) {
    foreach ($res as $key => $value) {
        if ($key === 'prices' && is_array($value)) {
            foreach ($res['prices'] as $i => $priceItem) {
                foreach ($priceItem as $priceKey => $priceVal) {
                    if (
                        ($priceKey !== 'size_id' && $priceKey !== 'discount_price') &&
                        (is_int($priceVal) || is_float($priceVal))
                    ) {
                        $res['prices'][$i][$priceKey] = (string)$priceVal;
                    }
                }
            }
        } elseif (is_int($value) || is_float($value)) {
            $res[$key] = (string)$value;
        }
    }
}


if (isset($res['addon_item']) && is_array($res['addon_item'])) {
    foreach ($res['addon_item'] as &$addon) {
        if (isset($addon['sub_item']) && is_array($addon['sub_item'])) {
            foreach ($addon['sub_item'] as &$sub_item) {
                if (isset($sub_item['sub_item_id'])) {
                    $sub_item['sub_item_id'] = strval($sub_item['sub_item_id']);
                }
            }
        }
    }
    unset($addon, $sub_item); // clean references
}

if (isset($res['quantity']) && $res['quantity'] === "") {
    $res['quantity'] = [];
}


// Loop through prices and fix leading spaces
if (isset($res['prices']) && is_array($res['prices'])) {
    foreach ($res['prices'] as $index => $price_item) {
        if (isset($price_item['formatted_price'])) {
            $res['prices'][$index]['formatted_price'] = ltrim($price_item['formatted_price']);
        }
        if (isset($price_item['formatted_discount_price'])) {
            $res['prices'][$index]['formatted_discount_price'] = ltrim($price_item['formatted_discount_price']);
        }
    }
}

//---was custom code

                return $res;

                
                
            } else {
                return 0; 
            }       
        } else {
            return 0; 
        }   
        return 0;       
    }




 



     public function loadItemDetails()
    {       
        
        /*CHECK IF ORDERING IS DISABLED*/
        $ordering_disabled=false; $ordering_msg='';
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by admin");
            $ordering_disabled=true;            
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by merchant");
            $ordering_disabled=true;
        }
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $ordering_msg = ("Merchant is now close and not accepting any orders");
            $ordering_disabled=true;
        }
        
        $delivery_type = isset($this->data['order_type'])?$this->data['order_type']:'';
        //$delivery_type ='dinein';


        
        
        $cart_data=array();
        $item_id = isset($this->data['item_id'])?$this->data['item_id']:'';




        
        $trans=$this->functions->getOptionAdmin('enabled_multiple_translation'); 
        
        if(is_numeric($item_id)){
            
            if($delivery_type=='dinein'){

            $res=$this->functions->getItemById_dine($this->data['item_id']);
            }else{  



            $res=$this->functions->getItemById_pos($this->data['item_id']);
            }
            
            if ($res){
                $res = $res[0]; 
                                
                /*TRANSLATE ADDON*/
                if($trans==2){
                    $new_addon = array();
                    if(is_array($res['addon_item']) && count($res['addon_item'])>=1){
                        foreach ($res['addon_item'] as $add_val) {                          
                            $add_val['subcat_name']=$this->functions->qTranslate($add_val['subcat_name'],'subcat_name',$add_val);
                                                                                    
                            if(is_array($add_val['sub_item']) && count($add_val['sub_item'])>=1){
                                $new_sub_item = array();
                                foreach ($add_val['sub_item'] as $sub_item_val) {
                                    $sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'],'sub_item_name',$sub_item_val);
                                    $sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'],'item_description',$sub_item_val);                                   
                                    $new_sub_item[]=$sub_item_val;
                                }
                                $add_val['sub_item']=$new_sub_item;
                            }                                                   
                                                        
                            $new_addon[]=$add_val;
                        }
                        
                        $res['addon_item']=$new_addon;
                    }               
                }                               
                /*END TRANSLATE ADDON*/
                
                /*$food_option_not_available = getOption($this->merchant_id,'food_option_not_available');       
                if($food_option_not_available==2){*/
                    if($res['not_available']==2){               
                       $ordering_msg = ("Sorry but this item is not available");
                       $ordering_disabled=true;
                    }
                //} 
                
                $res['item_name']=$this->functions->qTranslate($res['item_name'],'item_name',$res);         
                $res['item_description']=$this->functions->qTranslate($res['item_description'],'item_description',$res);
                
                
                $res['item_name'] = ($res['item_name']);
                $res['barcode'] = $res['barcode'];
                
                
                $res['item_description'] = ($res['item_description']);
                $res['item_name_trans'] = ($res['item_name_trans']);
                $res['item_description_trans'] = ($res['item_description_trans']);
                
                if(!empty($res['photo'])){
                    $res['photo'] = $this->SingleAppClass_pos->getImage($res['photo']);
                } else $res['photo'] = $this->SingleAppClass_pos->getImage($this->functions->getOption('singleapp_default_image',$this->merchant_id),'default_cuisine.png');
                
                /*GET DISH*/
                $icon_dish= array();
                if(!empty($res['dish'])){               
                           
                       $icon_dish = $this->functions->getDishIcon($res['dish']);
                    
                } else $icon_dish='';
                
                $res['dish_list'] = $icon_dish;
                                
                /*GALLERY*/
                $res['gallery']=array();
                if(!empty($res['gallery_photo'])){
                    $new_gallery_photo=array();
                    $gallery_photo = json_decode($res['gallery_photo'],true);
                    if(is_array($gallery_photo) && count((array)$gallery_photo)>=1){
                        foreach ($gallery_photo as $gallery_photo_val) {
                            $new_gallery_photo[]= $this->SingleAppClass_pos->getImage($gallery_photo_val);
                        }
                        $res['gallery']=$new_gallery_photo;                 
                    }           
                }
                
                /*CHECK IF MULTIPLE PRICE*/
                $res['multiple_price'] = false;
                
                $res['quantity']=!empty($res['quantity'])?json_decode($res['quantity'],true):false;     
                
                if(is_array($res['prices']) && count($res['prices'])>=2){   
                    $new_price = array();
                    foreach ($res['prices'] as $keyss=>$prices) {
                        $prices['size']=$this->functions->qTranslate($prices['size'],'size',$prices);       
                        
                        if($res['is_variable_price']==2){$prices['variableprice']=$res['quantity'][$keyss];}
                        else{$prices['variableprice']="0";}
                        
                        $new_price[]=$prices;
                    }
                    $res['prices']=$new_price;                  
                    $res['multiple_price'] = true;
                } else {                
                    /*FIXED FOR SINGLE PRICE WITH ONLY 1 SIZE*/ 
                    if(isset($res['prices'][0])){
                        
                            
                        if($res['is_variable_price']==2){
                            $res['prices'][0]['variableprice']=$res['quantity'][0];
                        }else{$res['prices'][0]['variableprice']="0";}
                        
                        
                        
                        
                        
                        if( $res['prices'][0]['size_id']>0 ){
                            $res['multiple_price'] = true;
                        }                   
                    }                                   
                }   

                $row = isset($this->data['row'])?$this->data['row']:'';
                if(is_numeric($row)){

                    $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
                    
                    if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
                        $cart=json_decode($resp['cart'],true);
                        if(array_key_exists($row,(array)$cart)){
                            $cart[$row]['row']=$row;
                            $cart_data = isset($cart[$row])?$cart[$row]:'';
                        }
                    }
                } else $cart_data='';
                
                // GET FAVORITE
                $is_favorite = false;
                
                
                $inventory_enabled = $this->SingleAppClass_pos->inventoryEnabled($this->merchant_id);
                                            
                $this->code = 1;
                $this->msg = "OK";

               //+++was custom code
                if (isset($res) && is_array($res)) {
    foreach ($res as $key => $value) {
        if ($key === 'prices' && is_array($value)) {
            foreach ($res['prices'] as $i => $priceItem) {
                foreach ($priceItem as $priceKey => $priceVal) {
                    if (
                        ($priceKey !== 'size_id' && $priceKey !== 'discount_price') &&
                        (is_int($priceVal) || is_float($priceVal))
                    ) {
                        $res['prices'][$i][$priceKey] = (string)$priceVal;
                    }
                }
            }
        } elseif (is_int($value) || is_float($value)) {
            $res[$key] = (string)$value;
        }
    }
}


if (isset($res['addon_item']) && is_array($res['addon_item'])) {
    foreach ($res['addon_item'] as &$addon) {
        if (isset($addon['sub_item']) && is_array($addon['sub_item'])) {
            foreach ($addon['sub_item'] as &$sub_item) {
                if (isset($sub_item['sub_item_id'])) {
                    $sub_item['sub_item_id'] = strval($sub_item['sub_item_id']);
                }
            }
        }
    }
    unset($addon, $sub_item); // clean references
}

if (isset($res['quantity']) && $res['quantity'] === "") {
    $res['quantity'] = [];
}


// Loop through prices and fix leading spaces
if (isset($res['prices']) && is_array($res['prices'])) {
    foreach ($res['prices'] as $index => $price_item) {
        if (isset($price_item['formatted_price'])) {
            $res['prices'][$index]['formatted_price'] = ltrim($price_item['formatted_price']);
        }
        if (isset($price_item['formatted_discount_price'])) {
            $res['prices'][$index]['formatted_discount_price'] = ltrim($price_item['formatted_discount_price']);
        }
    }
}

//---was custom code



                $this->details = array(
                  'inventory_enabled'=>$inventory_enabled==true?1:0,
                  'cat_id'=>isset($this->data['cat_id'])?$this->data['cat_id']:'',
                  'data'=>$res,
                  
                  'cart_data'=>$cart_data,      
                  'ordering_disabled'=>$ordering_disabled,
                  'ordering_msg'=>$ordering_msg,
                  'is_favorite'=>$is_favorite
                );
                
            } else {
                $this->msg=("Item details not found");
                $this->code = 6;
                $this->details = array(
                  'title'=>("Item details not found"),
                  'sub_title'=>("Sorry but we cannot find what your looking for")
                );  
            }       
        } else {
            $this->msg = ("Invalid item id");
            $this->code = 6;
            $this->details = array(
              'title'=>("Invalid item id"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
        }   
        $this->output();        
    }



    public function loadItemDetails_pro()
    {       
        
        /*CHECK IF ORDERING IS DISABLED*/
        $ordering_disabled=false; $ordering_msg='';
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by admin");
            $ordering_disabled=true;            
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $ordering_msg = ("Ordering is disabled by merchant");
            $ordering_disabled=true;
        }
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $ordering_msg = ("Merchant is now close and not accepting any orders");
            $ordering_disabled=true;
        }
        
         $cart_data=array();
        $item_id = isset($this->data['item_id'])?$this->data['item_id']:'';
        
        $trans=$this->functions->getOptionAdmin('enabled_multiple_translation'); 
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if(is_numeric($item_id)){
            if ($res=$this->functions->getItemById($this->data['item_id'])){
                $res = $res[0]; 
                                
                /*TRANSLATE ADDON*/
                if($trans==2){
                    $new_addon = array();
                    if(is_array($res['addon_item']) && count($res['addon_item'])>=1){
                        foreach ($res['addon_item'] as $add_val) {                          
                            $add_val['subcat_name']=$this->functions->qTranslate($add_val['subcat_name'],'subcat_name',$add_val);
                                                                                    
                            if(is_array($add_val['sub_item']) && count($add_val['sub_item'])>=1){
                                $new_sub_item = array();
                                foreach ($add_val['sub_item'] as $sub_item_val) {
                                    $sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'],'sub_item_name',$sub_item_val);
                                    $sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'],'item_description',$sub_item_val);                                   
                                    $new_sub_item[]=$sub_item_val;
                                }
                                $add_val['sub_item']=$new_sub_item;
                            }                                                   
                                                        
                            $new_addon[]=$add_val;
                        }
                        
                        $res['addon_item']=$new_addon;
                    }               
                }                               
                /*END TRANSLATE ADDON*/
                
                /*$food_option_not_available = $this->functions->getOption($this->merchant_id,'food_option_not_available');     
                if($food_option_not_available==2){*/
                    if($res['not_available']==2){               
                       $ordering_msg = ("Sorry but this item is not available");
                       $ordering_disabled=true;
                    }
                //} 
                
                $res['item_name']=$this->functions->qTranslate($res['item_name'],'item_name',$res);         
                $res['item_description']=$this->functions->qTranslate($res['item_description'],'item_description',$res);
                
                $res['barcode'] = $res['barcode'];
                $res['item_name'] = ($res['item_name']);
                $res['item_description'] = ($res['item_description']);
                $res['item_name_trans'] = ($res['item_name_trans']);
                $res['item_description_trans'] = ($res['item_description_trans']);
                
                if(!empty($res['photo'])){
                    $res['photo'] = $this->SingleAppClass_pos->getImage($res['photo']);
                } else $res['photo'] = $this->SingleAppClass_pos->getImage($this->functions->getOption('singleapp_default_image',$this->merchant_id),'default_cuisine.png');
                
                /*GET DISH*/
                $icon_dish= array();
                if(!empty($res['dish'])){               
                           
                       $icon_dish = $this->functions->getDishIcon($res['dish']);
                    
                } else $icon_dish='';
                
                $res['dish_list'] = $icon_dish;
                                
                /*GALLERY*/
                $res['gallery']=array();
                if(!empty($res['gallery_photo'])){
                    $new_gallery_photo=array();
                    $gallery_photo = json_decode($res['gallery_photo'],true);
                    if(is_array($gallery_photo) && count((array)$gallery_photo)>=1){
                        foreach ($gallery_photo as $gallery_photo_val) {
                            $new_gallery_photo[]= $this->SingleAppClass_pos->getImage($gallery_photo_val);
                        }
                        $res['gallery']=$new_gallery_photo;                 
                    }           
                }
                
                /*CHECK IF MULTIPLE PRICE*/
                $res['multiple_price'] = false;
                if(is_array($res['prices']) && count($res['prices'])>=2){   
                    $new_price = array();
                    foreach ($res['prices'] as $prices) {
                        $prices['size']=$this->functions->qTranslate($prices['size'],'size',$prices);                   
                        $new_price[]=$prices;
                    }
                    $res['prices']=$new_price;                  
                    $res['multiple_price'] = true;
                } else {                
                    /*FIXED FOR SINGLE PRICE WITH ONLY 1 SIZE*/ 
                    if(isset($res['prices'][0])){
                        if( $res['prices'][0]['size_id']>0 ){
                            $res['multiple_price'] = true;
                        }                   
                    }                                   
                }           
                
                $row = isset($this->data['row'])?$this->data['row']:'';
                if(is_numeric($row)){               
                    if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
                        $cart=json_decode($resp['cart'],true);
                        if(array_key_exists($row,(array)$cart)){
                            $cart[$row]['row']=$row;
                            $cart_data = isset($cart[$row])?$cart[$row]:'';
                        }
                    }
                } else $cart_data='';
                
                // GET FAVORITE
                $is_favorite = false;
            
                $inventory_enabled = $this->SingleAppClass_pos->inventoryEnabled($this->merchant_id);
                                            
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                  'inventory_enabled'=>$inventory_enabled==true?1:0,
                  'cat_id'=>isset($this->data['cat_id'])?$this->data['cat_id']:'',
                  'data'=>$res,
                  'cart_data'=>$cart_data,      
                  'ordering_disabled'=>$ordering_disabled,
                  'ordering_msg'=>$ordering_msg,
                  'is_favorite'=>$is_favorite
                );
                
            } else {
                $this->msg=("Item details not found");
                $this->code = 6;
                $this->details = array(
                  'title'=>("Item details not found"),
                  'sub_title'=>("Sorry but we cannot find what your looking for")
                );  
            }       
        } else {
            $this->msg = ("Invalid item id");
            $this->code = 6;
            $this->details = array(
              'title'=>("Invalid item id"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
        }   
        $this->output();        
    }


    


    public function addToCartRetail()
    {               
        
        $code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;      
        if($code_version<2.2){
            $this->getGETData();
            $this->data = $_GET;
        } else {
            $this->getPOSTData();
            $this->data = $_POST;
        }   
            
        $data = $_POST;         
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        $cart_count = 0;
        $data['merchant_id'] = $this->merchant_id;
        //$device_id = $this->device_uiid;
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];       
            
        }
        
        
            
        
        //vvvvvvvv
        $item_id = isset($data['item_id'])?$data['item_id']:'';     
        
        if(!is_numeric($item_id)){
            $this->msg = ("Invalid item id");
            $this->output();
        }
        
        
        $qty = isset($data['qty'])?$data['qty']:'';     
        
        
        if($_REQUEST['variable_price']>0){$data['qty']=$qty=1;}
        
        if($qty>0){         
            if (strpos($qty,'.') !== false) {
               $this->msg = ("invalid quantity");
               $this->output();
            }   
        } else {
            $this->msg = ("invalid quantity");
            $this->output();
        }
        
        if(!$item_details = $this->functions->getFoodItem($item_id)){
            $this->msg = ("Item details not found");
            $this->output();
        }
        if($item_details['merchant_id']!=$this->merchant_id){
            $this->msg = ("Item does not belong to merchant");
            $this->output();
        }       
        $data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
        $data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
        
        
         
        
        /*dump($data);
        die();*/
        
        if(!isset($data['price'])){
            $this->msg = ("Please select price");
            $this->output();
        }
                
        $refresh = 0;
        
        if(!empty($device_id)){         
            
            
            $debug = false; 
            
            if ( $res = $this->SingleAppClass_pos->getCart($device_id,$this->merchant_id,$table_number)){
                $current_cart = json_decode($res['cart'],true);
                                
                $row = isset($data['row'])?$data['row']:'';
                if(is_numeric($row)){                               
                    $current_cart[$row]= $data;

                    if($table_number>0){
                        
                            $current_cart[$row]['is_printed']=0;  
                            
                            $current_cart[$row]['is_printed_already']='Updated Item';
                                            
                    }
                            

                    
                    $refresh = 1;       
                } else {                    
                    
                    
                    /*CHECK IF THE ITEM IS ALREADY IN THE CART */                   
                    $item_found = true; $found_key = -1;
                    
                    if(is_array($current_cart) && count($current_cart)>=1){
                        foreach ($current_cart as $current_cart_key => $current_cart_val) {
                            /*dump($current_cart_key);
                            dump($current_cart_val);*/
                            if($table_number>0){
                            if($current_cart_val['is_printed']>0){}else{$data['is_printed']=0;}
                            }
                            
                            $item_found = true;
                                                    
                            if ($current_cart_val['item_id']!=$data['item_id']){
                                $item_found = false;
                            }
                            if ($current_cart_val['price']!=$data['price']){
                                $item_found = false;
                            }
                            
                            /*COOKING REF*/
                            if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
                                if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
                                    $item_found = false;
                                }
                            } else {                                
                                if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*INGREDIENTS*/
                            if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
                                $ingredients = json_encode($data['ingredients']);
                                $ingredients2 = json_encode($current_cart_val['ingredients']);                              
                                if($ingredients!=$ingredients2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*ADDON*/
                            if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
                                $sub_item = json_encode($data['sub_item']);
                                $sub_item2 = json_encode($current_cart_val['sub_item']);
                                if($sub_item!=$sub_item2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            if($item_found==TRUE){                              
                               $found_key = $current_cart_key;
                            } 
                            
                        } /*END LOOP*/
                        
                        if($found_key>=0){
                            if($table_number>0){
                            
                            if($current_cart[$found_key]['is_printed']==1){$current_cart[$found_key]['is_printed_already']='Updated Item';}
                            $current_cart[$found_key]['is_printed']=0;  
                            
                            }
                            
                                                
                            $current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
                        } else {
                            if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';  }    
                            
                            array_push($current_cart,$data);
                        }
                        
                    } else {
                        if($table_number>0){$data['is_printed']=0;}
                        array_push($current_cart,$data);
                    }                   
                }
                    
                
                
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = 0;               
                  foreach ($current_cart as $val) {
                      if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
                         $inv_qty+=$val['qty'];
                      }
                  }                                               
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
                  } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    $this->output();
                  }                   
                }
                
                
                $cart_count = count($current_cart);
                $this->functions->updateData("mt_pos_cart",array(
                  'device_id'=>$device_id,
                  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
                  'cart'=>json_encode($current_cart),
                  'cart_count'=>$cart_count,
                  'table_number'=>$table_number,
                  'date_modified'=>$this->functions->dateNow(),
                ),'cart_id', $res['cart_id']);
            } else {            
                    
            
                


            $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
            
                        
        if($minfouser['pos_cashier_access']==1){                $created_by='Cashier';
        }else{          $created_by='Waiter';           
        if($table_number>0){            
    $stmt1 = "SELECT table_number FROM mt_pos_cart WHERE 1 AND table_number = $table_number";       
    $stmt = $this->db->prepare($stmt1);
    $stmt->execute();
    if ($res1 = $stmt->fetch(PDO::FETCH_ASSOC)){
        $this->code = 1;
        $this->msg = ("This Table is already active. You cannot add items");
        $this->output();
        //die();
    }else{          
            
    }
}
        
        } 
        
        //mmmmmmmmm
            
            // 'cart'=>json_encode(array($data),JSON_FORCE_OBJECT),
            //// item already added $data['is_printed_already']='item already added';
                if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';}
                
                    
                $cart_count=1;
                $this->functions->insertData("mt_pos_cart",array(
                 'device_id'=>$device_id,
                 'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
                 'cart'=>json_encode(array($data)),
                 'cart_count'=>$cart_count,
                 'table_number'=>$table_number,
                  'created_id'=>$_REQUEST['pos_user_id'],
                 'created_by'=>$created_by,
                 
                 'date_modified'=>$this->functions->dateNow(),
                 'merchant_id'=>$this->merchant_id
                ));
            }       
            
            
            $this->code = 1;
            $this->msg=("Added to cart");
            if($refresh==1){
                $this->msg=("Cart updated");
            }           
            $this->details=array(
             'cart_count'=>$cart_count,
             'refresh'=>$refresh
            );
                
        } else $this->msg = ("Device id is empty. please restart the application and try again");
        $this->output();
    }


    public function addToCart()
    {               
        
        $code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;      
        if($code_version<2.2){
            $this->getGETData();
            $this->data = $_GET;
        } else {
            $this->getPOSTData();
            $this->data = $_POST;
        }   
            
        $data = $_POST;         
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        $cart_count = 0;

        $data['merchant_id'] = strval($this->merchant_id);
        //$device_id = $this->device_uiid;
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];       
            
        }
        
        
            
        
        //vvvvvvvv
        $item_id = isset($data['item_id'])?$data['item_id']:'';     
        
        if(!is_numeric($item_id)){
            $this->msg = ("Invalid item id");
            $this->output();
        }
        
        
        $qty = isset($data['qty'])?$data['qty']:'';     
        
        
        if($_REQUEST['variable_price']>0){$data['qty']=$qty=1;}
        
        if($qty>0){         
            if (strpos($qty,'.') !== false) {
               $this->msg = ("invalid quantity");
               $this->output();
            }   
        } else {
            $this->msg = ("invalid quantity");
            $this->output();
        }
        
        if(!$item_details = $this->functions->getFoodItem($item_id)){
            $this->msg = ("Item details not found");
            $this->output();
        }
        if($item_details['merchant_id']!=$this->merchant_id){
            $this->msg = ("Item does not belong to merchant");
            $this->output();
        }       
        $data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
        $data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
        
        $data['non_taxable'] =strval($data['non_taxable']);
         
        
        /*dump($data);
        die();*/
        
        if(!isset($data['price'])){
            $this->msg = ("Please select price");
            $this->output();
        }
                
        $refresh = 0;
        
        if(!empty($device_id)){         
            
            
            $debug = false; 
            
            
            
            $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
            
                /* ----------------- if Phone order-----------------------------   */
                /* ----------------- if Phone order-----------------------------   */               
                
            $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
            if($cart_id>0){
                $res=$this->SingleAppClass_pos->getCart_bycartid($device_id,$this->merchant_id,$cart_id);   
            }else{          
                $res = $this->SingleAppClass_pos->getCartForPhoneForAdditems($device_id,$this->merchant_id,0,$phone_order);
            }
            
            
                if ($res){
                    $carts_id=$res['cart_id'];
                $current_cart = json_decode($res['cart'],true);
                                
                $row = isset($data['row'])?$data['row']:'';
                if(is_numeric($row)){                               
                    $current_cart[$row]= $data;

                    if($table_number>0){                        
                            $current_cart[$row]['is_printed']=0;                            
                            $current_cart[$row]['is_printed_already']='Updated Item';                                           
                    }
                            
            
                    $refresh = 1;       
                } else {                    
                    
                    /*CHECK IF THE ITEM IS ALREADY IN THE CART */                   
                    $item_found = true; $found_key = -1;
                    
                    if(is_array($current_cart) && count($current_cart)>=1 && 1==2){
                        foreach ($current_cart as $current_cart_key => $current_cart_val) {
                            /*dump($current_cart_key);
                            dump($current_cart_val);*/
                            if($table_number>0){
                            if($current_cart_val['is_printed']>0){}else{$data['is_printed']=0;}
                            }
                            
                            $item_found = true;
                                                    
                            if ($current_cart_val['item_id']!=$data['item_id']){
                                $item_found = false;
                            }
                            if ($current_cart_val['price']!=$data['price']){
                                $item_found = false;
                            }
                            
                            /*COOKING REF*/
                            if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
                                if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
                                    $item_found = false;
                                }
                            } else {                                
                                if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*INGREDIENTS*/
                            if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
                                $ingredients = json_encode($data['ingredients']);
                                $ingredients2 = json_encode($current_cart_val['ingredients']);                              
                                if($ingredients!=$ingredients2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*ADDON*/
                            if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
                                $sub_item = json_encode($data['sub_item']);
                                $sub_item2 = json_encode($current_cart_val['sub_item']);
                                if($sub_item!=$sub_item2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            if($item_found==TRUE){                              
                               $found_key = $current_cart_key;
                            } 
                            
                        } /*END LOOP*/
                        
                        if($found_key>=0){
                            if($table_number>0){
                            
                            if($current_cart[$found_key]['is_printed']==1){$current_cart[$found_key]['is_printed_already']='Updated Item';}
                            $current_cart[$found_key]['is_printed']=0;  
                            
                            }
                            
                                                    
                            $current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
                        } else {
                            if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';  }    
                            
                            array_push($current_cart,$data);
                        }
                        
                    } else {
                        if($table_number>0){$data['is_printed']=0;}
                        array_push($current_cart,$data);
                    }                   
                }
                    
                
                
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                

                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = 0;               
                  foreach ($current_cart as $val) {
                      if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
                         $inv_qty+=$val['qty'];
                      }
                  }                                               
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
                  } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    $this->output();
                  }                   
                }
                
                
                $cart_count = count($current_cart);
                $this->functions->updateData("mt_pos_cart",array(
                  'device_id'=>$device_id,
                  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
                  'cart'=>json_encode($current_cart),
                  'cart_count'=>$cart_count,
                  'table_number'=>$table_number,
                 'is_phone_order'=>$_REQUEST['phone_order'],        
                  'date_modified'=>$this->functions->dateNow(),
                ),'cart_id', $res['cart_id']);
                
            $carts_id=$res['cart_id'];  
                
            } else {            
                $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
                if($minfouser['pos_cashier_access']==1){
                            $created_by='Cashier';
                    } 
            
        //mmmmmmmmm
            
            // 'cart'=>json_encode(array($data),JSON_FORCE_OBJECT),
            //// item already added $data['is_printed_already']='item already added';
                if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';}
                
                    
                $cart_count=1;
                $carts_id =$this->functions->insertData("mt_pos_cart",array(
                 'device_id'=>$device_id,
                 'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
                 'cart'=>json_encode(array($data)),
                 'cart_count'=>$cart_count,
                 'table_number'=>$table_number,
                  'created_id'=>$_REQUEST['pos_user_id'],
                 'created_by'=>$created_by,
                 'is_phone_order'=>$_REQUEST['phone_order'],                 
        
                 'date_modified'=>$this->functions->dateNow(),
                 'merchant_id'=>$this->merchant_id
                ));
                
                
            }       
            
            
            /* if Phone order   */
            /* if Phone order   */
                }else{
            
            
            
            
            
            if ( $res = $this->SingleAppClass_pos->getCart($device_id,$this->merchant_id,$table_number)){

               
                $current_cart = json_decode($res['cart'],true);
                                
                $row = isset($data['row'])?$data['row']:'';
                if(is_numeric($row)){                               
                    $current_cart[$row]= $data;

                    if($table_number>0){                        
                            $current_cart[$row]['is_printed']=0;                            
                            $current_cart[$row]['is_printed_already']='Updated Item';                                           
                    }
                            
            
                    $refresh = 1;       
                } else {                    
                    
                    /*CHECK IF THE ITEM IS ALREADY IN THE CART */                   
                    $item_found = true; $found_key = -1;
                    
                    if(is_array($current_cart) && count($current_cart)>=1 && 1==2){
                        foreach ($current_cart as $current_cart_key => $current_cart_val) {
                            /*dump($current_cart_key);
                            dump($current_cart_val);*/
                            if($table_number>0){
                            if($current_cart_val['is_printed']>0){}else{$data['is_printed']=0;}
                            }
                            
                            $item_found = true;
                                                    
                            if ($current_cart_val['item_id']!=$data['item_id']){
                                $item_found = false;
                            }
                            if ($current_cart_val['price']!=$data['price']){
                                $item_found = false;
                            }
                            
                            /*COOKING REF*/
                            if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
                                if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
                                    $item_found = false;
                                }
                            } else {                                
                                if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*INGREDIENTS*/
                            if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
                                $ingredients = json_encode($data['ingredients']);
                                $ingredients2 = json_encode($current_cart_val['ingredients']);                              
                                if($ingredients!=$ingredients2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*ADDON*/
                            if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
                                $sub_item = json_encode($data['sub_item']);
                                $sub_item2 = json_encode($current_cart_val['sub_item']);
                                if($sub_item!=$sub_item2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            if($item_found==TRUE){                              
                               $found_key = $current_cart_key;
                            } 
                            
                        } /*END LOOP*/
                        
                        if($found_key>=0){
                            if($table_number>0){
                            
                            if($current_cart[$found_key]['is_printed']==1){$current_cart[$found_key]['is_printed_already']='Updated Item';}
                            $current_cart[$found_key]['is_printed']=0;  
                            
                            }
                            
                                                    
                            $current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
                        } else {
                            if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';  }    
                            
                            array_push($current_cart,$data);
                        }
                        
                    } else {
                        if($table_number>0){$data['is_printed']=0;}
                        array_push($current_cart,$data);
                    }                   
                }
                    
                
                
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = 0;               
                  foreach ($current_cart as $val) {
                      if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
                         $inv_qty+=$val['qty'];
                      }
                  }                                               
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
                  } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    $this->output();
                  }                   
                }
                
                
                $cart_count = count($current_cart);
                $this->functions->updateData("mt_pos_cart",array(
                  'device_id'=>$device_id,
                  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
                  'cart'=>json_encode($current_cart),
                  'cart_count'=>$cart_count,
                  'table_number'=>$table_number,
                  'date_modified'=>$this->functions->dateNow(),
                ),'cart_id', $res['cart_id']);
                
                $carts_id=$res['cart_id'];  
                
            } else {




                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = isset($data['qty'])?(integer)$data['qty']:1;             
                                                              
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
                  } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    $this->output();
                  }                   
                }




                $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
            if($minfouser['pos_cashier_access']==1){
                $created_by='Cashier';
        }else{
        $created_by='Waiter';       
        if($table_number>0){            
    $stmt1 = "SELECT table_number FROM mt_pos_cart WHERE 1 AND table_number = $table_number LIMIT 1";       
    $stmt = $this->db->prepare($stmt1);
    $stmt->execute();
    if ($res1 = $stmt->fetch(PDO::FETCH_ASSOC)){
        $this->code = 1;
        $this->msg = ("This Table is already active. You cannot add items");
        $this->output();
        //die();
    }else{          
            
    }
}
        
        } 
        
        //mmmmmmmmm
            
            // 'cart'=>json_encode(array($data),JSON_FORCE_OBJECT),
            //// item already added $data['is_printed_already']='item already added';
                if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';}
                
                    
                $cart_count=1;
                $carts_id=$this->functions->insertData("mt_pos_cart",array(
                 'device_id'=>$device_id,
                 'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
                 'cart'=>json_encode(array($data)),
                 'cart_count'=>$cart_count,
                 'table_number'=>$table_number,
                  'created_id'=>$_REQUEST['pos_user_id'],
                 'created_by'=>$created_by,
                
                 'date_modified'=>$this->functions->dateNow(),
                 'merchant_id'=>$this->merchant_id
                ));
                
                
                
            }       
            
            
                }
            
            //$carts_id=$res['cart_id'];
            $this->code = 1;
            $this->msg=("Added to cart");
            if($refresh==1){
                $this->msg=("Cart updated");
            }           
            $this->details=array(
             'cart_count'=>$cart_count,
             'cart_id'=>$carts_id,
             'refresh'=>$refresh
            );
                
        } else $this->msg = ("Device id is empty. please restart the application and try again");
        $this->output();
    }


    public function getCartCount()
    {       
        $basket_total=0;$item_total=0; 
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($client_info = $this->SingleAppClass_pos->getCustomerByToken($token)){                       
            $this->data['client_id'] = $client_info['client_id'];                       
            $this->data['merchant_id'] = $this->merchant_id;
            $this->SingleAppClass_pos->registeredDevice($this->data);
        }
        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        
        
        if($res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $cart=json_decode($res['cart'],true);           
            
            $params = array(
              'delivery_type'=>'delivery',
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $params,$cart );
            $code = $displayOrderHTML['code'];      
            if($code==1){
                $details = $displayOrderHTML['raw'];
                if(is_array($cart) && count($cart)>=1){
                    foreach ($cart as $val) {                   
                        $item_total+=$val['qty'];
                    }
                }               
                $basket_total = $details['total']['subtotal'];
                $basket_total = $this->functions->prettyPrice($basket_total);
                $this->code=1;
                $this->msg = "OK";              
                $this->details = array(
                  'count'=>$item_total,
                  
                  'basket_count'=>$item_total." items",
                  'basket_total'=>$basket_total
                );      

             
            
                
                $this->output();
            }                               
        } 
        
        $this->msg=("0 found");
        $this->details = array(
          'basket_count'=>("0 item"),
          'basket_total'=>$this->functions->getCurrencyCode()."0.00"
        );              
        $this->output();
    }


public function loadCart()
    {  

        $this->setMerchantTimezone();       
        
        /*CHECK IF ORDERING IS DISABLED*/
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $this->msg = ("Ordering is disabled by admin");
            $this->code = 4;
            $this->output();
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $this->msg = ("Ordering is disabled by merchant");
            $this->code = 4;
            $this->output();
        }
                
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $this->msg = ("Merchant is now close and not accepting any orders");
            $this->code = 4;
            $this->output();
        }
        
        
        $search_resp = $this->SingleAppClass_pos->searchMode();     
        $search_mode = $search_resp['search_mode']; 
        $location_mode = $search_resp['location_mode']; 
                
                
        $transaction_type='';
        $services = $this->functions->DeliveryOptions($this->merchant_id);
        
        if(is_array($services) && count($services)>=1){
            foreach ($services as $services_key=>$services_val) {               
                $transaction_type = $services_key;
                break;              
            }
        }
        
        if(isset($this->data['transaction_type'])){
            if(!empty($this->data['transaction_type'])){
                $transaction_type=$this->data['transaction_type'];
            }
        } else {
            $this->data['transaction_type'] = $transaction_type;
        }   
        
        $params_logs=array(
                                
                  
                  'response'=>json_encode($this->data)
                ); 
        $this->functions->insertData("mt_response",$params_logs); 
        
        $this->data['transaction_type'] = $transaction_type='pickup';
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        
        /* if order by phone number*/
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
        if($table_number>0){$phone_order=0;}
        
        if($phone_order>0){$table_number=0;}
        
        
        
        //mmmmmmmmmmmmmmmmmmmm
        
        if($phone_order>0){         

            $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}

            //+++was lock check
            $is_lock=$this->functions->pos_cart_lock_chk($this->device_uiid,$cart_id);
            if($is_lock){
              $device_id=$is_lock['current_device_id'];
              if($device_id==$this->device_uiid){

              }else{
                $minfouser=$this->functions->getMerchantUserInfobymid($is_lock['lock_user_id']);

                $username=$minfouser['username'];

                

                $this->msg = "This order is locked with ".  $username. " Please ask " .$username. " to process the order.";$this->output();
              }
             
            }



           //---was lock check

            //+++unlock all carts which are locked against this device uuiid
            $this->functions->unlock_allcarts($this->device_uiid);

            //---unlock all carts which are locked against this device uuiid
        
            $res=$this->SingleAppClass_pos->getCart_bycartid($this->device_uiid,$this->merchant_id,$cart_id);

            

            $params_lock = [
                'current_device_id'       => $this->device_uiid,
                'lock_user_id'       => $_REQUEST['pos_user_id'],
                'lock_flag'   => 1
            ];

            $this->functions->updateData('mt_pos_cart', $params_lock, 'cart_id', $cart_id);

        }else{
        
        
        
        /*GET CART*/
        $res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number);
        }
        if($res && !empty($res)){}else{
            $this->code = 2;

            $this->msg = ("Cart is empty");


            //$this->details['promo_items_data']="";

        $this->output();}
        /*CHECK TIPS DEFAULT*/
        if($res && $transaction_type=="delivery"){
            $merchant_tip_default = $this->functions->getOption('merchant_tip_default',$this->merchant_id);     
            if($merchant_tip_default>0 && $res['tips']<=0 && $res['remove_tip']<=0 ){           
                $res['tips'] = $merchant_tip_default;
                
                

                $this->functions->updateData('mt_pos_cart' , array(
                  'tips'=>$merchant_tip_default
                ), 'cart_id',$res['cart_id']);



            }                   
                      
        } else if ( $res ) {
            if($res['tips']>0){

                

                $this->functions->updateData('mt_pos_cart' , array(
                  'tips'=>0
                ), 'cart_id',$res['cart_id']);


            }       
            $res['tips'] = 0;
        }else{
            $this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
        $this->output();
        }   

                
        if($res){
            
                $this->data['transaction_type'] = $transaction_type=$res['order_type'];
            
            
            $cart=json_decode($res['cart'],true);                   
                    
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            //dump($data);
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }       
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['points_apply']>0.0001){
                $data['points_apply']=$res['points_apply'];
            }
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }
            
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $cart_details = $res;
            unset($cart_details['cart']);       
            unset($cart_details['device_id']);
            unset($cart_details['cart_id']);
            unset($cart_details['cart_id']);                                    
            unset($_SESSION['pts_redeem_amt']);
            
            /*inventory*/
            if($this->SingleAppClass_pos->inventoryEnabled($this->merchant_id) && 1==2){
                $new_cart = array();                
                if(is_array($cart) && count($cart)>=1){
                    foreach ($cart as $cartval) {                       
                        try {                                 
                           $this->StocksWrapper->verifyStocks(
                              isset($cartval['qty'])?(integer)$cartval['qty']:0,
                              $this->merchant_id,
                              isset($cartval['item_id'])?(integer)$cartval['item_id']:0,
                              isset($cartval['with_size'])?(integer)$cartval['with_size']:0,
                              isset($cartval['price'])?$cartval['price']:0
                           );
                           $new_cart[]=$cartval;
                        } catch (Exception $e) {
                            //echo $e->getMessage();
                         }
                    }
                    $cart = $new_cart;
                }           
            }
            
            
            
            $multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');   
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
               $this->code = 1;
               $details = $displayOrderHTML['raw'];
                  
               
               /*TRANSLATE*/
               if($multiple_translation==2){
                   if(is_array($details['item']) && count($details['item'])>=1){
                      $new_item = array();
                      foreach ($details['item'] as $key=> $details_item_val) {                      
                         $details_item_val['item_name'] = $this->functions->qTranslate($details_item_val['item_name'],'item_name',$details_item_val['item_name_trans']);
                         
                         if(isset($details_item_val['new_sub_item'])){
                         if(is_array($details_item_val['new_sub_item']) && count($details_item_val['new_sub_item'])>1){                         
                            $newest_new_sub_item_val=array();
                            foreach ($details_item_val['new_sub_item'] as $new_sub_item_key=>$new_sub_item_val) {       
                                $new_sub_item_key = $this->functions->qTranslate($new_sub_item_key,'subcategory_name',$new_sub_item_val[0]['subcategory_name_trans']);                                                              
                                $newest_new_sub_item_val[$new_sub_item_key]=$new_sub_item_val;
                            }       
                            $details_item_val['new_sub_item']=$newest_new_sub_item_val;
                         }                    
                         }
                         
                         $new_item[$key]=$details_item_val;
                      }     
                      $details['item']=$new_item;
                      
                      
                   }            
               }
               /*END TRANSLATE*/
               
               //dump($details);
        
                
               
               
               /*EURO TAX*/
               $is_apply_tax = 2;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($details, $this->merchant_id);
                   $details['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/
               
               //dump($details);
               
               $has_addressbook = 0;
               $client_id='';
               $client_id = isset($this->data['client_id'])?$this->data['client_id']:'0';
               
               /*
               $token = isset($this->data['token'])?$this->data['token']:'';
               
               
               if($client_info = $this->SingleAppClass_pos->getCustomerByToken($token)){
                   $client_id = $client_info['client_id'];
                   if($search_mode=="location"){
                       if(LocationWrapper::hasAddress($client_id)){
                          $has_addressbook = 1; 
                       }                   
                   } else {
                       if ($this->SingleAppClass_pos->getAddressBookByClient($client_id)){
                          $has_addressbook = 1; 
                       }
                   }
               }    
               */

               $defaul_delivery_date = date("Y-m-d");
               $date_list = $this->SingleAppClass_pos->deliveryDateList($this->merchant_id);
               foreach ($date_list as $date_list_key => $date_list_val) {                 
                  $defaul_delivery_date = $date_list_key;
                  break;
               }
               
               $subtotal = $details['total']['subtotal'];
               $cart_error=array();

               /*CHECKING MAX AND MIN AMOUNT*/
              if ( $transaction_type=="pickup"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_pickup',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        
                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);

                     }                
                  }                           
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_pickup',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);

                     }                
                  }         
               } elseif ( $transaction_type=="dinein"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_dinein',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        
                        $cart_error[] = "Sorry, your order does not meet the minimum".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);
                     }                
                  }                   
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_dinein',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);

                     }                
                  }         
               }               
               /*CHECKING MAX AND MIN AMOUNT*/  
                                      
               /*CHECK IF HAS POINTS ADDON*/
               $available_points=0; $available_points_label = '';
               $points_enabled = '';   $pts_disabled_redeem='';            
              
                                
                  $points_enabled = $this->functions->getOptionAdmin('points_enabled');
                  if($points_enabled=="1"){
                      if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                          $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                          if($mt_disabled_pts==2){
                             $points_enabled='';
                          }                       
                      }
                  }
                  
                  $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
                  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                      $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$this->merchant_id);
                      if($mt_pts_disabled_redeem>0){
                          $pts_disabled_redeem=$mt_pts_disabled_redeem;
                      }               
                  }
                   
                  /*GET EARNING POINTS FOR THIS ORDER*/
                  $subtotal = $details['total']['subtotal'];                  
                  if ($earn_pts = $this->SingleAppClass_pos->getCartEarningPoints($cart,$subtotal,$this->merchant_id)){                      
                    

                     $this->functions->updateData('mt_pos_cart' ,array(
                       'points_earn'=>$earn_pts['points_earn'],
                       'date_modified'=>$this->functions->dateNow()
                     ), 'cart_id',$res['cart_id']);



                  }         
                                                                   
                  if($client_id>0){                                                       
                      if($points_enabled=="1"){
                          $available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
                         
                          $available_points_label = "Your available points ".$available_points;
                      }
                   }               
                    
               
               $checkout_stats = $this->functions->isMerchantcanCheckout($this->merchant_id);
               if($checkout_stats['code']==2){
                  $cart_error[] = $checkout_stats['msg'];
               }            
               
               $subtotal = isset($details['total']['subtotal'])?$details['total']['subtotal']:0; 

              

                $this->functions->updateData('mt_pos_cart' ,array(
                  'cart_subtotal'=>(float)$subtotal,
                  'date_modified'=>$this->functions->dateNow()
                ), 'cart_id',$res['cart_id']);  
               
               if($earn_pts['points_earn']==0){$earn_pts['points_earn']='';$earn_pts['pts_label_earn']='';}
                
                //+++was custom code
                $details['total']['mid']=strval($details['total']['mid']);
               // $details['total']['total']=strval($details['total']['total']);

                if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as &$item) {
        // Convert "item_name_trans" to empty array if it has nested structure like: { "item_name_trans": "" }
        if (isset($item['item_name_trans']) && is_array($item['item_name_trans'])) {
            $item['item_name_trans'] = [];
        }

        // Also apply the same inside new_sub_item if needed
        if (isset($item['new_sub_item']) && is_array($item['new_sub_item'])) {
            foreach ($item['new_sub_item'] as &$subitemGroup) {
                if (is_array($subitemGroup)) {
                    foreach ($subitemGroup as &$subitem) {
                        if (isset($subitem['sub_item_name_trans']) && is_array($subitem['sub_item_name_trans'])) {
                            $subitem['sub_item_name_trans'] = [];
                        }
                    }
                }
            }
        }
    }
    unset($item, $subitem, $subitemGroup); // clean up references
}


//+++was custom code
if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as &$item) {
        if (!isset($item['is_printed']) || is_null($item['is_printed'])) {
            $item['is_printed'] = 0;
        }
        if (!isset($item['is_printed_already']) || is_null($item['is_printed_already'])) {
            $item['is_printed_already'] = "";
        }

        // If sub_item exists, apply same logic recursively
        if (isset($item['sub_item']) && is_array($item['sub_item'])) {
            foreach ($item['sub_item'] as &$subItem) {
                if (!isset($subItem['is_printed']) || is_null($subItem['is_printed'])) {
                    $subItem['is_printed'] = 0;
                }
                if (!isset($subItem['is_printed_already']) || is_null($subItem['is_printed_already'])) {
                    $subItem['is_printed_already'] = "";
                }
            }
        }
    }
    unset($item); // break reference
}
//---was custom code


                //---was custom code

//+++was custom code
if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as $i => $item) {

        // Fix size_name_trans if it's an array or object
        if (isset($details['item'][$i]['size_name_trans']) && is_array($details['item'][$i]['size_name_trans'])) {
            $details['item'][$i]['size_name_trans'] = '';
        }

        // Fix sub_item list
        if (isset($details['item'][$i]['sub_item']) && is_array($details['item'][$i]['sub_item'])) {
            foreach ($details['item'][$i]['sub_item'] as $j => $subitem) {
                if (isset($details['item'][$i]['sub_item'][$j]['sub_item_name_trans']) &&
                    is_array($details['item'][$i]['sub_item'][$j]['sub_item_name_trans'])) {
                    $details['item'][$i]['sub_item'][$j]['sub_item_name_trans'] = '';
                }
            }
        }

        // Fix new_sub_item
        if (isset($details['item'][$i]['new_sub_item']) && is_array($details['item'][$i]['new_sub_item'])) {
            foreach ($details['item'][$i]['new_sub_item'] as $cat => $addons) {
                foreach ($addons as $k => $addon) {
                    if (isset($details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans']) &&
                        is_array($details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans'])) {
                        $details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans'] = '';
                    }
                }
            }
        }

    }
}



if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as $key => $item) {
        if (isset($item['cooking_name_trans']) && is_array($item['cooking_name_trans']) && array_key_exists('cooking_name_trans', $item['cooking_name_trans'])) {
            $details['item'][$key]['cooking_name_trans'] = $item['cooking_name_trans']['cooking_name_trans'];
        }
    }
}

$cart_details['points_amount'] = number_format((float)$cart_details['points_amount'], 2, '.', '');

// Ensure normal_price and discounted_price stay floats with 2 decimal precision
if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as &$item) {
        if (isset($item['normal_price'])) {
            $item['normal_price'] = round((float)$item['normal_price'], 2);
        }
        if (isset($item['discounted_price'])) {
            $item['discounted_price'] = round((float)$item['discounted_price'], 2);
        }
    }
}


//---was custom code




               $this->details = array(
               'cart_id'=>$res['cart_id'],
                 'is_apply_tax'=>$is_apply_tax,
                 'checkout_stats'=>$checkout_stats,
                 'has_addressbook'=>$has_addressbook,
                 'services'=>$services,
                 'transaction_type'=>$transaction_type,
                 'default_delivery_date'=>$defaul_delivery_date,
                 //'default_delivery_date_pretty'=>date("D F d, Y"),
                 'default_delivery_date_pretty'=>$this->functions->prettyDate($defaul_delivery_date),
                 'required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),   
                 'tip_list'=>$this->SingleAppClass_pos->tipList(),
                 'data'=>$details,       
                 'cart_details'=>$cart_details,
                 
                 'cart_error'=>$cart_error,
                 'points_enabled'=>$points_enabled,              
                 'points_earn'=>isset($earn_pts['points_earn'])?$earn_pts['points_earn']:'',
                 'pts_label_earn'=>isset($earn_pts['pts_label_earn'])?$earn_pts['pts_label_earn']:'',
                 'available_points'=>$available_points,
                 'available_points_label'=>$available_points_label,
                 'pts_disabled_redeem'=>$pts_disabled_redeem,
                 'opt_contact_delivery'=>$this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id),
               );
            
               if($table_number>0){
                    $table_names=$this->functions->GetTables($table_number);
                    $this->details['table_name']=$table_names['name'];             
               }
            
            
            
            
            
            
             // dump($this->details);       
            
            
            
            
            } else {
                //$this->SingleAppClass_pos->clearCart($this->device_uiid,$table_number);
                $this->msg = $msg;
            }   
            
                
            
        } else {$this->msg = ("Cart is empty");$this->details['promo_items_data']=0;}
        $this->output();
    }


    public function unlock_cart_phoneorder(){
        $this->setMerchantTimezone(); 



         $params_unlock = [
                
                'lock_flag'   => 0
            ];

            $this->functions->updateData('mt_pos_cart', $params_unlock, 'cart_id', $this->data['cart_id']);
            $this->code = 1;
        $this->msg = "Order released";
        $this->output();

    }
    
    
    public function getcartbytable()
    {                       
        $this->setMerchantTimezone();       
        
        /*CHECK IF ORDERING IS DISABLED*/
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $this->msg = ("Ordering is disabled by admin");
            $this->code = 4;
            $this->output();
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $this->msg = ("Ordering is disabled by merchant");
            $this->code = 4;
            $this->output();
        }
                
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $this->msg = ("Merchant is now close and not accepting any orders");
            $this->code = 4;
            $this->output();
        }
        
        
        $search_resp = $this->SingleAppClass_pos->searchMode();     
        $search_mode = $search_resp['search_mode']; 
        $location_mode = $search_resp['location_mode']; 
                
                
        $transaction_type='';
        $services = $this->functions->DeliveryOptions($this->merchant_id);
        
        if(is_array($services) && count($services)>=1){
            foreach ($services as $services_key=>$services_val) {               
                $transaction_type = $services_key;
                break;              
            }
        }
        
        if(isset($this->data['transaction_type'])){
            if(!empty($this->data['transaction_type'])){
                $transaction_type=$this->data['transaction_type'];
            }
        } else {
            $this->data['transaction_type'] = $transaction_type;
        }   
        $this->data['transaction_type'] = $transaction_type='pickup';
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        /*GET CART*/
        $res=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);
        if($res && !empty($res)){}else{
            $this->code = 2;
            $this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
        $this->output();}
        /*CHECK TIPS DEFAULT*/
        if($res && $transaction_type=="delivery"){
            $merchant_tip_default = $this->functions->getOption('merchant_tip_default',$this->merchant_id);     
            if($merchant_tip_default>0 && $res['tips']<=0 && $res['remove_tip']<=0 ){           
                $res['tips'] = $merchant_tip_default;
                
                


                $this->functions->updateData("mt_pos_cart",array(
                  'tips'=>$merchant_tip_default
                ),'cart_id', $res['cart_id']);







            }                   
                      
        } else if ( $res ) {
            if($res['tips']>0){
                

                $this->functions->updateData("mt_pos_cart",array(
                  'tips'=>0
                ),'cart_id', $res['cart_id']);



            }       
            $res['tips'] = 0;
        }else{
            $this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
        $this->output();
        }   

                
        if($res){
            $cart=json_decode($res['cart'],true);                   
                    
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            //dump($data);
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }       
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['points_apply']>0.0001){
                $data['points_apply']=$res['points_apply'];
            }
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }
            
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $cart_details = $res;
            unset($cart_details['cart']);       
            unset($cart_details['device_id']);
            unset($cart_details['cart_id']);
            unset($cart_details['cart_id']);                                    
            unset($_SESSION['pts_redeem_amt']);
            
            /*inventory*/
            if($this->SingleAppClass_pos->inventoryEnabled($this->merchant_id)){
                $new_cart = array();                
                if(is_array($cart) && count($cart)>=1){
                    foreach ($cart as $cartval) {                       
                        try {                                 
                           $this->StocksWrapper->verifyStocks(
                              isset($cartval['qty'])?(integer)$cartval['qty']:0,
                              $this->merchant_id,
                              isset($cartval['item_id'])?(integer)$cartval['item_id']:0,
                              isset($cartval['with_size'])?(integer)$cartval['with_size']:0,
                              isset($cartval['price'])?$cartval['price']:0
                           );
                           $new_cart[]=$cartval;
                        } catch (Exception $e) {
                            //echo $e->getMessage();
                         }
                    }
                    $cart = $new_cart;
                }           
            }
            
            $multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');   
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
               $this->code = 1;
               $details = $displayOrderHTML['raw'];
               
               
               /*TRANSLATE*/
               if($multiple_translation==2){
                   if(is_array($details['item']) && count($details['item'])>=1){
                      $new_item = array();
                      foreach ($details['item'] as $key=> $details_item_val) {                      
                         $details_item_val['item_name'] = $this->functions->qTranslate($details_item_val['item_name'],'item_name',$details_item_val['item_name_trans']);
                         
                         if(isset($details_item_val['new_sub_item'])){
                         if(is_array($details_item_val['new_sub_item']) && count($details_item_val['new_sub_item'])>1){                         
                            $newest_new_sub_item_val=array();
                            foreach ($details_item_val['new_sub_item'] as $new_sub_item_key=>$new_sub_item_val) {       
                                $new_sub_item_key = $this->functions->qTranslate($new_sub_item_key,'subcategory_name',$new_sub_item_val[0]['subcategory_name_trans']);                                                              
                                $newest_new_sub_item_val[$new_sub_item_key]=$new_sub_item_val;
                            }       
                            $details_item_val['new_sub_item']=$newest_new_sub_item_val;
                         }                    
                         }
                         
                         $new_item[$key]=$details_item_val;
                      }     
                      $details['item']=$new_item;
                   }            
               }
               /*END TRANSLATE*/
               
               //dump($details);

               
               
               /*EURO TAX*/
               $is_apply_tax = 2;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($details, $this->merchant_id);
                   $details['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/
               
               //dump($details);
               
               $has_addressbook = 0;
               $client_id='';
               
               $token = isset($this->data['token'])?$this->data['token']:'';
               if($client_info = $this->SingleAppClass_pos->getCustomerByToken($token)){
                   $client_id = $client_info['client_id'];
                   if($search_mode=="location"){
                       if($this->LocationWrapper->hasAddress($client_id)){
                          $has_addressbook = 1; 
                       }                   
                   } else {
                       if ($this->SingleAppClass_pos->getAddressBookByClient($client_id)){
                          $has_addressbook = 1; 
                       }
                   }
               }    

               $defaul_delivery_date = date("Y-m-d");
               $date_list = $this->SingleAppClass_pos->deliveryDateList($this->merchant_id);
               foreach ($date_list as $date_list_key => $date_list_val) {                 
                  $defaul_delivery_date = $date_list_key;
                  break;
               }
               
               $subtotal = $details['total']['subtotal'];
               $cart_error=array();

               /*CHECKING MAX AND MIN AMOUNT*/
               if($transaction_type=="delivery"){
                                 
                  $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$this->merchant_id);       
                  $min_tables_enabled = $this->functions->getOption('min_tables_enabled',$this->merchant_id);
                                                                          
                  if($min_tables_enabled==1 && !empty($res['distance'])){                     
                      $merchant_minimum_order = $this->CheckoutWrapperTemp->getMinimumOrderTable(
                      $this->merchant_id,$res['distance'],$res['distance_unit'],$merchant_minimum_order
                      );
                  }            
                                        
                  if($merchant_minimum_order>0){
                     if($merchant_minimum_order>$subtotal){
                        

                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($merchant_minimum_order);

                     }                
                  }      
                  
                  $merchant_maximum_order = $this->functions->getOption('merchant_maximum_order',$this->merchant_id);
                  if($merchant_maximum_order>0.001){
                     if($subtotal>$merchant_maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($merchant_maximum_order);

                     }                
                  }                  
               } elseif ( $transaction_type=="pickup"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_pickup',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        

                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);

                     }                
                  }                           
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_pickup',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);

                     }                
                  }         
               } elseif ( $transaction_type=="dinein"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_dinein',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        

                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);

                     }                
                  }                   
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_dinein',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);

                     }                
                  }         
               }               
               /*CHECKING MAX AND MIN AMOUNT*/  
                                      
               /*CHECK IF HAS POINTS ADDON*/
               $available_points=0; $available_points_label = '';
               $points_enabled = '';   $pts_disabled_redeem='';            
               
                                
                  $points_enabled = $this->functions->getOptionAdmin('points_enabled');
                  if($points_enabled=="1"){
                      if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                          $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                          if($mt_disabled_pts==2){
                             $points_enabled='';
                          }                       
                      }
                  }
                  
                  $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
                  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                      $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$this->merchant_id);
                      if($mt_pts_disabled_redeem>0){
                          $pts_disabled_redeem=$mt_pts_disabled_redeem;
                      }               
                  }
                   
                  /*GET EARNING POINTS FOR THIS ORDER*/
                  $subtotal = $details['total']['subtotal'];                  
                  if ($earn_pts = $this->SingleAppClass_pos->getCartEarningPoints($cart,$subtotal,$this->merchant_id)){                      
                      

                      $this->functions->updateData("mt_pos_cart",array(
                       'points_earn'=>$earn_pts['points_earn'],
                       'date_modified'=>$this->functions->dateNow()
                     ),'cart_id', $res['cart_id']);

                  }         
                                                                   
                  if($client_id>0){                                                       
                      if($points_enabled=="1"){
                          $available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
                          

                           $available_points_label = "Your available points ".$available_points;
                      }
                   }               
                    
               
               $checkout_stats = $this->functions->isMerchantcanCheckout($this->merchant_id);
               if($checkout_stats['code']==2){
                  $cart_error[] = $checkout_stats['msg'];
               }            
               
               $subtotal = isset($details['total']['subtotal'])?$details['total']['subtotal']:0;                   
                

                $this->functions->updateData("mt_pos_cart",array(
                  'cart_subtotal'=>(float)$subtotal,
                  'date_modified'=>$this->functions->dateNow()
                ),'cart_id', $res['cart_id']);


               
               $this->details = array(
                 'is_apply_tax'=>$is_apply_tax,
                 'checkout_stats'=>$checkout_stats,
                 'has_addressbook'=>$has_addressbook,
                 'services'=>$services,
                 'transaction_type'=>$transaction_type,
                 'default_delivery_date'=>$defaul_delivery_date,
                 //'default_delivery_date_pretty'=>date("D F d, Y"),
                 'default_delivery_date_pretty'=>$this->functions->prettyDate($defaul_delivery_date),
                 'required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),   
                 'tip_list'=>$this->SingleAppClass_pos->tipList(),
                 'data'=>$details,
                 'cart_details'=>$cart_details,
                 'cart_error'=>$cart_error,
                 'points_enabled'=>$points_enabled,              
                 'points_earn'=>isset($earn_pts['points_earn'])?$earn_pts['points_earn']:'',
                 'pts_label_earn'=>isset($earn_pts['pts_label_earn'])?$earn_pts['pts_label_earn']:'',
                 'available_points'=>$available_points,
                 'available_points_label'=>$available_points_label,
                 'pts_disabled_redeem'=>$pts_disabled_redeem,
                 'opt_contact_delivery'=>$this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id),
               );
            
            
            
            } else {
                        $this->msg = $msg;
            }   
            
                
            
        } else {$this->msg = ("Cart is empty");$this->details['promo_items_data']=0;}
        $this->output();
    }


    public function removeCartItem()
{
    $row = isset($this->data['row']) ? $this->data['row'] : 0;

    $phone_order = isset($_REQUEST['phone_order']) ? $_REQUEST['phone_order'] : 0;
    if ($phone_order > 0) {

        $cart_id = isset($_REQUEST['cart_id']) ? $_REQUEST['cart_id'] : 0;
        if (isset($cart_id) && !empty($cart_id) && $cart_id > 0) {
            // valid
        } else {
            $this->msg = ("Cart ID is missing");
            $this->output();
        }

        if ($res = $this->SingleAppClass_pos->getCart_bycartid($this->device_uiid, $this->merchant_id, $cart_id)) {
            $cart = json_decode($res['cart'], true);
            if (array_key_exists($row, (array)$cart)) {
                unset($cart[$row]);

                $this->functions->updateData("mt_pos_cart", array(
                    'device_id' => $this->device_uiid,
                    'cart' => json_encode($cart, JSON_FORCE_OBJECT),
                    'cart_count' => count($cart),
                ), 'cart_id', $cart_id);

                if (count($cart) < 1) {
                    $stmt = $this->db->prepare("DELETE FROM mt_pos_cart WHERE cart_id = :cart_id");
                    $stmt->execute([
                        ':cart_id' => $cart_id
                    ]);
                }
                $this->code = 1;
                $this->msg = "OK";
                $this->details = '';
            } else {
                $this->msg = ("Cannot find cart row");
            }
        } else {
            $this->msg = ("Cart is empty");
        }
    } else {

        $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;
        if ($res = $this->SingleAppClass_pos->getCart($this->device_uiid, $this->merchant_id, $table_number)) {
            $cart = json_decode($res['cart'], true);
            if (array_key_exists($row, (array)$cart)) {
                unset($cart[$row]);

                $this->functions->updateData("mt_pos_cart", array(
                    'device_id' => $this->device_uiid,
                    'cart' => json_encode($cart, JSON_FORCE_OBJECT),
                    'cart_count' => count($cart),
                ), 'cart_id', $res['cart_id']);

                if (count($cart) < 1) {
                    $stmt = $this->db->prepare("DELETE FROM mt_pos_cart WHERE cart_id = :cart_id");
                    $stmt->execute([
                        ':cart_id' => $res['cart_id']
                    ]);
                }
                $this->code = 1;
                $this->msg = "OK";
                $this->details = '';
            } else {
                $this->msg = ("Cannot find cart row");
            }
        } else {
            $this->msg = ("Cart is empty");
        }
    }

    $this->output();
}


public function removeCartItem_cahier_for_waiterorder()
{
    $row = isset($this->data['row']) ? $this->data['row'] : 0;

    $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;
    if (isset($table_number) && !empty($table_number) && $table_number > 0) {
        // valid
    } else {
        $this->msg = ("Table Number is missing");
        $this->output();
    }

    if ($res = $this->SingleAppClass_pos->getCart_cashier($this->merchant_id, $table_number)) {
        $cart = json_decode($res['cart'], true);

        if (array_key_exists($row, (array)$cart)) {
            unset($cart[$row]);

            $this->functions->updateData("mt_pos_cart", array(
                'cart' => json_encode($cart, JSON_FORCE_OBJECT),
                'cart_count' => count($cart),
            ), 'cart_id', $res['cart_id']);

            if (count($cart) < 1) {
                $stmt = $this->db->prepare("DELETE FROM mt_pos_cart WHERE cart_id = :cart_id");
                $stmt->execute([
                    ':cart_id' => $res['cart_id']
                ]);
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = '';
        } else {
            $this->msg = ("Cannot find cart row");
        }
    } else {
        $this->msg = ("Cart is empty");
    }

    $this->output();
}


public function applyVoucher()
{
    $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;
    $phone_order = isset($_REQUEST['phone_order']) ? $_REQUEST['phone_order'] : 0;
    $this->code = 0;

    if ($phone_order > 0) {
        $cart_id = isset($_REQUEST['cart_id']) ? $_REQUEST['cart_id'] : 0;
        if (!(isset($cart_id) && !empty($cart_id) && $cart_id > 0)) {
            $this->msg = ("Cart ID is missing");
            $this->output();
        }
    }

    $data = array(
        'delivery_type' => isset($this->data['transaction_type']) ? $this->data['transaction_type'] : '',
        'merchant_id' => $this->merchant_id,
        'card_fee' => 0,
        'table_number' => $table_number,
        'phone_order' => $phone_order,
        'cart_id' => $cart_id ?? 0,
    );

    if ($cart = $this->SingleAppClass_pos->getCartContent_pos($this->device_uiid, $data)) {
        if ($cart['total']['discounted_amount'] >= 0.0001) {
            $this->msg = ("Sorry you cannot apply voucher, existing discount is already applied in your cart");
            $this->output();
        }
    }

    // CHECK IF HAS POINTS APPLIED
    $pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');
    $is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();

    if (!$is_disabled_merchant_settings) {
        $mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher', $this->merchant_id);
        if ($mt_pts_enabled_add_voucher > 0) {
            $pts_enabled_add_voucher = $mt_pts_enabled_add_voucher;
        }
    }

    if ($pts_enabled_add_voucher != 1) {
        $pts_redeem_amt_orig = isset($cart['total']['pts_redeem_amt_orig']) ? $cart['total']['pts_redeem_amt_orig'] : 0;
        if ($pts_redeem_amt_orig > 0.0001) {
            $this->msg = ("Sorry but you cannot apply voucher when you have already redeemed points");
            $this->output();
        }
    }

    $voucher_name = isset($this->data['voucher_name']) ? $this->data['voucher_name'] : '';
    if (!empty($voucher_name)) {
        if ($res = $this->SingleAppClass_pos->getVoucherMerchant($client_id, $voucher_name, $this->merchant_id)) {
            $voucher_type = 'merchant';
        } else {
            $voucher_type = 'admin';
            $res = $this->SingleAppClass_pos->getVoucherMerchant($client_id, $voucher_name);
        }

         


        if ($res) {
            // Expiry check
            if (!empty($res['expiration'])) {
                $expiration = $res['expiration'];
                $now = date('Y-m-d');
                $date_diff = date_diff(date_create($now), date_create($expiration));
                if (is_object($date_diff) && $date_diff->invert == 1 && $date_diff->d > 0) {
                    $this->msg = ("Voucher code has expired");
                    $this->output();
                }
            }

            // Check joining merchant
            if ($voucher_type == "admin" && !empty($res['joining_merchant'])) {
                $joining_merchant = json_decode($res['joining_merchant']);
                if (!in_array($this->merchant_id, (array)$joining_merchant)) {
                    $this->msg = ("Sorry this voucher code cannot be used on this merchant");
                    $this->output();
                }
            }

            // Check subtotal after voucher
            if ($table_number > 0) {
                $resp = $this->SingleAppClass_pos->getCart_by_table_id($this->merchant_id, $table_number);
            } else {
                $resp = $this->SingleAppClass_pos->getCart($this->device_uiid, $this->merchant_id, $table_number);
            }

            if ($resp) {
                $cart = json_decode($resp['cart'], true);
                $data = array(
                    'delivery_type' => isset($this->data['transaction_type']) ? $this->data['transaction_type'] : 'delivery',
                    'merchant_id' => $this->merchant_id,
                    'card_fee' => 0
                );

                $displayOrderHTML = $this->functions->displayOrderHTML($data, $cart);
                if ($displayOrderHTML['code'] == 1) {
                    $raw = $displayOrderHTML['raw']['total'];
                    $subtotal = isset($raw['subtotal']) ? $raw['subtotal'] : 0;

                    if ($res['voucher_type'] == "percentage") {
                        $less_voucher = $subtotal * ($res['amount'] / 100);
                        $subtotal_after_voucher = $subtotal - $less_voucher;
                    } else {
                        $subtotal_after_voucher = $subtotal - $res['amount'];
                    }

                    if ($subtotal_after_voucher <= 0) {
                        $this->msg = ("Voucher cannot be applied as voucher exceeds subtotal.");
                        $this->output();
                    }
                }
            }

            // Prepare voucher data to be stored
            $params = array(
                'voucher_id' => $res['voucher_id'],
                'voucher_owner' => $res['voucher_owner'],
                'voucher_name' => $res['voucher_name'],
                'amount' => $res['amount'],
                'voucher_type' => $res['voucher_type'],
            );

            if ($table_number > 0) {
                $this->functions->updateData("mt_pos_cart", [
                    'voucher_details' => json_encode($params)
                ], 'table_number', $table_number);
            } else if ($phone_order > 0) {
                $this->functions->updateData("mt_pos_cart", [
                    'voucher_details' => json_encode($params)
                ], 'cart_id', $cart_id);
            } else {
                // Use PDO here for update
                $stmt = "UPDATE mt_pos_cart 
         SET voucher_details = :voucher_details 
         WHERE device_id = :device_id 
         AND is_phone_order = 0 
         AND table_number = 0";

$statement = $this->db->prepare($stmt);
$statement->execute([
    ':voucher_details' => json_encode($params),
    ':device_id' => $this->device_uiid
]);

            }

            $this->code = 1;
            $this->msg = "Voucher Applied";
            $this->details = '';
        } else {
            $this->msg = ("Invalid voucher code");
        }
    } else {
        $this->msg = ("Voucher is required");
    }

    $this->output();
}


public function removeVoucher()
    { 
    
    
    $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
    
    $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
                        
                }
    
    
if($table_number>0){$this->SingleAppClass_pos->removeVoucher_pos($table_number);}
else if($phone_order>0){$this->SingleAppClass_pos->removeVoucher_pos_phone($cart_id);}
else{
                $this->SingleAppClass_pos->removeVoucher($this->device_uiid);
    
}
    

        $this->code = 1;
        $this->msg="Voucher removed";
        $this->details='';
        $this->output();
    }



    public function servicesList()
    {
        $services = $this->functions->DeliveryOptions($this->merchant_id);
        if(is_array($services) && count($services)>=1){
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
              'data'=>$services
            );
        } else $this->msg = ("Services not available");
        $this->output();
    }
    
    public function deliveryDateList()
    {       
        $this->setMerchantTimezone();           
        $dates = $this->functions->getDateList($this->merchant_id);
        
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
         'data'=>$dates
        );
        $this->output();
        
    }
    
    public function deliveryTimeList()
    {           
        $this->setMerchantTimezone();           
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';       
        $times = $this->functions->getTimeList($this->merchant_id,$delivery_date);
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
          'data'=>$times
        );      
        $this->output();
    }
    
    public function customerRegister()
    {
        
        
        $reg_email = $this->functions->getOption('singleapp_reg_email',$this->merchant_id);
        $reg_mobile = $this->functions->getOption('singleapp_reg_phone',$this->merchant_id);
        
        
                
        if(empty($reg_email) && empty($reg_mobile)){
            $reg_email = 1;
            $reg_mobile = 1;
        }           
                
        if ($this->data['password']!=$this->data['cpassword']){         
            
            $this->Validator->setmsg("Confirm password does not match");
        }
        
        /*check if email address is blocked*/
        if($reg_email==1){
            if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
                   
                $this->Validator->setmsg("Sorry but your email address is blocked by website admin");       
            }       
        }
        
        if($reg_mobile==1){
            if ( $this->Validator->mobileBlockedCheck($this->data['contact_phone'])){
                
                $this->Validator->setmsg("Sorry but your mobile number is blocked by website admin");           
            }
            
            if ($res= $this->functions->CheckCustomerMobile_with_merchant($this->data['contact_phone'],$this->merchant_id)){
                $this->Validator->setmsg("Sorry but your mobile number is already exist in our records");           
            }   
        }
        
        if($reg_email==1){
            if ( $resp = $this->functions->isClientExist_with_merchant($this->data['email_address'],$this->merchant_id) ){          
                $this->Validator->setmsg("Sorry but your email address already exist in our records");
            }
        }
                
        if($this->Validator->validate()){                               
            $params=array(
              'first_name'=>$this->data['first_name'],
              'last_name'=>$this->data['last_name'],              
              'password'=>md5($this->data['password']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],                          
              'single_app_merchant_id'=>$this->merchant_id,           
            );              
            
            if($reg_email==1){
                $params['email_address'] = $this->data['email_address'];
            }   
            if($reg_mobile==1){
                $params['contact_phone'] = trim($this->data['contact_phone']);
            }   
                
            /** update 2.3*/
            if (isset($this->data['custom_field1'])){
                $params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
            }
            if (isset($this->data['custom_field2'])){
                $params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
            }
            
            $primary_next_step = isset($this->data['next_step'])?$this->data['next_step']:'';
                                                
            /** send verification code */
            $enabled_verification_mobile = $this->functions->getOptionAdmin('website_enabled_mobile_verification');            
            if ( $enabled_verification_mobile=="yes" && $reg_mobile==1){
                $code=$this->functions->generateRandomKey(5);                   
                $this->functions->sendCustomerSMSVerification($params['contact_phone'],$code);
                $params['mobile_verification_code']=$code;
                $params['status']='pending';
                $this->data['next_step'] = 'verification_mobile';
            }             
            
            /*send email verification added on version 3*/       
                
            $enabled_verification_email = $this->functions->getOptionAdmin('theme_enabled_email_verification');
            if ($enabled_verification_email==2 && $reg_email==1){
                $email_code=$this->functions->generateRandomKey(5);
                $params['email_verification_code']=$email_code;
                $params['status']='pending';
                $this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
                $this->data['next_step'] = 'verification_email';
            }
            
            if($reg_email==1){
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['email_address']);
            } else $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['contact_phone']);
            
            $params['token']=$token;

            $last_insert_id = $this->functions->insertData('mt_client', $params);
            if ($last_insert_id!== false){                                  
                                                            
                
                $customer_id =$last_insert_id;    
                
                $this->data['client_id'] = $customer_id;
                $this->data['merchant_id'] = $this->merchant_id;
                $this->SingleAppClass_pos->registeredDevice($this->data);
                        
                $this->code=1;
                $this->msg = ("Registration successful");
                
                if ( $enabled_verification_email==2 || $enabled_verification_mobile=="yes"){    
                    if($this->data['next_step']=="verification_mobile"){
                       $this->msg=("We have sent verification code to your mobile number");
                    } else $this->msg=("We have sent verification code to your email address");             
                } else {                    
                    /*sent welcome email*/  
                    $this->functions->sendCustomerWelcomeEmail($params);
                }           
                
                $this->details = array(
                  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                  'token'=>$token,
                  'primary_next_step'=>$primary_next_step,
                  'contact_phone'=>isset($params['contact_phone'])?$params['contact_phone']:''
                );              
                
                /*POINTS PROGRAM*/                  
              
                    $this->PointsProgram->signupReward($customer_id);
                
                                
            } else $this->msg = ("Something went wrong during processing your request. Please try again later");
            
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }


        public function setDeliveryAddress()
    {       
        $lat = isset($this->data['lat'])?$this->data['lat']:'';
        $lng = isset($this->data['lng'])?$this->data['lng']:'';
        
        $merchant_id = $this->merchant_id;
        if($merchant_id<=0){
            $this->msg = ("invalid merchant id");
            $this->output();
        }   
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if(!$cart=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $this->msg = ("Cart is empty");     
            $this->output();
        }
        
        $country_name = $this->functions->countryCodeToFull(isset($this->data['country_code'])?$this->data['country_code']:'');     
        if(!empty($country_name)){
            $this->data['country']=$country_name;
        }
        
        $complete_address = $this->data['street']." ".$this->data['city']." ".$this->data['state']." ".$this->data['zipcode'];
        $complete_address.=" $country_name";
        
        try {
            
            $min_fees=0;            
            $cart_subtotal = isset($cart['cart_subtotal'])?(float)$cart['cart_subtotal']:0;                     
            $resp = $this->CheckoutWrapperTemp->verifyLocation($merchant_id,$lat,$lng,$cart_subtotal);  
            
            $this->code = 1;
            $this->msg = "OK";
            
            $this->details = array(
              'complete_address'=>$complete_address,              
              'min_delivery_order'=>$min_fees,
              'lat'=>$lat,
              'lng'=>$lng,
              'formatted_address'=>$complete_address,
              'street'=>isset($this->data['street'])?$this->data['street']:'',
              'city'=>isset($this->data['city'])?$this->data['city']:'',
              'state'=>isset($this->data['state'])?$this->data['state']:'',
              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
              'country'=>$country_name
            );
            
            $params = array(
              'street'=>isset($this->data['street'])?$this->data['street']:'',
              'city'=>isset($this->data['city'])?$this->data['city']:'',
              'state'=>isset($this->data['state'])?$this->data['state']:'',
              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
              'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
              'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
              'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
              'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
              'delivery_lat'=>$lat,
              'delivery_long'=>$lng,
              'save_address'=>isset($this->data['save_address'])?(integer)$this->data['save_address']:0,
              'delivery_fee'=>(float)$resp['delivery_fee'],
              'min_delivery_order'=>(float)$resp['min_order'],
              'distance'=>$resp['distance'],
              'distance_unit'=>$resp['unit'],
            );                      
            

           $this->functions->updateData("mt_pos_cart", $params, 'cart_id', $cart['cart_id']);   
                                               
           $token = isset($this->data['token'])?$this->data['token']:'';
           if($res_client = $this->SingleAppClass_pos->getCustomerByToken($token)){
            
                $client_id = $res_client['client_id'];  
                
                if(isset($this->data['save_address'])){
                  if($this->data['save_address']==1){
                     if(!empty($this->data['street']) && !empty($this->data['city'])){                      
                        if (!$this->SingleAppClass_pos->getBookAddressByClientID($client_id,$this->data['street'],$this->data['city'],
                        $this->data['state'])){                         
                            $this->db->createCommand("UPDATE mt_address_book SET as_default = '1'")->execute();

                            $params_address_book = array(
                              'client_id'=>$client_id,
                              'street'=>isset($this->data['street'])?$this->data['street']:'',
                              'city'=>isset($this->data['city'])?$this->data['city']:'',
                              'state'=>isset($this->data['state'])?$this->data['state']:'',
                              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
                              'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
                              'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
                              'as_default'=>2,
                              'date_created'=>$this->functions->dateNow(),
                              'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
                              'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
                              'ip_address'=>$_SERVER['REMOTE_ADDR']
                            );                                                  
                            $this->functions->insertData("mt_address_book",$params_address_book);
                        }
                     }            
                  }         
                }       
            }

            /*SAVE LOCATION*/                   
            $params_recent = array(
              'device_uiid'=>$this->device_uiid,
              'search_address'=>isset($this->data['search_address2'])?trim($this->data['search_address2']):'',
              'street'=>isset($this->data['street'])?trim($this->data['street']):'',
              'city'=>isset($this->data['city'])?trim($this->data['city']):'',
              'state'=>isset($this->data['state'])?trim($this->data['state']):'',
              'country'=>isset($this->data['country'])?trim($this->data['country']):'',
              'location_name'=>isset($this->data['location_name'])?trim($this->data['location_name']):'',
              'zipcode'=>isset($this->data['zipcode'])?trim($this->data['zipcode']):'',
              'latitude'=>$lat,
              'longitude'=>$lng,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
            );                          
            if(!empty($params_recent['search_address'])){
                if($res = $this->SingleAppClass_pos->getRecentLocationByID($this->device_uiid,$lat, $lng)){                 
                    $id = $res['id'];                   
                    


                    $this->functions->updateData("mt_singleapp_recent_location", $params_recent, 'id', $id);

                } else {                                    
                    $this->functions->insertData("mt_singleapp_recent_location",$params_recent);
                }       
            }
            
        } catch (Exception $e) {
           $this->msg = $e->getMessage();                       
        }
                
        $this->output();
    }


    public function setAddressBook()
    {       
        $merchant_id = $this->merchant_id;
        if($merchant_id<=0){
            $this->msg = ("invalid merchant id");
            $this->output();
        }       
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if(!$cart=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $this->msg =("Cart is empty");      
            $this->output();
        } 
            
        $min_fees = 0;
        $addressbook_id  = isset($this->data['addressbook_id'])?(integer)$this->data['addressbook_id']:0;
        if($addressbook_id>0){
            if ( $res = $this->functions->getAddressBookByID($addressbook_id)){             
                try {
                    $lat = isset($res['latitude'])?$res['latitude']:0;
                    $lng = isset($res['longitude'])?$res['longitude']:0;                    
                    $cart_subtotal = isset($cart['cart_subtotal'])?(float)$cart['cart_subtotal']:0;                     
                    $resp = $this->CheckoutWrapperTemp->verifyLocation($merchant_id,$lat,$lng,$cart_subtotal);  
                    
                    $country_code = isset($res['country_code'])?$res['country_code']:'';
                    $country_name = $this->functions->countryCodeToFull($country_code);     
                    
                    $complete_address = $res['street']." ".$res['city']." ".$res['state']." ".$res['zipcode'];
                    $complete_address.=" $country_name";
                    
                    $min_fees = (float)$resp['min_order'];
                    $params = array(
                      'street'=>isset($res['street'])?$res['street']:'',
                      'city'=>isset($res['city'])?$res['city']:'',
                      'state'=>isset($res['state'])?$res['state']:'',
                      'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                      'country_code'=>isset($res['country_code'])?$res['country_code']:'',
                      'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
                      'location_name'=>isset($res['location_name'])?$res['location_name']:'',
                      'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',                   
                      'delivery_lat'=>$lat,
                      'delivery_long'=>$lng,
                      'save_address'=>isset($this->data['save_address'])?(integer)$this->data['save_address']:0,
                      'delivery_fee'=>(float)$resp['delivery_fee'],
                      'min_delivery_order'=>(float)$resp['min_order'],
                      'distance'=>$resp['distance'],
                      'distance_unit'=>$resp['unit'],
                    );      
                                        
                    


                     $this->functions->updateData("mt_pos_cart", $params, 'cart_id', $cart['cart_id']);


                   
                   $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                      'complete_address'=>$complete_address,
                      'save_address'=>'',
                      'min_delivery_order'=>$min_fees
                    );
            
                } catch (Exception $e) {
                    $this->msg = $e->getMessage();                      
                }                               
            } else $this->msg = ("Address not available. please try again later");
        } else $this->msg = ("Invalid id"); 
        
        $this->output();
    }


    public function verifyCustomerToken()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!empty($token)){          
             if($res=$this->SingleAppClass_pos->getCustomerByToken($token)){
                $data = array(
                  'contact_phone'=>$res['contact_phone'],
                  'email_address'=>$res['email_address'],
                );
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                  'data'=>$data
                );
             } else {
                $this->code = 3;
                $this->msg = ("token not found");               
             }
        } else $this->msg = ("token empty");
        $this->output();
    }


    public function loadPaymentList()
    {
        
        /*CHECK IF ORDERING IS DISABLED*/
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');       
        if($disabled_website_ordering=="yes"){
            $this->msg = ("Ordering is disabled by admin");
            $this->output();
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $this->msg = ("Ordering is disabled by merchant");
            $this->output();
        }
            
        $merchant_opt_contact_delivery= $this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id);
        $opt_contact_delivery = isset($this->data['opt_contact_delivery'])?$this->data['opt_contact_delivery']:'';
        
        if ( $res = $this->functions->getMerchantPaymentListNew($this->merchant_id)){
             $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
             $this->code = 1;
             $this->msg = "OK";     
             $list = array();
             
             if(isset($res['mcd'])){
                unset($res['mcd']);
             }
             if(isset($res['pyp'])){
                unset($res['pyp']);
             }
             
             /*REMOVE OFFLINE PAYMENT OPTION CONTACT DELIVERY*/
             if($merchant_opt_contact_delivery==1 && $transaction_type=="delivery" && $opt_contact_delivery==1){
                if(isset($res['cod'])){unset($res['cod']);}
                if(isset($res['pyr'])){unset($res['pyr']);}
                if(isset($res['obd'])){unset($res['obd']);}
                if(isset($res['ocr'])){unset($res['ocr']);}
             }      
             
             foreach ($res as $key => $val) {
                switch ($key) {
                    case "cod":
                        $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
                        break;
                
                    case "pyr":
                        $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
                        break;
                                        
                    case "paypal_v2":



                       if ( !$resp = $this->functions->getCredentials_paypal($this->merchant_id)){
                           if ($resp['card_fee']>0.0001){
                              

                               $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);

                           } else $val = $val;
                       } else $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);


                      $val=$this->functions->frontend_payment_translations($key,$resp['card_fee'],$transaction_type);
                       break;     
                      
                    case "stp":                     
                       if ( $resp = $this->functions->getCredentials_stripe($this->merchant_id)){
                           if ($resp['card_fee']>0.0001){
                              $cardfee = ($resp['card_fee']);
                              if(isset($resp['card_percentage'])){
                                 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
                                 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
                              } 

                              
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
                              //$val = "Stripe card fee ".$cardfee;

                           } else $val =$val;
                       } else $val = $val;
                       break; 


                       case "windcave":                     
                       if ( $resp = $this->functions->getCredentials_windcave($this->merchant_id)){
                           if ($resp['card_fee']>0.0001){
                              $cardfee = ($resp['card_fee']);
                              if(isset($resp['card_percentage'])){
                                 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
                                 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
                              } 

                              
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
                              //$val = "Windcave card fee ".$cardfee;

                           } else $val =$val;
                       } else $val = $val;
                       break;   

                        case "poli":
                $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
               
                break;    
                       
                   
                                        
                    default:
                        $val = ($val);
                        break;
                }               
                $list[] = array(
                  'payment_code'=>$key,
                  'payment_name'=>$val
                );
             }
             $this->details = array(
               'data'=>$list
             );
        } else $this->msg = ("No payment option available");
        $this->output();
    }


    public function payNow()
    {
        
        
        $this->setMerchantTimezone();

        

          

        
        if (!$this->functions->validateSellLimit($this->merchant_id) ){
            //$this->msg =t("This merchant has reach the maximum sells per month");
            //$this->output();
        }
        
        $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
        $payment_provider = isset($this->data['payment_provider'])?$this->data['payment_provider']:'';
        
        
        
        
            //die();
        
              


        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0; 
        $client_id= isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'0'; 

         
    
        
        
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
        
        if($table_number>0){
            
            
        $res11=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);
        $minfouser=$this->functions->getMerchantUserInfobymid($res11['created_id']);    
        
        
        if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                
                
            //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
                
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }else{
            
            $transaction_type="dinein";
        $this->data['transaction_type']="dinein";
            
            $created_by='waiter';$created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
            if($table_number>0){}else{              
                    $this->msg = ("Table Number is required");
            $this->output();
            }
            
            
            
        }
            
            
            
            
        }else{
        
        $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
        
        
        if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                    //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }else{
                $transaction_type="dinein";
        $this->data['transaction_type']="dinein";
            $created_by='waiter';$created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
            if($table_number>0){}else{              
                    $this->msg = ("Table Number is required");
            $this->output();
            }
            
            
            
        }
        
        }
        
        
         $first_name= isset($_REQUEST['customer_first_name'])?$_REQUEST['customer_first_name']:''; 
         $last_name= isset($_REQUEST['customer_last_name'])?$_REQUEST['customer_last_name']:''; 
         $email_address= isset($_REQUEST['customer_email'])?$_REQUEST['customer_email']:''; 
        
        
        
         $client_id= isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'0'; 




        
        if($client_id>0){}else{
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
                            $res11=$this->SingleAppClass_pos->getCart_bycartid($this->device_uiid,$this->merchant_id,$cart_id); 
                            
                            // $_REQUEST['client_id']=$res11['clients_id'];
                            
                }   
        
        
        
        }
        
        
        
        
        
        /*
        if($client_id>0){}else{
        if(isset($first_name) && !empty($first_name)){}else{$this->msg = ("first name is missing");$this->output();}
        if(isset($last_name) && !empty($last_name)){}else{$this->msg = ("last name is missing");$this->output();}
        if(isset($email_address) && !empty($email_address)){}else{$this->msg = ("email address  is missing");$this->output();}
        }
        */
        if($client_id>0){
            
            $client_info = $this->functions->getClientInfo($client_id);
        
            
        }else{
            
        if(isset($email_address) && !empty($email_address)){    
        if( $client_info = $this->functions->isClientExist_with_merchant($email_address,$this->merchant_id)){

        }else{
            
                        
            $params2=array(
              'first_name'=>($first_name),
              'last_name'=>($last_name),
              'email_address'=>($email_address),
              'password'=>md5('123456'),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>'',
              'device_platform'=>'',
              'merchant_id'=>$this->merchant_id,
               'single_app_merchant_id'=>$_REQUEST['pos_user_id'],
              
             
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params2['email_address']);
                $params2['token']=$token;
                if ($customer_id = $this->functions->insertData("mt_client",$params2)){
                     
        
                $client_info = $this->functions->getClientInfo($customer_id);
        
        
        
                }
        }
        
        }
        }
        
        $customer_first_name=''; $customer_last_name =''; $customer_email='';       
        
        $client_id = $client_info['client_id'];     
        $email_address = trim($client_info['email_address']);
        $customer_email = trim($client_info['email_address']);
        $customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
        $customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
        
        
        
        
        /*transaction_type*/
        
        
        if($minfouser['pos_cashier_access']==1){
            
                    $transaction_type=$this->data['transaction_type'];
        //$this->data['transaction_type']="pickup"; 
        }
        
        
    
        
        if(empty($delivery_date)){
            //$this->msg = ("Delivery date is required");
            //$this->output();
        }
        
        if(empty($payment_provider)){
            //$this->msg = ("Payment provider is empty. please go back and try again");
            //$this->output();
        }
        
        $full_delivery = "$delivery_date $delivery_time";       
        $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
        $delivery_time_formated = '';
        if(!empty($delivery_time)){
            $delivery_time_formated=date('h:i A',strtotime($delivery_time));
        } else $delivery_time_formated = date('h:i A');
                        
        /*CHECK MERCHANT OPENING HOURS*/
        //dump($delivery_day);dump($delivery_time_formated);        
        if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
            $date_close=date("F,d l Y h:ia",strtotime($full_delivery));
            //$this->msg = Yii::t("singleapp","Sorry but we are closed on [date_close]. Please check merchant opening hours.",array(
            //  '[date_close]'=>$date_close
            //));
            //$this->output();
        }               
            
        /*CHECK PRE ORDER*/
        $date_today = date("Y-m-d");        
    
        /*END PRE ORDER*/
                
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:date("Y-m-d");
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:date('h:i A');
        //naxxxx          
        
        
        
        
        //hhhhhhhhhhhhhhhhhhhhhhh
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;

        if($this->data['is_retail']>0){
           $phone_order=0; 
        }

                if($phone_order>0){
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
                            $res=$this->SingleAppClass_pos->getCart_bycartid($this->device_uiid,$this->merchant_id,$cart_id);   
                            
                            //nnnnnnnnn
                                //$transaction_type=$res['order_type'];
                            
                            
                    
                }else{
        
        
        
        
        if($minfouser['pos_cashier_access']==1){
            $res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id);             
        }else{
            $res=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);      
        }
        
        
        
                }
        if($res){
            $cart=json_decode($res['cart'],true); 

            //print_r($cart);die();

            
            $card_fee = 0; $card_percentage=0;
            
            /*Custom code 10 starts */
            
                        $n_total = $res['cart_subtotal'];   
                    
             // $resp=$this->SingleAppClass_pos->getCart($this->device_uiid , $this->merchant_id);
             // $n_total = $resp['cart_subtotal'];
                
           /*Custom code 10 ends */
            
            //dump($payment_provider);
            
            /*CARD FEE*/
            
                        
                        
            
                        
                        
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>$card_fee
            );
            if($card_percentage>0){
               $data['card_percentage']=$card_percentage;
            }    
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }                   

            /*POINTS*/
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }                               
            //dump($data);die();
            
            /*DELIVERY FEE*/
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $raw = $displayOrderHTML['raw'];
                
                /*EURO TAX*/
               $is_apply_tax = 0;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
                   $raw['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/             
                
                $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
                if(empty($donot_apply_tax_delivery)){
                    $donot_apply_tax_delivery=1;
                }
                
                if($card_percentage>0){
                    $card_fee = (float) $raw['total']['card_fee'];
                }


                    switch ($payment_provider) {
                
                    
                

                   case "windcave": 
                    if($credentials = $this->functions->getCredentials_windcave($this->merchant_id)){
                        //print_r($credentials);die();
                        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                            
                          }
                       }

                       $data['card_fee']=$card_fee;

                    }  
                   break;    

                   
                                                      
                default:
                    break;
            }

                
                $params = array(
                  'merchant_id'=>$this->merchant_id,                  
                  'client_id'=>isset($client_id)?$client_id:'0',
                  'json_details'=>$res['cart'],
                  'trans_type'=>$transaction_type,
                  'payment_type'=>$this->data['payment_provider'],
                  'sub_total'=>$raw['total']['subtotal'],
                  'tax'=>$raw['total']['tax'],
                  'taxable_total'=>$raw['total']['taxable_total'],
                  'total_w_tax'=>isset($raw['total']['total'])?($raw['total']['total']+$card_fee):0,
                  'delivery_charge'=>isset($raw['total']['delivery_charges'])?$raw['total']['delivery_charges']:0,
                  'delivery_date'=>$delivery_date,
                  'delivery_time'=>$delivery_time,
                  'delivery_asap'=>isset($this->data['delivery_asap'])?$this->data['delivery_asap']:'',
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'delivery_instruction'=>isset($res['delivery_instruction'])?$res['delivery_instruction']:'',
                  'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',
                  'order_change'=>isset($this->data['order_change'])?$this->data['order_change']:0,
                  'pos_user_id'=>isset($minfouser['merchant_user_id'])?$minfouser['merchant_user_id']:0,
                  'table_number'=>$table_number,
                  'payment_provider_name'=>'',
                  'card_fee'=>$card_fee,                  
                  'created_by'=>$created_by,
                  'created_name'=>$created_name,                              
                  'packaging'=>$raw['total']['merchant_packaging_charge'],
                  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
                  'order_id_token'=>$this->functions->generateOrderToken(),
                //  'request_from'=>"single_mob",
                  'request_from'=>"pos",
                  'apply_food_tax'=>$is_apply_tax,      
                  'is_phone_order'=>isset($phone_order)?$phone_order:0,
                  'cart_id'=>isset($cart_id)?$cart_id:0,    
                  'is_retail'=>isset($this->data['is_retail'])?$this->data['is_retail']:0,
                  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
                );
                
                
                
                
                if($phone_order==1){
                    $params['client_names']=$res['client_name'];
                    $params['email']=$res['email'];
                    $params['phones']=$res['phones'];
                    $params['address']=$res['address'];             
                    
                }
                
                
                //print_r($params);
                //die();
                
                
                //get-last-order
                
                $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);
                if($get_id_orders>=0){$params['order_number']=$get_id_orders+1;}else{$params['order_number']=1;}
                
                
                
                
                
                $order_id_token = $params['order_id_token'];
                
                /*TIPS*/
                if(isset($raw['total']['tips'])){
                    if($raw['total']['tips']>0.0001){
                        $params['cart_tip_percentage']= $raw['total']['cart_tip_percentage'];
                        $params['cart_tip_value']= $raw['total']['tips'];
                    }               
                }           
                                
                switch ($transaction_type) {
                    case "dinein":
                        $params['dinein_number_of_guest'] = isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction'] = isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
                        
                        $params['dinein_table_number'] = isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:'';
                        
                        if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                        }                       
                        break;
                        
                    case "pickup":   
                          if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                          }                     
                        break;
                        
                    case "delivery":
                        $delivery_asap = '';
                        if(isset($this->data['delivery_asap'])){
                            $delivery_asap = $this->data['delivery_asap']=="true"?1:'';
                            $params['delivery_asap'] = $delivery_asap;
                        }
                        break;
                
                    default:
                        break;
                }
                    
                /*DEFAULT ORDER STATUS*/                
                
                
                
                        $params['payment_provider_name']=$payment_provider;
                
                         $params['status']='paid';  
                /*PROMO*/                       
                //dump($raw);
                if (isset($raw['total']['discounted_amount'])){
                    if ($raw['total']['discounted_amount']>=0.0001){                            
                        $params['discounted_amount']=$raw['total']['discounted_amount'];
                        $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
                    }
                }
                
                /*VOUCHER*/
                if(!empty($res['voucher_details'])){
                    $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
                    if(is_array($voucher_details) && count($voucher_details)>=1){
                        $params['voucher_amount']=$voucher_details['amount'];
                        $params['voucher_code']=$voucher_details['voucher_name'];
                        $params['voucher_type']=$voucher_details['voucher_type'];
                    }
                }
                
                /*POINTS*/
                if($res['points_amount']>0.0001){
                    $params['points_discount']=$res['points_amount'];
                }   
                
                
                
                if ($params['payment_type']=="windcave"){
                $params['status']='initial_order';
            }else{
                $params['status']='Complete';
                
            }
                
                
                if ($params['request_from']="pos")
                        {
                            $params['percent_commision']=0;
                            $params['total_commission']=0;
                            $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                        }

                if(!is_numeric($params['cc_id'])){
                    unset($params['cc_id']);
                }
                if(!is_numeric($params['order_change'])){
                    unset($params['order_change']);
                }
                                                
                /*BEGIN INSERT ORDER*/              
                if(!is_numeric($params['sub_total'])){
                    $params['sub_total']=0;
                }           
                if(!is_numeric($params['tax'])){
                    $params['tax']=0;
                }           
                if(!is_numeric($params['taxable_total'])){
                    $params['taxable_total']=0;
                }           
                if(!is_numeric($params['total_w_tax'])){
                    $params['total_w_tax']=0;
                }
                
                if(isset($params['order_change'])){
                    if(!is_numeric($params['order_change'])){
                        $params['order_change']=0;
                    }           
                }
                if(!is_numeric($params['card_fee'])){
                    $params['card_fee']=0;
                }           
                if(!is_numeric($params['packaging'])){
                    $params['packaging']=0;
                }           
                if(!is_numeric($params['donot_apply_tax_delivery'])){
                    unset($params['donot_apply_tax_delivery']);
                }           
                if(!is_numeric($params['apply_food_tax'])){
                    unset($params['apply_food_tax']);
                }           
                
                if(isset($params['percent_commision'])){
                    if(!is_numeric($params['percent_commision'])){
                        $params['percent_commision']=0;
                    }           
                }
                
                if(isset($params['total_commission'])){
                    if(!is_numeric($params['total_commission'])){
                        $params['total_commission']=0;
                    }           
                }
                
                if(isset($params['merchant_earnings'])){
                    if(!is_numeric($params['merchant_earnings'])){
                        $params['merchant_earnings']=0;
                    }           
                }               
                
                if($transaction_type=="delivery"){          
                   if($res['distance']>0){
                      

                      $params['distance'] = isset($res['distance']) ? $res['distance'] . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '') : '0' . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '');

                   }
                }


                    

                    
                if( $order_id=$this->functions->insertData("mt_order",$params)){
                    
                    
                    $params_history=array(
                      'order_id'=>$order_id,
                      'status'=>'Complete',     
                      'remarks'=>'',
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );          
                    if ($params['payment_type']=="windcave"){
                
            }else{
                $this->functions->insertData("mt_order_history",$params_history);
                    
                
            }
                    
                    
                    
                    
                    
                    
                    
                    
                    if ($transaction_type=="delivery" && $phone_order==1 && isset($params['address']) && !empty($params['address'])){                       
                        $params_address=array(                        
                          'street'=>isset($res['street'])?$res['street']:'',
                          'city'=>isset($res['city'])?$res['city']:'',
                          'state'=>isset($res['state'])?$res['state']:'',
                          'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                          'location_name'=>$params['address'],
                          'formatted_address'=>$params['address'],
                          'contact_phone'=>$params['phones'],
                          'country'=>isset($res['country_code'])?$res['country_code']:'',
                          'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
                          'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
                          'opt_contact_delivery'=>isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0
                        );              


                                        
                    $params_address['order_id'] = (integer)$order_id;
                    $params_address['client_id'] = (integer)$client_id;
                    $params_address['first_name'] =$params['client_names'];
                    $params_address['last_name'] ='';
                    $params_address['contact_email'] =$params['email'];
                    $params_address['date_created'] = $this->functions->dateNow();
                    $params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
                                        
                    $this->functions->insertData("mt_order_delivery_address",$params_address);
                    
                    }
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    $next_step = "receipt";
                    
                    /*SAVE ITEM */                  
                    foreach ($raw['item'] as $val) {                                
                        $params_order_details=array(
                          'order_id'=>isset($order_id)?$order_id:'',
                          'client_id'=>isset($client_id)?$client_id:'0',
                          'item_id'=>isset($val['item_id'])?$val['item_id']:'',
                          'item_name'=>isset($val['item_name'])?$val['item_name']:'',
                          'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
                          'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
                          'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
                          'size'=>isset($val['size_words'])?$val['size_words']:'',
                          'qty'=>isset($val['qty'])?$val['qty']:'',                               
                          'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
                          'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                          'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
                          'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
                        );
                        /*inventory*/
                        $new_fields=array('size_id'=>"size_id");
                        if ( $this->functions->checkTableFields('order_details',$new_fields)){
                            $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
                            $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
                        }           
                        $this->functions->insertData("mt_order_details",$params_order_details);
                        
                        /*inventory*/
                        if ($this->functions->checkIfTableExist('order_details_addon')){
                            if(isset($val['sub_item'])){
                                if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                                    foreach ($val['sub_item'] as $sub_item_data) {
                                        $this->functions->insertData("mt_order_details_addon",array(
                                          'order_id'=>$order_id,
                                          'subcat_id'=>$sub_item_data['subcat_id'],
                                          'sub_item_id'=>$sub_item_data['sub_item_id'],
                                          'addon_price'=>$sub_item_data['addon_price'],
                                          'addon_qty'=>$sub_item_data['addon_qty'],
                                        ));
                                    }
                                }                           
                            }
                        }
                        
                    }
                    
                    /*SAVE DELIVERY ADDRESS*/
                    $params_address = array();
                    
                    /*SAVE DELIVERY ADDRESS*/
                    if ( $transaction_type=="pickup"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:''                        
                        );
                    } elseif ( $transaction_type=="dinein"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
                          'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
                          'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
                          'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
                        );
                    }
                    
                
                                        
                
                    
                    
                    
                    $this->code = 1;
                    
                    
                        if ($params['payment_type']=="windcave"){
                            
                            

                     $this->msg = "Your order has been created and waiting for the payment. Reference # ".$order_id;



                       //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($this->data['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints_windcavepos_offline($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                    if (
                    isset($this->data['points_amount']) &&
                    !empty($this->data['points_amount']) &&
                    $this->data['points_amount'] > 0.0001
                    ) {
                        $this->PointsProgram->saveExpensesPoints_windcave(
                        $this->data['points_apply'],
                        $this->data['points_amount'],
                        $client_id,
                        $this->merchant_id,
                        $order_id,
                        ''
                       );
                     }


                }  

                         
                //---was custom code



                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                                        
                            
                        }else{
                    
                    

                    $this->msg = "Your order has been placed. Reference # ".$order_id;
                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                 

                            
                            $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
                        
                        
                        
                        
                        
                            
                                  $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$cart_id);    
                            
                    
                }else{

                            if($minfouser['pos_cashier_access']==1){                                
                                  $this->SingleAppClass_pos->handleAll_cash($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status']); 
                            }else{  
                              $this->SingleAppClass_pos->handleAll($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$table_number);   
                            }
                              
                              
                              
                              
                                  $this->SingleAppClass_pos->updatePoints($order_id,$params['status']);
                              
                              
                              
                }}          
                              
                              
                              
                              
                              
                        
                    $client_info = array( 
                      'first_name'=>$client_info['first_name'],
                      'last_name'=>$client_info['last_name'],
                      'email_address'=>$client_info['email_address'],
                      'contact_phone'=>$client_info['contact_phone'],                     
                    );
                    
                   

                    $payment_description = "Payment to merchant ".$this->functions->clearString($this->merchant_name);

                    
                    $total = number_format($params['total_w_tax'],2,'.','');
                    
                    
                    
                    
                    
                    $resp = $this->SingleAppClass_pos->prepareReceipt($order_id);
                    
                    $resp['timezone']=date_default_timezone_get();
            
                    //+++was code      
                    foreach ($resp as $key => $val) {
    if ($key !== 'total_amount' && $key !== 'total_amount_by_100') {
        if (is_array($val)) {
            foreach ($val as $subKey => $subVal) {
                if (is_int($subVal) || is_float($subVal)) {
                    $resp[$key][$subKey] = (string)$subVal;
                }
            }
        } elseif (is_int($val) || is_float($val)) {
            $resp[$key] = (string)$val;
        }
    }
}
//---was code

// Convert all nulls in $resp to empty strings
array_walk_recursive($resp, function (&$v) {
    if (is_null($v)) {
        $v = "";
    }
});

// Ensure merchant_id is string (in main data and nested json_details if string)
if (isset($resp['data']['merchant_id'])) {
    $resp['data']['merchant_id'] = (string)$resp['data']['merchant_id'];
}
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Fix merchant_id in json_details to be quoted
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}

// Ensure sub_total, tax, taxable_total are strings if present
foreach (['sub_total', 'tax', 'taxable_total', 'total_w_tax'] as $key) {
    if (isset($resp['data'][$key])) {
        $resp['data'][$key] = (string)round((float)$resp['data'][$key], 2);
    }
}

// Total amount as formatted string
$total = isset($params['total_w_tax']) ? round((float)$params['total_w_tax'], 2) : 0;


            
                    
                    
                    $this->details=array(
                      'order_id'=>$order_id,
                      'order_detail'=>$resp,
                      'total_amount'=>$params['total_w_tax'],
                      'total_amount_by_100'=>$total*100,
                      'total_amount_formatted'=>$total,
                      'payment_provider'=>$payment_provider,
                      'next_step'=>$next_step,
                      'currency_code'=>$this->functions->getCurrencyCode(),
                      'payment_description'=>$payment_description,
                      'merchant_name'=>$this->functions->clearString($this->merchant_name),
                      'provider_credentials'=>$provider_credentials,
                      'redirect_url'=>$redirect_url,
                      'client_info'=>$client_info
                    );
                    
                } else $this->msg = ("Something went wrong cannot insert records. please try again later");
                
            } else $this->msg = $msg;           
        } else $this->msg = ("Cart is empty");      
        
        $this->output();
    }



    public function GetAddressFromCart()
    {
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $this->code = 1;
            $this->msg = "OK";
            
            $country_list = $this->functions->CountryList();
            
            $default_country_code = $this->functions->getOptionAdmin('admin_country_set');
            
            $this->details = array(
              'street'=>$resp['street'],
              'city'=>$resp['city'],
              'state'=>$resp['state'],
              'zipcode'=>$resp['zipcode'],
              'delivery_instruction'=>$resp['delivery_instruction'],
              'location_name'=>$resp['location_name'],
              'contact_phone'=>$resp['contact_phone'],
              'country_code'=>!empty($resp['country_code'])?$resp['country_code']:$default_country_code,
              'delivery_lat'=>$resp['delivery_lat'],
              'delivery_long'=>$resp['delivery_long'],
              'country_list'=>$country_list
            );
            
        } else $this->msg = "cart not available";
        $this->output();
    }

    public function getUserProfile()
    {       
        $token = isset($this->data['token'])?$this->data['token']:'';
        $device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        
        if($res = $this->SingleAppClass_pos->getCustomerByTokenAndDevice($token,$device_uiid)){                                         
            
            $has_pts = '';
            $client_id = (integer) $res['client_id'];           
            $avatar =  $this->SingleAppClass_pos->getAvatar2($res['avatar']);       
            
            if($res['single_app_merchant_id']<=0){
                

                $this->functions->updateData("mt_client",array(
                  'single_app_merchant_id'=>$this->merchant_id,
                  'date_modified'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                ), 'client_id', $client_id);

            }       
                                            
            $data = array(
               'first_name'=>$res['first_name'],
               'last_name'=>$res['last_name'],
               'full_name'=>ucwords($res['first_name']." ".$res['last_name']),
               'email_address'=>$res['email_address'],
               'contact_phone'=>$res['contact_phone'],
               'enabled_push'=>$res['push_enabled']>0?$res['push_enabled']:0,
               'has_pts'=>$has_pts,
               'avatar'=>$avatar,
               'social_strategy'=>$res['social_strategy'],
               'subscribe_topic'=>$res['subscribe_topic']>0?$res['subscribe_topic']:0
            );
            
            $this->code = 1;
            $this->msg = "ok";
            $this->details = array(
             'data'=>$data
            );
        } else {
            $this->code = 3;
            $this->msg = ("token not found");
        }
        $this->output();
    }
    
    public function saveChangePassword()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if ($this->data['password']==$this->data['cpassword']){
            if($res = $this->SingleAppClass_pos->getCustomerByToken($token)){       
                $client_id = $res['client_id'];
                $current_pass = md5($this->data['current_password']);               
                $new_password = md5($this->data['password']);
                if ( $current_pass == $res['password']){                    
                    if ( $current_pass == $new_password){
                       $this->msg = ("New password cannot be the same as old password");
                    } else {
                       $params = array(
                          'password'=>md5($this->data['password']),
                          'date_modified'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR']
                        );              
                        
                        if ( $this->functions->updateData("mt_client",$params,'client_id',$client_id)){
                             $this->code = 1;
                             $this->msg = ("Password updated");
                             $this->details='';
                        } else $this->msg = ("Cannot update records, please try again later");  
                    }                                       
                } else $this->msg = ("Current password is not valid");
            } else {
                $this->code = 3;
                $this->msg = ("token not found");
            }
        } else $this->msg = ("Confirm password does not match");
        $this->output();
    }


    public function saveProfile()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $client_id = $res['client_id'];
            $params = array(
              'first_name'=>$this->data['first_name'],
              'last_name'=>$this->data['last_name'],
              'contact_phone'=>$this->data['contact_phone'],
              'date_modified'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            if ( $this->functions->updateData("mt_client",$params,'client_id',$client_id)){
                 $this->code = 1;
                 $this->msg = ("Profile updated");
                 
                 $avatar = $this->SingleAppClass_pos->getAvatar($client_id);
                 
                 $this->details=array(
                   'full_name'=>ucwords($res['first_name']." ".$res['last_name']),
                   'avatar'=>$avatar
                 );
            } else $this->msg = ("Cannot update records, please try again later");  
        } else {
            $this->code = 3;
            $this->msg = ("token not found");
        }
        $this->output();
    }
    
    public function savePushSettings()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    
    if ($res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $client_id = $res['client_id'];

        $params = array(
            'push_enabled' => isset($this->data['enabled_push']) ? (int)$this->data['enabled_push'] : 0,
            'date_modified' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        );

        $stmt = $this->db->prepare("
            UPDATE mt_singleapp_device_reg 
            SET push_enabled = :push_enabled, 
                date_modified = :date_modified, 
                ip_address = :ip_address 
            WHERE device_uiid = :device_uiid AND client_id = :client_id
        ");

        $stmt->bindValue(':push_enabled', $params['push_enabled'], PDO::PARAM_INT);
        $stmt->bindValue(':date_modified', $params['date_modified']);
        $stmt->bindValue(':ip_address', $params['ip_address']);
        $stmt->bindValue(':device_uiid', $this->device_uiid);
        $stmt->bindValue(':client_id', $client_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $this->code = 1;
            $this->msg = "Push settings updated";
            $this->details = array(
                'enabled_push' => $params['push_enabled']
            );
        } else {
            $this->msg = "Cannot update records, please try again later";
        }
    } else {
        $this->code = 3;
        $this->msg = "token not found";
    }

    $this->output();
}

    public function login()
    {
        
        $username = isset($this->data['username'])?$this->data['username']:'';
        $password = isset($this->data['password'])?$this->data['password']:'';
        
        
        $pos_keys = isset($this->data['pos_keys'])?trim($this->data['pos_keys']):$_REQUEST['pos_keys'];     
        
        if(empty($pos_keys)){
            $this->code = 10;   
            $this->msg = ("Invalid merchant keys");
            $this->output();
            return false;
        }
        if(!$resp=$this->SingleAppClass_pos->validateKeys($pos_keys)){
            $this->code = 10;       
            $this->msg = ("Invalid merchant keys");
            $this->output();
            return false;
        }
                
        if($resp['status']!="active"){
            $this->code = 11;       
            $this->msg = ("Failed merchant is no longer active");
            $this->output();
            return false;
        }
        
        
        if ($res=$this->SingleAppClass_pos->appLogin($username,$password)){                     
            
            $client_id = $res['merchant_id'];
            
            $merchant_info=$this->functions->getMerchant($res['merchant_id']);
            
            if($merchant_info['pos_key']==$pos_keys){
            
            $this->data['client_id'] = $client_id;
            $this->data['merchant_id']=$res['merchant_id'];
            //SingleAppClass::registeredDevice($this->data);
            $this->code = 1;
            $this->msg = ("Login successful");
            $cash="cashier";
            if($res['pos_cashier_access']==1){
                $cash="cashier";
                
            }else{$cash="Waiter";}
            
            $this->details = array(
                  'merchant_id'=>$res['merchant_id'],
                  'name'=>$res['first_name'].' '.$res['last_name'],
                  'type'=>$cash,
                  'pos_key'=>$merchant_info['pos_key'],
                  'contact_email'=>$res['contact_email'],
                  'pos_user_id'=>$res['merchant_user_id']
                );
                
                
            } else $this->msg = ("User does not belong to the POS merchant");
            
        } else $this->msg = ("Login failed either username or password is not valid");
        $this->output();
    }

    public function getAddressBookDropDown()
    {
        $this->getAddressBookList(false , "ORDER BY as_default DESC");
    }
    
    public function getAddressBookList($with_limit = true, $sort_by = 'ORDER BY id DESC')
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }

    $client_id = $res['client_id'];
    if ($client_id > 0) {

        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

        $limit = $with_limit ? "LIMIT $page, $pagelimit" : "";

        $search_resp = $this->SingleAppClass_pos->searchMode();
        $search_mode = $search_resp['search_mode'];

        if ($search_mode == "location") {
            $sql = "
                SELECT SQL_CALC_FOUND_ROWS 
                    a.id,
                    a.as_default,
                    a.date_created,
                    CONCAT(a.street,' ',d.name,' ',c.name,' ',b.name) AS address
                FROM mt_address_book_location a
                LEFT JOIN mt_location_states b ON a.state_id = b.state_id
                LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
                LEFT JOIN mt_location_area d ON a.area_id = d.area_id
                WHERE a.client_id = :client_id
                AND a.street <> ''
                ORDER BY a.id DESC
                $limit
            ";
        } else {
            $sql = "
                SELECT
                    CONCAT(street,' ',city,' ',state,' ',zipcode) AS address,
                    id,
                    location_name,
                    country_code,
                    as_default,
                    latitude,
                    longitude,
                    date_created
                FROM mt_address_book
                WHERE client_id = :client_id
                $sort_by
                $limit
            ";
        }

        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':client_id', $client_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($res) {
                $data = array();
                foreach ($res as $val) {
                    $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                    $val['date_added'] = "Added " . $date_added;

                    if ($search_mode == "location") {
                        if ($val['as_default'] == 1) {
                            $val['as_default'] = 2;
                        }
                    }

                    $data[] = $val;
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                    'data' => $data,
                    'page_action' => $page_action
                );
                $this->output();
            } else {
                if ($page_action == "infinite_scroll") {
                    $this->code = 2;
                    $this->msg = "end of records";
                } else {
                    $this->code = 6;
                    $this->details = array(
                        'title' => "Your address book list is empty",
                        'sub_title' => "Add your first address"
                    );
                }
            }
        } else {
            $this->msg = "Query failed";
            $this->code = 3;
        }
    } else {
        $this->msg = "Invalid token, please relogin again";
        $this->code = 3;
    }

    $this->output();
}


public function saveAddressBook()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        
        
        
        $this->Validator->required(array(
          'lat'=>("latitude is required"),
          'lng'=>("longitude id is required")
        ),$this->data);
        
        
        if($this->Validator->validate()){   
            $client_id = $res['client_id'];
            $id = isset($this->data['book_id'])?$this->data['book_id']:'';
            
            $params = array(
              'client_id'=>$client_id,
              'street'=>isset($this->data['street'])?$this->data['street']:'',
              'city'=>isset($this->data['city'])?$this->data['city']:'',
              'state'=>isset($this->data['state'])?$this->data['state']:'',
              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
              'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
              'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:1,
              'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
              'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
            );
                                
                                    
            if($id>=1){
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();
                if(!$this->SingleAppClass_pos->checkAddressBook($client_id,$params['latitude'],$params['longitude'],$id)){                  
                    

                     $up =$this->functions->updateData("mt_address_book",$params, 'id', $id);


                    if($up){                    
                        $this->code = 1;
                        $this->msg = ("Successfully updated");
                    } else $this->msg = ("Something went wrong cannot update records. please try again later");
                } else $this->msg = ("Address already exist");
            } else {
                if(!$this->SingleAppClass_pos->checkAddressBook($client_id,$params['latitude'],$params['longitude'])){                  
                    if($id =$this->functions->insertData("mt_address_book",$params)){   
                        
                        $this->code = 1;
                        $this->msg = ("Successfully added");
                        $this->details='';
                    } else $this->msg = ("Something went wrong cannot insert records. please try again later");
                } else $this->msg = ("Address already exist");
            }       
            
            if ($this->code == 1 && $id > 0) {
    if ($params['as_default'] == 2) {
        $sql = "UPDATE mt_address_book SET as_default='1' 
                WHERE client_id = '" . $client_id . "'
                AND ID NOT IN ('" . $id . "')";
        $this->db->query($sql);
    }
}
        
            
            
            /*SAVE LOCATION*/       
            $lat = isset($this->data['lat'])?$this->data['lat']:'';
            $lng = isset($this->data['lng'])?$this->data['lng']:'';
        
            $country_name = $this->functions->countryCodeToFull(isset($this->data['country_code'])?$this->data['country_code']:'');     
            if(!empty($country_name)){
                $this->data['country']=$country_name;
            }
                                
            $params_recent = array(
              'device_uiid'=>$this->device_uiid,
              'search_address'=>isset($this->data['search_address2'])?trim($this->data['search_address2']):'',
              'street'=>isset($this->data['street'])?trim($this->data['street']):'',
              'city'=>isset($this->data['city'])?trim($this->data['city']):'',
              'state'=>isset($this->data['state'])?trim($this->data['state']):'',
              'country'=>isset($this->data['country'])?trim($this->data['country']):'',
              'location_name'=>isset($this->data['location_name'])?trim($this->data['location_name']):'',
              'zipcode'=>isset($this->data['zipcode'])?trim($this->data['zipcode']):'',
              'latitude'=>$lat,
              'longitude'=>$lng,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
            );                  
            if(!empty($params_recent['search_address'])){
                if($res = $this->SingleAppClass_pos->getRecentLocationByID($this->device_uiid,$lat, $lng)){                 
                    $id = $res['id'];                   
                    

                    $this->functions->updateData("mt_singleapp_recent_location",$params_recent, 'id', $id);

                } else {                                    
                    $this->functions->insertData("mt_singleapp_recent_location",$params_recent);
                }       
            }
            
        } else $this->msg  = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }


    public function deleteAddressBook()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }

    $client_id = $res['client_id'];
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;

    if ($id >= 1) {
        $search_resp = $this->SingleAppClass_pos->searchMode();
        $search_mode = $search_resp['search_mode'];

        if ($search_mode == "location") {
            $stmt = $this->db->prepare("
                DELETE FROM mt_address_book_location
                WHERE id = ? AND client_id = ?
            ");
        } else {
            $stmt = $this->db->prepare("
                DELETE FROM mt_address_book
                WHERE id = ? AND client_id = ?
            ");
        }

        $stmt->execute([$id, $client_id]);

        $this->code = 1;
        $this->msg = "OK";
    } else {
        $this->msg = "Invalid id";
    }

    $this->output();
}


public function getAddressBook()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];
        $id = isset($this->data['id'])?$this->data['id']:'';
        if($id>=1){
            if ($res=$this->functions->getAddressBookByID($id)){
                unset($res['date_created']);
                unset($res['date_modified']);
                unset($res['ip_address']);
                
                $country_list = $this->functions->CountryList();
                $res['country_list'] = $country_list;
                
                $this->code = 1;
                $this->msg = "ok";
                $this->details = $res;
            } else $this->msg = ("Record not found. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


public function getOrders()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

        $paginate_total = 0;
        $limit = "LIMIT $page, $pagelimit";

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d g:i:s a');
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        $and = $this->SingleAppClass_pos->getOrderTabsStatus($this->merchant_id, $tab);

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
                a.order_id,
                a.client_id,
                a.merchant_id,
                a.trans_type,
                a.payment_type,
                a.date_created,
                a.date_created as date_created_raw,
                a.total_w_tax,
                a.status,
                a.status as status_raw,
                a.request_cancel,
                a.order_locked,
                a.request_cancel_status,
                b.restaurant_name as merchant_name,
                b.logo,
                (
                    SELECT rating FROM mt_review
                    WHERE order_id = a.order_id
                    AND status = 'publish'
                    LIMIT 1
                ) as rating
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.client_id = ?
            AND a.merchant_id = ?
            AND a.status NOT IN ('initial_order')
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);

        $cmd = $this->db->prepare($stmt);
        $cmd->execute([$client_id, $this->merchant_id]);

        if ($res = $cmd->fetchAll()) {
            $data = [];
            foreach ($res as $val) {
                $val['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val['status'] = $val['status'];
                $val['transaction'] = $val['trans_type'] . " # " . $val['order_id'];

                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " .
                                       $this->functions->prettyTime($val['date_created']);
                $val['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);
                $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);
                $val['logo'] = $this->SingleAppClass_pos->getImage($val['logo']);

                $add_review = false;
                if ($this->SingleAppClass_pos->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)) {
                    $add_review = true;
                }

                if ($add_review) {
                    if ($val['client_id'] == $client_id) {
                        $date_diff = $this->functions->dateDifference(
                            date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                            $date_now
                        );
                        if (is_array($date_diff) && count($date_diff) >= 1) {
                            if ($date_diff['days'] >= 5) {
                                $add_review = false;
                            }
                        }
                    } else {
                        $add_review = false;
                    }
                }

                if ($website_review_type == 1 && $val['rating'] > 0 && $merchant_can_edit_reviews == "yes") {
                    $add_review = false;
                }

                $val['add_review'] = $add_review;

                $show_cancel = false;
                $cancel_status = '';
                if ($this->functions->canCancelOrderNew(
                    $val['request_cancel'],
                    $val['date_created_raw'],
                    $val['status_raw'],
                    $val['order_locked'],
                    $val['request_cancel_status'],
                    $cancel_order_enabled
                )) {
                    if ($val['request_cancel'] == 1) {
                        $cancel_status = "Pending for review";
                    } else {
                        $show_cancel = true;
                    }
                }

                if ($val['request_cancel_status'] != 'pending') {
                    $cancel_status = "Request cancel :" . $val['request_cancel_status'];
                }

                $val['add_cancel'] = $show_cancel;
                $val['cancel_status'] = $cancel_status;

                $val['add_track'] = true;
                $val['transaction_type'] = $val['trans_type'];
                $val['placed'] = "Placed on " . $this->functions->prettyDate($val['date_created']);
                $val['total'] = $val['total_w_tax'];

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = [
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data,
            ];
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $msg1 = '';
                switch ($tab) {
                    case "processing":
                        $msg1 = "There is no processing order";
                        break;
                    case "completed":
                        $msg1 = "There is no completed order";
                        break;
                    case "cancelled":
                        $msg1 = "There is no cancelled order";
                        break;
                    default:
                        $msg1 = "Your order list is empty";
                        break;
                }

                $this->code = 6;
                $this->details = [
                    'title' => $msg1,
                    'sub_title' => "Make your first order",
                ];
            }
        }
    } else {
        $this->code = 3;
        $this->details = [
            'title' => "Get your first order, sign up now!",
            'sub_title' => "Make your first order",
        ];
    }

    $this->output();
}

public function getPendingTodayOrders()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;
    if (empty($table_number) || $table_number <= 0) {
        $this->msg = "Table Number is missing";
        $this->output();
    }

    $pos_id = isset($this->data['pos_user_id']) ? $this->data['pos_user_id'] : '';
    $sales = 0;

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

        $paginate_total = 0;
        $limit = "LIMIT $page, $pagelimit";

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d');
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';

        $and = " AND a.date_created BETWEEN ? AND ?";
        $params = ["$date_now 00:00:00", "$date_now 23:59:00"];

        if ($table_number > 0) {
            $and .= " AND a.table_number = ?";
            $params[] = $table_number;
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
                a.order_id, a.json_details, a.order_number, a.table_number, 
                a.voucher_code, a.voucher_amount, a.voucher_type,
                a.client_id, a.merchant_id, a.trans_type, a.payment_type,
                a.date_created, a.date_created as date_created_raw, 
                a.total_w_tax, a.status, a.status as status_raw,
                a.request_cancel, a.order_locked, a.request_cancel_status,
                b.restaurant_name as merchant_name, b.logo,
                (
                    SELECT first_name 
                    FROM mt_client 
                    WHERE client_id = a.client_id  
                    LIMIT 1
                ) as first_name
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.merchant_id = ?
            AND a.status IN ('pending', 'New Order')
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $params[] = $this->merchant_id;

        $cmd = $this->db->prepare($stmt);
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $cmd->execute($params);
        
        if ($res = $cmd->fetchAll()) {
            $data = [];

            foreach ($res as $val) {
                $val2 = [];

                $val2['order_id'] = $val['order_id'];
                $val2['order_number'] = $val['merchant_id'] . '-' . $val['order_number'];
                $val2['customer'] = !empty($val['first_name']) ? $val['first_name'] : 'Guest';

                if ($val['table_number'] > 0) {
                    $tables = $this->functions->GetTables($val['table_number']);
                    if ($tables) {
                        $val2['table_name'] = $tables['name'];
                    }
                }

                if (!empty($val['voucher_code'])) {
                    if ($val['voucher_type'] == "fixed amount") {
                        $val2['less_voucher'] = $val['voucher_amount'];
                        $val2['voucher_amount'] = $val['voucher_amount'];
                    } else {
                        $val2['voucher_amount'] = $val['sub_total'] * ($val['voucher_amount'] / 100);
                        $val2['less_voucher'] = $this->functions->normalPrettyPrice($val['voucher_amount']) . "%";
                    }
                }

                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $sales += $val['total_w_tax'];

                $val2['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val2['status'] = $val['status'];
                $val2['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);

                $item_data = json_decode($val['json_details'], true);
                $total_qty = 0;
                if (!empty($item_data)) {
                    foreach ($item_data as $data2) {
                        $total_qty += $data2['qty'];
                    }
                }

                $val2['total_qty'] = $total_qty;
                $data[] = $val2;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = [
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data,
                'total_sale' => $sales,
            ];
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $msg1 = "No Active Order Against the Table #$table_number";
                $this->code = 6;
                $this->details = [
                    'title' => $msg1,
                    'sub_title' => $msg1,
                ];
            }
        }
    } else {
        $msg1 = "No Active Order Against the Table #$table_number";
        $this->code = 3;
        $this->details = [
            'title' => $msg1,
            'sub_title' => $msg1,
        ];
    }

    $this->output();
}


public function getallOrderslisttodaybycashier()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $pos_id = isset($this->data['pos_user_id']) ? $this->data['pos_user_id'] : '';
    $sales = 0;

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $paginate_total = 0;
        $limit = "LIMIT $page,$pagelimit";

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d');
        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;

        $and = " AND a.date_created BETWEEN '$date_now 00:00:00' AND '$date_now 23:59:00'";

        if ($table_number > 0) {
            $and .= " AND a.table_number='$table_number'";
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
                a.order_id,a.json_details,a.order_number,a.table_number,
                a.voucher_code,a.voucher_amount,a.voucher_type,a.sub_total,
                a.client_id,a.merchant_id,a.delivery_charge,a.address,a.client_names,
                a.email,a.phones,a.is_phone_order,a.trans_type,a.payment_type,
                a.date_created,a.date_created as date_created_raw,a.total_w_tax,
                a.status,a.status as status_raw,a.request_cancel,a.order_locked,
                a.request_cancel_status,
                b.restaurant_name as merchant_name,b.logo,
                (SELECT first_name FROM mt_client WHERE client_id = a.client_id LIMIT 1) as first_name
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.merchant_id = {$this->merchant_id}
            AND a.status NOT IN('initial_order')
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $stmt = $this->db->prepare($stmt);
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $val2 = array();
                $val2['order_id'] = $val['order_id'];
                $val2['order_number'] = $val['merchant_id'] . '-' . $val['order_number'];

                if ($val['table_number'] > 0) {
                    $tables = $this->functions->GetTables($val['table_number']);
                    if ($tables) {
                        $val2['table_name'] = $tables['name'];
                    }
                }

                if (isset($val['voucher_code'])) {
                    if ($val['voucher_type'] == "fixed amount") {
                        $val2['less_voucher'] = $val['voucher_amount'];
                        $val2['voucher_amount'] = $val['voucher_amount'];
                    } else {
                        $val2['voucher_amount'] = $val['sub_total'] * ($val['voucher_amount'] / 100);
                        $val2['less_voucher'] = $this->functions->normalPrettyPrice($val['voucher_amount']) . "%";
                    }
                }

                $val2['customer'] = isset($val['first_name']) && !empty($val['first_name']) ? $val['first_name'] : 'Guest';

                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $sales += $val['total_w_tax'];

                $val2['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val2['status'] = $val['status'];
                $val2['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);

                if ($val['is_phone_order'] == 1) {
                    $val2['customer'] = $val['client_names'];
                    $val2['delivery_charge'] = $this->functions->normalPrettyPrice($val['delivery_charge']);
                    $val2['email'] = $val['email'];
                    $val2['phone'] = $val['phones'];
                    $val2['address'] = $val['address'];
                }

                $item_data = json_decode($val['json_details'], true);
                $total_qty = 0;
                if (is_array($item_data)) {
                    foreach ($item_data as $data2) {
                        $total_qty += $data2['qty'];
                    }
                }

                $val2['total_qty'] = $total_qty;
                $data[] = $val2;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data,
                'total_sale' => $sales
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $msg1 = match ($tab) {
                    "processing" => "There is no processing order",
                    "completed" => "There is no completed order",
                    "cancelled" => "There is no cancelled order",
                    default => "Your order list is empty for today"
                };

                $this->code = 6;
                $this->details = array(
                    'title' => $msg1,
                    'sub_title' => "order list is empty for today"
                );
            }
        }
    } else {
        $this->code = 3;
        $this->details = array(
            'title' => "order list is empty for today",
            'sub_title' => "order list is empty for today"
        );
    }

    $this->output();
}


public function getallOrderslist()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $pos_id = isset($this->data['pos_user_id']) ? $this->data['pos_user_id'] : '';

    if (!isset($pos_id) || empty($pos_id)) {
        $this->msg = ("User ID is missing");
        $this->output();
    }

    $sales = 0;
    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $paginate_total = 0;
        $limit = "LIMIT $page,$pagelimit";

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d');
        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;

        if ($table_number > 0) {
            $and .= " AND a.table_number='$table_number'";
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
                a.order_id, a.json_details, a.order_number, a.table_number,
                a.voucher_code, a.voucher_amount, a.voucher_type,
                a.client_id, a.merchant_id, a.trans_type, a.delivery_charge,
                a.address, a.client_names, a.email, a.phones, a.is_phone_order,
                a.payment_type, a.date_created, a.date_created as date_created_raw,
                a.total_w_tax, a.status, a.status as status_raw,
                a.request_cancel, a.order_locked, a.request_cancel_status,
                b.restaurant_name as merchant_name, b.logo,
                (SELECT first_name FROM mt_client WHERE client_id = a.client_id LIMIT 1) as first_name
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE 1
            AND a.merchant_id = {$this->merchant_id}
            AND a.pos_user_id = {$pos_id}
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $stmt = $this->db->prepare($stmt);
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $val2 = array();
                $val2['order_id'] = $val['order_id'];
                $val2['order_number'] = $val['merchant_id'] . '-' . $val['order_number'];

                if ($val['table_number'] > 0) {
                    $tables = $this->functions->GetTables($val['table_number']);
                    if ($tables) {
                        $val2['table_name'] = $tables['name'];
                    }
                }

                $val2['customer'] = isset($val['first_name']) && !empty($val['first_name']) ? $val['first_name'] : 'Guest';
                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $sales += $val['total_w_tax'];

                if (isset($val['voucher_code'])) {
                    if ($val['voucher_type'] == "fixed amount") {
                        $val2['less_voucher'] = $val['voucher_amount'];
                        $val2['voucher_amount'] = $val['voucher_amount'];
                    } else {
                        $val2['voucher_amount'] = $val['sub_total'] * ($val['voucher_amount'] / 100);
                        $val2['less_voucher'] = $this->functions->normalPrettyPrice($val['voucher_amount']) . "%";
                    }
                }

                if ($val['is_phone_order'] == 1) {
                    $val2['customer'] =isset($val['client_names']) && !empty($val['client_names']) ? $val['client_names'] : 'Guest';
                    $val2['delivery_charge'] = $this->functions->normalPrettyPrice($val['delivery_charge']);
          
          if(isset($val['email']) && !empty($val['email'])){
                    $val2['email'] = isset($val['email']) && !empty($val['email']) ? $val['email'] : '';}
          
          if(isset($val['phones']) && !empty($val['phones'])){
                    $val2['phone'] =isset($val['phones']) && !empty($val['phones']) ? $val['phones'] : '';}
                    $val2['address'] = isset($val['address']) && !empty($val['address']) ? $val['address'] : '';
                }

                $val2['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val2['status'] = $val['status'];
                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val2['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);

                $item_data = json_decode($val['json_details'], true);
                $total_qty = 0;
                if (is_array($item_data)) {
                    foreach ($item_data as $data2) {
                        $total_qty += $data2['qty'];
                    }
                }

                $val2['total_qty'] = $total_qty;
                $data[] = $val2;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data,
                'total_sale' => $sales
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $msg1 = match ($tab) {
                    "processing" => "There is no processing order",
                    "completed" => "There is no completed order",
                    "cancelled" => "There is no cancelled order",
                    default => "Your order list is empty for today"
                };

                $this->code = 6;
                $this->details = array(
                    'title' => $msg1,
                    'sub_title' => "order list is empty"
                );
            }
        }
    } else {
        $this->code = 3;
        $this->details = array(
            'title' => "order list is empty!",
            'sub_title' => "order list is empty"
        );
    }

    $this->output();
}



public function getalltodayOrders()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $pos_id = isset($this->data['pos_user_id']) ? $this->data['pos_user_id'] : '';

    if (empty($pos_id)) {
        $this->msg = "User ID is missing";
        $this->output();
    }

    $sales = 0;

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $limit = "LIMIT $page,$pagelimit";
        $paginate_total = 0;

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');
        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d');
        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;

        $and = " AND a.date_created BETWEEN '$date_now 00:00:00' AND '$date_now 23:59:00'";
        if ($table_number > 0) {
            $and .= " AND a.table_number='$table_number'";
        }

        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.order_id, a.json_details, a.order_number, a.table_number, a.voucher_code, a.voucher_amount, a.voucher_type,
            a.client_id, a.merchant_id, a.trans_type, a.payment_type, a.date_created,
            a.delivery_charge, a.address, a.client_names, a.email, a.phones, a.is_phone_order,
            a.date_created as date_created_raw, a.total_w_tax, a.status, a.status as status_raw,
            a.request_cancel, a.order_locked, a.request_cancel_status,
            b.restaurant_name as merchant_name, b.logo,
            (
                SELECT first_name FROM mt_client
                WHERE client_id = a.client_id LIMIT 1
            ) as first_name
        FROM mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE 1
        AND a.merchant_id = {$this->merchant_id}
        AND a.pos_user_id = {$pos_id}
        $and
        ORDER BY a.order_id DESC
        $limit
        ";
       $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
            $data = [];

            foreach ($res as $val) {
                $val2 = [];
                $val2['order_id'] = $val['order_id'];
                $val2['order_number'] = $val['merchant_id'] . '-' . $val['order_number'];

                if ($val['table_number'] > 0) {
                    $tables = $this->functions->GetTables($val['table_number']);
                    if ($tables) {
                        $val2['table_name'] = $tables['name'];
                    }
                }

                $val2['customer'] = !empty($val['first_name']) ? $val['first_name'] : 'Guest';
                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $sales += $val['total_w_tax'];

                if ($val['is_phone_order'] == 1) {
                    $val2['customer'] = $val['client_names'];
                    $val2['delivery_charge'] = $this->functions->normalPrettyPrice($val['delivery_charge']);
                    $val2['email'] = $val['email'];
                    $val2['phone'] = $val['phones'];
                    $val2['address'] = $val['address'];
                }

                $val2['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val2['status'] = $val['status'];
                $val2['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val2['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);

                if (isset($val['voucher_code'])) {
                    if ($val['voucher_type'] == "fixed amount") {
                        $val2['less_voucher'] = $val['voucher_amount'];
                        $val2['voucher_amount'] = $val['voucher_amount'];
                    } else {
                        $val2['voucher_amount'] = $val['sub_total'] * ($val['voucher_amount'] / 100);
                        $val2['less_voucher'] = $this->functions->normalPrettyPrice($val['voucher_amount']) . "%";
                    }
                }

                $item_data = json_decode($val['json_details'], true);
                $total_qty = 0;
                if (!empty($item_data)) {
                    foreach ($item_data as $data2) {
                        $total_qty += $data2['qty'];
                    }
                }

                $val2['total_qty'] = $total_qty;

                $data[] = $val2;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data,
                'total_sale' => $sales
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $msg1 = '';
                switch ($tab) {
                    case "processing":
                        $msg1 = "There is no processing order";
                        break;
                    case "completed":
                        $msg1 = "There is no completed order";
                        break;
                    case "cancelled":
                        $msg1 = "There is no cancelled order";
                        break;
                    default:
                        $msg1 = "Your order list is empty for today";
                        break;
                }

                $this->code = 6;
                $this->details = array(
                    'title' => $msg1,
                    'sub_title' => "order list is empty for today"
                );
            }
        }
    } else {
        $this->code = 3;
        $this->details = array(
            'title' => "Get your first order, sign up now!",
            'sub_title' => "Make your first order"
        );
    }

    $this->output();
}



public function updateOrderStaus()
{       
    $pos_user_id = isset($this->data['pos_user_id']) ? $this->data['pos_user_id'] : '';         
    if (empty($pos_user_id)) {
        $this->msg = ("User ID is missing");
        $this->output();
    }

    $id = isset($this->data['id']) ? $this->data['id'] : '';        
    $order_id = $id;

    if ($id >= 1) {
        if ($data = $this->SingleAppClass_pos->getReceiptByID($order_id)) {
            
            if ($data['merchant_id'] == $this->merchant_id) {
                
                if ($data['status'] == 'New Order' || $data['status'] == 'pending') {
                    
                    $minfouser = $this->functions->getMerchantUserInfobymid($pos_user_id);  
                    
                    $params_update = array(
                        'status' => 'paid',
                        'cash_received_by' => $minfouser['merchant_user_id'],
                        'date_modified' => $this->functions->dateNow()
                    );

                    // Use existing updateData method
                    $this->functions->updateData("mt_order", $params_update, 'order_id', $order_id);    
                    
                    // Use native PDO for deleting from mt_pos_cart
                    if ($data['table_number'] > 0) {
                        $merchant_id = $this->merchant_id;
                        $table_number = $data['table_number'];
                        $sql = "DELETE FROM mt_pos_cart WHERE 1 AND merchant_id=$merchant_id AND table_number=$table_number";
                        $this->db->exec($sql);
                    }

                    $this->code = 1;
                    $this->msg = ("Order status changed to paid");
                    $this->output();

                } else {
                    $this->msg = ("Order already paid");
                    $this->output();
                }
                
            } else {
                $this->msg = ("Order does not belong to your Merchant");
                $this->output();
            }
            
        } else {
            $this->code = 2;
            $this->msg = ("No order Exist");
            $this->output();
        }
        
    } else {
        $this->msg = ("Invalid id");
        $this->output();
    }
}


public function getOrderDetails()
    {
                    
        $client_id = $res['client_id'];     
        
        $id = isset($this->data['id'])?$this->data['id']:'';        
        $order_id = $id;
        if($id>=1){
            $_GET['backend']='';
            if ($resp = $this->SingleAppClass_pos->prepareReceipt($order_id)) {
               
                

    $resp['timezone'] = date_default_timezone_get();


   //+++was custom code
    // Convert numeric values in ['data']
    if (isset($resp['data']) && is_array($resp['data'])) {
        foreach ($resp['data'] as $key => $value) {
            if (is_int($value) || is_float($value)) {
                $resp['data'][$key] = (string)$value;
            }
        }
    }

    // Convert numeric values in ['order_data']
    if (isset($resp['order_data']) && is_array($resp['order_data'])) {
        foreach ($resp['order_data'] as $key => $value) {
            if (is_int($value) || is_float($value)) {
                $resp['order_data'][$key] = (string)$value;
            }
        }
    }

    // Replace all null values with empty strings
            array_walk_recursive($resp, function (&$v) {
                if (is_null($v)) {
                    $v = "";
                }
            });

            // Ensure all merchant_id values in json_details are wrapped in double quotes
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Match only merchant_id with numeric value and wrap it in quotes
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}


// Replace "cooking_ref": "[]" with "cooking_ref": ""
if (isset($resp['order_details']) && is_array($resp['order_details'])) {
    foreach ($resp['order_details'] as &$group) {
        if (isset($group['item']) && is_array($group['item'])) {
            foreach ($group['item'] as &$item) {
                if (isset($item['cooking_ref']) && $item['cooking_ref'] === '[]') {
                    $item['cooking_ref'] = '';
                }
            }
        }
    }
}

// Replace \"cooking_ref\":\"[]\" with \"cooking_ref\":\"\" inside json_details
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    $resp['data']['json_details'] = str_replace('"cooking_ref":"[]"', '"cooking_ref":""', $resp['data']['json_details']);
}


//---was custom code



    $this->code = 1;
    $this->msg = "OK";
    $this->details = array('data' => $resp);
}
 else $this->msg = ("Order not available to view. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


    public function getOrderDetails_bkup()
    {
                    
        $client_id = $res['client_id'];     
        
        $id = isset($this->data['id'])?$this->data['id']:'';        
        $order_id = $id;
        if($id>=1){
            $_GET['backend']='';
            if ($resp = $this->SingleAppClass_pos->prepareReceipt($order_id)){
                
                        
            
            $resp['timezone'] = date_default_timezone_get();
            
                          
                                        
                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array('data'=>$resp);
                     
                
            } else $this->msg = ("Order not available to view. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }



        public function reOrder()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        $id = isset($this->data['id'])?$this->data['id']:'';    
        $order_id = $id;
        if($id>=1){
            if ($res = $this->SingleAppClass_pos->ReOrderGetInfo($order_id)){   
                
                
                if($res['merchant_status']!="active"){
                    $this->msg = ("Merchant is no longer active");
                    $this->output();
                }           
                if($res['is_ready']!=2){
                    $this->msg = ("Merchant is not published");
                    $this->output();
                }           
                                                                
                /*VALIDATE IF ITEM IS AVAILABLE*/
                $cart_count=0;
                $json_details = json_decode($res['json_details'],true);
                $re_order_items = array();                          
                    
                if(is_array($json_details) && count($json_details)>=1){
                   foreach ($json_details as $item) {                                          
                    
                       $newest_price = 0; $newest_discount=0;
                       $current_discount = 0; $current_item_price = 0;
                    
                       if ($item_res = $this->functions->getFoodItem($item['item_id'])){
                           if($item_res['not_available']==2){
                              // do nothing                       
                           } else {                        
                              //dump($item_res);                              
                              $current_discount = isset($item['discount'])?$item['discount']:0;
                              $item_price = explode("|",$item['price']);
                                                          
                              if( count($item_price) <=1){                              
                                          
                                $newest_discount = $item_res['discount'];
                                $current_item_price = $item_price[0];
                                $current_item = json_decode($item_res['price'],true);
                                if(is_array($current_item) && count($current_item)>=1){
                                    //$newest_price = $current_item[0];
                                    foreach ($current_item as $new_price) {
                                        $newest_price = $new_price;
                                    }
                                }                                                                                                         
                                if($current_item_price!=$newest_price){
                                    $item['price'] = $newest_price;
                                }                             
                                if($current_discount!=$newest_discount){
                                    $item['discount'] = $newest_discount;
                                }                             
                              } else {                                                                            
                                $newest_discount = $item_res['discount'];                                           
                                $current_size_id = isset($item_price[2])?$item_price[2]:0;
                                $current_item_price = isset($item_price[0])?$item_price[0]:0;
                                $newest_price_list = json_decode($item_res['price'],true);                              
                                if(array_key_exists($current_size_id,(array)$newest_price_list)){
                                    $newest_price = $newest_price_list[$current_size_id];                                                                   
                                    if($current_item_price!=$newest_price){
                                        $item['price'] = $newest_price."|".$item_price[1]."|".$item_price[2];
                                    }           
                                    
                                    if($current_discount!=$newest_discount){
                                       $item['discount'] = $newest_discount;
                                    }                             
                                                    
                                } else {
                                    // price does not exist
                                }                                                                               
                              }                                   
                                                          
                              $re_order_items[] = $item;
                              $cart_count++;
                           }
                       }                   
                   }
                }   
                
                
                /*dump($re_order_items);
                die();*/
                            
                if($cart_count<=0){
                    $this->msg = ("There is no item to re-order");
                    $this->output();
                }       
                                
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                    try {                       
                        $this->StocksWrapper->verifyStocksReOrder($id,$merchant_id);
                    } catch (Exception $e) {
                        $this->msg = $e->getMessage();
                        $this->output();
                    }
                }       
                
                $params = array(                  
                  'cart'=>json_encode($re_order_items),
                  'date_modified'=>$this->functions->dateNow(),
                  'device_id'=>$this->device_uiid,
                  'table_number'=>$table_number,
                  'merchant_id'=>$this->merchant_id
                );
                
                
                
                if($this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
                    if ( $this->functions->updateData("mt_pos_cart",$params,'device_id',$this->device_uiid)){
                        $this->code = 1;
                        $this->msg = "OK";
                    } else $this->msg = ("Order not available to re-order. please try again later");
                } else {
                    if ($this->functions->insertData("mt_pos_cart",$params)){
                        $this->code = 1;
                        $this->msg = "OK";
                    } else $this->msg = ("Order not available to re-order. please try again later");
                }
                
                $trans_type = $res['trans_type'];               
                $services = $this->SingleAppClass_pos->getMerchantServices($res['service']);
                
                if(!array_key_exists($trans_type,(array)$services)){
                    if(is_array($services) && count($services)>=1){
                        foreach ($services as $key=>$val) {
                            $trans_type = $key;                         
                            break;
                        }
                    }           
                }
                
                $this->details = $trans_type;
                
            } else $this->msg = ("Order not available to re-order. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


public function loadReviews()
{
    $client_id = '';  
    $token = isset($this->data['token']) ? $this->data['token'] : '';

    if ($res = $this->SingleAppClass_pos->getCustomerByToken($token)) {     
        $client_id = $res['client_id'];
    }                   

    $date_now = date('Y-m-d g:i:s a');
    $data = array();
    $reply = array();

    if (isset($this->data['limit'])) {
        $this->paginate_limit = $this->data['limit'];
    }

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $this->paginate_limit;
    } else {
        $page = 0;
    }

    $website_review_type = $this->functions->getOptionAdmin('website_review_type');
    $review = false;
    if ($website_review_type == 1) {
        if ($remaining_review = $this->functions->getRemainingReview($client_id, $this->merchant_id)) {
            $review = true;
        }
    }

    $stmt = "
    SELECT a.*,
        (
            SELECT first_name
            FROM mt_client
            WHERE client_id = a.client_id
        ) AS client_name
    FROM mt_review a
    WHERE merchant_id = " . ($this->merchant_id) . "
    AND status = 'publish'
    ORDER BY id DESC
    LIMIT $page, $this->paginate_limit
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $res = $this->db->query($stmt);
    $result = $res ? $res->fetchAll(PDO::FETCH_ASSOC) : [];

    if (!empty($result)) {
        foreach ($result as $val) {

            $reply = array();
            $can_edit = true;

            $date_diff = $this->functions->dateDifference(
                date('Y-m-d g:i:s a', strtotime($val['date_created'])),
                $date_now
            );
            if (is_array($date_diff) && count($date_diff) >= 1) {
                if ($date_diff['days'] >= 10) {
                    $can_edit = false;
                }
            }

            $pretyy_date = $val['date_created'];
            $pretyy_date = $this->functions->translateDate($pretyy_date);

            if ($replies = $this->functions->reviewReplyList($val['id'], 'publish')) {
                foreach ($replies as $val_reply) {
                    $pretyy_date_reply = $val_reply['date_created'];
                    $pretyy_date_reply = $this->functions->translateDate($pretyy_date_reply);

                    $reply[] = array(
                        'reply_from' => stripslashes($val_reply['reply_from'] . " reply"),
                        'review' => $val_reply['review'],
                        'date' => $pretyy_date_reply
                    );
                }
            }

            if ($can_edit && $val['client_id'] != $client_id) {
                $can_edit = false;
            }

            $data[] = array(
                'id' => $val['id'],
                'review' => nl2br($val['review']),
                'rating' => $val['rating'],
                'client_name' => $val['client_name'],
                'avatar' => $this->SingleAppClass_pos->getAvatar($val['client_id']),
                'can_edit' => $can_edit,
                'date' => $pretyy_date,
                'reply' => $reply
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'review' => $review,
            'data' => $data
        );
    } else {
        $this->details = array(
            'review' => $review
        );
        $this->msg = "no results";
    }

    $this->output();
}


public function getReview()
    {
        $id = isset($this->data['id'])?$this->data['id']:'';
        if ($id>0){
            if ( $res=$this->functions->getReviewsById2($id,$this->merchant_id)){               
                $data = array(
                  'id'=>$res['id'],
                  'review'=>$res['review'],
                  'rating'=>$res['rating'],               
                );
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                  'data'=>$data
                );
            } else $this->msg = ("Review is not available to view. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }
    
    public function updateReview()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        
        $id = isset($this->data['review_id'])?$this->data['review_id']:'';
        if ($id>0){
            
            
             
            $params = array(
             'review'=>($this->data['review']),
             'date_modified'=>$this->functions->dateNow(),                       
            );
            
            if ($this->functions->updateData("mt_review",$params,'id',$id)){
                $this->code = 1;
                $this->msg  = "OK";
                $this->details = '';
            } else $this->msg = ("Cannot update records, please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


    public function deleteReview()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }

    $client_id = $res['client_id'];

    $id = isset($this->data['id']) ? $this->data['id'] : '';
    if ($id > 0) {
        $stmt = "
            DELETE FROM mt_review
            WHERE id = $id
            AND client_id = $client_id
        ";
        $this->db->query($stmt);
        $this->code = 1;
        $this->msg = "OK";
    } else {
        $this->msg = ("Invalid id");
    }

    $this->output();
}

    
    public function getUserInfo()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!empty($token)){
            if($res = $this->SingleAppClass_pos->getCustomerByToken($token)){           
                $data = array(
                  'name'=>$res['first_name']." ".$res['last_name'],
                  'email_address'=>$res['email_address'],
                  'contact_phone'=>$res['contact_phone']
                );
                $this->code = 1;
                $this->msg = "OK";  
                $this->details = array(
                   'data'=>$data
                );
            } else $this->msg = "Not login";
        } else $this->msg = "Not login";
        $this->output();
    }

        public function saveBooking()
    {
         if ( isset($this->data['booking_time'])){
          if(!empty($this->data['booking_time'])){
             $time_1=date('Y-m-d g:i:s a');
             $time_2=$this->data['date_booking']." ".$this->data['booking_time'];                
             $time_2=date("Y-m-d g:i:s a",strtotime($time_2));                       
             $time_diff=$this->functions->dateDifference($time_2,$time_1);                                                               
             if (is_array($time_diff) && count($time_diff)>=1){
                 if ( $time_diff['hours']>0){                       
                     $this->msg=("Sorry but you have selected time that already past");
                     $this->output();               
                 }              
                 if ( $time_diff['minutes']>0){                     
                     $this->msg=("Sorry but you have selected time that already past");
                     $this->output();               
                 }              
             }            
          }        
       }             
       
       $merchant_id = $this->merchant_id;
       
       $full_booking_time=$this->data['date_booking']." ".$this->data['booking_time'];
       $full_booking_day=strtolower(date("D",strtotime($full_booking_time)));           
       $booking_time=date('h:i A',strtotime($full_booking_time));   
           
       if ( !$this->functions->isMerchantOpenTimes($merchant_id,$full_booking_day,$booking_time)){          
            

            $this->msg = "Sorry but we are closed on ".date("F,d Y h:ia",strtotime($full_booking_time))." Please check merchant opening hours";

            $this->output();     
        }          
        
        $now=isset($this->data['date_booking'])?$this->data['date_booking']:'';         
        $merchant_close_msg_holiday='';
        $is_holiday=false;
        if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)){
            if (in_array($now,(array)$m_holiday)){
                $is_holiday=true;
            }
        }
        if ( $is_holiday==true){
            $merchant_close_msg_holiday=!empty($merchant_close_msg_holiday)?$merchant_close_msg_holiday:("Sorry but we are on holiday on")." ".date("F d Y",strtotime($now));
            $this->msg=$merchant_close_msg_holiday;
            $this->output();  
        }         
        
        $fully_booked_msg=$this->functions->getOption("fully_booked_msg",$merchant_id);
        if (!$this->functions->bookedAvailable($merchant_id)){
           if (!empty($fully_booked_msg)){
                    $this->msg=($fully_booked_msg);
           } else $this->msg=("Sorry we are fully booked for that day");                
           $this->output();  
        }  
        
        $params=array(
          'merchant_id'=>$this->merchant_id,
          'number_guest'=>isset($this->data['number_guest'])?$this->data['number_guest']:'',
          'date_booking'=>isset($this->data['date_booking'])?$this->data['date_booking']:'',
          'booking_time'=>isset($this->data['booking_time'])?$this->data['booking_time']:'',
          'booking_name'=>isset($this->data['booking_name'])?$this->data['booking_name']:'',
          'email'=>isset($this->data['email'])?$this->data['email']:'',
          'mobile'=>isset($this->data['mobile'])?$this->data['mobile']:'',
          'booking_notes'=>isset($this->data['booking_notes'])?$this->data['booking_notes']:'',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],          
        );
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($res = $this->SingleAppClass_pos->getCustomerByToken($token)){
           $params['client_id']= $res['client_id'];
        }           
        
                    
        if ($booking_id=$this->functions->insertData('mt_bookingtable',$params)){           
            
            $this->code=1;          
            
            

            $this->msg = "Your booking has been placed. Reference # ".$booking_id;
            
            $this->details = $booking_id;
            
            /*SEND NOTIFICATIONS*/      
            $new_data = $params;    
            $new_data['restaurant_name']=$this->merchant_name;
            $new_data['booking_id']=$booking_id;            
            $this->functions->notifyBooking($new_data);
            
            /*POINTS PROGRAM*/                  
            
               $this->PointsProgram->rewardsBookTable($booking_id , isset($params['client_id'])?$params['client_id']:'' , $merchant_id );
            
                
        } else $this->msg = ("Something went wrong during processing your request. Please try again later");
       
        $this->output();
    }


    public function getMerchantInfo()
    {
        if ( $res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){   
            $ratings=$this->functions->getRatings($this->merchant_id);      
            $rating_text = '';
            if(is_array($ratings) && count($ratings)>=1){
                
                $rating_text = $ratings['votes']." Reviews";
            }
            
            $merchant_photo_bg=$this->functions->getOption('merchant_photo_bg',$this->merchant_id);
            if ( empty($merchant_photo_bg)){
                $merchant_photo_bg='';
            }           
            $merchant_tax_number=$this->functions->getOption('merchant_tax_number',$this->merchant_id);         
            $data = array(  
              'merchant_name'=>$this->functions->clearString($res['restaurant_name']),
              'contact_phone'=>$res['contact_phone'],
              'address'=>$this->functions->clearString($res['complete_address']),
              'cuisine'=>$this->functions->displayCuisine($res['cuisine']),
              'free_delivery'=>$this->functions->getFreeDeliveryTag($this->merchant_id),
              'ratings'=>$ratings,
              'rating_text'=>$rating_text,
              'background_image'=>$merchant_photo_bg,
              'latitude'=>$res['latitude'],
              'lontitude'=>$res['lontitude'],
              'merchant_tax_number'=>$merchant_tax_number,
            );
            
            $new_hours = array();
            if ( $hours=$this->functions->getMerchantOpeningHours($this->merchant_id)){
                foreach ($hours as $val){
                    $new_hours[]=array(
                      'day'=>($val['day']),
                      'hours'=>$val['hours'],
                      'open_text'=>($val['open_text']),
                    );
                }
            } else $new_hours ='';
            
            $data['opening_hours'] = $new_hours;

            $payment_list_new=array();
            $payment_list = $this->functions->getMerchantPaymentListNew($this->merchant_id);        
            if(is_array($payment_list) && count($payment_list)>=1){
               foreach ($payment_list as $payment_list_key=>$payment_list_val) {
                    $payment_list_new[$payment_list_key] = ($payment_list_val);
                }   
            }       
            $data['payment_list'] = $payment_list_new;
            
            $data['information'] = $this->functions->getOption('merchant_information',$this->merchant_id);
            $data['information'] = $this->functions->clearString($data['information']);
                if(isset($data['information']) && !empty($data['information'])){}else{
                $data['information']='empty';
            }
            
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
              'data'=>$data
            );
        } else {
            $this->msg = ("Merchant information not available. please try again later");
            $this->details = array(
              'title'=>("Information not found"),
              'sub_title'=>("Merchant information is not available")
            );  
        }   
        $this->output();
    }
    
    public function getMerchantPhoto()
    {
        $list = array();
        $gallery=$this->functions->getOption("merchant_gallery",$this->merchant_id);
        $gallery=!empty($gallery)?json_decode($gallery):false;
        if(is_array($gallery) && count($gallery)>=1){
            foreach ($gallery as $val) {
                $list[] = $this->SingleAppClass_pos->getImage($val);
            }        
            $this->code = 1;
            $this->msg ="OK";
            $this->details=array('data'=>$list);
        } else $this->msg = ("Photos not available");        
        $this->output();
    }

    public function loadPromo()
    {
         $merchant_id = $this->merchant_id;
        if($merchant_id>0){
            $promo = array();
            $promo['enabled']=1;
                        
            
                if($offer=$this->functions->getOffersByMerchantNew($merchant_id)){
                   $promo['offer']=$offer;
                   $promo['enabled']=2;
                }               
            
            
                        
                if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){                           
                    $promo['enabled']=2;                
                    foreach ($voucher as $val) {
                        if ( $val['voucher_type']=="fixed amount"){
                          $amount=$this->functions->prettyPrice($val['amount']);
                        } else $amount=number_format( ($val['amount']/100)*100 )." %";
                        
                        $promo['voucher'][] = $val['voucher_name']." - ".$amount." ".("Discount");
                    }                               
                }
            
            
            $free_delivery_above_price=$this->functions->getOption('free_delivery_above_price',$merchant_id);
            if ($free_delivery_above_price>0){
                $promo['free_delivery']=("Free Delivery On Orders Over")." ". $this->functions->prettyPrice($free_delivery_above_price);
                $promo['enabled']=2;
            }
                      
            $this->code = 1;
            $this->msg = "OK";
            if($promo['enabled']==1){
                $this->msg = ("No available promos for this merchant");             
            }                           
            $this->details = array(
              'data'=>$promo,
              'title'=>("No available promo"),
               'sub_title'=>("We don't have promo at this time")
            );
            
        } else $this->msg = ("Invalid merchant id");        
        $this->output();
    }

    public function loadBooking()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $data = array();

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        $page = isset($this->data['page']) ? ($this->data['page'] * $pagelimit) : 0;
        $limit = "LIMIT $page,$pagelimit";

        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        switch ($tab) {
            case "all":
                break;
            default:
                $and = " AND a.status=" . ($tab) . " ";
                break;
        }

        $booking_cancel_days = $this->functions->getOptionAdmin('booking_cancel_days');
        $booking_cancel_hours = $this->functions->getOptionAdmin('booking_cancel_hours');
        $booking_cancel_minutes = $this->functions->getOptionAdmin('booking_cancel_minutes');

        $stmt = "
        SELECT
        a.booking_id,
        a.merchant_id,
        a.number_guest,
        a.status,
        a.status as status_raw,
        a.date_created,
        a.date_created as date_created_raw,
        a.request_cancel,
        b.restaurant_name as merchant_name,
        b.logo
        FROM mt_bookingtable a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE a.client_id = $client_id 
        AND a.merchant_id = {$this->merchant_id}
        $and
        ORDER BY a.booking_id DESC
        $limit
        ";
       $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $stmt_exec = $this->db->query($stmt);
        if ($stmt_exec && $res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                $val['merchant_name'] = $val['merchant_name'];
                $val['status'] = ($val['status']);
                $val['number_guest'] = "No. of guest " . $val['number_guest'];
                $val['booking_ref'] = "Booking ID#" . $val['booking_id'];
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['logo'] = $this->SingleAppClass_pos->getImage($val['logo']);

                $ratings = $this->functions->getRatings($val['merchant_id']);
                $ratings['review_count'] = $ratings['votes'] . " reviews";
                $val['rating'] = $ratings;

                $val['can_cancel'] = 0;
                $can_cancel = $this->SingleAppClass_pos->canCancel(
                    $val['date_created_raw'],
                    $booking_cancel_days,
                    $booking_cancel_hours,
                    $booking_cancel_minutes
                );

                if ($can_cancel) {
                    if ($val['request_cancel'] <= 0) {
                        if ($val['status_raw'] == 'pending') {
                            $val['can_cancel'] = 'cancel_booking';
                        } else {
                            $val['can_cancel'] = 'cancel_booking_request_sent';
                        }
                    }
                } else {
                    if ($val['request_cancel'] > 0) {
                        $val['can_cancel'] = 'cancel_booking_request_sent';
                    }
                }

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->msg = ("Your Booking is empty");
                $this->details = array(
                    'title' => ("Your Booking is empty"),
                    'sub_title' => ("Make your first booking")
                );
            }
        }
    }

    $this->output();
}



public function mapInfo()
    {
        if ($res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            $latitude = $res['latitude'];
            $lontitude  = $res['lontitude'];
            $address = $this->functions->clearString($res['complete_address']);
            $merchant_name = $this->functions->clearString($res['restaurant_name']);
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
              'data'=>array(                
                'info_window'=>"<h5>$merchant_name</h5><p>$address</p>",
                'latitude'=>$latitude,
                'lontitude'=>$lontitude,                
              )
            );
        } else $this->msg = ("Merchant information not available. please try again later");
        $this->output();
    }


    public function fbRegister()
    {           
            
        
        $this->Validator->required(array(
          'email_address'=>("email address is required"),
          'fb_id'=>("facebook id is required")
        ),$this->data);
        
        
        /*check if email address is blocked*/
        if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
               
            $this->Validator->setmsg("Sorry but your email address is blocked by website admin");       
        }       
        
                        
        if($this->Validator->validate()){                       
            
                        
            $params=array(
              'first_name'=>($this->data['first_name']),
              'last_name'=>($this->data['last_name']),
              'email_address'=>($this->data['email_address']),
              'password'=>md5($this->data['fb_id']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>isset($this->data['device_id'])?$this->data['device_id']:'',
              'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
              'social_strategy'=>'fb_mobile',
              'single_app_merchant_id'=>$this->merchant_id,
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
            $save_pic = $this->functions->getOption('singleapp_fb_save_pic',$this->merchant_id);
            $save_avatar_exist = false;
                    
            
            if( $res = $this->functions->isClientExist_with_merchant($params['email_address'],$this->merchant_id )){
                
                if($save_pic==1 && $save_avatar_exist==true){
                    if (empty($res['avatar'])){
                        $params['social_id'] = $this->data['fb_id'];
                    }
                }
                
                $token = $res['token'];
                if(empty($token)){
                    $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['fb_id']);       
                    $params['token'] = $token;
                }           
                
                unset($params['date_created']);
                $params['last_login']=$this->functions->dateNow();
                                
                $this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);            
                
                $this->code=1;
                $this->msg = ("Registration successful");
                
                $this->details = array(
                  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                  'token'=>$token
                );
                
                //FunctionsV3::fastRequest( websiteUrl()."/pos/cron/getfbavatar" );
                
            } else {
                // insert 
                
                if($save_pic==1 && $save_avatar_exist==true){                   
                    $params['social_id'] = $this->data['fb_id'];
                }
                
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['email_address']);
                $params['token']=$token;
                if ($customer_id =$this->functions->insertData("mt_client",$params)){
                                    
                    $this->code=1;
                    $this->msg = ("Registration successful");
                    
                    $this->details = array(
                      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                      'token'=>$token
                    );
                                        
                    /*POINTS PROGRAM*/                  
                   
                     $this->PointsProgram->signupReward($customer_id);
                    
                                        
                    //FunctionsV3::fastRequest( websiteUrl()."/pos/cron/getfbavatar" );
                    
                } else $this->msg = ("Something went wrong during processing your request. Please try again later");
            }
        
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        $this->output();
    }


    public function verificationMobile()
    {
        $code = isset($this->data['code'])?trim($this->data['code']):'';
        if(!empty($code)){
            $token = isset($this->data['token'])?$this->data['token']:'';
            if(empty($token)){
                $this->msg =("Token is empty");
                $this->output();
            }                   
            if($res = $this->SingleAppClass_pos->getCustomerByToken($token,false)){             
                $client_id = $res['client_id'];
                if ( $res['mobile_verification_code']==$code){
                                    
                    $this->code=1;
                    $this->msg=("Successful");
                    $this->details = array(
                      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                      'token'=>$token
                    );
                    $params=array( 
                      'status'=>"active",
                      'mobile_verification_date'=>$this->functions->dateNow()
                    );
                    
                    $this->functions->updateData("mt_client",$params,'client_id',$client_id);
                    
                    /*sent welcome email*/                  
                    $this->functions->sendCustomerWelcomeEmail($res);
                    
                } else $this->msg = ("Verification code is invalid");
            } else $this->msg = ("Records not found");
        } else $this->msg = ("Invalid code");
        $this->output();
    }



    public function verificationEmail()
    {
        $code = isset($this->data['code'])?trim($this->data['code']):'';
        if(!empty($code)){
            $token = isset($this->data['token'])?$this->data['token']:'';
            if(empty($token)){
                $this->msg = ("Token is empty");
                $this->output();
            }       
            if($res = $this->SingleAppClass_pos->getCustomerByToken($token,false)){             
                $client_id = $res['client_id'];             
                if ( $res['email_verification_code']==$code){
                                    
                    $this->code=1;
                    $this->msg=("Successful");
                    $this->details = array(
                      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                      'token'=>$token
                    );
                    $params=array( 
                      'status'=>"active",
                      'last_login'=>$this->functions->dateNow()
                    );
                    
                    $this->functions->updateData("mt_client",$params,'client_id',$client_id);
                    
                    /*sent welcome email*/                  
                    $this->functions->sendCustomerWelcomeEmail($res);
                    
                } else $this->msg = ("Verification code is invalid");
            } else $this->msg = ("Records not found");
        } else $this->msg = ("Invalid code");       
        $this->output();
    }



public function getAppSettings()
    {
        $this->code = 1;
        $this->msg = "OK";  

        $lang = 'en';
            
        $mobile_prefix  = $this->functions->getOption('singleapp_prefix',$this->merchant_id);
        if(!empty($mobile_prefix)){
            $mobile_prefix = "+$mobile_prefix";
        } else $mobile_prefix="+1";
                
        $singleapp_default_lang = $this->functions->getOption('singleapp_default_lang',$this->merchant_id);     
        if(!empty($singleapp_default_lang)){
            $lang=$singleapp_default_lang;
        }
        
        $has_pts = '';
        
            $points_enabled = $this->functions->getOptionAdmin('points_enabled');
            if($points_enabled==1){
               $has_pts=1;
            }
            
            if($has_pts==1){                    
                $points_disabled_merchant_settings  = $this->functions->getOptionAdmin('points_disabled_merchant_settings');
                if(empty($points_disabled_merchant_settings)){
                    $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                    if($mt_disabled_pts==2){
                        $has_pts='';
                    }                   
                }           
            }
        
                
        $settings = array(                
          'terms_customer'=>$this->functions->getOptionAdmin('website_terms_customer'),
          'terms_customer_url'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('website_terms_customer_url')),
          'currency_set'=>$this->functions->getOptionAdmin('admin_currency_set'),
          'currency_symbol'=>$this->functions->getCurrencyCode(),
          'currency_position'=>$this->functions->getOptionAdmin('admin_currency_position'),
          'currency_decimal_place'=>$this->functions->getOptionAdmin('admin_decimal_place'),
          'currency_space'=>$this->functions->getOptionAdmin('admin_add_space_between_price'),
          'currency_use_separators'=>$this->functions->getOptionAdmin('admin_use_separators'),
          'currency_decimal_separator'=>$this->functions->getOptionAdmin('admin_decimal_separator'),
          'currency_thousand_separator'=>$this->functions->getOptionAdmin('admin_thousand_separator'),
          'booking_disabled'=>$this->functions->getOptionAdmin('merchant_tbl_book_disabled'),
          'cod_change_required'=>$this->functions->getOptionAdmin('cod_change_required'),
          'disabled_website_ordering'=>$this->functions->getOptionAdmin('disabled_website_ordering'),
          'website_hide_foodprice'=>$this->functions->getOptionAdmin('website_hide_foodprice'),
          'enabled_map_selection_delivery'=>$this->functions->getOptionAdmin('enabled_map_selection_delivery'),
          'map_icon_pin'=>$this->functions->websiteUrl()."/assets_pos/images/icon_28.png",
          'mobile_prefix'=>$mobile_prefix,
          'lang'=>$singleapp_default_lang,
          
          'order_verification'=>$this->functions->getOption('order_verification',$this->merchant_id),
          'gallery_disabled'=>$this->functions->getOption('gallery_disabled',$this->merchant_id),
          'merchant_enabled_voucher'=>$this->functions->getOption('merchant_enabled_voucher',$this->merchant_id),
          'merchant_required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),
          'merchant_enabled_tip'=>$this->functions->getOption('merchant_enabled_tip',$this->merchant_id),
          'merchant_tip_default'=>$this->functions->getOption('merchant_tip_default',$this->merchant_id),
          'singleapp_location_accuracy'=>$this->functions->getOption('singleapp_location_accuracy',$this->merchant_id),
          'singleapp_enabled_fblogin'=>$this->functions->getOption('singleapp_enabled_fblogin',$this->merchant_id),
          
          'singleapp_help_url'=>$this->functions->getOption('singleapp_help_url',$this->merchant_id),
          'singleapp_terms_url'=>$this->functions->getOption('singleapp_terms_url',$this->merchant_id),
          'singleapp_privacy_url'=>$this->functions->getOption('singleapp_privacy_url',$this->merchant_id),
          
          'merchant_two_flavor_option'=>$this->functions->getOption('merchant_two_flavor_option',$this->merchant_id),
          'singleapp_enabled_banner'=>$this->functions->getOption('singleapp_enabled_banner',$this->merchant_id),
          'map_provider'=>$this->functions->getMapProvider(),
          'map_country'=>$this->functions->getCountryCode(),
          'geocomplete_default_country'=>$this->functions->getOptionAdmin('google_default_country'),
          'mapbox_access_token'=>$this->functions->getOptionAdmin('mapbox_access_token'),
          'mapbox_default_zoom'=>$this->functions->getOptionAdmin('mapbox_default_zoom'),
          'singleapp_enabled_google'=>$this->functions->getOption('singleapp_enabled_google',$this->merchant_id),
          'has_pts'=>$has_pts,
          'disabled_cc_management'=>$this->functions->getOptionAdmin('disabled_cc_management')
        );      
        
        if($settings['booking_disabled']!=2){
           if($this->functions->getOption('merchant_table_booking',$this->merchant_id)=="yes"){
              $settings['booking_disabled']=2;
           }        
        }   
        
        $settings['default_map_location']  = array(
          'lat'=>$this->functions->getOption('singleapp_default_lat',$this->merchant_id),
          'lng'=>$this->functions->getOption('singleapp_default_lng',$this->merchant_id)
        );
        
        $settings['icons']=array(
          'marker1'=>$this->functions->websiteUrl()."/assets_pos/images/icon_28.png",
          'marker2'=>$this->functions->websiteUrl()."/assets_pos/images/marker_green.png",
          'marker3'=>$this->functions->websiteUrl()."/assets_pos/images/marker_orange.png",
          'bicycle'=>$this->functions->websiteUrl()."/assets_pos/images/bicycle.png",
          'bike'=>$this->functions->websiteUrl()."/assets_pos/images/bike.png",
          'car'=>$this->functions->websiteUrl()."/assets_pos/images/car.png",
          'scooter'=>$this->functions->websiteUrl()."/assets_pos/images/scooter.png",
          'truck'=>$this->functions->websiteUrl()."/assets_pos/images/truck.png",
          'walk'=>$this->functions->websiteUrl()."/assets_pos/images/walk.png",
        );  
        $settings['marker_icon']=array(
           $settings['icons']['marker1'],
           $settings['icons']['marker2'],
           $settings['icons']['marker3'],
           $this->functions->websiteUrl()."/assets_pos/images/marker1.png",
           $this->functions->websiteUrl()."/assets_pos/images/marker2.png",
           $this->functions->websiteUrl()."/assets_pos/images/marker3.png",
           $this->functions->websiteUrl()."/assets_pos/images/marker4.png",
        );
        
        if($settings['singleapp_enabled_banner']==1){       
            if($banner = $this->SingleAppClass_pos->getBannerLink($this->merchant_id)){
                $settings['singleapp_banner']=$banner;      
                
                $homebanner_interval = $this->functions->getOption('singleapp_homebanner_interval',$this->merchant_id);
                $homebanner_auto_scroll = $this->functions->getOption('singleapp_homebanner_auto_scroll',$this->merchant_id);
                $settings['homebanner_interval']=$homebanner_interval>0?$homebanner_interval:3000;
                $settings['homebanner_auto_scroll']=$homebanner_auto_scroll>0?$homebanner_auto_scroll:0;
                        
            } else $settings['singleapp_enabled_banner']=0;                             
        }   
        
        if(empty($settings['currency_set'])){
            $settings['currency_set']='USD';
        }
        if(empty($settings['currency_position'])){
            $settings['currency_position']='left';
        }
        if(empty($settings['currency_decimal_place'])){
            $settings['currency_position']=2;
        }
        if(empty($settings['currency_decimal_separator'])){
            $settings['currency_decimal_separator']=".";
        }
        if($settings['currency_use_separators']=="yes"){
            if($settings['currency_thousand_separator']==""){
                $settings['currency_thousand_separator']=",";
            }       
        }   
        if($settings['order_verification']==2){
            $mechant_sms_enabled = $this->functions->getOptionAdmin('mechant_sms_enabled');
            if($mechant_sms_enabled=="yes"){
                $settings['order_verification']='';
            }       
            $sms_balance=$this->functions->getMerchantSMSCredit($this->merchant_id);
             if ( $sms_balance<=0){
                $settings['order_verification']='';
             }      
        }               
        
        $reg_email = $this->functions->getOption('singleapp_reg_email',$this->merchant_id); 
        $reg_mobile = $this->functions->getOption('singleapp_reg_phone',$this->merchant_id);
        
        if(empty($reg_email) && empty($reg_mobile)){
            $reg_email = 1;
            $reg_mobile = 1;
        }
        
        $settings['registration']=array(
          'email'=>$reg_email,
          'mobile'=>$reg_mobile,
          'custom_field1'=>$this->functions->getOptionAdmin('client_custom_field_name1'),
          'custom_field2'=>$this->functions->getOptionAdmin('client_custom_field_name2'),
        );
        
        $valid_token = false;
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($this->SingleAppClass_pos->getCustomerByToken($token)){
            $valid_token = true;
        }
                
        $settings['valid_token'] = $valid_token;            
        $settings['remove_phone_prefix'] = $this->functions->getOption('singleapp_remove_phone_prefix',$this->merchant_id);
        
        $location_rep = $this->SingleAppClass_pos->searchMode();
        $settings['search_mode']=$location_rep['search_mode'];
        $settings['location_mode'] = $location_rep['location_mode'];
        
        
        $singleapp_startup = $this->functions->getOption('singleapp_startup',$this->merchant_id);       
        $singleapp_startup_auto_scroll = $this->functions->getOption('singleapp_startup_auto_scroll',$this->merchant_id);
        $singleapp_startup_interval = $this->functions->getOption('singleapp_startup_interval',$this->merchant_id);
        
        $settings['home']=array(
          'startup_language'=>$this->functions->getOption('singleapp_enabled_select_language',$this->merchant_id),
          'startup_banner'=>!empty($singleapp_startup)?$singleapp_startup:1,
          'startup_banner_auto'=>$singleapp_startup_auto_scroll==1?true:false,
          'startup_banner_interval'=>$singleapp_startup_interval>0?$singleapp_startup_interval:3000,      
        );                      
        $settings['startup_banner_images'] = (array)$this->SingleAppClass_pos->getStartUpBanner($this->merchant_id);
                
        $settings['custom_pages'] = $this->SingleAppClass_pos->getTitlePages($this->merchant_id);
        
        $singleapp_rtl = $this->functions->getOption('singleapp_rtl',$this->merchant_id);
        $settings['is_rtl'] = $singleapp_rtl>0?$singleapp_rtl:0;
        
        $custom_pages_position = $this->functions->getOption('singleapp_custom_pages_position',$this->merchant_id);
        $settings['custom_pages_position'] = $custom_pages_position>0?$custom_pages_position:1;
        
        $cart_theme = $this->functions->getOption('singleapp_cart_theme',$this->merchant_id);       
        $settings['cart_settings']=array(
          'theme'=>$cart_theme>0?$cart_theme:1,
          'auto_address'=>$this->functions->getOption('singleapp_cart_auto_address',$this->merchant_id),
          'floating_category'=>$this->functions->getOption('singleapp_floating_category',$this->merchant_id)
        );
                            
        $settings['banner'] = array(
          'banner1'=>$this->SingleAppClass_pos->getImage('resto_banner.jpg','resto_banner.jpg')
        );
        
        $settings['tracking_interval_timeout'] = $this->functions->getOption('singleapp_tracking_interval',$this->merchant_id);
        
        if ($merchant_res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            $info_address = $this->functions->clearString($merchant_res['complete_address']);
            $info_merchant_name = $this->functions->clearString($merchant_res['restaurant_name']);
            $settings['merchant_details'] = array(
              'lat'=>trim($merchant_res['latitude']),
              'lng'=>trim($merchant_res['lontitude']),
              'info_window'=>"<h5>$info_merchant_name</h5><p>$info_address</p>",
            );
        }
        
        $menu_type = $this->functions->getOption('singleapp_menu_type',$this->merchant_id);
        $settings['menu_type'] = $menu_type>0?$menu_type:1;
                
        $settings['disabled_default_image'] = $this->functions->getOption('singleapp_disabled_default_menu',$this->merchant_id);
                    
        $dict = "";
        $settings['dict'] = $dict;
        
        $settings['booking_tabs'] = $this->SingleAppClass_pos->BookingTabs();
        $settings['order_tabs'] = $this->SingleAppClass_pos->OrderTabs();
        $settings['contact_us']= $this->SingleAppClass_pos->ContactUsData($this->merchant_id);
        $settings['contact_us_enabled']= $this->functions->getOption('singleapp_contactus_enabled',$this->merchant_id);
        
        $settings['enabled_addon_desc']= $this->functions->getOption('singleapp_enabled_addon_desc',$this->merchant_id);
        $settings['confirm_future_order']= $this->functions->getOption('singleapp_confirm_future_order',$this->merchant_id);
                
        $settings['customer_forgot_password_sms'] = $this->functions->getOptionAdmin('customer_forgot_password_sms');
        
        if ($device_info = $this->SingleAppClass_pos->getDeviceByUIID( $this->device_uiid )){
            $settings['subscribe_topic']= $device_info['subscribe_topic'];
        } else $settings['subscribe_topic'] = 1;
        
        //$settings['topics'] = CHANNEL_TOPIC_MERCHANT.$this->merchant_id;
        $settings['topics'] = "";
        
        $this->details = $settings;
        $this->output();
    }


    

    public function SendOrderSMSCode()
    {
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        $customer_number = isset($this->data['customer_number'])?$this->data['customer_number']:'';
        
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        $contact_phone = trim($res['contact_phone']);
                
        if(!empty($customer_number)){
            $contact_phone = trim($customer_number);
            $this->functions->updateData("mt_client",array(
              'contact_phone'=>$customer_number
            ),'client_id',$client_id);
        }   
                
        if(empty($contact_phone)){
            $this->msg = ("We cannot send sms code to your phone number cause its empty. please fixed by putting mobile number into your profile");
            $this->output();
        }   
        
        $sms_balance=$this->functions->getMerchantSMSCredit($this->merchant_id);    
        if ( $sms_balance>=1){
            $code=$this->functions->generateSMSOrderCode($contact_phone);
            

            $sms_msg="Your order sms code is ".$code;           
                        
            if($last = $this->SingleAppClass_pos->getLastOrderSMS($contact_phone)){             
                $date_now=date('Y-m-d g:i:s a');
                $date_created = date("Y-m-d g:i:s a",strtotime($last['date_created']));
                $date_diff=$this->functions->dateDifference($date_created,$date_now);               
                
                $order_sms_code_waiting = (integer) $this->functions->getOption('order_sms_code_waiting',$this->merchant_id);
                if($order_sms_code_waiting<=0){
                    $order_sms_code_waiting = 5;
                }           
                                        
                $continue = true;   $waiting_time = '';                                 
                if(is_array($date_diff) && count($date_diff)>=1){               
                    if($order_sms_code_waiting>$date_diff['minutes']){                              
                        $waiting_time = $date_diff['minutes'];
                        $continue=false;
                    }   
                    if($continue==false){
                        if($date_diff['days']>0){
                            $continue=true;
                        }                   
                        if($date_diff['hours']>0){
                            $continue=true;
                        }                   
                    }               
                }                       
                
                if(!$continue){
                    $waiting_time = (integer)$order_sms_code_waiting - (integer)$waiting_time;
                    
                    $this->msg ="Your requesting too soon please wait after ".$waiting_time." minutes";
                    $this->output();
                }                                           
            }
            
            if ( $resp=$this->functions->sendSMS($contact_phone,$sms_msg)){ 
                             
                $resp['msg']="process";
                $resp['raw']=mktime();
                
                 if ($resp['msg']=="process"){                   
                    
                    $sms_order_session = $this->functions->generateCode(50);
                    
                    $this->code=1;
                   

                    $this->msg= "Your order sms code has been sent to ".$contact_phone;
                    
                    $this->details = array(
                      'sms_order_session'=>$sms_order_session
                    );                                      
                    
                    $contact_phone = str_replace("+","",$contact_phone);
                    $params=array(
                      'mobile'=>trim($contact_phone),
                      'code'=>$code,
                      'session'=>$sms_order_session,
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );                  
                    $this->functions->insertData("mt_order_sms",$params);
                    
                    $params=array(
                      'merchant_id'=>$this->merchant_id,
                      'broadcast_id'=>"999999999",                        
                      'contact_phone'=>$contact_phone,
                      'sms_message'=>$sms_msg,
                      'status'=>$resp['msg'],
                      'gateway_response'=>$resp['raw'],
                      'date_created'=>$this->functions->dateNow(),
                      'date_executed'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'gateway'=>$resp['sms_provider']
                    );                        
                    $this->functions->insertData("mt_sms_broadcast_details",$params);   
                    
                 } else $this->msg=("Sorry but we cannot send sms code this time")." ".$resp['msg'];
            } else $this->msg=("Sorry but we cannot send sms code this time. please try again later");
        } else $this->msg=("Sorry but this merchant does not have enought sms credit to send sms");     
        $this->output();
    }


    public function verifyOrderSMSCODE()
    {
        $order_sms_session = isset($this->data['order_sms_session'])?$this->data['order_sms_session']:'';   
        $sms_code = isset($this->data['sms_code'])?$this->data['sms_code']:'';  
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token,false)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        $contact_phone = $res['contact_phone'];
        
        if(!empty($order_sms_session)){
            if ($res = $this->functions->validateOrderSMSCode($contact_phone,$sms_code,$order_sms_session)){
                $this->code = 1;
                $this->msg = "OK";
                $this->details='';
            } else  $this->msg = ("Invalid sms code");
        } else $this->msg = ("sms session is empty");
        
        $this->output();
    }


    public function applyTips()
    {
        if (!is_numeric($this->merchant_id)){
            $this->msg = ("Invalid merchant id");
            $this->output();
        }
        
        $tips = isset($this->data['tips'])?$this->data['tips']:0;
        if ($tips>0){
            
            $data = array(
              'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            if ( $cart = $this->SingleAppClass_pos->getCartContent($this->device_uiid,$data)){          
                $params = array(
                  'tips'=>$tips,
                  'date_modified'=>$this->functions->dateNow()
                );
                
                $this->functions->updateData("mt_pos_cart",$params,'device_id',$this->device_uiid);
                $this->code = 1;
                $this->msg = "OK";
            } else $this->msg = ("cart not available");
                        
        } else $this->msg = ("Invalid tip");
        $this->output();
    }
    
    public function removeTip()
    {
        $this->SingleAppClass_pos->removeTip($this->device_uiid);
        $this->code = 1;
        $this->msg="OK";
        $this->details='';      
        $this->output();
    }



public function getOrderHistory()
    {
        if ($client_id = $this->checkToken()){          
            $order_id = isset($this->data['id'])?$this->data['id']:0;
            $page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';        
            if($order_id>0){
                if ($res = $this->SingleAppClass_pos->orderHistory($order_id)){
                    $data =array();
                    
                    
                    foreach ($res as $val) {
                  
                      $remarks = ($this->functions->clearString($val['remarks']));
                      if(!empty($val['remarks2'])){
                          $args=json_decode($val['remarks_args'],true);  
                          if(is_array($args) && count( (array) $args)>=1){
                             foreach ($args as $args_key=>$args_val) {
                                $args[$args_key]=($args_val);
                             }                       
                             $new_remarks=$val['remarks2'];
                            
                             $remarks="".$new_remarks;      
                          }
                      }
                      
                      $data[]=array(
                        'date'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
                        'status_raw'=>$val['status'],
                        'status'=>($val['status']),
                        'remarks'=>$remarks
                      );
                   }
                   
                   $order_info = $this->SingleAppClass_pos->orderDetails($order_id);               
                   $order_info['merchant_name'] = $this->functions->clearString($order_info['merchant_name']);
                   $order_info['logo'] = $order_info['logo']=$this->SingleAppClass_pos->getImage($order_info['logo']);
                        

                   $order_info['transaction'] = $order_info['trans_type']."#".$order_info['order_id'];  

                   $order_info['payment_type'] = ($this->functions->prettyPaymentTypeTrans($order_info['trans_type'],$order_info['payment_type']));
                   
                   $this->code = 1;
                   $this->msg="OK";
                   $this->details = array(
                     'order_id'=>$order_id,
                     'show_track'=>$this->SingleAppClass_pos->showTrackOrder($order_id),
                     'page_action'=>$page_action,
                     'order_info'=>$order_info,
                     'data'=>$data,             
                   );               
                } else {
                    $this->code = 6;        
                    $this->msg = ("No results");                            
                    $this->details = array(
                      'title'=>("No results"),
                      'sub_title'=>("Order history is empty")
                    );  
                }       
            } else {                
                $this->code = 6;        
                $this->msg = ("invalid order id");                          
                $this->details = array(
                  'title'=>("Invalid order id"),
                  'sub_title'=>("Order history is empty")
                );  
            }
        }
        $this->output();
    }

        public function ReGetOrderHistory()
    {
        if ($client_id = $this->checkToken()){      
            $order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
            if($order_id>0){
                if ($res = $this->SingleAppClass_pos->orderHistory($order_id)){
                    $data =array();
                        
                    foreach ($res as $val) {                  
                      $remarks =($this->functions->clearString($val['remarks']));
                      if(!empty($val['remarks2'])){
                          $args=json_decode($val['remarks_args'],true);  
                          if(is_array($args) && count( (array) $args)>=1){
                             foreach ($args as $args_key=>$args_val) {
                                $args[$args_key]=($args_val);
                             }                       
                             $new_remarks=$val['remarks2'];
                             $remarks=$new_remarks; 
                          }
                      }
                      
                      $data[]=array(
                        'date'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
                        'status_raw'=>$val['status'],
                        'status'=>($val['status']),
                        'remarks'=>$remarks
                      );
                   }
                   $this->code=1;
                   $this->details = array(                   
                     'show_track'=>$this->SingleAppClass_pos->showTrackOrder($order_id),                     
                     'data_count'=>count($data),
                     'data'=>$data,             
                   );       
                } else $this->msg = ("No results");
            } else {
                $this->code = 6;
                $this->msg =("invalid order id");
            }       
        }
        $this->output();
    }


    public function getMobileCodeList()
    {
        $mobile_countrycode = $this->functions->MobileCountryCode();
        $data = array();
        
        foreach ($mobile_countrycode as $key=>$val) {                       
            $val['name']=ucwords(strtolower($val['name']));
            $val['country_code']=$key;
            $data[]=$val;           
        }
                
        $this->code=1;
        $this->msg="OK";
        $this->details = array(               
          'data'=>$data
        );
        $this->output();
    }

    public function loadNotification()
{
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $this->paginate_limit;
    } else {
        $page = 0;
    }

    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $client_id = '';

    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        // Do nothing
    } else {
        $client_id = $res['client_id'];
    }

    $where = "WHERE is_read='0'";
    $and = '';

    if ($client_id > 0) {
        $and = " AND client_id = $client_id ";
    } else {
        $and = " AND device_id = {$this->device_id} ";
    }

    $stmt = "
        SELECT 
            push_title,
            push_message,
            date_created
        FROM mt_singleapp_mobile_push_logs
        $where
        $and
        ORDER BY id DESC
        LIMIT $page, $this->paginate_limit
    ";

    try {
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $stmt_exec = $this->db->query($stmt);
        if ($res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC)) {
            $data = array();
            foreach ($res as $val) {
                $date_created = $this->functions->prettyDate($val['date_created']);
                $date_created = $this->functions->translateDate($date_created);
                $data[] = array(
                    'push_title'   => $this->functions->clearString($val['push_title']),
                    'push_message' => $this->functions->clearString($val['push_message']),
                    'date_created' => $date_created
                );
            }
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'data' => $data
            );
        } else {
            $this->msg = "No results";
        }
    } catch (Exception $e) {
        $this->msg = $e->getMessage();
    }

    $this->output();
}

public function requestForgotPass()
    {       
        $user_email = isset($this->data['user_email'])?$this->data['user_email']:'';
        if(empty($user_email)){
            $user_email = isset($this->data['user_mobile'])?$this->data['user_mobile']:'';
        }   
        if(!empty($user_email)){
            if ( $res=$this->functions->isClientExist_with_merchant($user_email,$this->merchant_id) ){
                $token=md5(date('c'));
                $params=array('lost_password_token'=>$token);       
                
                if ($this->functions->updateData("mt_client",$params,'client_id',$res['client_id'])){
                    
                    $this->code=1;                      
                    $this->msg= ("We sent your forgot password link, Please follow that link. Thank You.");
                    
                    $to=$res['email_address'];
                    
                    //send email                                            
                    $enabled=$this->functions->getOptionAdmin('customer_forgot_password_email');
                    if($enabled){
                        $lang="en"; 
                        $subject=$this->functions->getOptionAdmin("customer_forgot_password_tpl_subject_$lang");
                        if(!empty($subject)){
                            $subject=$this->functions->smarty('firstname',
                            isset($res['first_name'])?$res['first_name']:'',$subject);
                            
                            $subject=$this->functions->smarty('lastname',
                            isset($res['last_name'])?$res['last_name']:'',$subject);
                        }
                                                    
                        $tpl=$this->functions->getOptionAdmin("customer_forgot_password_tpl_content_$lang") ;
                        if (!empty($tpl)){                              
                            $tpl=$this->functions->smarty('firstname',
                            isset($res['first_name'])?$res['first_name']:'',$tpl);
                            
                            $tpl=$this->functions->smarty('lastname',
                            isset($res['last_name'])?$res['last_name']:'',$tpl);
                            
                            

                            
                            $tpl=$this->functions->smarty('change_pass_link',Config::$baseUrl."/store/forgotpassword/token/".$token
                            ,$tpl);

                            
                            $tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
                            $tpl=$this->functions->smarty('siteurl',websiteUrl(),$tpl);
                        }
                        if (!empty($subject) && !empty($tpl)){
                            sendEmail($to,'',$subject, $tpl );
                        }                       
                    }       

                    
                } else $this->msg = ("Cannot update records, please try again later");
            } else $this->msg = ("Sorry but we cannot find your information");
        } else $this->msg = ("Invalid username or email address");
        $this->output();
    }

    public function mapboxgeocode()
    {
        $this->geoCode();
    }
    
    public function geoCode()
    {
        $lat = isset($this->data['lat'])?$this->data['lat']:'';
        $lng = isset($this->data['lng'])?$this->data['lng']:'';
        
        if(!empty($lat) && !empty($lng)){
            try {            
            
              $res = $this->functions->latToAdress($lat,$lng);              
              
              
              $this->code = 1;
              $this->msg  = "OK";   
              $this->details = $res;
            } catch (Exception $e) {
              $this->msg =  ($e->getMessage());
            }           
        } else $this->msg = ("Lat and long is required");
        $this->output();
    }


    public function updateDeviceID()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }

    $client_id = $res['client_id'];
    $old_device_id = isset($this->data['old_device_id']) ? $this->data['old_device_id'] : '';
    $device_id = isset($this->data['device_id']) ? $this->data['device_id'] : '';

    if (!empty($device_id)) {
        $this->code = 1;
        $this->msg = 'Token updated';
        $params = array(
            'device_id' => trim($device_id),
            'device_platform' => isset($this->data['device_platform']) ? strtolower($this->data['device_platform']) : 'android',
            'date_modified' => $this->functions->dateNow(),
            'single_app_merchant_id' => $this->merchant_id,
        );

        $this->functions->updateData("mt_client", $params, 'client_id', $client_id);

        /* CHECK IF OLD DEVICE IS THE SAME AS NEW */
        if (!empty($old_device_id)) {
            if ($old_device_id != $device_id) {
                $stmt = "
                    UPDATE mt_pos_cart
                    SET 
                        device_id = '$device_id',
                        device_platform = '{$params['device_platform']}',
                        date_modified = '{$params['date_modified']}'
                    WHERE device_id = '$old_device_id'
                ";
                try {
                    $this->db->query($stmt);
                } catch (Exception $e) {
                    // Optional: log or handle errors if needed
                }
            }
        }
    } else {
        $this->msg = ("device id is empty");
    }

    $this->output();
}

public function applyRedeemPoints()
{
    $points = isset($this->data['points']) ? $this->data['points'] : 0;

    if ($points <= 0.0001) {
        $this->msg = ("Invalid redeem points");
        $this->output();
    }

    $client_id = isset($this->data['client_id']) ? $this->data['client_id'] : 0;
    $client_info = $this->functions->getClientInfo($client_id);

    if ((!$client_info) && $client_id > 0) {
        $this->msg = ("Invalid client detail, please relogin again");
        $this->output();
    }

    $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
    if ($pts_disabled_redeem == 1) {
        $this->msg = ("Redeeming points is disabled");
        $this->output();
    }

    $available_points = $this->PointsProgram->getTotalEarnPoints($client_id, $this->merchant_id);
    if ($available_points <= 0 || $points > $available_points) {
        $this->msg = ("Sorry but your points is not enough");
        $this->output();
    }

    $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;
    $phone_order = isset($_REQUEST['phone_order']) ? $_REQUEST['phone_order'] : 0;
    if ($phone_order > 0) {
        $cart_id = isset($_REQUEST['cart_id']) ? $_REQUEST['cart_id'] : 0;
        if (!(isset($cart_id) && !empty($cart_id) && $cart_id > 0)) {
            $this->msg = ("Cart ID is missing");
            $this->output();
        }
    }

    $data = array(
        'table_number' => $table_number,
        'delivery_type' => isset($this->data['transaction_type']) ? $this->data['transaction_type'] : '',
        'merchant_id' => $this->merchant_id,
        'card_fee' => 0,
        'phone_order' => $phone_order,
        'cart_id' => isset($cart_id) ? $cart_id : 0,
    );

    if ($cart = $this->SingleAppClass_pos->getCartContent_pos($this->device_uiid, $data)) {
        $is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();

        $pts_enabled_offers_discount = $this->functions->getOptionAdmin('pts_enabled_offers_discount');
        if (!$is_disabled_merchant_settings) {
            $mt_pts_enabled_offers_discount = $this->functions->getOption('mt_pts_enabled_offers_discount', $this->merchant_id);
            if ($mt_pts_enabled_offers_discount > 0) {
                $pts_enabled_offers_discount = $mt_pts_enabled_offers_discount;
            }
        }
        if ($pts_enabled_offers_discount != 1) {
            $discounted_amount = isset($cart['total']['discounted_amount']) ? $cart['total']['discounted_amount'] : 0;
            if ($discounted_amount > 0.0001) {
                $this->msg = ("Sorry you cannot apply voucher, exising discount is alread applied in your cart");
                $this->output();
            }
        }

        $pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');
        if (!$is_disabled_merchant_settings) {
            $mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher', $this->merchant_id);
            if ($mt_pts_enabled_add_voucher > 0) {
                $pts_enabled_add_voucher = $mt_pts_enabled_add_voucher;
            }
        }
        if ($pts_enabled_add_voucher != 1) {
            $less_voucher = $cart['total']['less_voucher'];
            if ($less_voucher > 0.0001) {
                $this->msg = ("Sorry but you cannot redeem points if you have already voucher applied on your cart");
                $this->output();
            }
        }

        $redeeming_point = $this->functions->getOptionAdmin('pts_redeeming_point');
        $redeeming_point_value = $this->functions->getOptionAdmin('pts_redeeming_point_value');

        if (!$is_disabled_merchant_settings) {
            $mt_pts_redeeming_point = $this->functions->getOption('mt_pts_redeeming_point', $this->merchant_id);
            $mt_pts_redeeming_point_value = $this->functions->getOption('mt_pts_redeeming_point_value', $this->merchant_id);

            if ($mt_pts_redeeming_point > 0) {
                $redeeming_point = $mt_pts_redeeming_point;
            }
            if ($mt_pts_redeeming_point_value > 0) {
                $redeeming_point_value = $mt_pts_redeeming_point_value;
            }
        }

        $subtotal = isset($cart['total']['subtotal']) ? $cart['total']['subtotal'] : 0;

        $points_apply_order_amt = $this->functions->getOptionAdmin('points_apply_order_amt');
        if (!$is_disabled_merchant_settings) {
            $mt_points_apply_order_amt = $this->functions->getOption('mt_points_apply_order_amt', $this->merchant_id);
            if ($mt_points_apply_order_amt > 0) {
                $points_apply_order_amt = $mt_points_apply_order_amt;
            }
        }
        if ($points_apply_order_amt > 0.0001 && $points_apply_order_amt > $subtotal) {
            $this->msg = "Sorry but you can only redeem points on orders over " . $this->functions->prettyPrice($points_apply_order_amt);
            $this->output();
        }

        $points_minimum = $this->functions->getOptionAdmin('points_minimum');
        if (!$is_disabled_merchant_settings) {
            $mt_points_minimum = $this->functions->getOption('mt_points_minimum', $this->merchant_id);
            if ($mt_points_minimum > 0) {
                $points_minimum = $mt_points_minimum;
            }
        }
        if ($points_minimum > 0.0001 && $points_minimum > $points) {
            $this->msg = "Sorry but Minimum redeem points can be used is " . $points_minimum;
            $this->output();
        }

        $points_max = $this->functions->getOptionAdmin('points_max');
        if (!$is_disabled_merchant_settings) {
            $mt_points_max = $this->functions->getOption('mt_points_max', $this->merchant_id);
            if ($mt_points_max > 0.0001) {
                $points_max = $mt_points_max;
            }
        }
        if ($points_max > 0.0001 && $points_max < $points) {
            $this->msg = "Sorry but Maximum redeem points can be used is " . $points_max;
            $this->output();
        }

        $temp_redeem = intval($this->data['points'] / $redeeming_point);
        $points_amount = $temp_redeem * $redeeming_point_value;

        $new_balance = $subtotal - $points_amount;
        if ($new_balance <= 0) {
            $this->msg = ("Sorry you cannot redeem points which the Sub Total will become negative when after applying the points");
            $this->output();
        }

        $params = array(
            'points_apply' => $this->data['points'],
            'points_amount' => $points_amount
        );

        if ($table_number > 0) {
            $this->functions->updateData("mt_pos_cart", $params, 'table_number', $table_number);
        } else if ($cart_id > 0) {
            $this->functions->updateData("mt_pos_cart", $params, 'cart_id', $cart_id);
        } else {
            // direct SQL using $this->db
            $stmt = "
                UPDATE mt_pos_cart
                SET points_apply = {$params['points_apply']},
                    points_amount = {$params['points_amount']}
                WHERE device_id = '{$this->device_uiid}'
                AND is_phone_order = 0
                AND table_number = 0
            ";
            $this->db->query($stmt);
        }

        $this->code = 1;
        $this->msg = "Succesful";
        $this->details = array(
            'points_apply' => $this->data['points'],
            'points_amount' => $points_amount,
            'pretty_points_amount' => $this->functions->prettyPrice($points_amount)
        );
    } else {
        $this->msg = ("Cart is empty");
    }
    $this->output();
}


public function removePoints()
{
    $table_number = isset($_REQUEST['table_number']) ? $_REQUEST['table_number'] : 0;       
    $phone_order = isset($_REQUEST['phone_order']) ? $_REQUEST['phone_order'] : 0;

    if ($phone_order > 0) {                 
        $cart_id = isset($_REQUEST['cart_id']) ? $_REQUEST['cart_id'] : 0;  
        if (!(isset($cart_id) && !empty($cart_id) && $cart_id > 0)) {
            $this->msg = ("Cart ID is missing");
            $this->output();
        }
    }

    $params = array(
        'date_modified' => $this->functions->dateNow(),
        'points_apply'  => 0,
        'points_amount' => 0
    );

    if ($table_number > 0) {
        $this->functions->updateData("mt_pos_cart", $params, 'table_number', $table_number);    

    } else if (isset($cart_id) && $cart_id > 0) {
        $this->functions->updateData("mt_pos_cart", $params, 'cart_id', $cart_id);  

    } else {
        $date_modified = $this->functions->dateNow();
        $points_apply = 0;
        $points_amount = 0;
        $device_id = $this->device_uiid;

        $stmt = "
            UPDATE mt_pos_cart
            SET 
                date_modified = '{$date_modified}',
                points_apply = {$points_apply},
                points_amount = {$points_amount}
            WHERE device_id = '{$device_id}'
            AND is_phone_order = 0
            AND table_number = 0
        ";
        $this->db->query($stmt);
    }

    $this->code = 1;
    $this->msg = "OK";
    $this->details = '';
    $this->output();
}


public function pointsSummary()
    {       
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$client_info = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->msg = ("Invalid token, please relogin again");
            $this->output();
        }       
        
        $client_id = $client_info['client_id'];
        
        $total_available_pts = $this->PointsProgram->getTotalEarnPoints($client_id);        
        $total_expiring_pts = $this->PointsProgram->getExpiringPoints($client_id);
        $total_expenses = $this->SingleAppClass_pos->pointsTotalExpenses($client_id);
        $total_earn_by_merchant = $this->SingleAppClass_pos->pointsEarnByMerchant($client_id);
        
        $data = array();
        
        $data[]=array(
          'label'=>("Income Points"),
          'value'=>$total_available_pts>0?$total_available_pts:0,
          'point_type'=>'income_points'
        );
        
        $data[]=array(
          'label'=>("Expenses Points"),
          'value'=>$total_expenses>0?$total_expenses:0,
          'point_type'=>'expenses_points'
        );
        
        $data[]=array(
          'label'=>("Expired Points"),
          'value'=>$total_expiring_pts>0?$total_expiring_pts:0,
          'point_type'=>'expired_points'
        );
        
        $data[]=array(
          'label'=>("Points By Merchant"),
          'value'=>$total_earn_by_merchant,
          'point_type'=>'points_merchant'
        );
        
        $this->code = 1;
        $this->msg="OK";
        $this->details=array(
          'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
          'data'=>$data
        );
        
        $this->output();
    }

public function pointsGetEarn()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }       

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_earn
        WHERE
        status='active'
        AND
        client_id = $client_id
        ORDER BY id DESC
        LIMIT 0,1000
    ";

    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition('earn', $val['trans_type'], $val['order_id']);
            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points_earn']
            );
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}

public function pointsExpenses()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_expenses
        WHERE
        status='active'
        AND
        client_id = $client_id
        ORDER BY id DESC
        LIMIT 0,1000
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points']
            );
            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points']
            );
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}

public function pointsExpired()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_earn
        WHERE
        status = 'expired'
        AND
        client_id = $client_id
        ORDER BY id DESC
        LIMIT 0,1000
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points_earn']
            );

            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points_earn']
            );
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}

public function pointsEarnByMerchant()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT 
            a.merchant_id,
            b.restaurant_name,
            b.restaurant_slug
        FROM mt_points_earn a       
        LEFT JOIN mt_merchant b
            ON a.merchant_id = b.merchant_id        
        WHERE a.merchant_id <> 0
            AND a.client_id = $client_id
        GROUP BY a.merchant_id      
        ORDER BY b.restaurant_name ASC
    ";
  $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {
            $points = $this->SingleAppClass_pos->getTotalEarnPoints($client_id, $val['merchant_id']);
            $data[] = array(
                'date' => $val['restaurant_name'],
                'label' => ("Merchant Name"),
                'points' => $points > 0 ? $points : 0
            );
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}

public function getCountryList()
    {       
        $country_list = $this->functions->CountryList();
        $this->code = 1;
        $this->msg="OK";
        $this->details  = array(
          'counry_code'=>$this->functions->getOptionAdmin('admin_country_set'),
          'list'=>$country_list,
        );
        $this->output();
    }

    public function clearCart()
    {   $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;            
    
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
            
                   // $this->SingleAppClass_pos->clearCart_phoneorder($this->device_uiid,$cart_id);
                         $this->SingleAppClass_pos->clearCart_phoneorder_was($cart_id);
                    
                }else{
    
    
        $this->SingleAppClass_pos->clearCart($this->device_uiid,$table_number);

                }       
        $this->code = 1;
        $this->msg = "Cart Clear";
        $this->output();
    }


      public function removeCart_phoneorder()
    {            
    
        
               
                    
        $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
            if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
            
        $this->SingleAppClass_pos->clearCart_phoneorder_was($cart_id);
                    
                   
        $this->code = 1;
        $this->msg = "Cart Clear";
        $this->output();
    }




    public function setDeliveryLocation()
    {
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $id = $resp['cart_id'];
            $params = array(
              'delivery_lat'=>trim($this->data['selected_lat']),
              'delivery_long'=>trim($this->data['selected_lng']),
            );
            
            $this->functions->updateData("mt_pos_cart",$params,'cart_id',$id);
            $this->code = 1;
            $this->msg = "OK";
            $this->details=array();
        } else $this->msg = ("Cart is empty");
        $this->output();
    }
    
    public function searchByCategory()
{               
    $this->db->query("SET SQL_BIG_SELECTS=1");

    $search_str = isset($this->data['category_name']) ? trim($this->data['category_name']) : '';        
    $merchant_id = $this->merchant_id;

    if ($merchant_id > 0) {
        $stmt = "
            SELECT merchant_id, cat_id, category_name, photo, category_name_trans
            FROM mt_category
            WHERE category_name LIKE '%$search_str%'
            AND merchant_id = $merchant_id
            LIMIT 0,10
        ";
         $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
            $data = array();
            foreach ($res as $val) {
                $category_id = $val['cat_id'];

                $stmt2 = "
                    SELECT count(*) as total
                    FROM mt_item
                    WHERE merchant_id = $merchant_id
                    AND category LIKE '%\"$category_id\"%'
                    AND status IN ('publish','published')
                ";

                $total_found = 0;
                if ($resp = $this->db->query($stmt2)->fetch(PDO::FETCH_ASSOC)) {
                    $total_found = $resp['total'];
                }

                $json = json_decode($val['category_name_trans'], true);

                $category_name_trans = $this->functions->qTranslate(
                    $val['category_name'],
                    'category_name',
                    array('category_name_trans' => $json)
                );

                $category_name_orig = $category_name_trans;

                $category_name = $this->SingleAppClass_pos->highlight_word($category_name_trans, $search_str);

                $val['category_name'] = $category_name;
                $val['category_name_orig'] = $category_name_orig;
                $val['photo_url'] = $this->SingleAppClass_pos->getImage($val['photo']);
                $val['item_found'] = $total_found . " item";

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'list' => $data
            );
        } else {
            $this->msg = "no results";
        }
    } else {
        $this->msg = "invalid merchant id";
    }
    $this->output();
}


public function searchByItem()
{   
    $search_str = isset($this->data['item_name']) ? trim($this->data['item_name']) : '';        
    $merchant_id = $this->merchant_id;      
    $category_id = isset($this->data['category_id']) ? $this->data['category_id'] : '';

    if (!empty($search_str) && !empty($merchant_id)) {
        if ($merchant_id > 0) {
            $stmt = "
                SELECT
                    item_id, merchant_id, item_name, item_description, photo,
                    item_name_trans, item_description_trans,
                    price, discount
                FROM mt_item
                WHERE
                    merchant_id = $merchant_id
                    AND item_name LIKE '%$search_str%'
                    AND category LIKE '%\"$category_id\"%'
                LIMIT 0,10
            ";
            $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
                $data = array();
                foreach ($res as $val) {

                    $json = json_decode($val['item_name_trans'], true);
                    $item_name_trans = $this->functions->qTranslate($val['item_name'], 'item_name', array(
                        'item_name_trans' => $json
                    ));                                             
                    $item_name = $this->SingleAppClass_pos->highlight_word($item_name_trans, $search_str);

                    $json = json_decode($val['item_description_trans'], true);
                    $item_description = $this->functions->qTranslate($val['item_description'], 'item_description', array(
                        'item_description_trans' => $json
                    ));

                    $val['prices'] = $this->SingleAppClass_pos->getPrices($val['price'], $val['discount']);
                    $val['photo_url'] = $this->SingleAppClass_pos->getImage($val['photo']);                 
                    $val['item_name'] = $item_name;
                    $val['item_description'] = $item_description;
                    $val['category_id'] = $category_id;

                    $data[] = $val;
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                    'list' => $data
                );
            } else {
                $this->msg = "no results";
            }
        } else {
            $this->msg = "invalid merchant id";
        }
    } else {
        $this->msg = "no results";
    }

    $this->output();
}


public function CancelOrder()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';       
        if($res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $client_id = $res['client_id'];
            $order_id = isset($this->data['order_id'])?$this->data['order_id']:'';
            if($order_id>0){
                if ($res = $this->functions->getOrderInfo($order_id)){
                    if($res['client_id']== $client_id){
                        $params = array(
                          'request_cancel'=>1,
                          'date_modified'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR']
                        );
                        
                        if ( $this->functions->updateData("mt_order",$params,'order_id',$order_id)){ 
                            $this->functions->notifyCancelOrder($res);
                            $this->code = 1;
                            $this->msg = ("Your request has been sent to merchant");
                            $this->details;
                            
                            /*logs*/
                            $params_logs=array(
                              'order_id'=>$order_id,
                              'status'=>"cancel order request",
                              'date_created'=>$this->functions->dateNow(),
                              'ip_address'=>$_SERVER['REMOTE_ADDR']
                            );
                            $this->functions->insertData("mt_order_history",$params_logs);
                            
                        } else $this->msg = ("ERROR: cannot update records.");
                    }else $this->msg = ("Sorry but this order does not belong to you");
                } else $this->msg = ("Order id not found");
            } else $this->msg = ("invalid order id");
        } else {
            $this->code = 3;
            $this->msg = ("token not found");
        }
        $this->output();
    }


    public function LoginGoogle()
    {
                
        
        $this->Validator->required(array(
          'email'=>("email address is required"),
          'userid'=>("google user id is required")
        ),$this->data);
        
        /*check if email address is blocked*/
        if ( $this->functions->emailBlockedCheck($this->data['email'])){
            
            $this->Validator->setmsg("Sorry but your email address is blocked by website admin");           
        }    
        
        foreach ($this->data as $key => $val) {
            if($val=="null" || $val==null ){
                $this->data[$key]='';
            } else $this->data[$key]=$val;
        }
                
        if($this->Validator->validate()){
                        
            $params=array(
              'first_name'=>($this->data['fullname']),
              'last_name'=>($this->data['lastname']),
              'email_address'=>($this->data['email']),
              'password'=>md5($this->data['userid']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>isset($this->data['device_id'])?$this->data['device_id']:'',
              'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
              'social_strategy'=>'google_mobile',
              'single_app_merchant_id'=>$this->merchant_id,
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid
            );
            
            if( $res = $this->functions->isClientExist_with_merchant($params['email_address'],$this->merchant_id) ){
                $token = $res['token'];
                if(empty($token)){
                    $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['userid']);
                    $params['token'] = $token;
                }           
                
                unset($params['date_created']);
                $params['last_login']=$this->functions->dateNow();
                
                $this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);            
                
                $this->code=1;
                $this->msg = ("Registration successful");
                
                $this->details = array(
                  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                  'token'=>$token
                );
            } else {
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['email_address']);
                $params['token']=$token;
                if ( $customer_id =$this->functions->insertData("mt_client",$params)){
                                
                    $this->code=1;
                    $this->msg = ("Registration successful");
                    
                    $this->details = array(
                      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
                      'token'=>$token
                    );
                    
                    /*POINTS PROGRAM*/                  
                    
                    $this->PointsProgram->signupReward($customer_id);
                    
                    
                } else $this->msg = ("Something went wrong during processing your request. Please try again later");
            }       
        
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }


public function UploadProfile()
{       
    $profile_photo = '';
    $path_to_upload = $this->functions->uploadPath();
    
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if ($res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        $client_id = $res['client_id'];
        
        if (isset($_FILES['file'])) {
            header('Access-Control-Allow-Origin: *');

            $new_image_name = urldecode($_FILES["file"]["name"]) . ".jpg";
            $new_image_name = str_replace(array('?', ':'), '', $new_image_name);

            $upload_res = @move_uploaded_file($_FILES["file"]["tmp_name"], "$path_to_upload/" . $new_image_name);

            if ($upload_res) {
                $params = array(
                    'avatar' => $new_image_name,
                    'date_modified' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                );

                if ($this->functions->updateData("mt_client", $params, 'client_id', $client_id)) {
                    $this->code = 1;
                    $this->msg = ("Upload successful");
                    $this->details = $new_image_name;
                    $profile_photo = $this->SingleAppClass_pos->getImage($new_image_name);
                } else {
                    $this->msg = ("Cannot update records");
                }
            } else {
                $this->msg = ("Cannot upload file");
            }
        } else {
            $this->msg = ("Image is missing");
        }
    } else {
        $this->code = 3;
        $this->msg = ("token not found");
    }

    echo $this->code . "|" . $this->msg . "|" . $profile_photo;
    exit; // Replaces Yii::app()->end()
}

public function getPages()
    {       
        $data=array();
        $enabled_multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');
        $lang = $this->data['lang']?$this->data['lang']:'';         
        if ($res = $this->SingleAppClass_pos->getPages($this->merchant_id)){
            foreach ($res as $val) {                                
                if ($enabled_multiple_translation==2 && !empty($lang)){                         
                    $title = $val['title'];
                    $field_title="lang_title_$lang";                    
                    if(array_key_exists($field_title,$val)){
                        if(!empty($val[$field_title])){
                           $title=$val[$field_title]; 
                        }
                    } 
                    $data[]= array(
                      'page_id'=>$val['page_id'],
                      'merchant_id'=>$val['merchant_id'],
                      'title'=>$title,  
                      'icon'=>$val['icon'],
                    );
                } else {
                    $data[]= array(
                      'page_id'=>$val['page_id'],
                      'merchant_id'=>$val['merchant_id'],
                      'title'=>$val['title'],                     
                      'icon'=>$val['icon'],
                    );
                }           
            }
            $this->code = 1;
            $this->msg = "ok";
            $this->details = array(
              'data'=>$data
            );
        } else $this->msg = "no results";
        $this->output();
    }


    public function getPagesByID()
    {
       $data=array();
       $enabled_multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');
       $lang = $this->data['lang']?$this->data['lang']:'';          
        
       $page_id = isset($this->data['page_id'])?$this->data['page_id']:0;
       $merchant_id = $this->merchant_id;
       if($page_id>0){
          if ( $val = $this->SingleAppClass_pos->getPagesByID($page_id)){
              $content = '';
                                             
              if($val['use_html']==1){
                 $content=nl2br(strip_tags($val['content']));
              } else $content=trim($val['content']);
              
              if ($enabled_multiple_translation==2 && !empty($lang)){
                $title = $val['title'];
                $field_title="title_$lang";   
                $field_content="content_$lang"; 
                                        
                if(array_key_exists($field_title,$val)){
                    if(!empty($val[$field_title])){
                       $title=$val[$field_title]; 
                    }
                } 
                
                if(array_key_exists($field_content,$val)){
                    if(!empty($val[$field_content])){
                       $content=$val[$field_content]; 
                       
                       if($val['use_html']==1){
                          $content=nl2br(strip_tags($content));
                       } else $content=trim($content);
                    }
                } 
                
                $data = array(
                  'page_id'=>$val['page_id'],
                  'merchant_id'=>$val['merchant_id'],
                  'title'=>$title,  
                  'content'=>$content,  
                  'icon'=>$val['icon'],
                );
              } else {
                $data = array(
                  'page_id'=>$val['page_id'],
                  'merchant_id'=>$val['merchant_id'],
                  'title'=>$val['title'],                     
                  'content'=>$content,  
                  'icon'=>$val['icon'],
                );
              }           
              
              $this->code = 1;
              $this->msg = "ok";
              $this->details = array(
                  'data'=>$data
              );
            
          } else {
            $this->code = 6; 
            $this->msg = ("Page not found");
            $this->details = array(
              'title'=>("Page not found"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
          }       
       } else {
           $this->code = 6; 
           $this->msg = ("Invalid page id");
           $this->details = array(
              'title'=>("Invalid page id"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
       }
       $this->output();
    }


public function clearNotification()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $id = isset($this->data['id']) ? $this->data['id'] : '';
    $client_id = '';

    if (!$res = $this->SingleAppClass_pos->getCustomerByToken($token)) {
        // no action if not found
    } else {
        $client_id = $res['client_id'];
    }

    $and = '';
    if ($id > 0) {
        $and .= " AND id=" . intval($id) . " ";
    }

    if ($client_id > 0) {
        $stmt = "
        UPDATE mt_singleapp_mobile_push_logs
        SET is_read='1'
        WHERE
        client_id=" . intval($client_id) . "
        $and
        ";
    } else {
        $stmt = "
        UPDATE mt_singleapp_mobile_push_logs
        SET is_read='1'
        WHERE
        device_id=" . $this->db->quote($this->device_id) . "
        $and
        ";
    }

    $this->db->exec($stmt);

    $this->code = 1;
    $this->msg = "OK";
    $this->details = '';

    $this->output();
}


    public function addReview()
    {       
        
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->msg = ("Sorry but you need to login to write a review.");
            $this->output();
        }
        
        $client_id = $res['client_id'];             
        $order_id =  isset($this->data['review_order_id'])?$this->data['review_order_id']:'';       
        
        //if($order_id>0){          
            $website_review_type = $this->functions->getOptionAdmin('website_review_type');
            if ($website_review_type==2){       
                if($order_id>0){            
                    if ( $order_info=$this->functions->getOrder($order_id)){
                        $params = array(
                          'merchant_id'=>$order_info['merchant_id'],
                          'client_id'=>$client_id,
                          'review'=>$this->data['review'],
                          'rating'=>$this->data['rating'],
                          'date_created'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'order_id'=>$order_id,                  
                        );
                        
                        
                           $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
                                    
                       
                        if(!$this->functions->getReviewByOrder($client_id,$order_id)){
                            if ( $review_id=$this->functions->insertData("mt_review",$params)){
                                
                                
                                
                                    
                                        $this->PointsProgram->addReviewsPerOrder($order_id,
                                        $client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
                                                
                                    
                                
                                $this->code = 1;
                                $this->msg = ("Your review has been published.");
                                $this->details = array(
                                  'tab'=>2
                                );
                                
                            } else $this->msg = ("ERROR. cannot insert data.");
                       } else $this->msg = ("You have already have add review to this order");
                        
                    } else $this->msg = ("Order id not found");
                } else $this->msg = ("Invalid order id");
            } else {
                                
                
                
                if ( $this->functions->getOptionAdmin('website_reviews_actual_purchase')=="yes"){                   
                    if (!$this->functions->checkIfUserCanRateMerchant($client_id,$this->merchant_id)){
                        $this->msg= ("Reviews are only accepted from actual purchases!");
                        $this->output();
                    }
                    if (!$this->functions->canReviewBasedOnOrder($client_id,$this->merchant_id)){
                       $this->msg= ("Sorry but you can make one review per order");
                       $this->output();
                    }    
                }
                                
                $params = array(
                  'merchant_id'=>$this->merchant_id,
                  'client_id'=>$client_id,
                  'review'=>$this->data['review'],
                  'rating'=>$this->data['rating'],
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'order_id'=>$order_id,                  
                );          
                
                if ( $ref_orderid=$this->functions->reviewByLastOrderRef($client_id,$this->merchant_id)){
                    $params['order_id']=$ref_orderid;
                }           
                
                if ( $review_id =$this->functions->insertData("mt_review",$params)){
                    $review_id  = $this->details=$review_id  ;
                    $this->code = 1;
                    $this->msg = ("Your review has been published.");
                    $this->details = array(
                      'tab'=>1
                    );
                    
                    /*POINTS PROGRAM*/                  
                    
                     $this->PointsProgram->reviewsReward($client_id , $review_id  , $this->merchant_id );
                    
                    
                } else $this->msg = ("ERROR: cannot insert records.");
            }
        //} else $this->msg = $this->t("Invalid order id");
        $this->output();
    }


    public function getAllCategory()
    {
        if ( $resp = $this->SingleAppClass_pos->getCategory($this->merchant_id, 0 ,0, true)){

            //+++was custom code
            array_walk_recursive($resp, function (&$value) {
        if (is_null($value)) {
            $value = "";
        }
    });

              if (is_array($resp)) {
    foreach ($resp as &$row) {
        if (isset($row['dish']) && is_string($row['dish'])) {
            $temp = json_decode($row['dish'], true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($temp)) {
                $row['dish'] = '';
            }
        }
    }
}
    //---was custom code

            $this->code = 1; $this->msg = 'OK';  
            $this->details = array('data'=>$resp);
        } else $this->msg = ("This restaurant has not published their menu yet");
        $this->output();
    }
    
    private function checkToken()
    {
        return 1;
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass_pos->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            return false;
        }           
        $client_id = $res['client_id']; 
        return $client_id;
        
    }



    public function PointsDetails()
{
    $limit=''; $stmt=''; $page_title='';
    if ($client_id = $this->checkToken()){
        $point_type = isset($this->data['point_type'])?$this->data['point_type']:'';
        $page_action = isset($this->data['page_action'])?$this->data['page_action']:'';

        $pagelimit = $this->SingleAppClass_pos->paginateLimit();
        if (isset($this->data['page'])){
            $page = $this->data['page'] * $pagelimit;
        } else  $page = 0;

        $limit="LIMIT $page,$pagelimit";

        switch ($point_type) {
            case "income_points":
                $page_title = ("Income Points");
                $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                a.trans_type,
                a.order_id,
                a.date_created,
                a.total_points_earn
                FROM
                mt_points_earn a
                WHERE
                status='active'
                AND
                client_id=$client_id
                ORDER BY id DESC
                $limit
                ";
                break;

            case "expenses_points":
                $page_title = ("Expenses Points");
                $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                a.points_type,
                a.trans_type,
                a.order_id,
                a.total_points,
                a.date_created
                FROM
                mt_points_expenses a
                WHERE
                status='active'
                AND
                client_id=$client_id
                ORDER BY id DESC
                $limit
                ";
                break;

            case "expired_points":
                $page_title = ("Expired Points");
                $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                a.points_type,
                a.trans_type,
                a.order_id,
                a.date_created,
                a.total_points_earn
                FROM
                mt_points_earn a
                WHERE
                status='expired'
                AND
                client_id=$client_id
                ORDER BY id DESC
                $limit
                ";
                break;

            case "points_merchant":
                $page_title = ("Points By Merchant");
                $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                a.merchant_id,
                b.restaurant_name,
                b.restaurant_slug
                FROM mt_points_earn a
                LEFT JOIN mt_merchant b
                ON a.merchant_id=b.merchant_id
                WHERE
                a.merchant_id <> 0
                AND client_id=$client_id
                GROUP BY a.merchant_id
                ORDER BY b.restaurant_name ASC
                $limit
                ";
                break;
        }

        $data = array();
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        if($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)){
            foreach ($res as $val) {
                switch ($point_type) {
                    case "income_points":
                        $label=$this->PointsProgram->PointsDefinition('earn',$val['trans_type'],$val['order_id']);
                        $data[]=array(
                            'date'=>$this->functions->prettyDate($val['date_created'])." ".
                                    $this->functions->prettyTime($val['date_created']),
                            'label'=>$label,
                            'points'=>$val['total_points_earn']
                        );
                        break;

                    case "expenses_points":
                        $label=$this->PointsProgram->PointsDefinition(
                            $val['points_type'],
                            $val['trans_type'],
                            $val['order_id'],
                            $val['total_points']
                        );
                        $data[]=array(
                            'date'=>$this->functions->prettyDate($val['date_created'])." ".
                                    $this->functions->prettyTime($val['date_created']),
                            'label'=>$label,
                            'points'=>$val['total_points']
                        );
                        break;

                    case "expired_points":
                        $label=$this->PointsProgram->PointsDefinition(
                            $val['points_type'],
                            $val['trans_type'],
                            $val['order_id'],
                            $val['total_points_earn']
                        );
                        $data[]=array(
                            'date'=>$this->functions->prettyDate($val['date_created'])." ".
                                    $this->functions->prettyTime($val['date_created']),
                            'label'=>$label,
                            'points'=>$val['total_points_earn']
                        );
                        break;

                    case "points_merchant":
                        $points = $this->SingleAppClass_pos->getTotalEarnPoints($client_id,$val['merchant_id']);
                        $data[]=array(
                            'date'=>$this->functions->clearString($val['restaurant_name']),
                            'label'=>("Merchant Name"),
                            'points'=>$points>0?$points:0
                        );
                        break;
                }
            }

            $this->code = 1; $this->msg = "ok";
            $this->details = array(
                'page_action'=>$page_action,
                'page_title'=>$page_title,
                'data'=>$data
            );

        } else {
            if($page_action=="infinite_scroll"){
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->details = array(
                    'title'=>$page_title." is empty",
                    'sub_title'=>("Make your first order to earn points")
                );
            }
        }
    }
    $this->output();
}

public function FavoritesList()
{
    $page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
    
    if ($client_id = $this->checkToken()){
        
        $pagelimit = $this->SingleAppClass_pos->paginateLimit();        
        if (isset($this->data['page'])){
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0; 
        }

        $paginate_total = 0; 
        $limit = "LIMIT $page,$pagelimit"; 

        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.id,
        a.merchant_id,
        a.client_id,
        a.date_created,
        b.restaurant_name as merchant_name,
        b.logo
        FROM
        mt_favorites a
        LEFT JOIN mt_merchant b
        ON
        a.merchant_id = b.merchant_id
        WHERE a.client_id = $client_id
        ORDER BY a.id DESC
        $limit
        ";

        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);

        if($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)){
            
            $total_records = 0;
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            if ($resp = $this->db->query($stmtc)->fetch(PDO::FETCH_ASSOC)){                     
                $total_records = $resp['total_records'];
            }                   
            $paginate_total = ceil($total_records / $pagelimit);
            
            $data = array();
            foreach ($res as $val) {                                        
                $date_added = $this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']);
                $val['date_added'] = "Added ".$date_added;
                $val['logo'] = $this->SingleAppClass_pos->getImage($val['logo']);
                
                $ratings = $this->functions->getRatings($val['merchant_id']);
                $ratings['review_count'] = $ratings['votes']." reviews";
                $val['rating'] = $ratings;

                $val['background_url'] = $this->SingleAppClass_pos->getMerchantBackground($val['merchant_id'],'resto_banner.jpg');
                
                $data[] = $val;
            }
            
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array( 
              'page_action'=> $page_action,
              'paginate_total'=> $paginate_total,
              'data'=> $data
            );              
        } else {                
            if($page_action == "infinite_scroll"){
                $this->code = 2;
                $this->msg = ("end of records");
            } else {            
                $this->code = 6;
                $this->details = array(
                  'title'=>("Your Favorites is empty"),
                  'sub_title'=>("Add your own favorite restaurant")
                );  
            }
        }        
    }
    $this->output();
}


public function GetOrderInfo()
    {
        $data = array();
        $order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
        if($order_id>0){
           if ($res = $this->SingleAppClass_pos->orderDetails($order_id)){
              
              $res['review_as']='';
              if($clien_info =  $this->functions->getClientInfo($res['client_id'])){
                

                 $res['review_as'] = "Review as ".$clien_info['first_name'];
              }        
              $this->code = 1;
              $this->msg = "ok";
              
              $res['logo'] = $res['logo']=$this->SingleAppClass_pos->getImage($res['logo']);
              
              

              $res['transaction'] = $res['trans_type']."#".$res['order_id'];

              
              $res['payment_type'] = ($this->functions->prettyPaymentTypeTrans($res['trans_type'],$res['payment_type']));
              $res['merchant_name'] = $this->functions->clearString($res['merchant_name']);
              
              $this->details = array(
                'data'=>$res
              );
           } else $this->msg = ("order not found");     
        } else $this->msg = ("invalid order id");       
        $this->output();
    }

    public function GetOrderInfoCancel()
    {
        $this->GetOrderInfo();
    }

    public function addReviewNew()
    {       
        
        $order_id =  isset($this->data['order_id'])?$this->data['order_id']:''; 
        $rating =  isset($this->data['rating'])?$this->data['rating']:''; 
        
        if(!is_numeric($rating)){
            $this->msg = ("Please select rating");
            $this->output();
        }
        if(!is_numeric($order_id)){
            $this->msg = ("invalid order id");
            $this->output();
        }
        
        if ($client_id = $this->checkToken()){
            $website_review_type = $this->functions->getOptionAdmin('website_review_type');             
            if($order_info=$this->functions->getOrderInfo($order_id)){
                if ($website_review_type==2){                                                       
                    $order_id = $order_info['order_id'];
                    $params = array(
                      'merchant_id'=>$order_info['merchant_id'],
                      'client_id'=>$client_id,
                      'review'=>$this->data['review'],
                      'rating'=>$this->data['rating'],
                      'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'order_id'=>$order_id,  
                    );
                    
                       $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
                    
                                        
                    if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){
                        if ($review_id=$this->functions->insertData("mt_review",$params)){
                            
                            
                            
                            $this->PointsProgram->addReviewsPerOrder($order_id,
                            $client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
                                        
                                
                            
                            $this->code = 1;
                            $this->msg = ("Your review has been published.");
                            $this->details = array();
                                    
                        } else $this->msg = ("ERROR. cannot insert data.");
                    } else {                        
                        $id = $res_review['id'];
                        unset($params['date_created']);
                        $params['date_modified'] = $this->functions->dateNow();
                        $this->functions->updateData("mt_review",$params,'id', $id);
                        $this->code = 1;
                        $this->msg = ("Your review has been published.");
                        $this->details = array();
                    }
                                        
                } else {
                    // review merchant
                    $order_id = $order_info['order_id'];
                    $params = array(
                      'merchant_id'=>$order_info['merchant_id'],
                      'client_id'=>$client_id,
                      'review'=>$this->data['review'],
                      'rating'=>$this->data['rating'],
                      'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'order_id'=>$order_id,  
                    );
                    $actual_purchase = $this->functions->getOptionAdmin('website_reviews_actual_purchase');             
                    if($actual_purchase=="yes"){
                        
                        if (!$this->functions->checkIfUserCanRateMerchant($client_id,$order_info['merchant_id'])){
                            $this->msg=("Reviews are only accepted from actual purchases!");
                        }
                        if (!$this->functions->canReviewBasedOnOrder($client_id,$order_info['merchant_id'])){
                           $this->msg=("Sorry but you can make one review per order");
                           return ;
                        }              
                    }
                    
                    if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){
                        if ( $review_id=$this->functions->insertData("mt_review",$params)){
                            
                            
                            
                            $this->PointsProgram->addReviewsPerOrder($order_id,
                            $client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
                                        
                            
                            
                            $this->code = 1;
    
                            $this->msg = ("Your review has been published.");
                            $this->details = array();
                                    
                        } else $this->msg = ("ERROR. cannot insert data.");
                    } else {
                        $id = $res_review['id'];
                        unset($params['date_created']);
                        $params['date_modified'] = $this->functions->dateNow();
                        $this->functions->updateData("mt_review",$params,'id', $id);
                        $this->code = 1;
                        $this->msg = ("Your review has been published.");
                        $this->details = array();
                    }
                                
                }
            } else $this->msg = ("order id not found");     
        }
        $this->output();
    }

    public function ReviewList()
{
    $website_title = $this->functions->getOptionAdmin('website_title');
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $pagelimit = $this->SingleAppClass_pos->paginateLimit();
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $pagelimit;
    } else {
        $page = 0;
    }

    $paginate_total = 0;
    $limit = "LIMIT $page,$pagelimit";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.id,
        a.merchant_id,
        a.client_id,
        a.review,
        a.rating,
        a.as_anonymous,
        a.date_created,
        concat(b.first_name,' ',b.last_name) as customer_name,
        b.avatar
        FROM mt_review a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE a.status='publish'
        AND a.merchant_id=" . $this->merchant_id . "
        ORDER BY a.id DESC
        $limit
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $cmd = $this->db->prepare($stmt);
    if ($cmd->execute()) {
        $res = $cmd->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $data = array();
            foreach ($res as $val) {
                if ($val['as_anonymous'] == 1) {
                    $val['customer_name'] = "By " . $website_title . " Customer";
                    $val['avatar'] = $this->SingleAppClass_pos->getImage('x.png', 'avatar.png');
                } else {
                    $val['avatar'] = $this->SingleAppClass_pos->getImage($val['avatar'], 'avatar.png');
                    $val['customer_name'] = "By " . $val['customer_name'];
                }

                $pretyy_date = ($val['date_created']);
                $pretyy_date = $this->functions->translateDate($pretyy_date);
                $val['date_posted'] = $pretyy_date;

                $val['reply'] = $this->SingleAppClass_pos->getReviewReplied($val['id'], $val['merchant_id']);

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->msg = ("No available review");
                $this->details = array(
                    'title' => ("No available review"),
                    'sub_title' => ("be the first one to leave review order now!")
                );
            }
        }
    } else {
        $this->code = 6;
        $this->msg = "Query failed";
    }

    $this->output();
}


public function GetNotification()
{       
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    
    $pagelimit = $this->SingleAppClass_pos->paginateLimit();        
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $pagelimit;
    } else {
        $page = 0;
    }

    $paginate_total = 0; 
    $limit = "LIMIT $page,$pagelimit";   

    $where = "WHERE is_read='0'";
    $and = '';

    if (!$client_id = $this->checkToken()) {
        $client_id = 0;
    }

    if ($client_id > 0) {
        $and = " AND client_id = " . $client_id . " ";
    } else {
        $and = " AND device_id = '" . $this->device_id . "' ";
    }

    $stmt = "
        SELECT 
            id,
            push_title,
            push_message,
            date_created
        FROM mt_singleapp_mobile_push_logs
        $where
        $and
        ORDER BY id DESC
        $limit
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $cmd = $this->db->prepare($stmt);
    if ($cmd->execute()) {
        $res = $cmd->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $date_created = $this->functions->prettyDate($val['date_created']) . " " .
                                $this->functions->prettyTime($val['date_created']);             
                $data[] = array(
                    'id' => $val['id'],
                    'push_title' => $this->functions->clearString($val['push_title']),
                    'push_message' => $this->functions->clearString($val['push_message']),
                    'date_created' => $date_created
                );
            }
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = "end of records";
            } else {
                $this->code = 6;
                $this->details = array(
                    'title' => "Notifications is empty",
                    'sub_title' => "You don't have any notifications"
                );  
            }
        }
    } else {
        $this->code = 6;
        $this->msg = "Query failed";
    }

    $this->output();
}


public function GetGallery()
    {
        $page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';
        $list = array();
        $gallery=$this->functions->getOption("merchant_gallery",$this->merchant_id);
        $gallery=!empty($gallery)?json_decode($gallery):false;
        //$gallery=false;
        if(is_array($gallery) && count($gallery)>=1){
            foreach ($gallery as $val) {
                $list[] = $this->SingleAppClass_pos->getImage($val);
            }        
            $this->code = 1;
            $this->msg ="OK";
            $this->details=array(
              'page_action'=>$page_action,
              'data'=>$list
            );
        } else {            
            if($page_action=="infinite_scroll"){
                $this->code = 2;
                $this->msg = ("Photos not available"); 
            } else {
                $this->code = 6;
                $this->details = array(
                  'title'=>("No photos found"),
                  'sub_title'=>("There are no photo available")
                );  
            }
        }       
        $this->output();
    }


    public function searchOrder()
{
    if ($client_id = $this->checkToken()) {
        
        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');       
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');   
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');
        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }
        $date_now = date('Y-m-d g:i:s a');   
        
        $data = array();
        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';
        
        if (!empty($search_str)) {
            // Escape wildcard characters for LIKE
            $search_str_like = str_replace(array('%', '_'), array('\%', '\_'), $search_str);
            
            $stmt = "
            SELECT 
                a.order_id,
                a.client_id,
                a.trans_type,
                a.trans_type as trans_type_raw,
                a.payment_type,
                a.payment_type as payment_type_raw,
                a.total_w_tax,
                a.status,
                a.status as status_raw,     
                a.date_created,
                a.date_created as date_created_raw,
                a.request_cancel,
                a.order_locked,
                a.request_cancel_status,
                b.restaurant_name,
                b.logo
            FROM mt_order a         
            LEFT JOIN mt_merchant b
            ON a.merchant_id = b.merchant_id
            WHERE a.client_id = $client_id
            AND a.merchant_id = " . $this->merchant_id . "
            AND a.status NOT IN ('initial_order')
            AND (
                a.order_id LIKE '%$search_str_like%'
                OR b.restaurant_name LIKE '%$search_str_like%'
                OR a.trans_type LIKE '%$search_str_like%'
                OR a.payment_type LIKE '%$search_str_like%'
            )
            LIMIT 0,20
            ";
            $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            $cmd = $this->db->prepare($stmt);
            if ($cmd->execute()) {
                $res = $cmd->fetchAll(PDO::FETCH_ASSOC);
                if ($res) {
                    foreach ($res as $val) {

                        $val['restaurant_name'] = $this->functions->clearString($val['restaurant_name']);
                        $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);
                        $val['restaurant_name'] = $this->SingleAppClass_pos->highlight_word($val['restaurant_name'], $search_str);
                        $val['transaction'] = $val['trans_type'] . " #" . $val['order_id'];
                        $val['payment_type'] = $this->SingleAppClass_pos->highlight_word($val['payment_type'], $search_str);
                        $val['restaurant_name'] = $this->SingleAppClass_pos->highlight_word($val['restaurant_name'], $search_str);
                        $val['transaction'] = $this->SingleAppClass_pos->highlight_word($val['transaction'], $search_str);
                        $val['logo'] = $this->SingleAppClass_pos->getImage($val['logo']);

                        $add_review = false;
                        if ($this->functions->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)) {
                            $add_review = true;
                        }

                        if ($add_review) {
                            if ($val['client_id'] == $client_id) {
                                $date_diff = $this->functions->dateDifference(
                                    date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                                    $date_now
                                );
                                if (is_array($date_diff) && count($date_diff) >= 1) {
                                    if ($date_diff['days'] >= 5) {
                                        $add_review = false;
                                    }
                                }
                            } else {
                                $add_review = false;
                            }
                        }

                        if ($website_review_type == 1) {
                            if (isset($val['rating']) && $val['rating'] > 0) {
                                if ($merchant_can_edit_reviews == "yes") {
                                    $add_review = false;
                                }
                            }
                        }

                        $val['add_review'] = $add_review;

                        $show_cancel = false;
                        $cancel_status = '';
                        if ($this->functions->canCancelOrderNew($val['request_cancel'], $val['date_created'], $val['status_raw'], $val['order_locked'], $val['request_cancel_status'], $cancel_order_enabled)) {
                            if ($val['request_cancel'] == 1) {
                                $cancel_status = "Pending for review";
                            } else {
                                $show_cancel = true;
                            }
                        }

                        if ($val['request_cancel_status'] != 'pending') {
                            $cancel_status = "Request cancel :" . $val['request_cancel_status'];
                        }

                        $val['add_cancel'] = $show_cancel;
                        $val['cancel_status'] = $cancel_status;
                        $val['add_track'] = true;

                        $data[] = $val;
                    }

                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                        'data' => $data
                    );
                } else {
                    $this->msg = "No results";
                }
            } else {
                $this->msg = "Query failed to execute";
            }
        } else {
            $this->msg = "invalid search string";
        }
    }
    $this->output();
}

public function searchBooking()
{
    if ($client_id = $this->checkToken()) {
        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';
        
        if (!empty($search_str)) {
            // Escape wildcard characters for LIKE
            $search_str_like = str_replace(array('%', '_'), array('\%', '\_'), $search_str);
            
            $stmt = "
            SELECT              
                a.booking_id,
                a.client_id,
                a.merchant_id,
                a.date_booking,
                a.booking_time,
                a.number_guest,
                b.restaurant_name,
                b.logo
            FROM mt_bookingtable a
            LEFT JOIN mt_merchant b
            ON a.merchant_id = b.merchant_id
            WHERE a.client_id = $client_id
            AND a.merchant_id = " . $this->merchant_id . "
            AND (
                a.booking_id LIKE '%$search_str_like%'
                OR b.restaurant_name LIKE '%$search_str_like%'
            )
            LIMIT 0,20
            ";
            $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            $cmd = $this->db->prepare($stmt);
            if ($cmd->execute()) {
                $res = $cmd->fetchAll(PDO::FETCH_ASSOC);
                if ($res) {
                    foreach ($res as $val) {
                        $val['date_booking_format'] = $this->functions->prettyDate($val['date_booking']) . " " .
                            $this->functions->prettyTime($val['booking_time']);
                        $val['restaurant_name'] = $this->functions->clearString($val['restaurant_name']);
                        $val['logo'] = $this->SingleAppClass_pos->getImage($val['logo']);
                        $val['booking_ref'] = "Booking ID#" . $val['booking_id'];
                        $val['number_guest'] = "No. of guest " . $val['number_guest'];
                        $val['restaurant_name'] = $this->SingleAppClass_pos->highlight_word($val['restaurant_name'], $search_str);
                        $val['booking_ref'] = $this->SingleAppClass_pos->highlight_word($val['booking_ref'], $search_str);

                        $data[] = $val;
                    }

                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                        'data' => $data
                    );
                } else {
                    $this->msg = "No results";
                }
            } else {
                $this->msg = "Query failed to execute";
            }
        } else {
            $this->msg = "invalid search string";
        }
    }
    $this->output();
}


public function GetBookingDetails()
    {
        $page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
        
        if ($client_id = $this->checkToken()){          
            $booking_id = isset($this->data['booking_id'])?$this->data['booking_id']:'';
            if($res = $this->SingleAppClass_pos->GetBookingDetails($booking_id,$client_id)){
                $this->code = 1;
                $this->msg = "ok";
                $data = array();
                
                $data[]=array(
                  'label'=>("Booking ID"),
                  'value'=>$res['booking_id'],
                );
                $data[]=array(
                  'label'=>("Number of guest"),
                  'value'=>$res['number_guest'],
                );
                $data[]=array(
                  'label'=>("Date Of Booking"),
                  'value'=>$this->functions->prettyDate($res['date_booking']),
                );
                $data[]=array(
                  'label'=>("Time"),
                  'value'=>$this->functions->prettyTime($res['booking_time']),
                );
                $data[]=array(
                  'label'=>("Name"),
                  'value'=>$res['booking_name']
                );
                $data[]=array(
                  'label'=>("Email"),
                  'value'=>$res['email']
                );
                $data[]=array(
                  'label'=>("Mobile"),
                  'value'=>$res['mobile']
                );
                $data[]=array(
                  'label'=>("Your Instructions"),
                  'value'=>$res['booking_notes']
                );
                
                $this->details = array(
                  'page_action'=>$page_action,
                  'data'=>$data
                );
            } else {
                $this->code = 6;
                $this->msg = ("Booking not found");
                $this->details = array(
                  'title'=>("Booking not found"),
                  'sub_title'=>("booking details not available")
                );                                                      
            }
        }
        $this->output();
    }

    public function logout()
    {
        if ($client_id = $this->checkToken()){
            
            $this->functions->updateData("mt_client",array(
              'enabled_push'=>0
            ),'client_id', $client_id);
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->output();
    }

    public function getStocks()
    {
                                
     
        if($_POST){$this->data = $_POST;}else{$this->data = $_GET;} 
         
        $value = isset($this->data['price'])?$this->data['price']:'';
        $item_id = isset($this->data['item_id'])? (integer) $this->data['item_id']:'';
        $with_size = isset($this->data['with_size'])? (integer) $this->data['with_size']:'';
        $merchant_id = $this->merchant_id;
                                                    
        if($merchant_id>0 && $item_id>0 ){
            try {
                
                $allow_negative_stock = $this->InventoryWrapper->allowNegativeStock($merchant_id);
                
                $size_id = 0;
                                
                if($with_size>0){
                    $value = explode("|",$value);
                    if(is_array($value) && count($value)>=1){
                        $size_id = isset($value[2])?(integer)$value[2]:0;
                    }
                }       
                
                $resp = $this->StocksWrapper->getAvailableStocks($merchant_id,$item_id,$size_id);
                
                $this->code = 1; $this->msg = "OK";
                $this->details = array(
                  'next_action'=>"display_stocks",
                  'available_stocks'=>$resp['available_stocks'],
                  'message'=>$resp['message'],
                  'allow_negative_stock'=>$allow_negative_stock
                );          
                        
            } catch (Exception $e) {
               $this->details = array('next_action'=>"item_not_available");
               $this->msg = $e->getMessage();
            }
        } else {
             $this->details = array('next_action'=>"item_info_not_available");
             $this->msg = "invalid merchant id or size id";
        }
        $this->output();
    }   

    public function AddTip()
    {       
        $tip_amount = isset($this->data['tip_amount'])?(float)$this->data['tip_amount']:0;      
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if($resp=$this->SingleAppClass_pos->getCart($this->device_uiid , $this->merchant_id,$table_number)){
            $cart_id = $resp['cart_id'];
            $subtotal = (float)$resp['cart_subtotal'];          
            $percentage = ($tip_amount/$subtotal)*100;
            $percentage = number_format($percentage/100,4);         
                

            $this->functions->updateData("mt_pos_cart",array(
              'tips'=>$percentage
            ),'cart_id', $cart_id);

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array();           
        } else $this->msg = ("cart not available");
        $this->output();
    }


    public function saveTable()
    {
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        $id = isset($this->data['id'])?$this->data['id']:'';
        
    if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){}else{$this->msg = ("name is missing");$this->output();}
        
        
        if ( $resp1 = $this->functions->istableExist_new_by_user_id($_REQUEST['name'],$_REQUEST['pos_user_id']) ){          
            $this->msg = ("Sorry but table name already exist in our records");$this->output();
            }
        
        
        
                    
        $params = array(
          'm_id'=>$this->merchant_id,
          'm_user_id'=>$_REQUEST['pos_user_id'],
          'name'=>isset($this->data['name'])?$this->data['name']:'',
          'date_created'=>$this->functions->dateNow(),
         );
                
        
        if($id>=1){
            unset($params['date_created']);
                $this->functions->updateData("mt_table",$params,'id',$id);
            $this->code = 1;
            $this->msg = ("Successfully updated");
        } else {
                $this->functions->insertData("mt_table",$params);
                $this->code = 1;
                $this->msg = ("Table Added successfully");
            
        }
        
        $this->output();
    }

public function deleteTable()
{
    if (isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])) {
        // continue
    } else {
        $this->msg = ("User ID is missing");
        $this->output();
    }

    $id = isset($this->data['id']) ? $this->data['id'] : '';

    if ($id >= 1) {
        $datas = $this->functions->GetTables($id);

        if (isset($datas) && !empty($datas)) {
            $stmt = "DELETE FROM mt_table WHERE id = '$id'";
            $cmd = $this->db->prepare($stmt);
            $cmd->execute();

            $this->code = 1;
            $this->msg = "Table Deleted";
        } else {
            $this->msg = ("Table Not found");
        }
    } else {
        $this->msg = ("Invalid id");
    }

    $this->output();
}


public function customerRegisters()
    {
        
                
        
                if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
            
                
        if (isset($this->data['first_name']) && !empty($this->data['first_name'])){}else{           
            
            $this->Validator->setmsg("First Name is missing"); 
        }
        
        if (isset($this->data['email_address']) && !empty($this->data['email_address'])){}else{         
            

            $this->Validator->setmsg("Email Address is missing"); 

        }
            
                
        
        
        
            if ( $resp = $this->functions->isClientExist_with_merchant($this->data['email_address'],$this->merchant_id) ){          
                
                $this->Validator->setmsg("Sorry but your email address already exist in our records"); 
            }
        
                
        if($this->Validator->validate()){                               
            $params=array(
              'first_name'=>$this->data['first_name'],
              'last_name'=>$this->data['last_name'],    
             'merchant_id'=>$this->merchant_id,     
             
             'social_strategy'=>"POS",      
             
              'password'=>md5($this->data['password']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],                          
              'single_app_merchant_id'=>$_REQUEST['pos_user_id'],             
            );              
            
   
                $params['email_address'] = $this->data['email_address'];
    
            
                $params['contact_phone'] = trim($this->data['contact_phone']);

                 // +++Branch logic (specific to current merchant)
                $merchant_id=$this->merchant_id;
        $stmt = "SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?)) LIMIT 1";
        $pdoStmt = $this->db->prepare($stmt);
        $pdoStmt->execute([$merchant_id]);
        $branchRow = $pdoStmt->fetch(PDO::FETCH_ASSOC);

        if ($branchRow && !empty($branchRow['merchant_id'])) {
            $branchMerchants = json_decode($branchRow['merchant_id'], true);
            if (is_array($branchMerchants)) {
                $params['branch'] = json_encode(array_values(array_map('intval', $branchMerchants)));
            } else {
                $params['branch'] = json_encode([ (int) $merchant_id ]);
            }
        } else {
            $params['branch'] = json_encode([ (int) $merchant_id ]);
        }
            
          //--- Branch logic (specific to current merchant)  
        
            
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params['email_address']);
            
            
            $params['token']=$token;                                    
                                                            
            if($customer_id =$this->functions->insertData("mt_client",$params)){    
                      
                
                $this->data['client_id'] = $customer_id;
                $this->data['merchant_id'] = $this->merchant_id;

                $this->details = array(
                  'client_id'=>$customer_id,
                  'name'=>$params['first_name']." ".$params['last_name'],
                  'email'=>$params['email_address']
                );  
                    
                $this->code=1;
                $this->msg = ("Registration successful");

                $this->PointsProgram->signupReward($customer_id);
                
                                                
            } else $this->msg = ("Something went wrong during processing your request. Please try again later");
            
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }


    public function PhoneCustomerRegisters()
    {
        
        
        
        
                if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
            
                
        if (isset($this->data['first_name']) && !empty($this->data['first_name'])){}else{           
            

            $this->Validator->setmsg("First Name is missing"); 

        }       
        /*if (isset($this->data['email_address']) && !empty($this->data['email_address'])){}else{           
            
            
            $this->Validator->setmsg("Email Address is missing"); 
        }   */

        if (isset($this->data['phone']) && !empty($this->data['phone'])){}else{         
            

            $this->Validator->setmsg("Phone Number is missing"); 
        }       
        
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];               
        }
        $names=$this->data['first_name'].' '.$this->data['last_name'];                      
        if($this->Validator->validate()){

                
             
                $this->code=1; 
                $this->msg = ("OK"); 
            
                    $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                        
                /* ----------------- if Phone order-----------------------------   */
                /* ----------------- if Phone order-----------------------------   */               
                
            
            
                if ( $res1 = $this->SingleAppClass_pos->getCartForPhone($device_id,$this->merchant_id)){    

                    
        $distance=0;
        $delivery_fee=0;
        
        $lat=0;
        $lng=0; 
        $complete_address='';
        
        if($this->data['order_type']=='delivery'){
        
        
        $complete_address=$this->data['address'];
            if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                       $lat=$lat_res['lat'];
                       $lng=$lat_res['long'];
                    
            }
        
            $lat = isset($lat)?$lat:0;
            $lng = isset($lng)?$lng:0;  
            
            
            if(isset($lat) && !empty($lat) && isset($lng) && !empty($lng)){
            
            if ($res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            
                $data['merchant_id']=$res['merchant_id'];
                            
                $data['latitude']=$res['latitude'];
                $data['lontitude']=$res['lontitude'];
                                
                $data['delivery_fee'] = '';
                                    
                        $provider = $this->functions->getMapProvider();                                         
                        $params_fee =  array(
                          'merchant_id'=>$res['merchant_id'],
                          'provider'=>$provider,
                          'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
                          'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
                          'to_lat'=>$lat,
                          'to_lng'=>$lng,
                          'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
                          'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
                          'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:'',
                          'order_subtotal'=>0,
                          'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
                        );  
                    //print_r($params_fee); 
                        
                    $resp_fee = $this->CheckoutWrapperTemp->getDeliveryDetails($params_fee);
                    
                
                
                
                    if(isset($resp_fee) && !empty($resp_fee)){
                //print_r($resp_fee);
                $distance=$resp_fee['distance'];
                $delivery_fee=$resp_fee['delivery_fee'];
                
                
                    }else{
                        $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                        
                    }
            
        //$this->output();
        }


            }else{
                $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                
                
            }

        }

                    $this->functions->updateData("mt_pos_cart",array(                 
                  'clients_id'=>1,
                  'client_name'=>$names,
                  'email'=>$this->data['email_address'],
                  'phones'=>$this->data['phone'],
                  'distance'=>$distance,
                  'delivery_fee'=>$delivery_fee,
                  'delivery_lat'=>$lat,
                  'delivery_long'=>$lng,                              
                  'address'=>isset($complete_address)?$complete_address:'',
                  'order_type'=>isset($this->data['order_type'])?$this->data['order_type']:'pickup',                  
                  'date_modified'=>$this->functions->dateNow(),
                ),'cart_id', $res1['cart_id']);
                    
                    
                }
                
                
            
            
            
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }


public function deleteCustomer()
{
    if (isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])) {
        // continue
    } else {
        $this->msg = ("User ID is missing");
        $this->output();
    }

    $id = isset($this->data['client_id']) ? $this->data['client_id'] : '';

    if ($id >= 1) {

        $datas = $this->functions->getClientInfowm_id($id, $this->merchant_id, $_REQUEST['pos_user_id']);

        if (isset($datas) && !empty($datas)) {
            $stmt = "DELETE FROM mt_client WHERE client_id = $id";
            $this->db->exec($stmt);

            $this->code = 1;
            $this->msg = "Customer Deleted";
        } else {
            $this->msg = ("Customer Not found");
        }
    } else {
        $this->msg = ("Invalid id");
    }

    $this->output();
}

    
    
    
    public function ListCustomers()
    {
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
          $datas=$this->functions->getallcustomers($this->merchant_id,$_REQUEST['pos_user_id']);    
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'customers'=>$datas
                );
            } else $this->msg = ("No customer Found!"); 
        
        $this->output();
    }   

    public function ListTables()
    {
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
          $datas=$this->functions->getalltables($this->merchant_id,$_REQUEST['pos_user_id']);   
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'tables'=>$datas
                );
            } else $this->msg = ("No Table Found!"); 
        
        $this->output();
    }   
    
    
    
    public function Checktableavailable()
    {                       
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
        if(isset($_REQUEST['table_number']) && !empty($_REQUEST['table_number'])){}else{$this->msg = ("Table ID is missing");$this->output();}
        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        /*GET CART*/
        $res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number);
        if($res && !empty($res)){
            $this->code = 1;
            $this->msg = ("Table is not available");
            
        }else{
            $this->code = 1;
            $this->msg = ("Table is available");
        }
        $this->output();
    }


    public function ActiveTables()
    {
         $datas=$this->functions->getallactivetables($this->merchant_id);   
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'tables'=>$datas
                );
            } else $this->msg = ("No Active Table Found!"); 
        
        $this->output();
    }   
    
    
    public function AvailableTables()
    {
         $datas=$this->functions->getallavailabletables($this->merchant_id);    
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'tables'=>$datas
                );
            } else $this->msg = ("No Table Available!"); 
        
        $this->output();
    }


    public function loadCart_cashier()
    {    

        $this->setMerchantTimezone();       
        
        /*CHECK IF ORDERING IS DISABLED*/

        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');     
        if($disabled_website_ordering=="yes"){
            $this->msg = ("Ordering is disabled by admin");
            $this->code = 4;
            $this->output();
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $this->msg = ("Ordering is disabled by merchant");
            $this->code = 4;
            $this->output();
        }
                
        $merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
        if($merchant_close_store=="yes"){
            $this->msg = ("Merchant is now close and not accepting any orders");
            $this->code = 4;
            $this->output();
        }
        
        
        $search_resp = $this->SingleAppClass_pos->searchMode();     
        $search_mode = $search_resp['search_mode']; 
        $location_mode = $search_resp['location_mode']; 
                
                
        $transaction_type='';
        $services = $this->functions->DeliveryOptions($this->merchant_id);
        
        if(is_array($services) && count($services)>=1){
            foreach ($services as $services_key=>$services_val) {               
                $transaction_type = $services_key;
                break;              
            }
        }
        
        if(isset($this->data['transaction_type'])){
            if(!empty($this->data['transaction_type'])){
                $transaction_type=$this->data['transaction_type'];
            }
        } else {
            $this->data['transaction_type'] = $transaction_type;
        }   
        $this->data['transaction_type'] = $transaction_type='pickup';
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        /*GET CART*/
        $res=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);
        if($res && !empty($res)){}else{
            $this->code = 2;
            $this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
        $this->output();}
        /*CHECK TIPS DEFAULT*/
        if($res && $transaction_type=="delivery"){
            $merchant_tip_default = $this->functions->getOption('merchant_tip_default',$this->merchant_id);     
            if($merchant_tip_default>0 && $res['tips']<=0 && $res['remove_tip']<=0 ){           
                $res['tips'] = $merchant_tip_default;
                
                

                $this->functions->updateData("mt_pos_cart",array(                 
                  'tips'=>$merchant_tip_default
                ),'cart_id', $res['cart_id']);



            }                   
                      
        } else if ( $res ) {
            if($res['tips']>0){
                

                $this->functions->updateData("mt_pos_cart",array(                 
                  'tips'=>0
                ),'cart_id', $res['cart_id']);

            }       
            $res['tips'] = 0;
        }else{
            $this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
        $this->output();
        }   

                
        if($res){
            $cart=json_decode($res['cart'],true);                   
                    
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            //dump($data);
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }       
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['points_apply']>0.0001){
                $data['points_apply']=$res['points_apply'];
            }
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }
            
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $cart_details = $res;
            unset($cart_details['cart']);       
            unset($cart_details['device_id']);
            unset($cart_details['cart_id']);
            unset($cart_details['cart_id']);                                    
            unset($_SESSION['pts_redeem_amt']);
            
            /*inventory*/
            if($this->SingleAppClass_pos->inventoryEnabled($this->merchant_id) && 1==2){
                $new_cart = array();                
                if(is_array($cart) && count($cart)>=1){
                    foreach ($cart as $cartval) {                       
                        try {                                 
                           $this->StocksWrapper->verifyStocks(
                              isset($cartval['qty'])?(integer)$cartval['qty']:0,
                              $this->merchant_id,
                              isset($cartval['item_id'])?(integer)$cartval['item_id']:0,
                              isset($cartval['with_size'])?(integer)$cartval['with_size']:0,
                              isset($cartval['price'])?$cartval['price']:0
                           );
                           $new_cart[]=$cartval;
                        } catch (Exception $e) {
                            //echo $e->getMessage();
                         }
                    }
                    $cart = $new_cart;
                }           
            }
            
            $multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');   
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
               $this->code = 1;
               $details = $displayOrderHTML['raw'];
                   
               
               /*TRANSLATE*/
               if($multiple_translation==2){
                   if(is_array($details['item']) && count($details['item'])>=1){
                      $new_item = array();
                      foreach ($details['item'] as $key=> $details_item_val) {                      
                         $details_item_val['item_name'] = $this->functions->qTranslate($details_item_val['item_name'],'item_name',$details_item_val['item_name_trans']);
                         
                         if(isset($details_item_val['new_sub_item'])){
                         if(is_array($details_item_val['new_sub_item']) && count($details_item_val['new_sub_item'])>1){                         
                            $newest_new_sub_item_val=array();
                            foreach ($details_item_val['new_sub_item'] as $new_sub_item_key=>$new_sub_item_val) {       
                                $new_sub_item_key = $this->functions->qTranslate($new_sub_item_key,'subcategory_name',$new_sub_item_val[0]['subcategory_name_trans']);                                                              
                                $newest_new_sub_item_val[$new_sub_item_key]=$new_sub_item_val;
                            }       
                            $details_item_val['new_sub_item']=$newest_new_sub_item_val;
                         }                    
                         }
                         
                         $new_item[$key]=$details_item_val;
                      }     
                      $details['item']=$new_item;
                      
                      
                   }            
               }
               /*END TRANSLATE*/
               
               //dump($details);
        

               
               
               /*EURO TAX*/
               $is_apply_tax = 2;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($details, $this->merchant_id);
                   $details['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/
               
               //dump($details);
               
               $has_addressbook = 0;
               $client_id='';
               $client_id = isset($this->data['client_id'])?$this->data['client_id']:'0';
                 

               $defaul_delivery_date = date("Y-m-d");
               $date_list = $this->SingleAppClass_pos->deliveryDateList($this->merchant_id);
               foreach ($date_list as $date_list_key => $date_list_val) {                 
                  $defaul_delivery_date = $date_list_key;
                  break;
               }
               
               $subtotal = $details['total']['subtotal'];
               $cart_error=array();

               /*CHECKING MAX AND MIN AMOUNT*/
               if($transaction_type=="delivery"){
                                 
                  $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$this->merchant_id);       
                  $min_tables_enabled = $this->functions->getOption('min_tables_enabled',$this->merchant_id);
                                                                          
                  if($min_tables_enabled==1 && !empty($res['distance'])){                     
                      $merchant_minimum_order = $this->CheckoutWrapperTemp->getMinimumOrderTable(
                      $this->merchant_id,$res['distance'],$res['distance_unit'],$merchant_minimum_order
                      );
                  }            
                                        
                  if($merchant_minimum_order>0){
                     if($merchant_minimum_order>$subtotal){
                        

                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($merchant_minimum_order);



                     }                
                  }      
                  
                  $merchant_maximum_order = $this->functions->getOption('merchant_maximum_order',$this->merchant_id);
                  if($merchant_maximum_order>0.001){
                     if($subtotal>$merchant_maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($merchant_maximum_order);

                     }                
                  }                  
               } elseif ( $transaction_type=="pickup"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_pickup',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        
                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);

                     }                
                  }                           
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_pickup',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);

                     }                
                  }         
               } elseif ( $transaction_type=="dinein"){
                  $minimum_order = $this->functions->getOption('merchant_minimum_order_dinein',$this->merchant_id); 
                  if($minimum_order>0.001){
                     if($minimum_order>$subtotal){
                        

                        $cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of ".$this->functions->prettyPrice($minimum_order);

                     }                
                  }                   
                  $maximum_order = $this->functions->getOption('merchant_maximum_order_dinein',$this->merchant_id);
                  if($maximum_order>0.001){
                     if($subtotal>$maximum_order) {
                        

                        $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of ".$this->functions->prettyPrice($maximum_order);


                     }                
                  }         
               }               
               /*CHECKING MAX AND MIN AMOUNT*/  
                                      
               /*CHECK IF HAS POINTS ADDON*/
               $available_points=0; $available_points_label = '';
               $points_enabled = '';   $pts_disabled_redeem='';            
               
                                
                  $points_enabled = $this->functions->getOptionAdmin('points_enabled');
                  if($points_enabled=="1"){
                      if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                          $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                          if($mt_disabled_pts==2){
                             $points_enabled='';
                          }                       
                      }
                  }
                  
                  $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
                  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                      $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$this->merchant_id);
                      if($mt_pts_disabled_redeem>0){
                          $pts_disabled_redeem=$mt_pts_disabled_redeem;
                      }               
                  }
                   
                  /*GET EARNING POINTS FOR THIS ORDER*/
                  $subtotal = $details['total']['subtotal'];                  
                  if ($earn_pts = $this->SingleAppClass_pos->getCartEarningPoints($cart,$subtotal,$this->merchant_id)){  
                
                    


                     $this->functions->updateData("mt_pos_cart",array(                
                          'points_earn'=>$earn_pts['points_earn'],
                          'date_modified'=>$this->functions->dateNow()
                        ),'cart_id', $res['cart_id']);


                  }         
                                                                   
                  if($client_id>0){                                                       
                      if($points_enabled=="1"){
                          $available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
                          

                           $available_points_label = "Your available points ".$available_points;

                      }
                   }               
                    
               
               $checkout_stats = $this->functions->isMerchantcanCheckout($this->merchant_id);
               if($checkout_stats['code']==2){
                  $cart_error[] = $checkout_stats['msg'];
               }            
               
               $subtotal = isset($details['total']['subtotal'])?$details['total']['subtotal']:0;                   
              

               $this->functions->updateData("mt_pos_cart",array(                  
                          'cart_subtotal'=>(float)$subtotal,
                         'date_modified'=>$this->functions->dateNow()
                        ),'cart_id', $res['cart_id']);

               if($earn_pts['points_earn']==0){$earn_pts['points_earn']='';$earn_pts['pts_label_earn']='';}
               



                //+++was custom code
                $details['total']['mid']=strval($details['total']['mid']);
               // $details['total']['total']=strval($details['total']['total']);

                if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as &$item) {
        // Convert "item_name_trans" to empty array if it has nested structure like: { "item_name_trans": "" }
        if (isset($item['item_name_trans']) && is_array($item['item_name_trans'])) {
            $item['item_name_trans'] = [];
        }

        // Also apply the same inside new_sub_item if needed
        if (isset($item['new_sub_item']) && is_array($item['new_sub_item'])) {
            foreach ($item['new_sub_item'] as &$subitemGroup) {
                if (is_array($subitemGroup)) {
                    foreach ($subitemGroup as &$subitem) {
                        if (isset($subitem['sub_item_name_trans']) && is_array($subitem['sub_item_name_trans'])) {
                            $subitem['sub_item_name_trans'] = [];
                        }
                    }
                }
            }
        }
    }
    unset($item, $subitem, $subitemGroup); // clean up references
}


//+++was custom code
if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as &$item) {
        if (!isset($item['is_printed']) || is_null($item['is_printed'])) {
            $item['is_printed'] = 0;
        }
        if (!isset($item['is_printed_already']) || is_null($item['is_printed_already'])) {
            $item['is_printed_already'] = "";
        }

        // If sub_item exists, apply same logic recursively
        if (isset($item['sub_item']) && is_array($item['sub_item'])) {
            foreach ($item['sub_item'] as &$subItem) {
                if (!isset($subItem['is_printed']) || is_null($subItem['is_printed'])) {
                    $subItem['is_printed'] = 0;
                }
                if (!isset($subItem['is_printed_already']) || is_null($subItem['is_printed_already'])) {
                    $subItem['is_printed_already'] = "";
                }
            }
        }
    }
    unset($item); // break reference
}
//---was custom code


                //---was custom code

//+++was custom code
if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as $i => $item) {

        // Fix size_name_trans if it's an array or object
        if (isset($details['item'][$i]['size_name_trans']) && is_array($details['item'][$i]['size_name_trans'])) {
            $details['item'][$i]['size_name_trans'] = '';
        }

        // Fix sub_item list
        if (isset($details['item'][$i]['sub_item']) && is_array($details['item'][$i]['sub_item'])) {
            foreach ($details['item'][$i]['sub_item'] as $j => $subitem) {
                if (isset($details['item'][$i]['sub_item'][$j]['sub_item_name_trans']) &&
                    is_array($details['item'][$i]['sub_item'][$j]['sub_item_name_trans'])) {
                    $details['item'][$i]['sub_item'][$j]['sub_item_name_trans'] = '';
                }
            }
        }

        // Fix new_sub_item
        if (isset($details['item'][$i]['new_sub_item']) && is_array($details['item'][$i]['new_sub_item'])) {
            foreach ($details['item'][$i]['new_sub_item'] as $cat => $addons) {
                foreach ($addons as $k => $addon) {
                    if (isset($details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans']) &&
                        is_array($details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans'])) {
                        $details['item'][$i]['new_sub_item'][$cat][$k]['sub_item_name_trans'] = '';
                    }
                }
            }
        }

    }
}



if (isset($details['item']) && is_array($details['item'])) {
    foreach ($details['item'] as $key => $item) {
        if (isset($item['cooking_name_trans']) && is_array($item['cooking_name_trans']) && array_key_exists('cooking_name_trans', $item['cooking_name_trans'])) {
            $details['item'][$key]['cooking_name_trans'] = $item['cooking_name_trans']['cooking_name_trans'];
        }
    }
}
$cart_details['points_amount'] = number_format((float)$cart_details['points_amount'], 2, '.', '');
//---was custom code




               $this->details = array(
               'cart_id'=>$res['cart_id'],  
                 'is_apply_tax'=>$is_apply_tax,
                 'checkout_stats'=>$checkout_stats,
                 'has_addressbook'=>$has_addressbook,
                 'services'=>$services,
                 'transaction_type'=>$transaction_type,
                 'default_delivery_date'=>$defaul_delivery_date,
                 //'default_delivery_date_pretty'=>date("D F d, Y"),
                 'default_delivery_date_pretty'=>$this->functions->prettyDate($defaul_delivery_date),
                 'required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),   
                 'tip_list'=>$this->SingleAppClass_pos->tipList(),
                 'data'=>$details,      
                 
                 'cart_details'=>$cart_details,
                 'cart_error'=>$cart_error,
                 'points_enabled'=>$points_enabled,              
                 'points_earn'=>isset($earn_pts['points_earn'])?$earn_pts['points_earn']:'',
                 'pts_label_earn'=>isset($earn_pts['pts_label_earn'])?$earn_pts['pts_label_earn']:'',
                 'available_points'=>$available_points,
                 'available_points_label'=>$available_points_label,
                 'pts_disabled_redeem'=>$pts_disabled_redeem,
                 'opt_contact_delivery'=>$this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id),
               );
                 if($table_number>0){
                    $table_names=$this->functions->GetTables($table_number);
                    $this->details['table_name']=$table_names['name'];             
               } 
            
            } else {
                //SingleAppClass::clearCart($this->device_uiid,$table_number);
                $this->msg = $msg;
            }   
            
                
            
        } else {$this->msg = ("Cart is empty");}
        $this->output();
    }







    public function addToCart_cashier()
    {               
        
        $code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;      
        if($code_version<2.2){
            $this->getGETData();
            $this->data = $_GET;
        } else {
            $this->getPOSTData();
            $this->data = $_POST;
        }   
            
            
        $data = $_POST;         
        if(isset($_REQUEST['table_number']) && !empty($_REQUEST['table_number'])){}else{$this->msg = ("Table ID is missing");$this->output();}
        $cart_count = 0;
        $data['merchant_id'] = $this->merchant_id;
        //$device_id = $this->device_uiid;
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];       
            
        }
        $item_id = isset($data['item_id'])?$data['item_id']:'';     
        
        if(!is_numeric($item_id)){
            $this->msg = ("Invalid item id");
            $this->output();
        }
        
        
        $qty = isset($data['qty'])?$data['qty']:'';     
        if($_REQUEST['variable_price']>0){$data['qty']=$qty=1;}
        if($qty>0){         
            if (strpos($qty,'.') !== false) {
               $this->msg = ("invalid quantity");
               $this->output();
            }   
        } else {
            $this->msg = ("invalid quantity");
            $this->output();
        }
        
        if(!$item_details = $this->functions->getFoodItem($item_id)){
            $this->msg = ("Item details not found");
            $this->output();
        }
        if($item_details['merchant_id']!=$this->merchant_id){
            $this->msg = ("Item does not belong to merchant");
            $this->output();
        }       
        $data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
        $data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
        
        
         $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        
        /*dump($data);
        die();*/
        
        if(!isset($data['price'])){
            $this->msg = ("Please select price");
            $this->output();
        }
                
        $refresh = 0;
        
        if(!empty($device_id)){         
            
            
            $debug = false; 
            
            if ( $res = $this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number)){
                $current_cart = json_decode($res['cart'],true);
                                
                $row = isset($data['row'])?$data['row']:'';
                if(is_numeric($row)){                               
                    $current_cart[$row]= $data; 
                    if($table_number>0){
                        
                            $current_cart[$row]['is_printed']=0;  
                            $current_cart[$row]['is_printed_already']='Updated Item';
                                            
                    }
                    $refresh = 1;       
                } else {                    
                                        
                    /*CHECK IF THE ITEM IS ALREADY IN THE CART */                   
                    $item_found = true; $found_key = -1;
                    
                    if(is_array($current_cart) && count($current_cart)>=1 && 1==2){
                        foreach ($current_cart as $current_cart_key => $current_cart_val) {
                            /*dump($current_cart_key);
                            dump($current_cart_val);*/
                                    
                            if($table_number>0){
                            if($current_cart_val['is_printed']>0){}else{$data['is_printed']=0;
                            
                            }
                            }
                                    
                            $item_found = true;
                                                    
                            if ($current_cart_val['item_id']!=$data['item_id']){
                                $item_found = false;
                            }
                            if ($current_cart_val['price']!=$data['price']){
                                $item_found = false;
                            }
                            
                            /*COOKING REF*/
                            if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
                                if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
                                    $item_found = false;
                                }
                            } else {                                
                                if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*INGREDIENTS*/
                            if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
                                $ingredients = json_encode($data['ingredients']);
                                $ingredients2 = json_encode($current_cart_val['ingredients']);                              
                                if($ingredients!=$ingredients2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            /*ADDON*/
                            if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
                                $sub_item = json_encode($data['sub_item']);
                                $sub_item2 = json_encode($current_cart_val['sub_item']);
                                if($sub_item!=$sub_item2){
                                    $item_found = false;
                                } 
                            } else {
                                if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
                                } else $item_found = false;                             
                            }
                            
                            if($item_found==TRUE){                              
                               $found_key = $current_cart_key;
                            } 
                            
                        } /*END LOOP*/
                        
                        if($found_key>=0){
                            
                            if($table_number>0){
                             
                                if($current_cart[$found_key]['is_printed']==1){$current_cart[$found_key]['is_printed_already']='Updated Item';}
                                $current_cart[$found_key]['is_printed']=0; 
                                
                            }
                            
                                                
                            $current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
                        } else {
                            if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';  }    
                            array_push($current_cart,$data);
                        }
                        
                    } else {    
                            if($table_number>0){$data['is_printed']=0;} 
                        array_push($current_cart,$data);
                    }                   
                }
                
                /*inventory*/               
                $merchant_id = $this->merchant_id;

                //+++was custom code for inventory
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = 0;               
                  foreach ($current_cart as $val) {
                      if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
                         $inv_qty+=$val['qty'];
                      }
                  }                                               
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
                  } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    $this->output();
                  }                   
                }
                //---was custom code for inventory

            
                $cart_count = count($current_cart);
                $this->functions->updateData("mt_pos_cart",array(
                  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
                  'cart'=>json_encode($current_cart),
                  'cart_count'=>$cart_count,
                  'table_number'=>$table_number,
                  'date_modified'=>$this->functions->dateNow(),
                ),'cart_id', $res['cart_id']);
            } else {                    
                
                $this->msg=("Cart is empty against the table");
            }       
            
            
            $this->code = 1;
            $this->msg=("Added to cart");
            if($refresh==1){
                $this->msg=("Cart updated");
            }           
            $this->details=array(
             'cart_count'=>$cart_count,
             'refresh'=>$refresh
            );
                
        } else $this->msg = ("Device id is empty. please restart the application and try again");
        $this->output();
    }

    public function loadPaymentListOption()
    {   



            //$merchant_id = $this->merchant_id;
        $merchant_id = isset($_GET['merchant_id'])?$_GET['merchant_id']:0;
        $transaction_type = isset($_GET['transaction_type'])?$_GET['transaction_type']:'pickup';            
                    
        $_SESSION['kr_delivery_options']['delivery_type']='pickup';
                    
        if ( $res = $this->functions->getMerchantPaymentListNew($merchant_id)){


                    
            //$transaction_type = "pickup";
             $this->code = 1;
             $this->msg = "OK";     
             $list1 = array();
                    
             if(isset($res['mcd'])){
                unset($res['mcd']);
             }      
             if(isset($res['pyp'])){
                unset($res['pyp']);
             }
             if(isset($res['poli'])){
                unset($res['poli']);
             }
             
             $windcave_enabled=$this->functions->getOption('windcave_pos_enabled',$merchant_id);

            
       
             if ($windcave_enabled == "") {
                if(isset($res['windcave'])){
                unset($res['windcave']);
                }
           }else{
            $res['windcave']="Card Pay(Windcave)";
           }
           
             
            
             foreach ($res as $key => $val) {
                $offline_mode=1;
                 if($key=='cod' || $key=='sop' || $key=='windcave'){
                     if($key=='cod'){$images=$this->functions->websiteUrl()."/upload/cash_payment.png";
                     if($transaction_type == "delivery"){
                     $names="Pay On Delivery";
                     }else{
                     $names="Pay On Pickup";
                     }  

                     }else if($key=='sop'){$images=$this->functions->websiteUrl()."/upload/sop.jpg";
                    if($transaction_type == "delivery"){
                    $names="Pay by card on delivery";   
                    }else{
                    $names="Pay by card on pickup";}

                    }   
                
                
                else if($key=='windcave'){$images=$this->functions->websiteUrl()."/upload/sop.jpg";
                $names="Card Pay(Windcave)";$offline_mode=0;    }   

                
                $list1[] = array(
                  'payment_code'=>$key,
                  'payment_name'=>$names,
                  'payment_logo'=>$images,
          'is_enabled_offline'=>$offline_mode
                );
                
                
                 }
             
             
             if($key=='pyr'){
                    
                    
                          $payondelivery_enabled= $this->functions->getOption('merchant_payondeliver_enabled',$merchant_id);    
                          if($payondelivery_enabled=='yes'){
                      $provider_list=$this->functions->getPaymentProviderMerchant($merchant_id);
 
                            if (is_array($provider_list) && count($provider_list)>=1){
                                    foreach ($provider_list as $val_provider_list){
                                        
                                        
                                          $showtype='payment_show_type_'.$val_provider_list['id'];
                                          $showtypes=$this->functions->getOption($showtype,$merchant_id);        
                                        
                                        //print_r($val_provider_list);die();
                                        if($showtypes=='0' || $showtypes=='2'){
                                        
                                        
                                        $list1[] = array(
                  'payment_code'=>$val_provider_list['payment_name'],
                  'payment_name'=>"Pay by (".$val_provider_list['payment_name'].")",
                  'payment_logo'=>$this->functions->websiteUrl()."/upload/".$val_provider_list['payment_logo'],
           'is_enabled_offline'=>$offline_mode
                );
                                        
                                        }   
                                    }
                            }
                            
             }
                        
                    
                }
             
             }
             
        }else{
            $list1="No gateway Available";
        }
        if(isset($list1) && !empty($list1)){}else{
            $list1="No gateway Available";      }
        
             $this->code = 1;
             $this->msg = "OK";     
            // $this->msg =$list1;      
            
                
                
                
             
             $this->details = array(
               'data'=>$list1
             );
        
        $this->output();
    }


    public function ListCustomersbyname()
    {
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
        if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){}else{$this->msg =("Name is missing");$this->output();}
        $name=$_REQUEST['name'];
        
          $datas=$this->functions->getallcustomers_byname($this->merchant_id,$_REQUEST['pos_user_id'],$name);   
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'customers'=>$datas
                );
            } else $this->msg = ("No customer Found!"); 
        
        $this->output();
    }


    public function UpdatePrintedItem()
    {       
        $row = isset($this->data['row'])?$this->data['row']:0;  
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;    
        if($res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id,$table_number)){
            $cart=json_decode($res['cart'],true);           
            if(array_key_exists($row,(array)$cart)){
                $cart[$row]['is_printed']=1;
                $cart[$row]['is_printed_already']="Updated Item";
                            
                $this->functions->updateData("mt_pos_cart",array(
                  'device_id'=>$this->device_uiid,
                  'cart'=>json_encode($cart,JSON_FORCE_OBJECT),
                ),'cart_id', $res['cart_id']);
                
                $this->code = 1;
                $this->msg="OK"; 
                $this->details='';
            } else $this->msg = ("Cannot find cart row");
        } else $this->msg = ("Cart is empty");
        $this->output();
    }
    
    
    
    
    // update the printed order for waiter
        public function UpdateTable()
    {       
        $old_table_number= isset($_REQUEST['old_table_number'])?$_REQUEST['old_table_number']:0;
        if(isset($old_table_number) && !empty($old_table_number) && $old_table_number>0){}else{$this->msg = ("Old Table Number is missing");$this->output();}
        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        if(isset($table_number) && !empty($table_number) && $table_number>0){}else{$this->msg = ("Table Number is missing");$this->output();}
        
        
        if($res=$this->SingleAppClass_pos->getCart_by_table_id($this->merchant_id,$old_table_number)){
                
                                
                $this->functions->updateData("mt_pos_cart",array(                
                  'table_number'=>$table_number,
                ),'cart_id', $res['cart_id']);
                
                $this->code = 1;
                $this->msg="OK"; 
                $this->details='';
            
        } else $this->msg = ("Not updated");
        $this->output();
    }


    public function windverify()
    {   
    $order_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;
    $merchant_id= isset($_REQUEST['merchant_id'])?$_REQUEST['merchant_id']:0;
    $device_uiid= isset($_REQUEST['device_uiid'])?$_REQUEST['device_uiid']:0;
    $order_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;

    $status="Complete";
    //$reference_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;
    //  if(isset($reference_id) && !empty($reference_id) && $reference_id>0){}else{$this->msg = $this->t("Order Id is Required");$this->output();}
    
    //$data=Yii::app()->functions->getOrder($reference_id);
    //$amount_to_pay=normalPrettyPrice($data['total_w_tax']);
    
        $params_update=array('status'=>'Complete','date_modified'=>$this->functions->dateNow());            
        if($this->functions->updateData("mt_order",$params_update,'order_id',$order_id)){   
    

        $res=$this->functions->getOrderInfo($order_id); 

        if($res['windcave_offline']==0){

        $client_id=$res['client_id'];

$table_number=$res['table_number'];     

$phone_order=$res['is_phone_order'];
            $cart_id=$res['cart_id'];
            if($cart_id>0){
            
              $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$merchant_id,
                              $client_id,$device_uiid,$status,$cart_id);    
            }else{
                    

                    
            $this->SingleAppClass_pos->handleAll_cash($order_id,$merchant_id,$client_id,$device_uiid,$status);  
             
             
                if($table_number>0){    

                     $this->SingleAppClass_pos->handleAll($order_id,$merchant_id,
                              $client_id,$device_uiid,$status,$table_number);   
                              
                }else{ $this->SingleAppClass_pos->handleAll_cash($order_id,$merchant_id,
                              $client_id,$device_uiid,$status); 
                            }
                             
             
            }
             
             
             
        $this->SingleAppClass_pos->updatePoints($order_id,$status); 
        }else{ //+++was custom code

             $params = array(
    'status' => "active"
);

// Update the `{{item}}` table where `item_id` matches the given `$item_id`


 $this->functions->updateData('mt_points_earn' , $params ,'order_id',$order_id);
 $this->functions->updateData('mt_points_expenses' , $params ,'order_id',$order_id);

        }//---was custom code


                              
       }

echo json_encode(array('code'=>1,'status'=>'success','response'=>'Your payment hass been done'));       
        
    
    
    }


    public function windverify_bkupwas_13oct()
    {   
    $order_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;
    $merchant_id= isset($_REQUEST['merchant_id'])?$_REQUEST['merchant_id']:0;
    $device_uiid= isset($_REQUEST['device_uiid'])?$_REQUEST['device_uiid']:0;
    $order_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;

    $status="Complete";
    //$reference_id= isset($_REQUEST['order_id'])?$_REQUEST['order_id']:0;
    //  if(isset($reference_id) && !empty($reference_id) && $reference_id>0){}else{$this->msg = $this->t("Order Id is Required");$this->output();}
    
    //$data=Yii::app()->functions->getOrder($reference_id);
    //$amount_to_pay=normalPrettyPrice($data['total_w_tax']);
    
        $params_update=array('status'=>'Complete','date_modified'=>$this->functions->dateNow());            
        if($this->functions->updateData("mt_order",$params_update,'order_id',$order_id)){   
    

        $res=$this->functions->getOrderInfo($order_id); 
            
        $client_id=$res['client_id'];

$table_number=$res['table_number'];     

$phone_order=$res['is_phone_order'];
            $cart_id=$res['cart_id'];
            if($cart_id>0){
            
              $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$merchant_id,
                              $client_id,$device_uiid,$status,$cart_id);    
            }else{
                    

                    
            $this->SingleAppClass_pos->handleAll_cash($order_id,$merchant_id,$client_id,$device_uiid,$status);  
             
             
                if($table_number>0){    

                     $this->SingleAppClass_pos->handleAll($order_id,$merchant_id,
                              $client_id,$device_uiid,$status,$table_number);   
                              
                }else{ $this->SingleAppClass_pos->handleAll_cash($order_id,$merchant_id,
                              $client_id,$device_uiid,$status); 
                            }
                             
             
            }
             
             
             
        $this->SingleAppClass_pos->updatePoints($order_id,$status); 
                              
       }

echo json_encode(array('code'=>1,'status'=>'success','response'=>'Your payment hass been done'));       
        
    
    
    }

    
    
    
        public function windverify11()
    {   echo json_encode(array('code'=>1,'status'=>'success','response'=>'Your payment hass been done'));       
    }
    
    
    public function winderror()
    {   echo json_encode(array('code'=>0,'status'=>'error','response'=>'Error on your payment.Timeout'));       
    }
    
    
    public function windcaveRespCardDeclined()
    {   echo json_encode(array('code'=>0,'status'=>'error','response'=>'Error on your payment.Card is declined'));      
    }
    
        public function windcaveRespCancelled()
    {   echo json_encode(array('code'=>0,'status'=>'error','response'=>'Error on your payment.Transaction Cancelled'));     
    }

    public function ActivePhoneOrders()
    {
        
        if(isset($_REQUEST['search']) && !empty($_REQUEST['search'])){
            $search=$_REQUEST['search'];
            
        }else{$search='';}
        $name=$_REQUEST['name'];
            $device_uiid= isset($_REQUEST['device_uiid'])?$_REQUEST['device_uiid']:0;
         $datas=$this->functions->getallactivephoneorders($device_uiid,$this->merchant_id,$search); 
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'PhoneOrders'=>$datas
                );
            } else $this->msg = ("No Active Phone Order Found!"); 
        
        $this->output();
    }   
    
    
    
        public function getClientInfo()
    {
            $client_id= isset($_REQUEST['client_id'])?$_REQUEST['client_id']:0;
        if(isset($client_id) && !empty($client_id) && $client_id>0){}else{$this->msg = ("Client Id is Required");$this->output();}  
        
         $datas=$this->functions->getClientInfobyids($client_id);   
         
         
            if($datas){
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=$datas;
            } else $this->msg = ("No customer found!"); 
        
        $this->output();
    }

    public function updateCartPrice()
{               
    $row = isset($this->data['row']) ? $this->data['row'] : 0;  
    
    $cart_id = isset($_REQUEST['cart_id']) ? $_REQUEST['cart_id'] : 0;  
    $new_price = isset($_REQUEST['updated_price']) ? $_REQUEST['updated_price'] : 0;        
    $quantity = isset($_REQUEST['quantity']) ? $_REQUEST['quantity'] : 0;       

    if (empty($cart_id) || $cart_id <= 0) {
        $this->msg = ("Cart ID is missing");
        $this->output();
    }

    if (empty($new_price) || $new_price <= 0) {
        $this->msg = ("Updated Price is missing");
        $this->output();
    }

    if (empty($quantity) || $quantity <= 0) {
        $this->msg = ("quantity is missing");
        $this->output();
    }

    if ($res = $this->SingleAppClass_pos->getcart_cart_id($this->merchant_id, $cart_id)) {
        $cart = json_decode($res['cart'], true);    

        if (array_key_exists($row, (array)$cart)) {
            $price_parts = explode("|", $cart[$row]['price']);
            
            if ($cart[$row]['discount'] > 0) {
                $dis = $cart[$row]['discount'] * $quantity;
                $new_price = $new_price + $dis;
            }
            
            $orignal_price = $new_price / $quantity;            
            $price_parts[0] = $orignal_price;
            $cart[$row]['price'] = implode("|", $price_parts);

            $this->functions->updateData("mt_pos_cart", array(
                'cart' => json_encode($cart, JSON_FORCE_OBJECT),
                'cart_count' => count($cart),
            ), 'cart_id', $cart_id);

            if (count($cart) < 1) {
                $this->db->query("DELETE FROM mt_pos_cart WHERE cart_id = " . (int)$cart_id . " ");
            }

            $this->code = 1;
            $this->msg = "OK"; 
            $this->details = '';
        } else {
            $this->msg = ("Cannot find cart row");
        }
    } else {
        $this->msg = ("Cart is empty");
    }

    $this->output();
}


    


    public function addtoOrder()
    {               
        
        $code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;      
        if($code_version<2.2){
            $this->getGETData();
            $this->data = $_GET;
        } else {
            $this->getPOSTData();
            $this->data = $_POST;
        }   
            
            $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;

            if($this->data['is_retail']>0){
                $phone_order=0;
            }



        $data = $_POST;         
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0;
        $cart_count = 0;
        $data['merchant_id'] = $this->merchant_id;
        //$device_id = $this->device_uiid;
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];       
            
        }
        
        
         
        
        if($_REQUEST['transaction_type']=='takeaway' || $_REQUEST['transaction_type']=='Takeaway'){
            $_REQUEST['transaction_type']='pickup';
        }
        
        if($_REQUEST['transaction_type']=='Dinein'){
            $_REQUEST['transaction_type']='dinein';
        }
        
            
            $transaction_type = isset($_REQUEST['transaction_type'])?$_REQUEST['transaction_type']:'';  
            
        
        if(isset($transaction_type) && !empty($transaction_type)){$this->data['transaction_type']=$_REQUEST['transaction_type'];}else{$transaction_type=$this->data['transaction_type']='pickup';}
        
        //vvvvvvvv
        $item_id = isset($data['item_id'])?$data['item_id']:'';     
        
        if(!is_numeric($item_id)){
            $this->msg = ("Invalid item id");
            $this->output();
        }
        
        
        $qty = isset($data['qty'])?$data['qty']:'';     
        
        
        if($_REQUEST['variable_price']>0){$data['qty']=$qty=1;}
        
        if($qty>0){         
            if (strpos($qty,'.') !== false) {
               $this->msg = ("invalid quantity");
               $this->output();
            }   
        } else {
            $this->msg = ("invalid quantity");
            $this->output();
        }
        
        if(!$item_details = $this->functions->getFoodItem($item_id)){
            $this->msg = ("Item details not found");
            $this->output();
        }
        if($item_details['merchant_id']!=$this->merchant_id){
            $this->msg = ("Item does not belong to merchant");
            $this->output();
        }       
        $data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
        $data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
        
        
         
        
        /*dump($data);
        die();*/
        
        if(!isset($data['price'])){
            $this->msg = ("Please select price");
            $this->output();
        }
                
        $refresh = 0;
        
        if(!empty($device_id)){         
        
            
            $debug = false; 
            
                        
                /* ----------------- if Phone order-----------------------------   */
                /* ----------------- if Phone order-----------------------------   */               
                
            
                        
                $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
                if($minfouser['pos_cashier_access']==1){
                            $created_by='Cashier';
                    } 
            
        //mmmmmmmmm
            
            // 'cart'=>json_encode(array($data),JSON_FORCE_OBJECT),
            //// item already added $data['is_printed_already']='item already added';
                if($table_number>0){$data['is_printed']=0;$data['is_printed_already']='';}
                
                    
                $cart_count=1;
                $carts_id =$this->functions->insertData("mt_pos_cart",array(
                 'device_id'=>$device_id.'0010',
                 'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
                 'cart'=>json_encode(array($data)),
                 'cart_count'=>$cart_count,
                 'table_number'=>$table_number,
                  'created_id'=>$_REQUEST['pos_user_id'],
                 'created_by'=>$created_by,
                 'is_phone_order'=>0,                
        
                 'date_modified'=>$this->functions->dateNow(),
                 'merchant_id'=>$this->merchant_id
                ));
                 
                
                
                
                
                
                    
                
                    $res=$this->SingleAppClass_pos->getCart_bycartid($device_id,$this->merchant_id,$carts_id);
                
                
                
        
        $this->setMerchantTimezone();
        
        if (!$this->functions->validateSellLimit($this->merchant_id) ){
            //$this->msg =t("This merchant has reach the maximum sells per month");
            //$this->output();
        }
        
        
        //$this->data['transaction_type']='pickup';
        //$this->data['payment_provider']='cod';

            //$this->data['payment_provider']= payment_provider']:'';   
        $this->data['payment_provider'] = isset($_REQUEST['payment_provider'])?$_REQUEST['payment_provider']:'';    
            
        
    
        $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
        $payment_provider = isset($this->data['payment_provider'])?$this->data['payment_provider']:'cod';
        
        
        
        
            //die();
        
            
        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0; 
    
        
        
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
        
        $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
        
        
        if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                    //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }
        
        }
        
         $first_name= isset($_REQUEST['customer_first_name'])?$_REQUEST['customer_first_name']:''; 
         $last_name= isset($_REQUEST['customer_last_name'])?$_REQUEST['customer_last_name']:''; 
         $email_address= isset($_REQUEST['customer_email'])?$_REQUEST['customer_email']:''; 
        
        
        
         $client_id= isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'0'; 
        
        
        
        
        $customer_first_name=''; $customer_last_name =''; $customer_email='';       
        
        $client_id = $client_info['client_id'];     
        $email_address = trim($client_info['email_address']);
        $customer_email = trim($client_info['email_address']);
        $customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
        $customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
        
        
        
        
        /*transaction_type*/
        
        
        if($minfouser['pos_cashier_access']==1){
            
                
        //$this->data['transaction_type']="pickup"; 
        }
        
            $transaction_type=$this->data['transaction_type'];
    
        
        if(empty($delivery_date)){
            //$this->msg = ("Delivery date is required");
            //$this->output();
        }
        
        if(empty($payment_provider)){
            //$this->msg = ("Payment provider is empty. please go back and try again");
            //$this->output();
        }
        
        $full_delivery = "$delivery_date $delivery_time";       
        $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
        $delivery_time_formated = '';
        if(!empty($delivery_time)){
            $delivery_time_formated=date('h:i A',strtotime($delivery_time));
        } else $delivery_time_formated = date('h:i A');
                        
                
            
        /*CHECK PRE ORDER*/
        $date_today = date("Y-m-d");        
    
        /*END PRE ORDER*/
                
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:date("Y-m-d");
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:date('h:i A');
        //naxxxx          
        
        
        

        
        if($res){
            $cart=json_decode($res['cart'],true);           
            
            $card_fee = 0; $card_percentage=0;
            
            /*Custom code 10 starts */
            
                        $n_total = $res['cart_subtotal'];   
            
                        
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>$card_fee
            );
            if($card_percentage>0){
               $data['card_percentage']=$card_percentage;
            }    
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }                   

            /*POINTS*/
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }                               
            //dump($data);die();
            
            /*DELIVERY FEE*/
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $raw = $displayOrderHTML['raw'];
                
                /*EURO TAX*/
               $is_apply_tax = 0;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
                   $raw['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/             
                
                $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
                if(empty($donot_apply_tax_delivery)){
                    $donot_apply_tax_delivery=1;
                }
                
                if($card_percentage>0){
                    $card_fee = (float) $raw['total']['card_fee'];
                }
                
                $params = array(
                  'merchant_id'=>$this->merchant_id,                  
                  'client_id'=>isset($client_id)?$client_id:'0',
                  'json_details'=>$res['cart'],
                  'trans_type'=>$transaction_type,
                  'payment_type'=>$this->data['payment_provider'],
                  'sub_total'=>$raw['total']['subtotal'],
                  'tax'=>$raw['total']['tax'],
                  'taxable_total'=>$raw['total']['taxable_total'],
                  'total_w_tax'=>isset($raw['total']['total'])?$raw['total']['total']:0,
                  'delivery_charge'=>isset($raw['total']['delivery_charges'])?$raw['total']['delivery_charges']:0,
                  'delivery_date'=>$delivery_date,
                  'delivery_time'=>$delivery_time,
                  'delivery_asap'=>isset($this->data['delivery_asap'])?$this->data['delivery_asap']:'',
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'delivery_instruction'=>isset($res['delivery_instruction'])?$res['delivery_instruction']:'',
                  'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',
                  'order_change'=>isset($this->data['order_change'])?$this->data['order_change']:0,
                  'pos_user_id'=>isset($minfouser['merchant_user_id'])?$minfouser['merchant_user_id']:0,
                  'table_number'=>$table_number,
                  'payment_provider_name'=>'',
                  'card_fee'=>$card_fee,                  
                  'created_by'=>$created_by,
                  'created_name'=>$created_name,                              
                  'packaging'=>$raw['total']['merchant_packaging_charge'],
                  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
                  'order_id_token'=>$this->functions->generateOrderToken(),
                //  'request_from'=>"single_mob",
                  'request_from'=>"pos",
                  'apply_food_tax'=>$is_apply_tax,      
                  'is_phone_order'=>isset($phone_order)?$phone_order:0,
                  'cart_id'=>isset($cart_id)?$cart_id:0,    
                  'is_retail'=>isset($this->data['is_retail'])?$this->data['is_retail']:0,
                  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
                );
                
                
                
                
            //  print_r($params);die();
                //get-last-order
                
                $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);
                if($get_id_orders>=0){$params['order_number']=$get_id_orders+1;}else{$params['order_number']=1;}
                
                
                
                
                
                $order_id_token = $params['order_id_token'];
                
                /*TIPS*/
                if(isset($raw['total']['tips'])){
                    if($raw['total']['tips']>0.0001){
                        $params['cart_tip_percentage']= $raw['total']['cart_tip_percentage'];
                        $params['cart_tip_value']= $raw['total']['tips'];
                    }               
                }           
                                
                switch ($transaction_type) {
                    case "dinein":
                        $params['dinein_number_of_guest'] = isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction'] = isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
                        
                        $params['dinein_table_number'] = isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:'';
                        
                        if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                        }                       
                        break;
                        
                    case "pickup":   
                          if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                          }                     
                        break;
                        
                    
                    default:
                        break;
                }
                    
                /*DEFAULT ORDER STATUS*/                
                
                
                
                        $params['payment_provider_name']=$payment_provider;
                
                         $params['status']='paid';  
                /*PROMO*/                       
                //dump($raw);
                if (isset($raw['total']['discounted_amount'])){
                    if ($raw['total']['discounted_amount']>=0.0001){                            
                        $params['discounted_amount']=$raw['total']['discounted_amount'];
                        $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
                    }
                }
                
                /*VOUCHER*/
                if(!empty($res['voucher_details'])){
                    $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
                    if(is_array($voucher_details) && count($voucher_details)>=1){
                        $params['voucher_amount']=$voucher_details['amount'];
                        $params['voucher_code']=$voucher_details['voucher_name'];
                        $params['voucher_type']=$voucher_details['voucher_type'];
                    }
                }
                
                /*POINTS*/
                if($res['points_amount']>0.0001){
                    $params['points_discount']=$res['points_amount'];
                }   
                
                
                $params['status']='Complete';
                
                
                
                if ($params['request_from']="pos")
                        {
                            $params['percent_commision']=0;
                            $params['total_commission']=0;
                            $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                        }

                if(!is_numeric($params['cc_id'])){
                    unset($params['cc_id']);
                }
                if(!is_numeric($params['order_change'])){
                    unset($params['order_change']);
                }
                                                
                /*BEGIN INSERT ORDER*/              
                if(!is_numeric($params['sub_total'])){
                    $params['sub_total']=0;
                }           
                if(!is_numeric($params['tax'])){
                    $params['tax']=0;
                }           
                if(!is_numeric($params['taxable_total'])){
                    $params['taxable_total']=0;
                }           
                if(!is_numeric($params['total_w_tax'])){
                    $params['total_w_tax']=0;
                }
                
                if(isset($params['order_change'])){
                    if(!is_numeric($params['order_change'])){
                        $params['order_change']=0;
                    }           
                }
                if(!is_numeric($params['card_fee'])){
                    $params['card_fee']=0;
                }           
                if(!is_numeric($params['packaging'])){
                    $params['packaging']=0;
                }           
                if(!is_numeric($params['donot_apply_tax_delivery'])){
                    unset($params['donot_apply_tax_delivery']);
                }           
                if(!is_numeric($params['apply_food_tax'])){
                    unset($params['apply_food_tax']);
                }           
                
                if(isset($params['percent_commision'])){
                    if(!is_numeric($params['percent_commision'])){
                        $params['percent_commision']=0;
                    }           
                }
                
                if(isset($params['total_commission'])){
                    if(!is_numeric($params['total_commission'])){
                        $params['total_commission']=0;
                    }           
                }
                
                if(isset($params['merchant_earnings'])){
                    if(!is_numeric($params['merchant_earnings'])){
                        $params['merchant_earnings']=0;
                    }           
                }               
                

                    
                if( $order_id=$this->functions->insertData("mt_order",$params)){
                    
                    
                    $params_history=array(
                      'order_id'=>$order_id,
                      'status'=>'Complete',     
                      'remarks'=>'',
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );          
                    if ($params['payment_type']=="windcave"){
                
            }else{
                $this->functions->insertData("mt_order_history",$params_history);
                    
                
            }
                    
                    
                    
                    $next_step = "receipt";
                    
                    /*SAVE ITEM */                  
                    foreach ($raw['item'] as $val) {                                
                        $params_order_details=array(
                          'order_id'=>isset($order_id)?$order_id:'',
                          'client_id'=>isset($client_id)?$client_id:'0',
                          'item_id'=>isset($val['item_id'])?$val['item_id']:'',
                          'item_name'=>isset($val['item_name'])?$val['item_name']:'',
                          'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
                          'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
                          'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
                          'size'=>isset($val['size_words'])?$val['size_words']:'',
                          'qty'=>isset($val['qty'])?$val['qty']:'',                               
                          'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
                          'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                          'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
                          'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
                        );
                        /*inventory*/
                        $new_fields=array('size_id'=>"size_id");
                        if ( $this->functions->checkTableFields('order_details',$new_fields)){
                            $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
                            $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
                        }           
                        $this->functions->insertData("mt_order_details",$params_order_details);
                        
                        /*inventory*/
                        if ($this->functions->checkIfTableExist('order_details_addon')){
                            if(isset($val['sub_item'])){
                                if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                                    foreach ($val['sub_item'] as $sub_item_data) {
                                        $this->functions->insertData("mt_order_details_addon",array(
                                          'order_id'=>$order_id,
                                          'subcat_id'=>$sub_item_data['subcat_id'],
                                          'sub_item_id'=>$sub_item_data['sub_item_id'],
                                          'addon_price'=>$sub_item_data['addon_price'],
                                          'addon_qty'=>$sub_item_data['addon_qty'],
                                        ));
                                    }
                                }                           
                            }
                        }
                        
                    }
                    
                    /*SAVE DELIVERY ADDRESS*/
                    $params_address = array();
                    
                    /*SAVE DELIVERY ADDRESS*/
                    if ( $transaction_type=="pickup"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:''                        
                        );
                    } elseif ( $transaction_type=="dinein"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
                          'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
                          'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
                          'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
                        );
                    }
                    
                
                                        
                
                    
                    
                    
                    $this->code = 1;
                    
                    

                    
                    

                    $this->msg = "Your order has been placed. Reference # ".$order_id;
                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                      
                        
                    $client_info = array( 
                      'first_name'=>$client_info['first_name'],
                      'last_name'=>$client_info['last_name'],
                      'email_address'=>$client_info['email_address'],
                      'contact_phone'=>$client_info['contact_phone'],                     
                    );
                    
                   

                    $payment_description = "Payment to merchant ".$this->functions->clearString($this->merchant_name);

                    
                    $total = number_format($params['total_w_tax'],2,'.','');
                    
                    
                    
                    
                    
                    $resp = $this->SingleAppClass_pos->prepareReceipt($order_id);
                    
                    $resp['timezone']=date_default_timezone_get();
            
                          
                        $stmt = $this->db->prepare("DELETE FROM mt_pos_cart WHERE cart_id = ?");
                        $stmt->execute([$carts_id]);


            //+++was code      
                    foreach ($resp as $key => $val) {
    if ($key !== 'total_amount' && $key !== 'total_amount_by_100') {
        if (is_array($val)) {
            foreach ($val as $subKey => $subVal) {
                if (is_int($subVal) || is_float($subVal)) {
                    $resp[$key][$subKey] = (string)$subVal;
                }
            }
        } elseif (is_int($val) || is_float($val)) {
            $resp[$key] = (string)$val;
        }
    }
}
//---was code

// Convert all nulls in $resp to empty strings
array_walk_recursive($resp, function (&$v) {
    if (is_null($v)) {
        $v = "";
    }
});

// Ensure merchant_id is string (in main data and nested json_details if string)
if (isset($resp['data']['merchant_id'])) {
    $resp['data']['merchant_id'] = (string)$resp['data']['merchant_id'];
}
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Fix merchant_id in json_details to be quoted
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}

// Ensure sub_total, tax, taxable_total are strings if present
foreach (['sub_total', 'tax', 'taxable_total', 'total_w_tax'] as $key) {
    if (isset($resp['data'][$key])) {
        $resp['data'][$key] = (string)round((float)$resp['data'][$key], 2);
    }
}

// Total amount as formatted string
$total = isset($params['total_w_tax']) ? round((float)$params['total_w_tax'], 2) : 0;
        
                    
                    
                    $this->details=array(
                      'order_id'=>$order_id,
                      'order_detail'=>$resp,
                      'total_amount'=>$params['total_w_tax'],
                      'total_amount_by_100'=>$total*100,
                      'total_amount_formatted'=>$total,
                      'payment_provider'=>$payment_provider,
                      'next_step'=>$next_step,
                      'currency_code'=>$this->functions->getCurrencyCode(),
                      'payment_description'=>$payment_description,
                      'merchant_name'=>$this->functions->clearString($this->merchant_name),
                      'provider_credentials'=>$provider_credentials,
                      'redirect_url'=>$redirect_url,
                      'client_info'=>$client_info
                    );
                    
                    
        
                } else $this->msg = ("Something went wrong cannot insert records. please try again later");
                
            
        
        

                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                            
            
                
        } else $this->msg = ("Device id is empty. please restart the application and try again");
        $this->output();
    }
    
    }



    


    


    









    










    
















    

    



    

        



//+++was new code for pos api

public function getSettings()
    {
            
              $points_enabled = $this->functions->getOptionAdmin('points_enabled');
                  if($points_enabled=="1"){
                      if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                          $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                          if($mt_disabled_pts==2){
                              $points_enabled="0";
                             $points_base_amount="0";
                             $points_min_spend="0";
                             $points_rate="0";
                          }else{
                             $points_enabled="1";

                             $points_base_amount_admin=$this->functions->getOptionAdmin('pts_earning_points_value');
                             $points_min_spend_admin=$this->functions->getOptionAdmin('pts_earn_above_amount');
                             $points_rate_admin=$this->functions->getOptionAdmin('pts_earning_points');

                             $points_base_amount=$this->functions->getOption('mt_pts_earning_points_value',$this->merchant_id);
                             $points_min_spend=$this->functions->getOption('mt_pts_earn_above_amount',$this->merchant_id);
                             $points_rate=$this->functions->getOption('mt_pts_earning_points',$this->merchant_id);

                             if($points_base_amount==""||$points_base_amount<=0){
                                $points_base_amount=$points_base_amount_admin;
                             }

                             if($points_min_spend==""||$points_min_spend<=0){
                                $points_min_spend=$points_min_spend_admin;
                             }

                             if($points_rate==""||$points_rate<=0){
                                $points_rate=$points_rate_admin;
                             }

                          }                       
                      }else{

                        $points_enabled="1";
                        $points_base_amount=$this->functions->getOptionAdmin('pts_earning_points_value');
                        $points_min_spend=$this->functions->getOptionAdmin('pts_earn_above_amount');
                        $points_rate=$this->functions->getOptionAdmin('pts_earning_points');

                      }
                  }else{
                     $points_enabled="0";
                     $points_base_amount="0";
                     $points_min_spend="0";
                     $points_rate="0";
                  }
    
              $keys=$this->functions->getOption('google_map_api_key',$this->merchant_id);       
              
               $google_default_country=$this->functions->getOptionAdmin('google_default_country');      
                $admin_country_set=$this->functions->getOptionAdmin('admin_country_set');       
                
      

      $currency_code=$this->functions->getCurrencyCode_dunamics(); 

                $tax=$this->functions->getOption('merchant_tax',$this->merchant_id);  
                $merchant_packaging_wise=$this->functions->getOption('merchant_packaging_wise',$this->merchant_id); 
                $merchant_packaging_charge=$this->functions->getOption('merchant_packaging_charge',$this->merchant_id); 
                $merchant_packaging_increment=$this->functions->getOption('merchant_packaging_increment',$this->merchant_id);
                $merchant_delivery_charges=$this->functions->getOption('merchant_delivery_charges',$this->merchant_id);



                if($tax==""){
                    $tax="0";
                    $tax_enabled="0";
                }else{
                    $tax_enabled="1";
                }   

                if($merchant_packaging_wise==""){
                    $merchant_packaging_wise="0";

                    $get_merchant_packaging_settings="from merchant";
                }else{
                    $get_merchant_packaging_settings="from item";
                }



                if($merchant_packaging_charge==""){
                    $merchant_packaging_charge="0";
                    $merchant_packaging_enabled="0";
                }else{
                     $merchant_packaging_enabled="1";
                }

                if($merchant_delivery_charges==""){
                    $merchant_delivery_charges="0";
                }

                if($merchant_packaging_increment==""){
                    $merchant_packaging_increment="0";
                    $merchant_packaging_increment_description="Dont need to multiply keep as it is";
                }else{
                    $merchant_packaging_increment="1";
                    $merchant_packaging_increment_description="Need to multiply with quantity";
                }
                
                
                
                if($google_default_country=='yes'){}else{
                $google_default_country='no';   
                }
                
                 $fast_order=$this->functions->getOption('fast_order',$this->merchant_id);      
                if($fast_order>0){}else{$fast_order=0;}
              
                //$fast_order=1;
                $this->code = 1;
                $this->msg = ("ok");
                $this->details=array(
                  'is_fast_order'=>$fast_order,               
                   'google_api_key'=>$keys,
                   'tax'=>$tax,
           'currency_code'=>$currency_code,
                   'tax_enabled'=>$tax_enabled,
                   'get_merchant_packaging_settings'=>$get_merchant_packaging_settings,
                   'merchant_packaging_enabled'=>$merchant_packaging_enabled,

                   'merchant_packaging_increment_description'=>$merchant_packaging_increment_description,

                   'points_enabled'      => empty($points_enabled) ? "0" : $points_enabled,
                    'points_base_amount' => empty($points_base_amount) ? "0" : $points_base_amount,
                    'points_min_spend'   => empty($points_min_spend) ? "0" : $points_min_spend,
                    'points_rate'        => empty($points_rate) ? "0" : $points_rate,



                  
                   'merchant_packaging_charges'=>$merchant_packaging_charge,
                   'merchant_packaging_increment'=>$merchant_packaging_increment,
                   'merchant_delivery_charges'=>$merchant_delivery_charges,
                  'google_default_country'=>$google_default_country,
                  'country_set'=>$admin_country_set,
                );
         
        
        $this->output();
    }






    public function inventorychk()
    {               
        
        $code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;      
        if($code_version<2.2){
            $this->getGETData();
            $this->data = $_GET;
        } else {
            $this->getPOSTData();
            $this->data = $_POST;
        }   
            
        $data = $_POST;     


        
        

        $data['merchant_id'] = strval($this->merchant_id);
        //$device_id = $this->device_uiid;
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];       
            
        }

        if (isset($data['last_quantity_saved']) && intval($data['last_quantity_saved']) > 0) {
            $last_quantity_saved = intval($data['last_quantity_saved']);
        } else {
            $last_quantity_saved = 0;
        }

        
        //vvvvvvvv
        $item_id = isset($data['item_id'])?$data['item_id']:'';     
        
        if(!is_numeric($item_id)){
            $this->msg = ("Invalid item id");
            $this->output();
        }
        
        $qty = isset($data['qty'])?$data['qty']:'';     
        
        if($qty>0){         
            if (strpos($qty,'.') !== false) {
               $this->msg = ("invalid quantity");
               $this->output();
            }   
        } else {
            $this->msg = ("invalid quantity");
            $this->output();
        }
        
        if(!$item_details = $this->functions->getFoodItem($item_id)){
            $this->msg = ("Item details not found");
            $this->output();
        }
        if($item_details['merchant_id']!=$this->merchant_id){
            $this->msg = ("Item does not belong to merchant");
            $this->output();
        }       
        
         
        if(!isset($data['price'])){
            $this->msg = ("Please select price");
            $this->output();
        }


                
        
        
        
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass_pos->inventoryEnabled($merchant_id)){
                  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
                  $current_item_price = isset($data['price'])?$data['price']:'';        
                  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
                  $inv_qty = isset($data['qty'])?(integer)$data['qty']:1;   
                  
                  $inv_qty=$inv_qty+$last_quantity_saved;


                      
                                                              
                  try {
                     $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);

                    $this->code = 1;
                    $this->msg = "Inventory enabled";
                    $this->details = array(
                        'inventory_enabled' => "1",
                        'stock_verified' => "1",
                    );
                    $this->output();

                  } catch (Exception $e) {
                    
                    /*$this->msg = $e->getMessage();
                    $this->output();*/


                    $this->code = 1;
                    $this->msg = "Inventory enabled";
                    $this->details = array(
                        'inventory_enabled' => "1",
                        'stock_verified' => "0",
                    );
                    $this->output();

                  }                   
                }else{

                    $this->code = 1;
                    $this->msg = "Inventory not enabled";
                    $this->details = array(
                        'inventory_enabled' => "0",
                        'stock_verified' => "1",
                    );
                    $this->output();
                }




            
    }


public function applyVoucher_offline()
{
    $this->code = 0;
    $voucher_name = isset($this->data['voucher_name']) ? $this->data['voucher_name'] : '';
    $subtotal = isset($this->data['subtotal']) ? floatval($this->data['subtotal']) : 0;

    if (!empty($voucher_name)) {
        if ($res = $this->SingleAppClass_pos->getVoucherMerchant($client_id, $voucher_name, $this->merchant_id)) {
            $voucher_type = 'merchant';
        } else {
            $voucher_type = 'admin';
            $res = $this->SingleAppClass_pos->getVoucherMerchant($client_id, $voucher_name);
        }

        if ($res) {
            // Expiry check
            if (!empty($res['expiration'])) {
                $expiration = $res['expiration'];
                $now = date('Y-m-d');
                $date_diff = date_diff(date_create($now), date_create($expiration));
                if (is_object($date_diff) && $date_diff->invert == 1 && $date_diff->d > 0) {
                    $this->msg = "Voucher code has expired";
                    $this->details = array(
                        'can_use' => "0",
                        'discount_amount' => 0,
                        'voucher' => array(
                            'voucher_id'   => $res['voucher_id'],
                            'voucher_name' => $res['voucher_name'],
                            'amount'       => $res['amount'],
                            'voucher_type' => $res['voucher_type'],
               'min_order'   => isset($res['min_order']) ? $res['min_order'] : 0,
                        ),
                    );
                    $this->output();
                }
            }

            // Check joining merchant
            if ($voucher_type == "admin" && !empty($res['joining_merchant'])) {
                $joining_merchant = json_decode($res['joining_merchant']);
                if (!in_array($this->merchant_id, (array)$joining_merchant)) {
                    $this->msg = "Sorry this voucher code cannot be used on this merchant";
                    $this->details = array(
                        'can_use' => "0",
                        'discount_amount' => 0,
                        'voucher' => array(
                            'voucher_id'   => $res['voucher_id'],
                            'voucher_name' => $res['voucher_name'],
                            'amount'       => $res['amount'],
                            'voucher_type' => $res['voucher_type'],
                        ),
                    );
                    $this->output();
                }
            }
           
            // ✅ Minimum amount check
            if (!empty($res['min_order']) && floatval($subtotal) < floatval($res['min_order'])) {
                $this->msg = "Sorry cannot be applied because minimum amount is " . floatval($res['min_order']);
                $this->details = array(
                    'can_use' => "0",
                    'discount_amount' => 0,
                    'voucher' => array(
                        'voucher_id'   => $res['voucher_id'],
                        'voucher_name' => $res['voucher_name'],
                        'amount'       => $res['amount'],
                        'voucher_type' => $res['voucher_type'],
                        'min_order'   => isset($res['min_order']) ? $res['min_order'] : 0,
                    ),
                );
                $this->output();
            }

            // Calculate discount
            $discount_amount = 0;
            if (strtolower($res['voucher_type']) == 'percentage') {
                $discount_amount = ($subtotal * floatval($res['amount'])) / 100;
            } else {
                $discount_amount = floatval($res['amount']);
            }

            // Prevent negative total
            if ($subtotal - $discount_amount < 0) {
                $this->msg = "Voucher cannot be applied as voucher exceeds subtotal.";
                $this->details = array(
                    'can_use' => "0",
                    'discount_amount' => 0,
                    'voucher' => array(
                        'voucher_id'   => $res['voucher_id'],
                        'voucher_name' => $res['voucher_name'],
                        'amount'       => $res['amount'],
                        'voucher_type' => $res['voucher_type'],
             'min_order'   => isset($res['min_order']) ? $res['min_order'] : 0,
                    ),
                );
                $this->output();
            }
			$this->code = 1;
            // Success response
            $this->msg = "Voucher can be applied";
            $this->details = array(
                'can_use' => "1",
                'discount_amount' => number_format($discount_amount, 2, '.', ''),
                'voucher' => array(
                    'voucher_id'   => $res['voucher_id'],
                    'voucher_name' => $res['voucher_name'],
                    'amount'       => $res['amount'],
                    'voucher_type' => $res['voucher_type'],
                    'min_order'   => isset($res['min_order']) ? $res['min_order'] : 0,
                ),
            );
            $this->output();
        } else {
			$this->code = 0;
            $this->msg = "No voucher found";
            $this->details = array(
                'can_use' => "0",
                'discount_amount' => 0,
                'voucher' => "",
            );
            $this->output();
        }
    }
}







public function applyRedeemPoints_posoffline()
{
    $points = isset($this->data['points']) ? $this->data['points'] : 0;

    $this->code = 1;

    if ($points <= 0.0001) {
        $this->msg = ("Invalid redeem points");
        $this->details = array(
            'can_apply' => "0", 
        );
        $this->output();
    }

    $client_id = isset($this->data['client_id']) ? $this->data['client_id'] : 0;
    $client_info = $this->functions->getClientInfo($client_id);

    if ((!$client_info) && $client_id > 0) {
        $this->msg = ("Invalid client detail, please relogin again");
        $this->details = array(
            'can_apply' => "0", 
        );
        $this->output();
    }

    $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
    if ($pts_disabled_redeem == 1) {
        $this->msg = ("Redeeming points is disabled");
        $this->details = array(
            'can_apply' => "0", 
        );
        $this->output();
    }

    $available_points = $this->PointsProgram->getTotalEarnPoints($client_id, $this->merchant_id);
    if ($available_points <= 0 || $points > $available_points) {
        $this->msg = ("Sorry but your points is not enough");
        $this->details = array(
            'can_apply' => "0", 
        );
        $this->output();
    }

    // -----------------
    if (1==1) {   // <--- opened here

        $is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();

        $pts_enabled_offers_discount = $this->functions->getOptionAdmin('pts_enabled_offers_discount');
        if (!$is_disabled_merchant_settings) {
            $mt_pts_enabled_offers_discount = $this->functions->getOption('mt_pts_enabled_offers_discount', $this->merchant_id);
            if ($mt_pts_enabled_offers_discount > 0) {
                $pts_enabled_offers_discount = $mt_pts_enabled_offers_discount;
            }
        }

        $pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');
        if (!$is_disabled_merchant_settings) {
            $mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher', $this->merchant_id);
            if ($mt_pts_enabled_add_voucher > 0) {
                $pts_enabled_add_voucher = $mt_pts_enabled_add_voucher;
            }
        }

        $redeeming_point = $this->functions->getOptionAdmin('pts_redeeming_point');
        $redeeming_point_value = $this->functions->getOptionAdmin('pts_redeeming_point_value');



        if (!$is_disabled_merchant_settings) {
            $mt_pts_redeeming_point = $this->functions->getOption('mt_pts_redeeming_point', $this->merchant_id);
            $mt_pts_redeeming_point_value = $this->functions->getOption('mt_pts_redeeming_point_value', $this->merchant_id);



            if ($mt_pts_redeeming_point > 0) {
                $redeeming_point = $mt_pts_redeeming_point;
            }
            if ($mt_pts_redeeming_point_value > 0) {
                $redeeming_point_value = $mt_pts_redeeming_point_value;
            }
        }

        $subtotal = isset($this->data['subtotal']) ? $this->data['subtotal'] : 0;

        $points_apply_order_amt = $this->functions->getOptionAdmin('points_apply_order_amt');
        if (!$is_disabled_merchant_settings) {
            $mt_points_apply_order_amt = $this->functions->getOption('mt_points_apply_order_amt', $this->merchant_id);
            if ($mt_points_apply_order_amt > 0) {
                $points_apply_order_amt = $mt_points_apply_order_amt;
            }
        }
        if ($points_apply_order_amt > 0.0001 && $points_apply_order_amt > $subtotal) {
            $this->msg = "Sorry but you can only redeem points on orders over " . $this->functions->prettyPrice($points_apply_order_amt);
            $this->details = array(
                'can_apply' => "0", 
                'discount_amount' => "0",
                'redeem_value_one_point'=>$redeeming_point_value
            );
            $this->output();
        }

        $points_minimum = $this->functions->getOptionAdmin('points_minimum');
        if (!$is_disabled_merchant_settings) {
            $mt_points_minimum = $this->functions->getOption('mt_points_minimum', $this->merchant_id);
            if ($mt_points_minimum > 0) {
                $points_minimum = $mt_points_minimum;
            }
        }
        if ($points_minimum > 0.0001 && $points_minimum > $points) {
            $this->msg = "Sorry but Minimum redeem points can be used is " . $points_minimum;
            $this->details = array(
                'can_apply' => "0", 
                'discount_amount' => "0",
                 'redeem_value_one_point'=>$redeeming_point_value
            );
            $this->output();
        }

        $points_max = $this->functions->getOptionAdmin('points_max');
        if (!$is_disabled_merchant_settings) {
            $mt_points_max = $this->functions->getOption('mt_points_max', $this->merchant_id);
            if ($mt_points_max > 0.0001) {
                $points_max = $mt_points_max;
            }
        }
        if ($points_max > 0.0001 && $points_max < $points) {
            $this->msg = "Sorry but Maximum redeem points can be used is " . $points_max;
            $this->details = array(
                'can_apply' => "0", 
                'discount_amount' => "0",
                 'redeem_value_one_point'=>$redeeming_point_value
            );
            $this->output();
        }

        $temp_redeem = intval($this->data['points'] / $redeeming_point);
        $points_amount = $temp_redeem * $redeeming_point_value;



        $new_balance = $subtotal - $points_amount;
        if ($new_balance <= 0) {
            $this->msg = ("Sorry you cannot redeem points which the Sub Total will become negative when after applying the points");
            $this->details = array(
                'can_apply' => "0", 
                'discount_amount' => "0",
                'redeem_value_one_point'=>$redeeming_point_value
            );
            $this->output();
        }

        $this->msg = ("Requested points can be applied");
        $this->details = array(
            'can_apply' => "1", 
            'discount_amount' => number_format($points_amount, 2, '.', ''),
            'redeem_value_one_point'=>$redeeming_point_value
        );
        $this->output();

    } // ✅ closed the if(1==1)
} // ✅ closed the function



public function PhoneCustomerRegisters_posoffline()
    {
        
        
        
        
                if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
            
                
        if (isset($this->data['first_name']) && !empty($this->data['first_name'])){}else{           
            

            $this->Validator->setmsg("First Name is missing"); 

        }       
        /*if (isset($this->data['email_address']) && !empty($this->data['email_address'])){}else{           
            
            
            $this->Validator->setmsg("Email Address is missing"); 
        }   */

        if (isset($this->data['phone']) && !empty($this->data['phone'])){}else{         
            

            $this->Validator->setmsg("Phone Number is missing"); 
        }       
        
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];               
        }
        $names=$this->data['first_name'].' '.$this->data['last_name'];                      
        if($this->Validator->validate()){

                
             
                $this->code=1; 
                $this->msg = ("OK"); 
            
                    $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                        
                /* ----------------- if Phone order-----------------------------   */
                /* ----------------- if Phone order-----------------------------   */               
                
            
            
                if ( 1==1){ 

                    
        $distance=0;
        $delivery_fee=0;
        
        $lat=0;
        $lng=0; 
        $complete_address='';
        
        if($this->data['order_type']=='delivery'){
        
        
        $complete_address=$this->data['address'];

        if($complete_address==""){
        $this->code=0;
        $this->msg = ("Address is empty please enter a valid address!");
        $this->output();

        }

            if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                       $lat=$lat_res['lat'];
                       $lng=$lat_res['long'];
                    
            }
        
            $lat = isset($lat)?$lat:0;
            $lng = isset($lng)?$lng:0;  
            
            
            if(isset($lat) && !empty($lat) && isset($lng) && !empty($lng)){
            
            if ($res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            
                $data['merchant_id']=$res['merchant_id'];
                            
                $data['latitude']=$res['latitude'];
                $data['lontitude']=$res['lontitude'];
                                
                $data['delivery_fee'] = '';
                                    
                        $provider = $this->functions->getMapProvider();                                         
                        $params_fee =  array(
                          'merchant_id'=>$res['merchant_id'],
                          'provider'=>$provider,
                          'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
                          'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
                          'to_lat'=>$lat,
                          'to_lng'=>$lng,
                          'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
                          'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
                          'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:'',
                          'order_subtotal'=>0,
                          'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
                        );  
                    //print_r($params_fee); 
                        
                    $resp_fee = $this->CheckoutWrapperTemp->getDeliveryDetails($params_fee);
                    
                
                
                
                    if(isset($resp_fee) && !empty($resp_fee)){
                //print_r($resp_fee);
                $distance=$resp_fee['distance'];
                $delivery_fee=$resp_fee['delivery_fee'];
                
                
                    }else{
                        $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                        
                    }
            
        //$this->output();
        }


            }else{
                $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                
                
            }

        }


         
            
            $email_address=$this->data['email_address'];
    




                $this->code=1;

                
                $this->msg = ("Phone order created");  
                

                $this->details = array(
                    'delivery_fee' => $delivery_fee, 
                     'lat' => number_format($lat, 3, '.', ''),   // always 3 decimals
                     'lng' => number_format($lng, 3, '.', ''),   // always 3 decimals
                     'name'=>$names,
                     'client_id'=>0,
                     'email'=>$email_address,
                     'address'=>$complete_address,
                );
                $this->output();



                    






                    
                    
                }
                
                
            
            
            
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }



    public function PhoneCustomerRegisters_posoffline_bkupbywaseemhassan()
    {
        
        
        
        
                if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
            
                
        if (isset($this->data['first_name']) && !empty($this->data['first_name'])){}else{           
            

            $this->Validator->setmsg("First Name is missing"); 

        }       
        /*if (isset($this->data['email_address']) && !empty($this->data['email_address'])){}else{           
            
            
            $this->Validator->setmsg("Email Address is missing"); 
        }   */

        if (isset($this->data['phone']) && !empty($this->data['phone'])){}else{         
            

            $this->Validator->setmsg("Phone Number is missing"); 
        }       
        
        $device_id = isset($this->device_uiid)?$this->device_uiid:$_REQUEST['device_uiid'];     
        
        if(empty($device_id)){
                $device_id =$_REQUEST['device_uiid'];               
        }
        $names=$this->data['first_name'].' '.$this->data['last_name'];                      
        if($this->Validator->validate()){

                
             
                $this->code=1; 
                $this->msg = ("OK"); 
            
                    $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                        
                /* ----------------- if Phone order-----------------------------   */
                /* ----------------- if Phone order-----------------------------   */               
                
            
            
                if ( 1==1){ 

                    
        $distance=0;
        $delivery_fee=0;
        
        $lat=0;
        $lng=0; 
        $complete_address='';
        
        if($this->data['order_type']=='delivery'){
        
        
        $complete_address=$this->data['address'];

        if($complete_address==""){
        $this->code=0;
        $this->msg = ("Address is empty please enter a valid address!");
        $this->output();

        }

            if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                       $lat=$lat_res['lat'];
                       $lng=$lat_res['long'];
                    
            }
        
            $lat = isset($lat)?$lat:0;
            $lng = isset($lng)?$lng:0;  
            
            
            if(isset($lat) && !empty($lat) && isset($lng) && !empty($lng)){
            
            if ($res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            
                $data['merchant_id']=$res['merchant_id'];
                            
                $data['latitude']=$res['latitude'];
                $data['lontitude']=$res['lontitude'];
                                
                $data['delivery_fee'] = '';
                                    
                        $provider = $this->functions->getMapProvider();                                         
                        $params_fee =  array(
                          'merchant_id'=>$res['merchant_id'],
                          'provider'=>$provider,
                          'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
                          'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
                          'to_lat'=>$lat,
                          'to_lng'=>$lng,
                          'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
                          'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
                          'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:'',
                          'order_subtotal'=>0,
                          'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
                        );  
                    //print_r($params_fee); 
                        
                    $resp_fee = $this->CheckoutWrapperTemp->getDeliveryDetails($params_fee);
                    
                
                
                
                    if(isset($resp_fee) && !empty($resp_fee)){
                //print_r($resp_fee);
                $distance=$resp_fee['distance'];
                $delivery_fee=$resp_fee['delivery_fee'];
                
                
                    }else{
                        $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                        
                    }
            
        //$this->output();
        }


            }else{
                $this->code=0;
                $this->msg = ("Address is invalid please enter a valid address!");
                $this->output();
                
                
            }

        }


         
            $is_customer_registered=0;
            $email_address=$this->data['email_address'];
           if(isset($email_address) && !empty($email_address)){    
        if( $client_info = $this->functions->isClientExist_with_merchant($this->data['email_address'],$this->merchant_id)){
             
             $first_name=$client_info['first_name'];
             $is_customer_registered=1;
             $client_id=$client_info['client_id'];
             $email=$client_info['email_address'];

        }else{
            
                        
            $params2=array(
              'first_name'=>$this->data['first_name'],
              'last_name'=>$this->data['last_name'],
              'email_address'=>($email_address),
              'social_strategy'=>"pos",
              'customer_address'=>$this->data['address']??"",
              'password'=>md5('123456'),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>'',
              'device_platform'=>'',
              'merchant_id'=>$this->merchant_id,
               'single_app_merchant_id'=>$_REQUEST['pos_user_id']??"",
              
             
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params2['email_address']);
                $params2['token']=$token;
                if ($customer_id = $this->functions->insertData("mt_client",$params2)){
                     
        
                $client_info = $this->functions->getClientInfo($customer_id);
                $first_name=$client_info['first_name'];
                $client_id=$client_info['client_id'];
                $email=$client_info['email_address'];
        
        
                }
        }
        
        }




                $this->code=1;

                if($is_customer_registered==1){
                $this->msg = ("Customer already Registered");
                }else{
                  $this->msg = ("Customer Registered");  
                }

                $this->details = array(
                    'delivery_fee' => $delivery_fee, 
                     'lat' => number_format($lat, 3, '.', ''),   // always 3 decimals
                     'lng' => number_format($lng, 3, '.', ''),   // always 3 decimals
                     'name'=>$first_name,
                     'client_id'=>$client_id,
                     'email'=>$email,
                     'address'=>$complete_address,
                );
                $this->output();



                    






                    
                    
                }
                
                
            
            
            
        } else $this->msg = $this->SingleAppClass_pos->parseValidatorError($this->Validator->getError());
        
        $this->output();
    }




public function payNow_pos()
    {
        
        
        $this->setMerchantTimezone();
        
        if (!$this->functions->validateSellLimit($this->merchant_id) ){
            //$this->msg =t("This merchant has reach the maximum sells per month");
            //$this->output();
        }
        
        $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
        $payment_provider = isset($this->data['payment_provider'])?$this->data['payment_provider']:'';
        
        
       $params_logs=array(
                                
                  
                  'response'=>json_encode($this->data)
                ); 
        $this->functions->insertData("mt_response",$params_logs); 

        $params_logs=array(
                                
                  
                  'response'=>json_encode($_REQUEST)
                ); 
        $this->functions->insertData("mt_response",$params_logs); 

        
        
            
        
            
        
        $table_number= isset($_REQUEST['table_number'])?$_REQUEST['table_number']:0; 
    
        
        
        if(isset($_REQUEST['pos_user_id']) && !empty($_REQUEST['pos_user_id'])){}else{$this->msg = ("User ID is missing");$this->output();}
        
        
        if($table_number>0){
            
            
        $res11=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);
        $minfouser=$this->functions->getMerchantUserInfobymid($res11['created_id']);    
        
        
        if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                
                
            //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
                
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }else{
            
            $transaction_type="dinein";
        $this->data['transaction_type']="dinein";
            
            $created_by='waiter';$created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
            if($table_number>0){}else{              
                    $this->msg = ("Table Number is required");
            $this->output();
            }
            
            
            
        }
            
            
            
            
        }else{
        
        $minfouser=$this->functions->getMerchantUserInfobymid($_REQUEST['pos_user_id']);    
        
        
        if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                    //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }else{
                $transaction_type="dinein";
        $this->data['transaction_type']="dinein";
            $created_by='waiter';$created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
            if($table_number>0){}else{              
                    $this->msg = ("Table Number is required");
            $this->output();
            }
            
            
            
        }
        
        }
        
        
         $first_name= isset($_REQUEST['customer_first_name'])?$_REQUEST['customer_first_name']:''; 
         $last_name= isset($_REQUEST['customer_last_name'])?$_REQUEST['customer_last_name']:''; 
         $email_address= isset($_REQUEST['customer_email'])?$_REQUEST['customer_email']:''; 
        
        
        
         $client_id= isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'0'; 
        
        if($client_id>0){}else{
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    /*$cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
                            $res11=$this->SingleAppClass_pos->getCart_bycartid($this->device_uiid,$this->merchant_id,$cart_id); 
                            */
                            // $_REQUEST['client_id']=$res11['clients_id'];
                            
                }   
        
        
        
        }
        
        
        
        
        
        /*
        if($client_id>0){}else{
        if(isset($first_name) && !empty($first_name)){}else{$this->msg = ("first name is missing");$this->output();}
        if(isset($last_name) && !empty($last_name)){}else{$this->msg = ("last name is missing");$this->output();}
        if(isset($email_address) && !empty($email_address)){}else{$this->msg = ("email address  is missing");$this->output();}
        }
        */
        if($client_id>0){
            
            $client_info = $this->functions->getClientInfo($client_id);
        
            
        }else{
            
        if(isset($email_address) && !empty($email_address)){    
        if( $client_info = $this->functions->isClientExist_with_merchant($email_address,$this->merchant_id)){

        }else{
            
                        
            $params2=array(
              'first_name'=>($first_name),
              'last_name'=>($last_name),
              'email_address'=>($email_address),
              'password'=>md5('123456'),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>'',
              'device_platform'=>'',
              'merchant_id'=>$this->merchant_id,
               'single_app_merchant_id'=>$_REQUEST['pos_user_id'],
              
             
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params2['email_address']);
                $params2['token']=$token;
                if ($customer_id = $this->functions->insertData("mt_client",$params2)){
                     
        
                $client_info = $this->functions->getClientInfo($customer_id);
        
        
        
                }
        }
        
        }
        }
        
        $customer_first_name=''; $customer_last_name =''; $customer_email='';       
        
        $client_id = $client_info['client_id'];     
        $email_address = trim($client_info['email_address']);
        $customer_email = trim($client_info['email_address']);
        $customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
        $customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
        
        
        
        
        /*transaction_type*/
        
        
        if($minfouser['pos_cashier_access']==1){
            
                    $transaction_type=$this->data['transaction_type'];
        //$this->data['transaction_type']="pickup"; 
        }
        
        
    
        
        if(empty($delivery_date)){
            //$this->msg = ("Delivery date is required");
            //$this->output();
        }
        
        if(empty($payment_provider)){
            //$this->msg = ("Payment provider is empty. please go back and try again");
            //$this->output();
        }
        
        $full_delivery = "$delivery_date $delivery_time";       
        $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
        $delivery_time_formated = '';
        if(!empty($delivery_time)){
            $delivery_time_formated=date('h:i A',strtotime($delivery_time));
        } else $delivery_time_formated = date('h:i A');
                        
        /*CHECK MERCHANT OPENING HOURS*/
        //dump($delivery_day);dump($delivery_time_formated);        
        if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
            $date_close=date("F,d l Y h:ia",strtotime($full_delivery));
            //$this->msg = Yii::t("singleapp","Sorry but we are closed on [date_close]. Please check merchant opening hours.",array(
            //  '[date_close]'=>$date_close
            //));
            //$this->output();
        }               
            
        /*CHECK PRE ORDER*/
        $date_today = date("Y-m-d");        
    
        /*END PRE ORDER*/
                
        $delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:date("Y-m-d");
        $delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:date('h:i A');
        //naxxxx          
        
        
        
        
        //hhhhhhhhhhhhhhhhhhhhhhh
        $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
        if($this->data['is_retail']>0){
                $phone_order=0;
            }
                if($phone_order>0){
                    $cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        /*if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}
        
                            $res=$this->SingleAppClass_pos->getCart_bycartid($this->device_uiid,$this->merchant_id,$cart_id); */  
                            
                            //nnnnnnnnn
                                //$transaction_type=$res['order_type'];
                            
                            
                    
                }else{
        
        
        
        
        if($minfouser['pos_cashier_access']==1){
            $res=$this->SingleAppClass_pos->getCart($this->device_uiid,$this->merchant_id);             
        }else{
            $res=$this->SingleAppClass_pos->getCart_cashier($this->merchant_id,$table_number);      
        }
        
        
        
                }

       $payload = json_decode(file_get_contents("php://input"), true);

        // Directly use 'items', but reindex them into the same numeric format
      $cart = [];

        if (!empty($payload['items'])) {
            foreach ($payload['items'] as $item) {
                $cart[] = $item; // keep full item structure, no stripping
            }
        }


       

                
        if(1==1){

            //$cart=json_decode($res['cart'],true);  
            
           //print_r($cart);die();
            
            $card_fee = 0; $card_percentage=0;
            
            /*Custom code 10 starts */
            
            $n_total = $this->data['sub_total'];   


                    
             // $resp=$this->SingleAppClass_pos->getCart($this->device_uiid , $this->merchant_id);
             // $n_total = $resp['cart_subtotal'];
                
           /*Custom code 10 ends */
            
            //dump($payment_provider);
            
            /*CARD FEE*/
            
                        
                        
            
                        
                        
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>$card_fee
            );
            if($card_percentage>0){
               $data['card_percentage']=$card_percentage;
            }    
            
            //$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
 
            if (
    isset($this->data['voucher_name'], $this->data['voucher_amount'], $this->data['voucher_type']) &&
    !empty($this->data['voucher_name']) &&
    !empty($this->data['voucher_amount']) &&
    !empty($this->data['voucher_type'])
) {
    $data['voucher_name']  = $this->data['voucher_name'];
    $data['voucher_amount'] = $this->data['voucher_amount'];
    $data['voucher_type']   = $this->data['voucher_type'];
}

            
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }                   

            /*POINTS*/
            /*if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            } */

            if (
            isset($this->data['points_amount']) &&
            !empty($this->data['points_amount']) &&
            $this->data['points_amount'] > 0.0001
            ) {
            $data['points_amount'] = $this->data['points_amount'];
           }
           

            //dump($data);die();
            
            /*DELIVERY FEE*/
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){

            	
                $raw = $displayOrderHTML['raw'];
                
                /*EURO TAX*/
               $is_apply_tax = 0;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
                   $raw['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/             
                
                $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
                if(empty($donot_apply_tax_delivery)){
                    $donot_apply_tax_delivery=1;
                }
                
                if($card_percentage>0){
                    $card_fee = (float) $raw['total']['card_fee'];
                }


                    switch ($payment_provider) {
                
                    
                

                   case "windcave": 
                    if($credentials = $this->functions->getCredentials_windcave($this->merchant_id)){
                        //print_r($credentials);die();
                        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $this->data['grand_total']*$credentials['card_fee']/100;
                            
                          }
                       }

                       $data['card_fee']=$card_fee;

                    }  
                   break;    

                   
                                                      
                default:
                    break;
            }
              

                
              
          
                  $params = array(
                  'merchant_id'=>$this->merchant_id,                  
                  'client_id'=>isset($client_id)?$client_id:'0',
                  'json_details'=>json_encode($cart),
                  'trans_type'=>$transaction_type,
                  'payment_type'=>$this->data['payment_provider'],
                  'sub_total'=>$this->data['sub_total'],
                  'tax'=>$this->data['tax']/100,
                  'taxable_total'=>$this->data['taxable_total'],
                  'total_w_tax'=>$this->data['grand_total'],
                  'delivery_charge'=>$this->data['delivery_charge'],
                  'delivery_date'=>$delivery_date,
                  'delivery_time'=>$delivery_time,
                  'delivery_asap'=>isset($this->data['delivery_asap'])?$this->data['delivery_asap']:'',
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
                  'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',
                  'order_change'=>isset($this->data['order_change'])?$this->data['order_change']:0,
                  'pos_user_id'=>isset($minfouser['merchant_user_id'])?$minfouser['merchant_user_id']:0,
                  'table_number'=>$table_number,
                  'payment_provider_name'=>'',
                  'card_fee'=>$card_fee,                  
                  'created_by'=>$created_by,
                  'created_name'=>$created_name,                              
                  'packaging'=>$this->data['packaging_charge'],
                  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
                  'order_id_token'=>$this->functions->generateOrderToken(),
                //  'request_from'=>"single_mob",
                  'request_from'=>"pos",
                  'apply_food_tax'=>$is_apply_tax,      
                  'is_phone_order'=>isset($phone_order)?$phone_order:0,
                  'cart_id'=>isset($cart_id)?$cart_id:0,    
                  'is_retail'=>isset($this->data['is_retail'])?$this->data['is_retail']:0,
                  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
                );



                


                
                
                
                
                if($phone_order==1){
                    $params['client_names']=$this->data['customer_name'];
                   $params['email'] = isset($this->data['customer_email']) && !empty($this->data['customer_email']) 
                    ? $this->data['customer_email'] 
                    : "";

                    $params['phones']=$this->data['phone_no'];
                    $params['address'] = isset($this->data['address']) && !empty($this->data['address']) 
                    ? $this->data['address'] 
                    : "";          
                    
                }
                
                
                //print_r($params);
                //die();
                
                
                //get-last-order
                
                $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);
                if($get_id_orders>=0){$params['order_number']=$get_id_orders+1;}else{$params['order_number']=1;}
                
                
                
                
                
                $order_id_token = $params['order_id_token'];
                
                       
                                
                switch ($transaction_type) {
                    case "dinein":
                        $params['dinein_number_of_guest'] = isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction'] = isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
                        
                        $params['dinein_table_number'] = isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:'';
                        
                        if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                        }                       
                        break;
                        
                    case "pickup":   
                          if(isset($this->data['contact_phone']) && $client_id>0){
                            if(!empty($this->data['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',$client_id);
                            }
                          }                     
                        break;
                        
                    case "delivery":
                        $delivery_asap = '';
                        if(isset($this->data['delivery_asap'])){
                            $delivery_asap = $this->data['delivery_asap']=="true"?1:'';
                            $params['delivery_asap'] = $delivery_asap;
                        }
                        break;
                
                    default:
                        break;
                }
                    
                /*DEFAULT ORDER STATUS*/                
                
                
                
                        $params['payment_provider_name']=$payment_provider;
                
                         $params['status']='paid';  
                /*PROMO*/                       
                //dump($raw);
               /* if (isset($raw['total']['discounted_amount'])){
                    if ($raw['total']['discounted_amount']>=0.0001){                            
                        $params['discounted_amount']=$raw['total']['discounted_amount'];
                        $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
                    }
                }*/
                
                /*VOUCHER*/
                

                  if (
    isset($this->data['voucher_name'], $this->data['voucher_amount'], $this->data['voucher_type']) &&
    !empty($this->data['voucher_name']) &&
    !empty($this->data['voucher_amount']) &&
    !empty($this->data['voucher_type'])
) {
    $params['voucher_code']  = $this->data['voucher_name'];
    $params['voucher_amount'] = $this->data['voucher_amount'];
    $params['voucher_type']   = $this->data['voucher_type'];
}

                
                /*POINTS*/
                /*if($res['points_amount']>0.0001){
                    $params['points_discount']=$res['points_amount'];
                }   */

                if (
                    isset($this->data['points_amount']) &&
                    !empty($this->data['points_amount']) &&
                    $this->data['points_amount'] > 0.0001
                ) {
                    $params['points_discount'] = $this->data['points_amount'];
                 }

                
                
                
                if ($params['payment_type']=="windcave"){
                $params['status']='initial_order';
            }else{
                $params['status']='Complete';
                
            }
                
                
                if ($params['request_from']="pos")
                        {
                            $params['percent_commision']=0;
                            $params['total_commission']=0;
                            $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                        }

                if(!is_numeric($params['cc_id'])){
                    unset($params['cc_id']);
                }
                if(!is_numeric($params['order_change'])){
                    unset($params['order_change']);
                }
                                                
                /*BEGIN INSERT ORDER*/              
                if(!is_numeric($params['sub_total'])){
                    $params['sub_total']=0;
                }           
                if(!is_numeric($params['tax'])){
                    $params['tax']=0;
                }           
                if(!is_numeric($params['taxable_total'])){
                    $params['taxable_total']=0;
                }           
                if(!is_numeric($params['total_w_tax'])){
                    $params['total_w_tax']=0;
                }
                
                if(isset($params['order_change'])){
                    if(!is_numeric($params['order_change'])){
                        $params['order_change']=0;
                    }           
                }
                if(!is_numeric($params['card_fee'])){
                    $params['card_fee']=0;
                }           
                if(!is_numeric($params['packaging'])){
                    $params['packaging']=0;
                }           
                if(!is_numeric($params['donot_apply_tax_delivery'])){
                    unset($params['donot_apply_tax_delivery']);
                }           
                if(!is_numeric($params['apply_food_tax'])){
                    unset($params['apply_food_tax']);
                }           
                
                if(isset($params['percent_commision'])){
                    if(!is_numeric($params['percent_commision'])){
                        $params['percent_commision']=0;
                    }           
                }
                
                if(isset($params['total_commission'])){
                    if(!is_numeric($params['total_commission'])){
                        $params['total_commission']=0;
                    }           
                }
                
                if(isset($params['merchant_earnings'])){
                    if(!is_numeric($params['merchant_earnings'])){
                        $params['merchant_earnings']=0;
                    }           
                }               
                
                if($transaction_type=="delivery"){          
                   if($res['distance']>0){
                      

                      $params['distance'] = isset($res['distance']) ? $res['distance'] . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '') : '0' . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '');

                   }
                }


                     /*$points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($this->data['sub_total'],$this->merchant_id);
                     echo $points_earn;die();*/
                $params['windcave_offline']=1;


                    
                if( $order_id=$this->functions->insertData("mt_order",$params)){
                    
                    
                    $params_history=array(
                      'order_id'=>$order_id,
                      'status'=>'Complete',     
                      'remarks'=>'',
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );          
                    if ($params['payment_type']=="windcave"){
                
            }else{
                $this->functions->insertData("mt_order_history",$params_history);
                    
                
            }
                    
                    
                    
                    
                    
                    
                    
                    
                    if ($transaction_type=="delivery" && $phone_order==1 && isset($params['address']) && !empty($params['address'])){                       
                        $params_address=array(                        
                          'street'=>isset($res['street'])?$res['street']:'',
                          'city'=>isset($res['city'])?$res['city']:'',
                          'state'=>isset($res['state'])?$res['state']:'',
                          'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                          'location_name'=>$params['address'],
                          'formatted_address'=>$params['address'],
                          'contact_phone'=>$params['phones'],
                          'country'=>isset($res['country_code'])?$res['country_code']:'',
                          'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
                          'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
                          'opt_contact_delivery'=>isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0
                        );              


                                        
                    $params_address['order_id'] = (integer)$order_id;
                    $params_address['client_id'] = (integer)$client_id;
                    $params_address['first_name'] =$params['client_names'];
                    $params_address['last_name'] ='';
                    $params_address['contact_email'] =$params['email'];
                    $params_address['date_created'] = $this->functions->dateNow();
                    $params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
                                        
                    $this->functions->insertData("mt_order_delivery_address",$params_address);
                    
                    }
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    $next_step = "receipt";
                    
                    /*SAVE ITEM */                  
                 /*SAVE ITEM */  
//print_r($raw['item']);die();                
foreach ($raw['item'] as $val) {                                
    $params_order_details=array(
      'order_id'=>isset($order_id)?$order_id:'',
      'client_id'=>isset($client_id)?$client_id:'0',
      'item_id'=>isset($val['item_id'])?$val['item_id']:'',
      'item_name'=>isset($val['item_name'])?$val['item_name']:'',
      'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
      'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
      'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
      'size'=>isset($val['size_words'])?$val['size_words']:'',
      'qty'=>isset($val['qty'])?$val['qty']:'',                               
      'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
      'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
      'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
      'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
    );

    /* inventory fields */
    $new_fields=array('size_id'=>"size_id");
    if ( $this->functions->checkTableFields('order_details',$new_fields)){
        $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
        $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
    }           
    
    $this->functions->insertData("mt_order_details",$params_order_details);
   
    /*inventory addon insert*/
    if ($this->functions->checkIfTableExist('order_details_addon')){
        if(isset($val['sub_item'])){
            if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                foreach ($val['sub_item'] as $sub_item_data) {
                  
                    $this->functions->insertData("mt_order_details_addon",array(
                      'order_id'=>$order_id,
                      'subcat_id'=>$sub_item_data['subcat_id'],
                      'sub_item_id'=>$sub_item_data['sub_item_id'],
                      'addon_price'=>$sub_item_data['addon_price'],
                      'addon_qty'=>$sub_item_data['addon_qty'],
                    ));

                }
            }                           
        }
    }
}

                    
                    /*SAVE DELIVERY ADDRESS*/
                    $params_address = array();
                    
                    /*SAVE DELIVERY ADDRESS*/
                    if ( $transaction_type=="pickup"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:''                        
                        );
                    } elseif ( $transaction_type=="dinein"){
                        $params_address = array(                          
                          'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
                          'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
                          'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
                          'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
                        );
                    }
                    
                
                                        
                
                    
                    
                    
                    $this->code = 1;
                    
                        
                        if ($params['payment_type']=="windcave"){
                            
                            

                     $this->msg = "Your order has been created and waiting for the payment. Reference # ".$order_id;


                       //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($this->data['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints_windcavepos_offline($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                    if (
                    isset($this->data['points_amount']) &&
                    !empty($this->data['points_amount']) &&
                    $this->data['points_amount'] > 0.0001
                    ) {
                        $this->PointsProgram->saveExpensesPoints_windcave(
                        $this->data['points_apply'],
                        $this->data['points_amount'],
                        $client_id,
                        $this->merchant_id,
                        $order_id,
                        ''
                       );
                     }


                }  

                         
                //---was custom code



                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                                        
                            
                        }else{
                    
                    

                    $this->msg = "Your order has been placed. Reference # ".$order_id;
                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                 

                            
                            $phone_order= isset($_REQUEST['phone_order'])?$_REQUEST['phone_order']:0;
                if($phone_order>0){
                    /*$cart_id= isset($_REQUEST['cart_id'])?$_REQUEST['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}*/
        
                        
                        
                        
                        
                        
                            
                                  $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$cart_id);    
                            
                    
                }else{

                            if($minfouser['pos_cashier_access']==1){                                
                                  $this->SingleAppClass_pos->handleAll_cash($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status']); 
                            }else{  
                              $this->SingleAppClass_pos->handleAll($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$table_number);   
                            }
                              
                                 
                              
                                   
                                  //$this->SingleAppClass_pos->updatePoints($order_id,$params['status']); commented by was
                              
                              
                              
                }

               //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($this->data['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                    if (
                    isset($this->data['points_amount']) &&
                    !empty($this->data['points_amount']) &&
                    $this->data['points_amount'] > 0.0001
                    ) {
                        $this->PointsProgram->saveExpensesPoints(
                        $this->data['points_apply'],
                        $this->data['points_amount'],
                        $client_id,
                        $this->merchant_id,
                        $order_id,
                        ''
                       );
                     }


                }  

                $this->SingleAppClass_pos->updatePoints($order_id,$params['status']);           
                //---was custom code

             }          
                              
                              
                              
                              
                              
                        
                    $client_info = array( 
                      'first_name'=>$client_info['first_name'],
                      'last_name'=>$client_info['last_name'],
                      'email_address'=>$client_info['email_address'],
                      'contact_phone'=>$client_info['contact_phone'],                     
                    );
                    
                   

                    $payment_description = "Payment to merchant ".$this->functions->clearString($this->merchant_name);

                    
                    $total = number_format($params['total_w_tax'],2,'.','');
                    
                    
                    
                    
                    
                    $resp = $this->SingleAppClass_pos->prepareReceipt($order_id);
                    
                    $resp['timezone']=date_default_timezone_get();
            
                    //+++was code      
                    foreach ($resp as $key => $val) {
    if ($key !== 'total_amount' && $key !== 'total_amount_by_100') {
        if (is_array($val)) {
            foreach ($val as $subKey => $subVal) {
                if (is_int($subVal) || is_float($subVal)) {
                    $resp[$key][$subKey] = (string)$subVal;
                }
            }
        } elseif (is_int($val) || is_float($val)) {
            $resp[$key] = (string)$val;
        }
    }
}
//---was code

// Convert all nulls in $resp to empty strings
array_walk_recursive($resp, function (&$v) {
    if (is_null($v)) {
        $v = "";
    }
});

// Ensure merchant_id is string (in main data and nested json_details if string)
if (isset($resp['data']['merchant_id'])) {
    $resp['data']['merchant_id'] = (string)$resp['data']['merchant_id'];
}
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Fix merchant_id in json_details to be quoted
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}

// Ensure sub_total, tax, taxable_total are strings if present
foreach (['sub_total', 'tax', 'taxable_total', 'total_w_tax'] as $key) {
    if (isset($resp['data'][$key])) {
        $resp['data'][$key] = (string)round((float)$resp['data'][$key], 2);
    }
}

// Total amount as formatted string
$total = isset($params['total_w_tax']) ? round((float)$params['total_w_tax'], 2) : 0;


            
                    
                    
                    $this->details=array(
                      'order_id'=>$order_id,
                      'order_detail'=>$resp,
                      'total_amount'=>$params['total_w_tax'],
                      'total_amount_by_100'=>$total*100,
                      'total_amount_formatted'=>$total,
                      'payment_provider'=>$payment_provider,
                      'next_step'=>$next_step,
                      'currency_code'=>$this->functions->getCurrencyCode(),
                      'payment_description'=>$payment_description,
                      'merchant_name'=>$this->functions->clearString($this->merchant_name),
                      'provider_credentials'=>$provider_credentials,
                      'redirect_url'=>$redirect_url,
                      'client_info'=>$client_info
                    );
                    
                } else $this->msg = ("Something went wrong cannot insert records. please try again later");
                
            } else $this->msg = $msg;           
        } else $this->msg = ("Cart is empty");      
        
        $this->output();
    }







//---was new code for pos api


public function sync_offline_request()
    {
        $json = file_get_contents('php://input');

       $params = array(
              'request'=>$json,
              
              'date_created' => $this->functions->dateNow()
            );                  
        $this->functions->insertData("mt_request_offline_orders",$params);  
        $this->payNow_pos_syncing();  
        $this->code=1;
        $this->msg = "Request Submitted";
        $this->output();

    }




     public function payNow_pos_syncing()
    {
        
        $this->setMerchantTimezone();
        
         $pdo = $this->db;

        // Define the SQL query
        $stmt = "SELECT * FROM mt_request_offline_orders
                 WHERE process = 0
                 ORDER BY id DESC
                 LIMIT 1";

        $query = $pdo->prepare($stmt);
        $query->execute();

        $requested_orders = $query->fetchAll(PDO::FETCH_ASSOC);

        //print_r($requested_orders);die();


        if (isset($requested_orders) && !empty($requested_orders)) {
        foreach ($requested_orders as $requested_order) {
            # code...
        
        $request = json_decode($requested_order['request'], true);


       
        


        
        if (isset($request) && !empty($request)) {
        foreach ($request['orders'] as $order_request) {


            # code...
         //+++was code for created by create name
         $minfouser=$this->functions->getMerchantUserInfobymid($order_request['pos_user_id']); 

        

          if($minfouser['pos_cashier_access']==1){
            $created_by='Cashier';
                    //$transaction_type="pickup";$this->data['transaction_type']="pickup";  
            $created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
        }else{
               
            $created_by='waiter';$created_name=$minfouser['first_name'].' '.$minfouser['last_name'];
   
        }

       

         //---was code for created by created name
        
        
        $transaction_type = isset($order_request['transaction_type'])?$order_request['transaction_type']:'';

          $pos_keys = isset($order_request['pos_keys'])?trim($order_request['pos_keys']):$order_request['pos_keys'];  
            $resp=$this->SingleAppClass_pos->validateKeys($pos_keys);
            

            
        $this->merchant_id = $resp['merchant_id'];;




        $delivery_date = isset($order_request['delivery_date'])?$order_request['delivery_date']:'';
        $delivery_time = isset($order_request['delivery_time'])?$order_request['delivery_time']:'';
        $payment_provider = isset($order_request['payment_provider'])?$order_request['payment_provider']:'cod';
        
        
        
        
            //die();
        
            
        
        
        
        
         $first_name= isset($order_request['customer_first_name'])?$order_request['customer_first_name']:''; 
         $last_name= isset($order_request['customer_last_name'])?$order_request['customer_last_name']:''; 
         $email_address= isset($order_request['customer_email'])?$order_request['customer_email']:''; 
        
        
        
         $client_id= isset($order_request['client_id'])?$order_request['client_id']:'0'; 
        
        if($client_id>0){}else{
        $phone_order= isset($order_request['phone_order'])?$order_request['phone_order']:0;
                
        
        }
        
        
        if($client_id>0){
            
            $client_info = $this->functions->getClientInfo($client_id);
        
            
        }else{
            
        if(isset($email_address) && !empty($email_address)){    
        if( $client_info = $this->functions->isClientExist_with_merchant($email_address,$this->merchant_id)){

        }else{
            
                        
            $params2=array(
              'first_name'=>($first_name),
              'last_name'=>($last_name),
              'email_address'=>($email_address),
              'password'=>md5('123456'),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>'',
              'device_platform'=>'',
              'merchant_id'=>$this->merchant_id,
               'single_app_merchant_id'=>$order_request['pos_user_id'],
              
             
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params2['email_address']);
                $params2['token']=$token;
                if ($customer_id = $this->functions->insertData("mt_client",$params2)){
                     
        
                $client_info = $this->functions->getClientInfo($customer_id);
        
        
        
                }
        }
        
        }
        }
        
        $customer_first_name=''; $customer_last_name =''; $customer_email='';       
        
        $client_id = $client_info['client_id'];     
        $email_address = trim($client_info['email_address']);
        $customer_email = trim($client_info['email_address']);
        $customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
        $customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
        
        
        
        
        /*transaction_type*/
        
        
        if($minfouser['pos_cashier_access']==1){
            
                    $transaction_type=$order_request['transaction_type'];
        //$order_request['transaction_type']="pickup"; 
        }
        
        
    
        
        if(empty($delivery_date)){
            //$this->msg = ("Delivery date is required");
            //$this->output();
        }
        
        if(empty($payment_provider)){
            //$this->msg = ("Payment provider is empty. please go back and try again");
            //$this->output();
        }
        
        $full_delivery = "$delivery_date $delivery_time";       
        $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
        $delivery_time_formated = '';
        if(!empty($delivery_time)){
            $delivery_time_formated=date('h:i A',strtotime($delivery_time));
        } else $delivery_time_formated = date('h:i A');
                        
        /*CHECK MERCHANT OPENING HOURS*/
        //dump($delivery_day);dump($delivery_time_formated);        
        if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
            $date_close=date("F,d l Y h:ia",strtotime($full_delivery));
           
        }               
            
        /*CHECK PRE ORDER*/
        $date_today = date("Y-m-d");        
    
        /*END PRE ORDER*/
                
        $delivery_date = isset($order_request['delivery_date'])?$order_request['delivery_date']:date("Y-m-d");
        $delivery_time = isset($order_request['delivery_time'])?$order_request['delivery_time']:date('h:i A');
        //naxxxx          
        
        
        
        
        

       $payload = $order_request['items'];

       //print_r($payload);die();

        // Directly use 'items', but reindex them into the same numeric format
      $cart = [];

        if (!empty($payload)) {
            foreach ($payload as $item) {
                $cart[] = $item; // keep full item structure, no stripping
            }
        }

      
       

                
        if(1==1){
            //$cart=json_decode($res['cart'],true);  
            
           //print_r($cart);die();
            
            $card_fee = 0; $card_percentage=0;
            
            /*Custom code 10 starts */
            
            $n_total = $order_request['sub_total'];   
                    
                       
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>$card_fee
            );
            
            

            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $raw = $displayOrderHTML['raw'];
                
                /*EURO TAX*/
               $is_apply_tax = 0;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
                   $raw['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/             
                
                $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
                if(empty($donot_apply_tax_delivery)){
                    $donot_apply_tax_delivery=1;
                }
                
                if($card_percentage>0){
                    $card_fee = (float) $raw['total']['card_fee'];
                }


            
                  $params = array(
                  'merchant_id'=>$this->merchant_id,                  
                  'client_id'=>isset($client_id)?$client_id:'0',
                  'json_details'=>json_encode($cart),
                  'trans_type'=>$transaction_type,
                  'payment_type'=>$order_request['payment_provider']??"cod",
                  'sub_total'=>$order_request['sub_total'],
                  'tax'=>$order_request['tax']/100,
                  'taxable_total'=>$order_request['taxable_total'],
                  'total_w_tax'=>$order_request['grand_total'],
                  'delivery_charge'=>$order_request['delivery_charge']??0,
                  'delivery_date'=>$delivery_date,
                  'delivery_time'=>$delivery_time,
                  'delivery_asap'=>isset($order_request['delivery_asap'])?$order_request['delivery_asap']:'',
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'delivery_instruction'=>isset($order_request['delivery_instruction'])?$order_request['delivery_instruction']:'',
                  'cc_id'=>isset($order_request['cc_id'])?$order_request['cc_id']:'',
                  'order_change'=>isset($order_request['order_change'])?$order_request['order_change']:0,
                  'pos_user_id'=>isset($minfouser['merchant_user_id'])?$minfouser['merchant_user_id']:0,
                  'table_number'=>$table_number??0,
                  'payment_provider_name'=>'',
                  'card_fee'=>$card_fee,                  
                  'created_by'=>$created_by,
                  'created_name'=>$created_name,                              
                  'packaging'=>$order_request['packaging_charge'],
                  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
                  'order_id_token'=>$this->functions->generateOrderToken(),
                //  'request_from'=>"single_mob",
                  'request_from'=>"pos",
                  'apply_food_tax'=>$is_apply_tax,      
                  'is_phone_order'=>isset($phone_order)?$phone_order:0,
                  'cart_id'=>isset($cart_id)?$cart_id:0,    
                  'is_retail'=>isset($order_request['is_retail'])?$order_request['is_retail']:0,
                  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
                );



                


                
                
                
                
                if($phone_order==1){
                    $params['client_names']=$order_request['customer_name'];
                   $params['email'] = isset($order_request['customer_email']) && !empty($order_request['customer_email']) 
                    ? $order_request['customer_email'] 
                    : "";

                    $params['phones']=$order_request['phone_no'];
                    $params['address'] = isset($order_request['address']) && !empty($order_request['address']) 
                    ? $order_request['address'] 
                    : "";          
                    
                }
                
                
                
                //get-last-order
                
                $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);
                if($get_id_orders>=0){$params['order_number']=$get_id_orders+1;}else{$params['order_number']=1;}
                
                
                
                
                
                $order_id_token = $params['order_id_token'];
                
                       
                                
                switch ($transaction_type) {
                    case "dinein":
                        $params['dinein_number_of_guest'] = isset($order_request['dinein_number_of_guest'])?$order_request['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction'] = isset($order_request['dinein_special_instruction'])?$order_request['dinein_special_instruction']:'';
                        
                        $params['dinein_table_number'] = isset($order_request['dinein_table_number'])?$order_request['dinein_table_number']:'';
                        
                        if(isset($order_request['contact_phone']) && $client_id>0){
                            if(!empty($order_request['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$order_request['contact_phone']
                                ),'client_id',$client_id);
                            }
                        }                       
                        break;
                        
                    case "pickup":   
                          if(isset($order_request['contact_phone']) && $client_id>0){
                            if(!empty($order_request['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$order_request['contact_phone']
                                ),'client_id',$client_id);
                            }
                          }                     
                        break;
                        
                    case "delivery":
                        $delivery_asap = '';
                        if(isset($order_request['delivery_asap'])){
                            $delivery_asap = $order_request['delivery_asap']=="true"?1:'';
                            $params['delivery_asap'] = $delivery_asap;
                        }
                        break;
                
                    default:
                        break;
                }
                    
                /*DEFAULT ORDER STATUS*/                
                
                
                
                        $params['payment_provider_name']=$payment_provider;
                
                         $params['status']='paid';  
                
                

                 

                
                

                
                
                
               
                $params['status']='Complete';
                
            
                
                
                if ($params['request_from']="pos")
                        {
                            $params['percent_commision']=0;
                            $params['total_commission']=0;
                            $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                        }

                if(!is_numeric($params['cc_id'])){
                    unset($params['cc_id']);
                }
                if(!is_numeric($params['order_change'])){
                    unset($params['order_change']);
                }
                                                
                /*BEGIN INSERT ORDER*/              
                if(!is_numeric($params['sub_total'])){
                    $params['sub_total']=0;
                }           
                if(!is_numeric($params['tax'])){
                    $params['tax']=0;
                }           
                if(!is_numeric($params['taxable_total'])){
                    $params['taxable_total']=0;
                }           
                if(!is_numeric($params['total_w_tax'])){
                    $params['total_w_tax']=0;
                }
                
                if(isset($params['order_change'])){
                    if(!is_numeric($params['order_change'])){
                        $params['order_change']=0;
                    }           
                }
                if(!is_numeric($params['card_fee'])){
                    $params['card_fee']=0;
                }           
                if(!is_numeric($params['packaging'])){
                    $params['packaging']=0;
                }           
                if(!is_numeric($params['donot_apply_tax_delivery'])){
                    unset($params['donot_apply_tax_delivery']);
                }           
                if(!is_numeric($params['apply_food_tax'])){
                    unset($params['apply_food_tax']);
                }           
                
                if(isset($params['percent_commision'])){
                    if(!is_numeric($params['percent_commision'])){
                        $params['percent_commision']=0;
                    }           
                }
                
                if(isset($params['total_commission'])){
                    if(!is_numeric($params['total_commission'])){
                        $params['total_commission']=0;
                    }           
                }
                
                if(isset($params['merchant_earnings'])){
                    if(!is_numeric($params['merchant_earnings'])){
                        $params['merchant_earnings']=0;
                    }           
                }               
                
                if($transaction_type=="delivery"){          
                   if($res['distance']>0){
                      

                      $params['distance'] = isset($res['distance']) ? $res['distance'] . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '') : '0' . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '');

                   }
                }


                     /*$points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($order_request['sub_total'],$this->merchant_id);
                     echo $points_earn;die();*/
                //print_r($params);die();
                    
                if( $order_id=$this->functions->insertData("mt_order",$params)){
                    
                    
                    $params_history=array(
                      'order_id'=>$order_id,
                      'status'=>'Complete',     
                      'remarks'=>'',
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );          
                   
                  $this->functions->insertData("mt_order_history",$params_history);
                    
                
            
                    
                    
                    
                    
                    
                    
                    
                    
                    if ($transaction_type=="delivery" && $phone_order==1 && isset($params['address']) && !empty($params['address'])){                       
                        $params_address=array(                        
                          'street'=>isset($res['street'])?$res['street']:'',
                          'city'=>isset($res['city'])?$res['city']:'',
                          'state'=>isset($res['state'])?$res['state']:'',
                          'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                          'location_name'=>$params['address'],
                          'formatted_address'=>$params['address'],
                          'contact_phone'=>$params['phones'],
                          'country'=>isset($res['country_code'])?$res['country_code']:'',
                          'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
                          'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
                          'opt_contact_delivery'=>isset($order_request['opt_contact_delivery'])?(integer)$order_request['opt_contact_delivery']:0
                        );              


                                        
                    $params_address['order_id'] = (integer)$order_id;
                    $params_address['client_id'] = (integer)$client_id;
                    $params_address['first_name'] =$params['client_names'];
                    $params_address['last_name'] ='';
                    $params_address['contact_email'] =$params['email'];
                    $params_address['date_created'] = $this->functions->dateNow();
                    $params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
                                        
                    $this->functions->insertData("mt_order_delivery_address",$params_address);
                    
                    }
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    $next_step = "receipt";
                    
                    /*SAVE ITEM */                  
                 /*SAVE ITEM */  
//print_r($raw['item']);die();                
foreach ($raw['item'] as $val) {                                
    $params_order_details=array(
      'order_id'=>isset($order_id)?$order_id:'',
      'client_id'=>isset($client_id)?$client_id:'0',
      'item_id'=>isset($val['item_id'])?$val['item_id']:'',
      'item_name'=>isset($val['item_name'])?$val['item_name']:'',
      'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
      'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
      'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
      'size'=>isset($val['size_words'])?$val['size_words']:'',
      'qty'=>isset($val['qty'])?$val['qty']:'',                               
      'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
      'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
      'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
      'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
    );

    /* inventory fields */
    $new_fields=array('size_id'=>"size_id");
    if ( $this->functions->checkTableFields('order_details',$new_fields)){
        $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
        $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
    }           
    
    $this->functions->insertData("mt_order_details",$params_order_details);
   
    /*inventory addon insert*/
    if ($this->functions->checkIfTableExist('order_details_addon')){
        if(isset($val['sub_item'])){
            if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                foreach ($val['sub_item'] as $sub_item_data) {
                  
                    $this->functions->insertData("mt_order_details_addon",array(
                      'order_id'=>$order_id,
                      'subcat_id'=>$sub_item_data['subcat_id'],
                      'sub_item_id'=>$sub_item_data['sub_item_id'],
                      'addon_price'=>$sub_item_data['addon_price'],
                      'addon_qty'=>$sub_item_data['addon_qty'],
                    ));

                }
            }                           
        }
    }
}

                    
                    /*SAVE DELIVERY ADDRESS*/
                    $params_address = array();
                    
                    /*SAVE DELIVERY ADDRESS*/
                    if ( $transaction_type=="pickup"){
                        $params_address = array(                          
                          'contact_phone'=>isset($order_request['contact_phone'])?$order_request['contact_phone']:''                        
                        );
                    } elseif ( $transaction_type=="dinein"){
                        $params_address = array(                          
                          'contact_phone'=>isset($order_request['contact_phone'])?$order_request['contact_phone']:'',
                          'dinein_number_of_guest'=>isset($order_request['dinein_number_of_guest'])?$order_request['dinein_number_of_guest']:'',
                          'dinein_special_instruction'=>isset($order_request['dinein_special_instruction'])?$order_request['dinein_special_instruction']:'',
                          'dinein_table_number'=>isset($order_request['dinein_table_number'])?$order_request['dinein_table_number']:''
                        );
                    }
                    
                
                                        
                
                    
                    
                    
                    $this->code = 1;
                    
                    
                        if ($params['payment_type']=="windcave"){
                            
                      //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($order_request['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints_windcavepos_offline($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                    if (
                    isset($order_request['points_amount']) &&
                    !empty($order_request['points_amount']) &&
                    $order_request['points_amount'] > 0.0001
                    ) {
                        $this->PointsProgram->saveExpensesPoints_windcave(
                        $order_request['points_apply'],
                        $order_request['points_amount'],
                        $client_id,
                        $this->merchant_id,
                        $order_id,
                        ''
                       );
                     }


                }  

                         
                //---was custom code

                    
                                        
                            
                        }else{
                    
                    

                    $this->msg = "Your order has been placed. Reference # ".$order_id;
                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                 

                            
                            $phone_order= isset($order_request['phone_order'])?$order_request['phone_order']:0;
                if($phone_order>0){
                    /*$cart_id= isset($order_request['cart_id'])?$order_request['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}*/
        
                        
                        
                        
                        
                        
                            
                                  $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$cart_id);    
                            
                    
                }else{

                            if($minfouser['pos_cashier_access']==1){                                
                                  $this->SingleAppClass_pos->handleAll_cash($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status']); 
                            }else{  
                              $this->SingleAppClass_pos->handleAll($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$table_number);   
                            }
                              
                                 
                              
                                   
                                  //$this->SingleAppClass_pos->updatePoints($order_id,$params['status']); commented by was
                              
                              
                              
                }

               //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($order_request['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                  

                }  

                $this->SingleAppClass_pos->updatePoints($order_id,$params['status']);           
                //---was custom code

             }          
                              
                              
                              
                              
                              
                        
                    $client_info = array( 
                      'first_name'=>$client_info['first_name'],
                      'last_name'=>$client_info['last_name'],
                      'email_address'=>$client_info['email_address'],
                      'contact_phone'=>$client_info['contact_phone'],                     
                    );
                    
                   

                    $payment_description = "Payment to merchant ".$this->functions->clearString($this->merchant_name);

                    
                    $total = number_format($params['total_w_tax'],2,'.','');
                    
                    
                    
                    
                    
                    $resp = $this->SingleAppClass_pos->prepareReceipt($order_id);
                    
                    $resp['timezone']=date_default_timezone_get();
            
                    //+++was code      
                    foreach ($resp as $key => $val) {
    if ($key !== 'total_amount' && $key !== 'total_amount_by_100') {
        if (is_array($val)) {
            foreach ($val as $subKey => $subVal) {
                if (is_int($subVal) || is_float($subVal)) {
                    $resp[$key][$subKey] = (string)$subVal;
                }
            }
        } elseif (is_int($val) || is_float($val)) {
            $resp[$key] = (string)$val;
        }
    }
}
//---was code

// Convert all nulls in $resp to empty strings
array_walk_recursive($resp, function (&$v) {
    if (is_null($v)) {
        $v = "";
    }
});

// Ensure merchant_id is string (in main data and nested json_details if string)
if (isset($resp['data']['merchant_id'])) {
    $resp['data']['merchant_id'] = (string)$resp['data']['merchant_id'];
}
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Fix merchant_id in json_details to be quoted
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}

// Ensure sub_total, tax, taxable_total are strings if present
foreach (['sub_total', 'tax', 'taxable_total', 'total_w_tax'] as $key) {
    if (isset($resp['data'][$key])) {
        $resp['data'][$key] = (string)round((float)$resp['data'][$key], 2);
    }
}

// Total amount as formatted string
$total = isset($params['total_w_tax']) ? round((float)$params['total_w_tax'], 2) : 0;


            
                    
                    
                    $this->details=array(
                      'order_id'=>$order_id,
                      'order_detail'=>$resp,
                      'total_amount'=>$params['total_w_tax'],
                      'total_amount_by_100'=>$total*100,
                      'total_amount_formatted'=>$total,
                      'payment_provider'=>$payment_provider,
                      'next_step'=>$next_step,
                      'currency_code'=>$this->functions->getCurrencyCode(),
                      'payment_description'=>$payment_description,
                      'merchant_name'=>$this->functions->clearString($this->merchant_name),
                      'provider_credentials'=>$provider_credentials,
                      'redirect_url'=>$redirect_url,
                      'client_info'=>$client_info
                    );
                    
                } else $this->msg = ("Something went wrong cannot insert records. please try again later");
                
            } else $this->msg = $msg;           
        } else $this->msg = ("Cart is empty");      
        
        //$this->output();

     }//--foreach end
        }

     $id_to_update=$requested_order['id'];
     $this->functions->updateData('mt_request_offline_orders' , array('process'=>1) ,'id',$id_to_update);

    }//--foreach end
    
    }



    }











    public function sync_offline_request_phoneorder()
    {
        $json = file_get_contents('php://input');

       $params = array(
              'request'=>$json,
              
              'date_created' => $this->functions->dateNow()
            );                  
        $this->functions->insertData("mt_request_offline_phone_order",$params);

        $this->payNow_pos_syncing_phone();  

        $this->code=1;
        $this->msg = "Request Submitted";
        $this->output();

    }


    public function payNow_pos_syncing_phone()
{
    $this->setMerchantTimezone();

    // Fetch 2 pending offline orders only
    /*$stmt = $this->db->prepare("
        SELECT * FROM mt_request_offline_phone_order
        WHERE process = 0
        ORDER BY id ASC
        LIMIT 2
    ");*/

    $stmt = $this->db->prepare("
    SELECT *
    FROM mt_request_offline_phone_order
    WHERE process = 0
      AND request IS NOT NULL
      AND request != ''
    ORDER BY id ASC
    LIMIT 2
");

    $stmt->execute();
    $requested_orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$requested_orders) {
        echo "No pending offline orders found.";
        return;
    }

    foreach ($requested_orders as $request_row) {

        $id = $request_row['id'];
        $json_request = $request_row['request'];
        $decoded = json_decode($json_request, true);

        // If JSON doesn't contain orders, skip
        if (!isset($decoded['orders']) || !is_array($decoded['orders'])) {
            continue;
        }

        foreach ($decoded['orders'] as $order) {

            // Convert items to cart JSON
            $cart_items = isset($order['items']) ? $order['items'] : [];
            $cart_json  = json_encode($cart_items, JSON_UNESCAPED_UNICODE);

            // Prepare fields for mt_pos_cart (using your rule)
            
            $params = array(
                'merchant_id'      => $order['merchant_id'] ?? 0,
                'created_by'      => $order['created_by'] ?? 'Cashier',
                'created_id'      => $order['created_id'] ?? 2,
                'table_number'      => $order['table_number'] ?? 0,
                'points_earn'      => $order['points_earn'] ?? 0,
                'tips'      => $order['tips'] ?? 0,
                'delivery_fee'      => $order['delivery_charge'] ?? 0,
                'cart_count'      => $order['cart_count'] ?? 1,
                'device_id'        => $order['device_uiid'] ?? '',
                'device_platform'  => $order['device_platform'] ?? '',
               
                'order_type' => $order['transaction_type'] ?? '',
                'clients_id'    => 1,
                'client_name'    => $order['customer_name'] ?? '',
                'email'   => $order['customer_email'] ?? '',
                'is_phone_order'      => $order['phone_order'] ?? 1,
                'phones'         => $order['phone_no'] ?? '',
                'cart_subtotal'        => $order['sub_total'] ?? 0,
                'address'          => $order['address'] ?? '',
                'points_apply'     => $order['points_apply'] ?? 0,
                'points_amount'    => $order['points_amount'] ?? 0,
                'cart'             => $cart_json
            );

            // Insert using your own function
            $this->functions->insertData("mt_pos_cart", $params);
        }

        // Mark batch as processed
        $update_params = array('process' => 1);
        $this->functions->updateData("mt_request_offline_phone_order", $update_params, 'id', $id);

       
    }
}










    


}
/*end class*/