<?php
class SingleAppClass_pos
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->PointsProgram = new PointsProgram();
        $this->FoodItemWrapper= new FoodItemWrapper();
        $this->InventoryWrapper = new InventoryWrapper();
        
        
        

    }

	public  function moduleBaseUrl()
    {
        return Config::$baseUrl."/app/modules/pos";
    }
    
    public  function moduleName()
    {
        return 'pos';
    }
    
    public  function getMerchantId()
    {
        return $this->functions->getMerchantID();  
    }
    
    public  function registrationType()
    {
        return 'fcm';
    }


    public function validateKeys($keys = '')
{
    if (empty($keys)) {
        return false;
    }

    $stmt = "
        SELECT 
            merchant_id,
            pos_key,
            restaurant_name,
            status
        FROM
            mt_merchant
        WHERE
            pos_key = :pos_key
        LIMIT 1
    ";

    $params = [':pos_key' => $keys];
    $cmd = $this->db->prepare($stmt);
    
    if ($cmd->execute($params)) {
        $res = $cmd->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}


public  function getBannerLink($merchant_id='')
  {
    $banner = $this->functions->getOption('singleapp_banner',$merchant_id);
    if(!empty($banner)){
      $banner = json_decode($banner,true);
      if(is_array($banner) && count($banner)>=1){
        $new_banner=array();
        foreach ($banner as $val) {
          $new_banner[]=$this->functions->websiteUrl()."/upload/$val";
        }
        return $new_banner;
      }
    }
    return false;
  }


public  function prepareReceipt($order_id='', $with_symbol = true)
    {       
        $details_details = array(); $data = array(); $order_details=array();
        
        $default_currency = $this->functions->getCurrencyCode();
        $enabled_trans = $this->functions->multipleField();
        
        if ($data=$this->getReceiptByID($order_id)){
        
        
            $data['tax']=round((float)$data['tax'],2);
            $data['taxable_total']=round((float)$data['taxable_total'],2);
            $data['sub_total']=round((float)$data['sub_total'],2);
            $data['total_w_tax']=round((float)$data['total_w_tax'],2);
            
            
            $data['points_discount']=round((float)$data['points_discount'],2);
            
            
            
            $data['voucher_amount']=round((float)$data['voucher_amount'],2);
            
            
            
            //$data['tax']=(float)$data['tax'];

            


                
            /*MC*/
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $default_currency;
        
                            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;

            if ( $json_details !=false){
                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               'voucher_name'=>$data['voucher_code'],
              // 'voucher_type'=>$data['voucher_type'],
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
               
               /* Custom code 13 starts */
               'promo_id'=>$data['promo_id'],
               /* Custom code 13 ends */
               
               'tax_set'=>$data['tax'],
              ),$json_details,true,$order_id);
            }   
            
            
            $types='';
            if(isset($data['voucher_type']) && !empty($data['voucher_type'])){
                if($data['voucher_type']=='percentage'){$types="%";}
            $data['voucher_type']=$data['voucher_amount'].$types;
            }
            //custom code 9 starts
            $data['merchant_tax_number']=$this->functions->getOption('merchant_tax_number',$merchant_id); 
            //custom code 9 ends
            
            $details_details['order_id']=$data['order_id'];
            $details_details['order_number']=$data['merchant_id'].'-'.$data['order_number'];
            
            
            if($data['table_number']>0){
                     $tables=$this->functions->GetTables($data['table_number']);
                     if($tables){                        
                     $details_details['table_name']=$tables['name'];
                     }
                    }
                    
            
            
            
            
            
            
            $details_details['merchant_name']= $this->functions->clearString($data['merchant_name']);         
            $details_details['merchant_contact_phone']= $this->functions->clearString($data['merchant_contact_phone']);
            $details_details['merchant_address']= $this->functions->clearString($data['merchant_address']);
            
            $details_details['request_cancel']=$data['request_cancel'];
            $details_details['customer_name']=$data['full_name'];           
            $details_details['date_created']=$this->functions->prettyDate($data['date_created'])." ".$this->functions->prettyTime($data['date_created']);     
            $details_details['payment_type_raw'] = $data['payment_type'];
// custom disable   $details_details['payment_type']=self::prettyPaymentType($data['payment_type'],$data['trans_type']);

            // Custom code 9 starts 
            $details_details['payment_type']= $this->functions->prettyPaymentType('payment_order',$data['payment_type'], $data['order_id'],$data['trans_type']); 
            // Custom code 9 ends   
                
            $details_details['trans_type'] = ($data['trans_type']);
            $details_details['trans_type_raw'] = $data['trans_type'];
            
            $details_details['status']=($data['status']);
            $details_details['status_raw']=$data['status'];
            
                        
            $details_details['estimated_time']=$data['estimated_time'];
            $details_details['estimated_date_time']=$data['estimated_date_time'];
            
            /* custom code 12 starts */
            $details_details['car_park_enable']=$data['car_park_enable'];
            $details_details['number_plate']=$data['number_plate'];
            /* custom code 12 ends */
            
            $details_details['sub_total']=$data['sub_total'];
            $details_details['total']=$this->functions->prettyPrice($data['total_w_tax'], $with_symbol);
            $details_details['delivery_address']=$data['full_address'];
            $details_details['location_lat']=!empty($data['location_lat'])?$data['location_lat']:'';
            $details_details['location_lng']=!empty($data['location_lng'])?$data['location_lng']:'';
            
            $details_details['contact_phone']=$data['contact_phone'];
            $details_details['delivery_date']=$this->functions->prettyDate($data['delivery_date']);
            $details_details['delivery_time']=$this->functions->prettyTime($data['delivery_time']);
            
            $date_now = date('Ymd'); $pre_order = 0; $pre_order_msg='';
            $delivery_date=$data['delivery_date'];
            $delivery_date=date("Ymd",strtotime($delivery_date));           
            if($delivery_date>$date_now){
                $pre_order = 1;
                $dtime = !empty($data['delivery_time'])?date("g:ia",strtotime($data['delivery_time'])):'';
                
                $pre_order_msg ="This is advance order on ".$this->functions->prettyDate($data['delivery_date'])." $dtime";
            }
            
            $details_details['pre_order']=$pre_order;
            $details_details['pre_order_msg']=$pre_order_msg;
            
            $details_details['delivery_asap']=$data['delivery_asap'];
            $details_details['delivery_instruction']=$data['delivery_instruction'];
            $details_details['location_name']=$data['location_name'];
            $details_details['order_change_raw']=$data['order_change'];
            $details_details['order_change']=$this->functions->prettyPrice($data['order_change'],$with_symbol);
            
            $details_details['payment_gateway_ref']=$data['payment_gateway_ref'];
            $details_details['dinein_number_of_guest']=$data['dinein_number_of_guest'];
            $details_details['dinein_special_instruction']=$data['dinein_special_instruction'];
            $details_details['dinein_table_number']=$data['dinein_table_number'];
            
            $details_details['opt_contact_delivery']=$data['opt_contact_delivery'];
            if($data['opt_contact_delivery']>=1){
                $details_details['opt_contact']=array(
                  'label'=>"Delivery options",
                  'value'=>"Leave order at the door or gate"
                );
            }
            
          
                        
            $raw = $displayOrderHTML['raw'];           
                        
            foreach ($raw['item'] as $item){
                $price = $item['normal_price']; $qty = $item['qty']; $addon_total=0;
                if($item['discount']>0){
                   $price = $item['discounted_price']; 
                }
                
                /* Custom code 13 starts */
                $promo_id = $item['promo_id'];
                /* Custom code 13 ends */
                
                $item_total = (integer)$qty* (float) $price; 
                
                $item_name=''; $line_items = array(); 
                                
                $item_name = $this->functions->qTranslate($item['item_name'],'item_name',
                $item['item_name_trans'],$enabled_trans);                
                
                $size_name = $this->functions->qTranslate($item['size_words'],'size_name',
                isset($item['size_name_trans'])?$item['size_name_trans']:array(),$enabled_trans);                
                
                if(!empty($item['size_words'])){
                   //$item_name = qTranslate("[item_name] ([size_words])",array(
                  //   '[item_name]'=>$item_name,
                   //  '[size_words]'=>$size_name,
                   //));
                   
                   $item_name =$item_name.' '.$size_name;
                   
                } else $item_name = $item['item_name'];
                
                /*SUB*/             
                $line_sub_item=array(); $subitem =array();
                if(isset($item['new_sub_item'])){
                    if(is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
                        foreach ($item['new_sub_item'] as $sub_item_cat => $sub_item){  
                            $subitem = array();
                            foreach ($sub_item as $sub_item_val) {
                                $sub_item_total = (float)$sub_item_val['addon_qty']*(float)$sub_item_val['addon_price'];
                                
                                $addon_name =  $this->functions->qTranslate($sub_item_val['addon_name'],'sub_item_name',
                                isset($sub_item_val['sub_item_name_trans'])?$sub_item_val['sub_item_name_trans']:array(),
                                $enabled_trans);   
                                
                                $addon_category = $this->functions->qTranslate($sub_item_cat,'subcategory_name',
                                isset($sub_item_val['subcategory_name_trans'])?$sub_item_val['subcategory_name_trans']:array(),
                                $enabled_trans);  
                                
                                $subitem[] = array(
                                  'name'=>$addon_name,
                                  'qty'=>$sub_item_val['addon_qty'],
                                  'price'=>$this->functions->prettyPrice($sub_item_val['addon_price'],$with_symbol),
                                  'sub_item_total'=>$this->functions->prettyPrice($sub_item_total,$with_symbol),
                                );
                                $line_sub_item[$sub_item_cat]= array(
                                  'addon_category'=>$addon_category,
                                  'item'=>$subitem
                                );
                            }
                        }                                               
                    }
                }
                                
                $item_total_price = (float)$qty*(float)$price;
                
                $cooking_ref = $this->functions->qTranslate($item['cooking_ref'],'cooking_name',
                isset($item['cooking_name_trans'])?$item['cooking_name_trans']:array(),$enabled_trans);
                
                $ingredients = array();  $resp_ingredients='';
                if(isset($item['ingredients'])){
                   if(is_array($item['ingredients']) && count($item['ingredients'])>=1){
                      foreach ($item['ingredients'] as $ingredients_name) {
                         if(!$resp_ingredients = $this->FoodItemWrapper->getIngredientsByName($ingredients_name,$enabled_trans)){
                            $resp_ingredients = stripslashes($ingredients_name);
                         }
                         $ingredients[]=$resp_ingredients;
                      }
                   }
                }
                
                
                if($item['variable_price']>0){
                    //$qty=$item['variable_price'];
                }
                
                
                $line_items[]=array(
                  'name'=>$item_name,
                  'qty'=>$qty,
                  'variable_price'=>$item['variable_price'],
                  'price'=>$this->functions->prettyPrice($item['normal_price'],$with_symbol),
                  
                  'discount'=>$item['discount'],
                  'price_after_discount'=>$this->functions->prettyPrice($price,$with_symbol),
                  'item_total_price'=>$this->functions->prettyPrice($item_total_price,$with_symbol),
                  'cooking_ref'=>$cooking_ref,
                  'order_notes'=>$item['order_notes'],
                  'ingredients'=>$ingredients,
                  
                  /* Custom code 13 starts */
                  'promo_id'=>$promo_id,
                  /* custom code 13 ends */
                  
                  'sub_item'=>$line_sub_item
                );
                
                $category_name = $this->functions->qTranslate($item['category_name'],'category_name',
                isset($item['category_name_trans'])?$item['category_name_trans']:array()
                ,$enabled_trans);   
                
                $order_details[]=array(
                  'category_name'=>$category_name,
                  'item'=>$line_items
                );
            }           
            
            /*TOTAL*/
            $total_details = array();
            $total = $raw['total'];
            
            $total_details['apply_food_tax'] = $data['apply_food_tax'];
            
            /*EURO TAX*/
            if($data['apply_food_tax']==1 && $data['tax']>0){       
                                        
                $grand_total = isset($total['subtotal'])?(float)$total['subtotal']:0;
                $grand_total+= isset($total['delivery_charges'])?(float)$total['delivery_charges']:0;
                $grand_total+= isset($total['merchant_packaging_charge'])?(float)$total['merchant_packaging_charge']:0;
                $grand_total+= isset($total['service_fee'])?(float)$total['service_fee']:0;
                $grand_total+= isset($total['card_fee'])?(float)$total['card_fee']:0;
                $grand_total+= isset($total['tips'])?(float)$total['tips']:0;               
                
                /*$grand_total-= isset($total['less_voucher'])?(float)$total['less_voucher']:0;
                $grand_total-= isset($total['pts_redeem_amt'])?(float)$total['pts_redeem_amt']:0;
                $grand_total-= isset($total['discounted_amount'])?(float)$total['discounted_amount']:0; */          
                //dump($grand_total);
                $new_sub_total = $grand_total/($data['tax']+1);             
                $taxable_total = (float)$grand_total - (float)$new_sub_total;               
                
                $total['subtotal'] = $new_sub_total;
                $total['taxable_total'] = $taxable_total;
                $total['total'] = $grand_total; 
            }
            
            
            if($total['less_voucher']>0){
                $total_details['less_voucher']=$this->functions->prettyPrice($total['less_voucher'],$with_symbol);
            }
            if($total['pts_redeem_amt']>0){
                $total_details['pts_redeem_amt']=$this->functions->prettyPrice($total['pts_redeem_amt'],$with_symbol);
            }
            
            if($total['discounted_amount']>0){
                $total_details['discounted_amount']=$this->functions->prettyPrice($total['discounted_amount'],$with_symbol);
                $total_details['merchant_discount_amount']=$total['merchant_discount_amount']."%";
            }
            
            if($total['subtotal']>0){
                $total_details['subtotal']=$this->functions->prettyPrice($total['subtotal'],$with_symbol);
            }
            if($total['delivery_charges']>0){
                $total_details['delivery_charges']=$this->functions->prettyPrice($total['delivery_charges'],$with_symbol);
            }
            
            if(isset($total['service_fee'])){
            if($total['service_fee']>0){
                $total_details['service_fee']=$this->functions->prettyPrice($total['service_fee'],$with_symbol);
            }
            }
            
            if($total['merchant_packaging_charge']>0){
                $total_details['packaging_charge']=$this->functions->prettyPrice($total['merchant_packaging_charge'],$with_symbol);
            }
            if($total['taxable_total']>0){
                $total_details['tax']=array(
                  'taxable_total'=>$this->functions->prettyPrice($total['taxable_total'],$with_symbol),
                  
                  'tax_label'=>$total['tax_label']." ".$this->functions->normalPrettyPrice($total['tax']*100)
                );
            }
            if($total['tips_percent']>0){
                $total_details['tips']=array(
                  'value'=>$this->functions->prettyPrice($total['tips'],$with_symbol),
                  
                  'label'=>"Tips ".$total['tips_percent']
                );
            }
            
            if(isset($total['card_fee'])){
            if($total['card_fee']>0){
                $total_details['card_fee']=$this->functions->prettyPrice($total['card_fee'],$with_symbol);
            }
            }
            
            if($total['total']>0){
                $total_details['total'] = $this->functions->prettyPrice($total['total'],$with_symbol);
            }



            
                                    
            return array(
              'order_data'=>$details_details,
              'order_details'=>$order_details,
              'total_details'=>$total_details,
              //custom code 9 Starts
              'data'=>$data 
              //custom code 9 ends
            );
            
        } else {return false;}
    }





public function getCategory($merchant_id = '', $page = 0, $limit = 0, $all = false)
{
    if (empty($merchant_id)) {
        return false;
    }

    $and = '';
    $todays_day = strtolower(date("l"));

    $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id);
    if ($enabled_category_sked == 1) {
        $and .= " AND $todays_day = '1' ";
    }

    $merchant_id = (int)$merchant_id;
    $page = (int)$page;
    $limit = (int)$limit;

    $limit_clause = (!$all && $limit > 0) ? "LIMIT $page, $limit" : '';

    $stmt = "
        SELECT 
            cat_id,
            category_name,
            category_description,
            photo,
            dish,
            category_name_trans,
            category_description_trans
        FROM
            mt_category
        WHERE 
            merchant_id = $merchant_id
            AND status IN ('publish','published')
            AND pos_available=2
            $and
        ORDER BY sequence ASC
        $limit_clause
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);

    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        $trans = $this->functions->getOptionAdmin('enabled_multiple_translation');
        $new_data = [];

        if ($trans == 2 && isset($_GET['lang'])) {
            foreach ($res as $val) {
                $val['category_name_trans'] = json_decode($val['category_name_trans'], true);
                $val['category_name'] = stripslashes($this->functions->qTranslate($val['category_name'], 'category_name', $val));

                if (!empty($val['photo'])) {
                    $val['photo_url'] = $this->getImage($val['photo']);
                } else {
                    $val['photo_url'] = $this->getImage($this->functions->getOption('singleapp_default_image', $merchant_id), 'default_cuisine.png');
                }

                $val['category_description_trans'] = json_decode($val['category_description_trans'], true);
                $val['category_description'] = $this->functions->qTranslate($val['category_description'], 'category_description', $val);

                $val['dish_list'] = $this->getDishPics(isset($val['dish']) ? $val['dish'] : '');

                if ($all) {
                    unset($val['photo'], $val['dish'], $val['category_description'], $val['category_name_trans'], $val['category_description_trans'], $val['photo_url'], $val['dish_list']);
                    $val['item_count'] = $this->getItemCountByCategory($val['cat_id']) . " item";
                }

                $new_data[] = $val;
            }
        } else {
            foreach ($res as $val) {
                $val['category_name'] = stripslashes($val['category_name']);

                if (!empty($val['photo'])) {
                    $val['photo_url'] = $this->getImage($val['photo']);
                } else {
                    $val['photo_url'] = $this->getImage($this->functions->getOption('singleapp_default_image', $merchant_id), 'default_cuisine.png');
                }

                $val['category_description'] = $val['category_description'];
                $val['dish_list'] = $this->getDishPics(isset($val['dish']) ? $val['dish'] : '');

                if ($all) {
                    unset($val['photo'], $val['dish'], $val['category_description'], $val['category_name_trans'], $val['category_description_trans'], $val['photo_url'], $val['dish_list']);
                    $val['item_count'] = $this->getItemCountByCategory($val['cat_id']) . " item";
                }

                $new_data[] = $val;
            }
        }

        return $new_data;
    }

    return false;
}





  public  function getImage($image='', $default="default-logo.png")
    {   
        $url='';            
        $path_to_upload=Config::$baseUrl."/upload/";                
        
        if (!empty($image)){ 

           
                                        
                $default=$image;  

                             
                $url = Config::$baseUrl."/upload/$default";


            
        } else $url=Config::$baseUrl."/assets_pos/images/$default";
        return $url;
    }

    public  function getImage2($image='')
  { 
    $url='';      
    $path_to_upload=Config::$baseUrl."/upload/";      
    
    if (!empty($image)){      
                                
        $url = Config::$baseUrl."/upload/$image";
      
    } 
    return $url;
  }


  public  function getAvatar($client_id='')
    {
      
      if($client_id>0){
        if ( $res= $this->functions->getClientInfo($client_id) ){
          $file=$res['avatar'];
        } else $file='avatar.jpg';
      } else $file='avatar.jpg';
      
      if (empty($file)){
        $file='avatar.jpg';
      }
                
      $path=Config::$baseUrl."/upload/$file";
      
      if (!empty($path)){                     
        return Config::$baseUrl."/upload/$file";
      } else return $this->functions->websiteUrl()."/assets/images/avatar.jpg";     
    } 


    public  function getAvatar2($file='')
    {                 
      if (empty($file)){
        $file='avatar.jpg';
      }
                
      $path=Config::$baseUrl."/upload/$file";
      
      if (!empty($path)){                   
        return Config::$baseUrl."/upload/$file";
      } else return $this->functions->websiteUrl()."/assets/images/avatar.jpg";     
    }

     public  function getGallerPicURL($filename='')
    {
      $path=Config::$baseUrl."/upload/$filename";  
       if (!empty($path)){
        return Config::$baseUrl."/upload/$filename";
      } 
      return false;
    }
    
  public  function getDishPics($list='')
    {
      $dish_list = array();
      $dish = json_decode($list,true);
    if(is_array($dish) && count($dish)>=1){
      foreach ($dish as $dish_id) {
        if($dish_info = $this->functions->GetDish($dish_id)){                
          if ($icon_link = $this->getGallerPicURL($dish_info['photo'])){
            $dish_list[]=$icon_link;
          }             
        }           
      }
      
    } else $dish_list='';
    return $dish_list;
    }


      public  function getPrices_variablers_price($price='',$discount=0,$is_variables_price=1,$quantity="0")
    {           
      $new_price = array();
      $price = !empty($price)? json_decode($price,true) : false;
    $ii=0;  
      if(is_array($price) && count($price)>=1){
        foreach ($price as $size_id =>  $presyo) {
          //dump($size_id."=>".$presyo);
          $size_name = '';
          if ($resp = $this->functions->getSize($size_id)){        
                            
            $size_name_trans = json_decode($resp['size_name_trans'],true);
            $resp['size_name_trans']=$size_name_trans;            
            $resp['size_name']=$this->functions->qTranslate($resp['size_name'],'size_name',$resp);          
            
            $size_name = $resp['size_name'];
          }
          
          $formatted_price='';
          if(!empty($size_name)){
            //$formatted_price = "$size_name ".FunctionsV3::prettyPrice($presyo);
            $formatted_price = $this->functions->prettyPrice($presyo);
          } else $formatted_price = $this->functions->prettyPrice($presyo);
          
          $discount_price = 0;
          if($discount>0.0001){
            $discount_price = $presyo-$discount;
          }
        
        if($is_variables_price==2){$variableprice=$quantity[$ii];}
            else{$variableprice="0";}
        
          
          $new_price []  = array(
            'price'=>$presyo,
            'formatted_price'=>$formatted_price,
            'discount'=>$discount,
            'discount_price'=>$discount_price,
            'formatted_discount_price'=>$this->functions->prettyPrice($discount_price),
            'size'=>$size_name,
            'size_id'=>$size_id,
            'size_trans'=>'',
          'variableprice'=>$variableprice,                    
          );
        $ii++;
        }
        return $new_price;
      }
      return false;
    }



    public  function getPrices($price='',$discount=0)
    {           
      $new_price = array();
      $price = !empty($price)? json_decode($price,true) : false;
      if(is_array($price) && count($price)>=1){
        foreach ($price as $size_id =>  $presyo) {
          //dump($size_id."=>".$presyo);
          $size_name = '';
          if ($resp = $this->functions->getSize($size_id)){        
                            
            $size_name_trans = json_decode($resp['size_name_trans'],true);
            $resp['size_name_trans']=$size_name_trans;            
            $resp['size_name']=$this->functions->qTranslate($resp['size_name'],'size_name',$resp);          
            
            $size_name = $resp['size_name'];
          }
          
          $formatted_price='';
          if(!empty($size_name)){
            //$formatted_price = "$size_name ".FunctionsV3::prettyPrice($presyo);
            $formatted_price = $this->functions->prettyPrice($presyo);
          } else $formatted_price = $this->functions->prettyPrice($presyo);
          
          $discount_price = 0;
          if($discount>0.0001){
            $discount_price = $presyo-$discount;
          }
          
          $new_price []  = array(
            'price'=>$presyo,
            'formatted_price'=>$formatted_price,
            'discount'=>$discount,
            'discount_price'=>$discount_price,
            'formatted_discount_price'=>$this->functions->prettyPrice($discount_price),
            'size'=>$size_name,
            'size_id'=>$size_id,
            'size_trans'=>'',
          );
        }
        return $new_price;
      }
      return false;
    }
    
  
   public function getCart($device_id = '', $merchant_id = '', $table_no = '0')
{
    if (empty($device_id)) {
        return false;
    }

    $merchant_id = (int) $merchant_id;
    $device_id = addslashes($device_id); // basic escaping

    $and = "";
    if ($table_no > 0) {
        $and = " AND table_number = '" . addslashes($table_no) . "'";
    }

    $sql = "SELECT * FROM mt_pos_cart
            WHERE device_id = '$device_id'
            AND merchant_id = $merchant_id
            AND is_phone_order = 0
            $and
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

  
  
    public function getCartForPhone($device_id = '', $merchant_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    $merchant_id = (int) $merchant_id;
    $device_id = $this->db->quote($device_id); // prevent SQL injection

    $stmt = "SELECT * FROM mt_pos_cart 
             WHERE device_id = $device_id 
             AND merchant_id = $merchant_id 
             AND clients_id = 0 
             AND is_phone_order = 1 
             LIMIT 0,1";

    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);

    $query = $this->db->query($stmt);
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


   public function getCartForPhoneForAdditems($device_id = '', $merchant_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    $merchant_id = (int) $merchant_id;
    $device_id = addslashes($device_id); // Basic escaping

    $sql = "SELECT * FROM mt_pos_cart
            WHERE device_id = '$device_id'
            AND merchant_id = $merchant_id
            AND clients_id = 0
            AND is_phone_order = 1
            LIMIT 0,1";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


public function getCart_bycartid($device_id = '', $merchant_id = '', $cart_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    $merchant_id = (int) $merchant_id;
    $cart_id = (int) $cart_id;

    $sql = "SELECT * FROM mt_pos_cart
            WHERE 1
            AND merchant_id = $merchant_id
            AND cart_id = $cart_id
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

  
  
     public function getcart_cart_id($merchant_id = '', $cart_id = '')
{
    $merchant_id = (int) $merchant_id;
    $cart_id = (int) $cart_id;

    $sql = "SELECT * FROM mt_pos_cart
            WHERE merchant_id = $merchant_id
            AND cart_id = $cart_id
            LIMIT 0,1";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

public function getCart_by_table_id($merchant_id = '', $table_no = '0')
{
    $merchant_id = (int) $merchant_id;
    $table_no = addslashes($table_no); // Escaping string input

    $and = " AND table_number = '$table_no'";

    $sql = "SELECT * FROM mt_pos_cart
            WHERE 1
            AND merchant_id = $merchant_id
            AND is_phone_order = 0
            $and
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

  

public function getCart_cashier($merchant_id = '', $table_no = '0')
{
    $merchant_id = (int) $merchant_id;

    $and = '';
    if ($table_no > 0) {
        $table_no = addslashes($table_no); // Basic escaping
        $and = " AND table_number = '$table_no'";
    }

    $sql = "SELECT * FROM mt_pos_cart
            WHERE 1
            AND merchant_id = $merchant_id
            AND is_phone_order = 0
            $and
            ORDER BY cart_id DESC
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

 public function removeVoucher($device_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    $date_modified = $this->functions->dateNow();
    $device_id_escaped = addslashes($device_id); // Basic escaping for direct interpolation

    $sql = "UPDATE mt_pos_cart
            SET date_modified = '$date_modified',
                voucher_details = ''
            WHERE device_id = '$device_id_escaped'
              AND is_phone_order = 0
              AND table_number = 0";

    return $this->db->exec($sql);
}

  
  public  function removeVoucher_pos($device_id='')
    {
          
      
      $params = array(
        'date_modified'=>$this->functions->dateNow(),
        'voucher_details'=>''
      );
      $this->functions->updateData("mt_pos_cart",$params,'table_number',$device_id);
    }

      public  function removeVoucher_pos_phone($device_id='')
    {
          
      
      $params = array(
        'date_modified'=>$this->functions->dateNow(),
        'voucher_details'=>''
      );
      $this->functions->updateData("mt_pos_cart",$params,'cart_id',$device_id);
    }
    
    public  function removeTip($device_id='')
    {     
      if(empty($device_id)){
        return false;
      }           
      $params = array(
        'date_modified'=>$this->functions->dateNow(),        
        'tips'=>0,
        'remove_tip'=>1
      );      
     

      $up =$this->functions->updateData("mt_pos_cart",$params,'device_id',$device_id);


    }

     public  function createTimeRange($start, $end, $interval = '30 mins', $format = '12') {
      $startTime = strtotime($start); 
      $endTime   = strtotime($end);
      $returnTimeFormat = ($format == '12')?'g:i:s A':'G:i:s';
  
      $current   = time(); 
      $addTime   = strtotime('+'.$interval, $current); 
      $diff      = $addTime - $current;
  
      $times = array();       
      while ($startTime < $endTime) { 
          $times[] = date($returnTimeFormat, $startTime); 
          $startTime += $diff; 
      } 
      $times[] = date($returnTimeFormat, $startTime); 
      return $times; 
  }
  
  public  function parseValidatorError($error='')
  {
    $error_string='';
    if (is_array($error) && count($error)>=1){
      foreach ($error as $val) {
        $error_string.="$val\n";
      }
    }
    return $error_string;   
  }   
  
    public  function generateUniqueToken($length,$unique_text=''){  
    $key = '';
      $keys = array_merge(range(0, 9), range('a', 'z'));  
      for ($i = 0; $i < $length; $i++) {
          $key .= $keys[array_rand($keys)];
      } 
      return $key.md5($unique_text);
  } 


   public function getCustomerByToken($token = '', $is_active = true)
{
    if (empty($token)) {
        return false;
    }

    $token = addslashes($token); // Basic escaping
    $and = "";
    if ($is_active) {
        $and = " AND status IN ('active')";
    }

    $sql = "SELECT * FROM mt_client
            WHERE token = '$token'
            $and
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

public function getCustomerByTokenAndDevice($token = '', $device_uiid = '', $is_active = true)
{
    if (empty($token)) {
        return false;
    }

    $token = addslashes($token); // Basic escaping
    $and = "";
    if ($is_active) {
        $and = " AND a.status IN ('active')";
    }

    $sql = "SELECT 
                a.client_id,
                a.first_name,
                a.last_name,
                CONCAT(a.first_name, ' ', a.last_name) AS full_name,
                a.email_address,
                a.contact_phone,
                a.social_strategy,
                a.avatar,
                a.single_app_merchant_id,

                b.device_uiid,
                b.device_id,
                b.device_platform,
                b.push_enabled,
                b.subscribe_topic
            FROM mt_client a
            LEFT JOIN mt_singleapp_device_reg b
              ON a.client_id = b.client_id
            WHERE a.token = '$token'
            $and
            LIMIT 0,1";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


public function clearCart($device_id = '', $table_no = 0)
{
    if ($table_no > 0) {
        $sql = "DELETE FROM mt_pos_cart WHERE is_phone_order = 0 AND table_number = '$table_no'";
        $this->db->exec($sql);
    } else {
        if (empty($device_id)) {
            return false;
        }

        $sql = "DELETE FROM mt_pos_cart WHERE is_phone_order = 0 AND device_id = '$device_id'";

        if ($table_no > 0) {
            $sql .= " AND table_number = '$table_no'";
        }

        $this->db->exec($sql);
    }
}


public function clearCart_phoneorder($device_id = '', $cart_id = 0)
{
    if (empty($device_id)) {
        return false;
    }

    $and = " AND cart_id='$cart_id'";
    $sql = "DELETE FROM mt_pos_cart WHERE device_id='$device_id' $and";
    $this->db->exec($sql);
}

public function clearCart_phoneorder_was($cart_id = 0)
{
    

    //$and = " AND cart_id='$cart_id'";
    $sql = "DELETE FROM mt_pos_cart WHERE cart_id='$cart_id' ";
    $this->db->exec($sql);
}
  
  
  
  
    public function clearCart_waiters($device_id = '', $table_no = 0)
{
    $and = '';
    if ($table_no > 0) {
        $and = " AND table_number='$table_no'";
    }

    $sql = "DELETE FROM mt_pos_cart WHERE is_phone_order=0 AND merchant_id='$device_id' $and";
    $this->db->exec($sql);
}

 public  function getCartContent($device_id='',$data=array())
    {
      if(empty($device_id)){
        return false;
      }
      
      $merchant_id = isset($data['merchant_id'])? (integer) $data['merchant_id']:0;
      
      if($res=$this->getCart_cashier($device_id , $merchant_id)){
        $cart=json_decode($res['cart'],true);
        
        if($res['tips']>0.0001){
        $data['cart_tip_percentage']=$res['tips'];
        $data['tip_enabled']=2;
        $data['tip_percent']=$res['tips'];
      }
      
        $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
      if(is_array($voucher_details) && count($voucher_details)>=1){
        $data['voucher_name']=$voucher_details['voucher_name'];
        $data['voucher_amount']=$voucher_details['amount'];
        $data['voucher_type']=$voucher_details['voucher_type'];
      }
      
      if($res['points_apply']>0.0001){
        $data['points_apply']=$res['points_apply'];
      }
      if($res['points_amount']>0.0001){
        $data['points_amount']=$res['points_amount'];
      }
      
      /*DELIVERY FEE*/
      unset($_SESSION['shipping_fee']);
      if($res['delivery_fee']>0.0001){
        $data['delivery_charge']=$res['delivery_fee'];
      }
                
      $cart_details = $res;
      unset($cart_details['cart']);   
      unset($cart_details['device_id']);
      unset($cart_details['cart_id']);      
      
     $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
      $code = $displayOrderHTML['code'];
      $msg  = $displayOrderHTML['msg'];
      if ($code==1){
        $details = $displayOrderHTML['raw'];;
        return $details;
      }
      }
      return false;
    }

    public  function getCartContent_pos($device_id='',$data=array())
    {
      
      $merchant_id = isset($data['merchant_id'])? (integer) $data['merchant_id']:0;
      
      
    $table_number = isset($data['table_number'])? (integer) $data['table_number']:0;
  
    $cart_id = isset($data['cart_id'])?$data['cart_id']:0;
    
    
      if($table_number>0){
      $res=$this->getCart_by_table_id($merchant_id,$table_number); 
    }else if($cart_id>0){
      $res=$this->getCart_bycartid($device_id,$merchant_id,$cart_id);  
    }else{
      $res=$this->getCart($device_id,$merchant_id,$table_number);
    }
    
      if($res){
        $cart=json_decode($res['cart'],true);
        
        if($res['tips']>0.0001){
        $data['cart_tip_percentage']=$res['tips'];
        $data['tip_enabled']=2;
        $data['tip_percent']=$res['tips'];
      }
      
        $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
      if(is_array($voucher_details) && count($voucher_details)>=1){
        $data['voucher_name']=$voucher_details['voucher_name'];
        $data['voucher_amount']=$voucher_details['amount'];
        $data['voucher_type']=$voucher_details['voucher_type'];
      }
      
      if($res['points_apply']>0.0001){
        $data['points_apply']=$res['points_apply'];
      }
      if($res['points_amount']>0.0001){
        $data['points_amount']=$res['points_amount'];
      }
      
      /*DELIVERY FEE*/
      unset($_SESSION['shipping_fee']);
      if($res['delivery_fee']>0.0001){
        $data['delivery_charge']=$res['delivery_fee'];
      }
                
      $cart_details = $res;
      unset($cart_details['cart']);   
      unset($cart_details['device_id']);
      unset($cart_details['cart_id']);      
      
      $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
      $code = $displayOrderHTML['code'];
      $msg  = $displayOrderHTML['msg'];
      if ($code==1){
        $details = $displayOrderHTML['raw'];
        return $details;
      }
      }
      return false;
    }

    public function appLogin($username = '', $password = '')
{
    if (empty($username) || empty($password)) {
        return false;
    }

    // Hash the password
    $hashed_password = md5($password);

    // Make sure PDO returns all values as strings
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);

    // Prepare and execute the query safely
    $sql = "
        SELECT *
        FROM mt_merchant_user
        WHERE username = ?
        AND password = ?
        AND status = 'active'
        LIMIT 1
    ";

    $stmt = $this->db->prepare($sql);

    $stmt->execute([$username, $hashed_password]);

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res[0]; // All values will be strings
    }

    return false;
}


public function appLogin_merchantwise($username = '', $password = '', $merchant_id = '')
{
    if (empty($username) || empty($password) || empty($merchant_id)) {
        return false;
    }

    // Hash the password
    $hashed_password = md5($password);

    // Make sure PDO returns all values as strings
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);

    // Prepare and execute the query safely
    $sql = "
        SELECT *
        FROM mt_merchant_user
        WHERE username = ?
        AND password = ?
        AND merchant_id = ?
        AND status = 'active'
        LIMIT 1
    ";

    $stmt = $this->db->prepare($sql);

    $stmt->execute([$username, $hashed_password, $merchant_id]);

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res[0]; // All values will be strings
    }

    return false;
}



public function getCreditCards($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $sql = "
        SELECT 
            cc_id,
            credit_card_number,
            date_created
        FROM mt_client_cc
        WHERE client_id = '$client_id'
        ORDER BY cc_id DESC
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }
    return false;
}

    
   public function getAddressBookByClient($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $data = [];

    $sql = "
        SELECT              
            CONCAT(street, ' ', city, ' ', state, ' ', zipcode) AS address,
            id,
            location_name,
            country_code,
            as_default,
            latitude,
            longitude,
            date_created
        FROM mt_address_book
        WHERE client_id = '$client_id'
        ORDER BY street ASC
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $date_added = $this->functions->prettyDate($val['date_created']) . " " .
                          $this->functions->prettyTime($val['date_created']);

            $val['date_added'] = "Added " . $date_added;
            $data[] = $val;
        }
        return $data;
    }

    return false;
}


public  function getMerchantLogo($merchant_id='')
  {   
    if ( !$logo =  $this->functions->getOption('merchant_photo',$merchant_id) ){     
      $logo = $this->functions->getOptionAdmin('mobile_default_image_not_available');
      if (empty($logo)){
         $logo="default-logo.png";
      }
    }   
    $path_to_upload=Config::$baseUrl."/upload/";     
     

      if (!empty($logo)){ 
         return Config::$baseUrl."/upload/$logo";
      }

    return $this->moduleBaseUrl()."/assets_pos/images/$logo";        
  }     
    
  public  function receiptFormater($label='', $val='')
  {
    return array(
      'label'=>$label,
      'value'=>$val
    );
  }
  
    public  function getOpeningHours($merchant_id='')
  {
    if(empty($merchant_id)){
        return false;
      }
      
        $stores_open_day=$this->functions->getOption("stores_open_day",$merchant_id);
    $stores_open_starts=$this->functions->getOption("stores_open_starts",$merchant_id);
    $stores_open_ends=$this->functions->getOption("stores_open_ends",$merchant_id);
    $stores_open_custom_text=$this->functions->getOption("stores_open_custom_text",$merchant_id);
    
    $stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;
    $stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
    $stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
    $stores_open_custom_text=!empty($stores_open_custom_text)?(array)json_decode($stores_open_custom_text):false;
    
    
    $stores_open_pm_start=$this->functions->getOption("stores_open_pm_start",$merchant_id);
    $stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;
    
    $stores_open_pm_ends=$this->functions->getOption("stores_open_pm_ends",$merchant_id);
    $stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;   
                        
    $open_starts='';
    $open_ends='';
    $open_text='';
    $data=array();
        
    if (is_array($stores_open_day) && count($stores_open_day)>=1){
      foreach ($stores_open_day as $val_open) { 
        if (array_key_exists($val_open,(array)$stores_open_starts)){
          $open_starts=$this->functions->timeFormat($stores_open_starts[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_ends)){
          $open_ends=$this->functions->timeFormat($stores_open_ends[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_custom_text)){
          $open_text=$stores_open_custom_text[$val_open];
        }         
        
        $pm_starts=''; $pm_ends=''; $pm_opens='';
        if (array_key_exists($val_open,(array)$stores_open_pm_start)){
          $pm_starts=$this->functions->timeFormat($stores_open_pm_start[$val_open],true);
        }                     
        if (array_key_exists($val_open,(array)$stores_open_pm_ends)){
          $pm_ends=$this->functions->timeFormat($stores_open_pm_ends[$val_open],true);
        }                       
        
        $full_time='';
        if (!empty($open_starts) && !empty($open_ends)){          
          $full_time=$open_starts."-".$open_ends;
        }     
        if (!empty($pm_starts) && !empty($pm_ends)){
          if ( !empty($full_time)){
            $full_time.="x";
          }       
          $full_time.="$pm_starts-$pm_ends";
        }                       
                
        $data[$val_open]=array(
          'day'=>$val_open,
          'hours'=>$full_time         
        );
        
        $open_starts='';
            $open_ends='';
            $open_text='';
      }
      return $data;
    }     
    return false;   
  } 


  public function getBookAddress($street = '', $city = '', $state = '')
{
    $sql = "
        SELECT * FROM mt_address_book
        WHERE street = '$street'
        AND city = '$city'
        AND state = '$state'
        LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

  
  public  function getPaypalCredentials($merchant_id='')
  {
    if(empty($merchant_id)){
        return false;
      }
      
    if ( $this->functions->isMerchantPaymentToUseAdmin($merchant_id)){
       $paypal_mobile_enabled=$this->functions->getOptionAdmin('adm_paypal_mobile_enabled');
         $paypal_fee=$this->functions->getOptionAdmin("admin_paypal_fee");         
         $paypal_mobile_mode=$this->functions->getOptionAdmin('adm_paypal_mobile_mode');
         $paypal_client_id=$this->functions->getOptionAdmin('adm_paypal_mobile_clientid');
    } else {
       $paypal_mobile_enabled=$this->functions->getOption('mt_paypal_mobile_enabled',$merchant_id);
         $paypal_fee=$this->functions->getOption('merchant_paypal_fee',$merchant_id);        
         $paypal_mobile_mode=$this->functions->getOption('mt_paypal_mobile_mode',$merchant_id);
         $paypal_client_id=$this->functions->getOption('mt_paypal_mobile_clientid',$merchant_id);
    }   
    if ($paypal_mobile_enabled=="yes"){
      return  array(
        'enabled'=>$paypal_mobile_enabled,
        'fee'=>$paypal_fee,
        'mode'=>strtolower($paypal_mobile_mode),
        'client_id'=>$paypal_client_id
      );
    }
    return false;
  }
  
  public  function getStripeCredentials($merchant_id='')
  {
    if(empty($merchant_id)){
        return false;
      }
      
    $enabled = false; $mode = ''; $secret_key=''; $publish_key='';
    if ( $this->functions->isMerchantPaymentToUseAdmin($merchant_id)){
      
      $enabled = $this->functions->getOptionAdmin('admin_stripe_enabled');
      if($enabled=="yes"){
        $enabled=true;
      }
      $mode = strtolower($this->functions->getOptionAdmin('admin_stripe_mode'));
      if($mode=="sandbox"){
         $secret_key = $this->functions->getOptionAdmin('admin_sanbox_stripe_secret_key');
         $publish_key = $this->functions->getOptionAdmin('admin_sandbox_stripe_pub_key');
      } else if ($mode=="live") {           
         $secret_key = $this->functions->getOptionAdmin('admin_live_stripe_secret_key');
         $publish_key = $this->functions->getOptionAdmin('admin_live_stripe_pub_key');
      }   
    } else {
      $enabled = $this->functions->getOption('stripe_enabled',$merchant_id);
      if($enabled=="yes"){
        $enabled=true;
      }
      $mode = strtolower(getOption('stripe_mode',$merchant_id));
      if($mode=="sandbox"){
         $secret_key = $this->functions->getOption('sanbox_stripe_secret_key',$merchant_id);
         $publish_key = $this->functions->getOption('sandbox_stripe_pub_key',$merchant_id);
      } else if ($mode=="live") {           
         $secret_key = $this->functions->getOption('live_stripe_secret_key',$merchant_id);
         $publish_key = $this->functions->getOption('live_stripe_pub_key',$merchant_id);
      }   
    }
    
    if ($enabled && !empty($secret_key) && !empty($publish_key)){
      return array(
        'mode'=>$mode,
        'secret_key'=>$secret_key,
        'publish_key'=>$publish_key
      );
    }
    return false;
  }

  public  function getOrderDetails($order_id='')
  {
    if(empty($order_id)){
        return false;
      }
      
    $_GET['backend']=''; 
      if ($res = $this->functions->getOrder2($order_id) ){
        return $res;
      }
      return false;
  }
    
  public  function deliveryDateList($merchant_id='')
  {   
    $dates=array();
    $day=$this->functions->getOption("stores_open_day",$merchant_id);
    $day_open=!empty($day)?json_decode($day,true):false;
      
    if(is_array($day_open) && count($day_open)>=1){
      
      for ($i = 0; $i <= 30; $i++) {        
        $key=date("Y-m-d",strtotime("+$i day"));
        $key_day = strtolower(date("l",strtotime($key)));
        if(in_array($key_day,(array)$day_open)){
          $dates[$key] = $this->functions->prettyDate($key);
        }
      }
    } else {
      for ($i = 0; $i <= 30; $i++) {        
        $key=date("Y-m-d",strtotime("+$i day"));
        $dates[$key] = date("D F d Y",strtotime("+$i day"));
      }
    }
    return $dates;
  }
  
  public  function tipList()
  {
    return array(
           '0.1'=>"10%",
           '0.15'=>"15%",
           '0.2'=>"20%",
           '0.25'=>"25%"         
        );  
  } 

  public  function getAppLanguage()
  {
    $translation=array();
                   
    
    return $translation;
  } 


  public function generateMerchantKeys()
{
    $pos_key = md5($this->functions->generateCode(50));

    $sql = "
        SELECT pos_key
        FROM mt_merchant
        WHERE pos_key = '$pos_key'
        LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = $this->db->query($sql);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $this->generateMerchantKeys();
    }

    return $pos_key;
}

  
    public  function handleAll($order_id='', $merchant_id='', 
    $client_id='',$device_id='', $order_status='', $table_number='')
  {
    $this->sendNotifications($order_id);
    
    /*POINTS ADDON*/
      

        if($table_number>0){
        $res=$this->getCart_cashier($merchant_id,$table_number);}else{
          $res=$this->getCart($device_id,$merchant_id);
        }
      


    
      if($res){
        if($client_id>0){
        $points_earn = $res['points_earn'];
        $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);
        
        if ($res['points_apply']>=0.0001){
          $this->PointsProgram->saveExpensesPoints(
            $res['points_apply'],
            $res['points_amount'],
            $client_id,
            $merchant_id,
            $order_id,
            ''
          );
        }
        
      }
        
      }
    
    
    /*SEND FAX*/
        $this->functions->sendFax($merchant_id,$order_id);
        
        
      
       /*inventory*/    
     if($this->inventoryEnabled($merchant_id)){
      try {                         
         $this->InventoryWrapper->insertInventorySale($order_id,strtolower($order_status));  
      } catch (Exception $e) {                        
        // echo $e->getMessage();               
      }                        
     }
      
      /*CLEAR CART*/
      $this->clearCart_waiters($merchant_id,$table_number); 
  }



   public  function handleAll_cash($order_id='', $merchant_id='', 
    $client_id='',$device_id='', $order_status='', $table_number='')
  {
   $this->sendNotifications($order_id);
    
    /*POINTS ADDON*/
          
      if($res=$this->getCart($device_id , $merchant_id)){
        $points_earn = $res['points_earn'];       
        if($client_id>0){       
        $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);       
        if ($res['points_apply']>=0.0001){
          $this->PointsProgram->saveExpensesPoints(
            $res['points_apply'],
            $res['points_amount'],
            $client_id,
            $merchant_id,
            $order_id,
            ''
          );
        }
        }
        
      }
    
    
    /*SEND FAX*/
        //$this->functions->sendFax($merchant_id,$order_id);
        
       
      
       /*inventory*/    
     if($this->inventoryEnabled($merchant_id)){
      try {                         
         $this->InventoryWrapper->insertInventorySale($order_id,strtolower($order_status));  
      } catch (Exception $e) {                        
        // echo $e->getMessage();               
      }                        
     }
      
      /*CLEAR CART*/
       $this->clearCart($device_id); 
  }
  
  
  
    public  function handleAll_cash_phone($order_id='', $merchant_id='', 
    $client_id='',$device_id='', $order_status='', $cart_id='')
  {
    $this->sendNotifications($order_id);
     
    /*POINTS ADDON*/
     
      if($res=$this->getCart_bycartid($device_id,$merchant_id,$cart_id)){
        $points_earn = $res['points_earn'];

        
        

        
        if($client_id>0){       
        $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);       
        if ($res['points_apply']>=0.0001){
          $this->PointsProgram->saveExpensesPoints(
            $res['points_apply'],
            $res['points_amount'],
            $client_id,
            $merchant_id,
            $order_id,
            ''
          );
        }
        }
        
      }
    
    
    /*SEND FAX*/
       $this->functions->sendFax($merchant_id,$order_id);
        
      
      
       /*inventory*/    
     if($this->inventoryEnabled($merchant_id)){
      try {                         
         $this->InventoryWrapper->insertInventorySale($order_id,strtolower($order_status));  
      } catch (Exception $e) {                        
        // echo $e->getMessage();               
      }                        
     }
      
      /*CLEAR CART*/
    //$this->clearCart_phoneorder($device_id,$cart_id);
    $this->clearCart_phoneorder_was($cart_id);
  }


  public  function sendNotifications($order_id='')
    {
        $_GET['backend']=true; $print=array();
        if ( $data=$this->functions->getOrder2($order_id)){
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            if ( $json_details !=false){
               $displayOrderHTML= $this->functions->displayOrderHTML(array(
                  'order_id'=>$order_id,
                  'merchant_id'=>$data['merchant_id'],
                  'delivery_type'=>$data['trans_type'],
                  'delivery_charge'=>$data['delivery_charge'],
                  'packaging'=>$data['packaging'],
                  'cart_tip_value'=>$data['cart_tip_value'],
                  'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
                  'card_fee'=>$data['card_fee'],
                  'tax'=>$data['tax'],
                  'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
                  'voucher_amount'=>$data['voucher_amount'],
                  'voucher_type'=>$data['voucher_type']
                  ),$json_details,true);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>"ABN",
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>"Telephone",'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];

            $print[]=array('label'=>"Address",'value'=>$full_merchant_address);
            
            $print[]=array('label'=>"TRN Type",'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>"Payment Type",
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>"Card#",'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>"Paypal Transaction ID",
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>"Reference #",
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>"Payment Ref",
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>"Card #",
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>"TRN Date",
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>"Delivery Date",
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>"Delivery Time",
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?("Yes"):'';
                        $print[]=array(
                         'label'=>"Deliver ASAP",
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>"Deliver to",
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>"Delivery Instruction",
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>"Location Name",
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            $to=isset($data['email_address'])?$data['email_address']:'';
            
            /*CHECK IF EURO TAX*/
            if($data['apply_food_tax']==1){             
                $new_total = $this->functions->computeWithTax($displayOrderHTML['raw'], $merchant_id);
                $displayOrderHTML['raw']['total']=$new_total;                                                                          
                $receipt=$this->functions->salesReceiptTax($print,$displayOrderHTML['raw']);
                
                       
                
            } else {
              $receipt=$this->functions->salesReceipt($print,$displayOrderHTML['raw']);
            
            
            }
            
            $this->functions->notifyCustomer($data,'',$receipt, $to);
            //FunctionsV3::notifyMerchant($data,Yii::app()->functions->additional_details,$receipt);
            
            /* Custom code starts */
           
                        
           // FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processemail"));
            //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processsms"));     
                       
            /*PRINTER ADDON*/
       
                  
        }
    }





  public  function latToAdress($lat='' , $lng='')
  {
    $lat_lng="$lat,$lng";
    $protocol = isset($_SERVER["https"]) ? 'https' : 'http';
    if ($protocol=="http"){
      $api="http://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
    } else $api="https://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
    
    /*check if has provide api key*/
    $key=$this->functions->getOptionAdmin('google_geo_api_key');   
    if ( !empty($key)){
      $api="https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($lat_lng)."&key=".urlencode($key);
    } 
    

    $google_use_curl = $this->functions->getOptionAdmin('google_use_curl');   
        
    if($google_use_curl==2){
      $json=$this->functions->Curl($api,'');
    } else $json=@file_get_contents($api);
    
   
    
    $address_out=array();
      
    if (!empty($json)){     
      
      $results = json_decode($json,true);         
      if(array_key_exists('error_message',(array)$results)){
         throw new Exception( $results['status']);
      }
            
      $parts = array(
          'address'=>array('street_number','route'),          
          'city'=>array('locality','political','sublocality','administrative_area_level_2','administrative_area_level_1'),
          'state'=>array('administrative_area_level_1'),
          'zip'=>array('postal_code'),
          'country'=>array('country'),
        );        
        if (!empty($results['results'][0]['address_components'])) {
          $ac = $results['results'][0]['address_components'];         
          foreach($parts as $need=>$types) {
            foreach($ac as &$a) {                             
                if (in_array($a['types'][0],$types)){
                    if (in_array($a['types'][0],$types)){
                        if($need=="address"){
                            if(isset($address_out[$need])) {
                               $address_out[$need] .= " ".$a['long_name'];
                            } else $address_out[$need]= $a['long_name'];
                        } else $address_out[$need] = $a['long_name'];                       
                    }
                } elseif (empty($address_out[$need])) $address_out[$need] = ''; 
            }
          }
          
          if(!empty($results['results'][0]['formatted_address'])){
             $address_out['formatted_address']=$results['results'][0]['formatted_address'];
          }         
          return $address_out;
        }         
    }     
    return false;
  } 


  public function getCartEarningPoints($cart = array(), $sub_total = 0, $mtid = '')
{
    /* CHECK IF ADMIN ENABLED THE POINTS SYSTEM */
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return false;
    }

    /* CHECK IF MERCHANT HAS DISABLED POINTS SYSTEM */
    if (isset($cart[0])) {
        if (isset($cart[0]['merchant_id'])) {
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts', $mtid);
            if ($mt_disabled_pts == 2) {
                return false;
            }
        }
    }

    $points = 0;

    if (is_array($cart) && count($cart) >= 1) {
        $earning_type = $this->PointsProgram->getBasedEarnings($mtid);

        if ($earning_type == 1) {
            foreach ($cart as $val) {
                $temp_price = explode("|", $val['price']);
                if ($val['discount'] >= 0.01) {
                    $set_price = ($temp_price[0] - $val['discount']) * $val['qty'];
                } else {
                    $set_price = (float)$temp_price[0] * $val['qty'];
                }

                $points += $this->PointsProgram->getPointsByItem($val['item_id'], $set_price, $mtid);
            }
        } else {
            $points += $this->PointsProgram->getTotalEarningPoints($sub_total, $mtid);
        }
$points=intval($points);
        /* CHECK IF SUBTOTAL ORDER IS ABOVE */
        $pts_earn_above_amount = $this->functions->getOptionAdmin('pts_earn_above_amount');

        if (!$this->PointsProgram->isMerchantSettingsDisabled()) {
            $mt_pts_earn_above_amount = $this->functions->getOption('mt_pts_earn_above_amount',$mtid);
            if ($mt_pts_earn_above_amount > 0) {
                $pts_earn_above_amount = $mt_pts_earn_above_amount;
            }
        }

        if (is_numeric($pts_earn_above_amount)) {
            if ($pts_earn_above_amount > $sub_total) {
                $points = 0;
            }
        }
       
        if ($points >= 0) {
            $pts_label_earn = $this->functions->getOptionAdmin('pts_label_earn');
            //if (empty($pts_label_earn)) {
                $pts_label_earn = "This order earned " . $points;
           // }
           
            return array(
                'points_earn' => $points,
                'pts_label_earn' => $pts_label_earn
            );
        }
    }

    return false;
}



 public function getCartEarningPoints_offline($sub_total = 0, $mtid = '')
{
    /* CHECK IF ADMIN ENABLED THE POINTS SYSTEM */
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return false;
    }

    /* CHECK IF MERCHANT HAS DISABLED POINTS SYSTEM */
    
        
    $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts', $mtid);
    if ($mt_disabled_pts == 2) {
        return false;
    }
        
    

    $points = 0;

  
    

        
       $points += $this->PointsProgram->getTotalEarningPoints($sub_total, $mtid);
        

        /* CHECK IF SUBTOTAL ORDER IS ABOVE */
        $pts_earn_above_amount = $this->functions->getOptionAdmin('pts_earn_above_amount');

        if (!$this->PointsProgram->isMerchantSettingsDisabled()) {
            $mt_pts_earn_above_amount = $this->functions->getOption('mt_pts_earn_above_amount',$mtid);
            if ($mt_pts_earn_above_amount > 0) {
                $pts_earn_above_amount = $mt_pts_earn_above_amount;
            }
        }

        if (is_numeric($pts_earn_above_amount)) {
            if ($pts_earn_above_amount > $sub_total) {
                $points = 0;
            }
        }
       
        if ($points >= 0) {
            $pts_label_earn = $this->functions->getOptionAdmin('pts_label_earn');
            //if (empty($pts_label_earn)) {
                $pts_label_earn = "This order earned " . $points;
           // }
           
            return $points;
        }
    

    return false;
}





public function pointsTotalExpenses($client_id = '')
{
    $stmt = "
    SELECT SUM(total_points) as total
    FROM mt_points_expenses
    WHERE
    status = 'active'
    AND
    client_id = " . ($client_id) . "
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res['total'];
    }
    return 0;
}

  
  public function getTotalEarnPoints($client_id = '', $merchant_id = '')
{
    $and = " AND (merchant_id = " . ($merchant_id) . " OR trans_type = 'adjustment') ";

    $stmt = "
    SELECT 
      SUM(total_points_earn) as total_earn,
      (
        SELECT SUM(total_points)
        FROM mt_points_expenses
        WHERE
          status IN ('active','adjustment')
          AND client_id = " . ($client_id) . "
          $and
      ) as total_points_expenses
    FROM mt_points_earn
    WHERE
      status IN ('active','adjustment')
      AND client_id = " . ($client_id) . "
      $and
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res['total_earn'] - $res['total_points_expenses'];
    }
    return 0;
}

public  function highlight_word( $content, $word ) {
      $replace = '<span class="highlight">' . $word . '</span>'; // create replacement
      $content = str_ireplace( $word, $replace, $content ); // replace content  
      return $content; // return highlighted data
    }
    
    public  function savePoints($device_id='',$client_id='',$merchant_id='', $order_id='',$order_status='')
    {
      /*POINTS ADDON*/
         
      if($res=$this->getCart($device_id , $merchant_id )){
        $points_earn = $res['points_earn'];
        $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);       
        
        if ($res['points_apply']>=0.0001){
           $this->PointsProgram->saveExpensesPoints(
            $res['points_apply'],
            $res['points_amount'],
            $client_id,
            $merchant_id,
            $order_id,
            ''
          );
        }
      }
    
    }   
    
    public  function updatePoints($order_id='', $order_status='')
  {
    
      
         $this->PointsProgram->updateOrderBasedOnStatus($order_status,$order_id);
      
    
  }
  
  public function orderHistory($order_id = '')
{
    $stmt = "
    SELECT * FROM mt_order_history
    WHERE order_id = " . ($order_id) . "
    ORDER BY id DESC
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}


  public  function platFormList()
    {
      return array(
        'android'=>"android",
          'ios'=>'ios',
          'all'=>"all platform"
      );
    }
    
 public function getPagesByID($page_id = '', $fields = '*')
{
    $stmt = "
    SELECT $fields
    FROM mt_singleapp_pages
    WHERE 
      page_id = " . ($page_id) . "
      AND status IN ('publish')
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}

public function getPages($merchant_id = '')
{
    $stmt = "
    SELECT *
    FROM mt_singleapp_pages
    WHERE 
      merchant_id = " . ($merchant_id) . "
      AND status IN ('publish')
    ORDER BY sequence ASC
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}


public function getItemCountByCategory($category_id = '')
{
    $stmt = "
    SELECT COUNT(*) AS total
    FROM mt_item
    WHERE category LIKE '%" . $category_id . "%'
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res['total'];
    }
    return 0;
}

      
  
  public function checkAddressBook($client_id = '', $lat = '', $lng = '', $id = '')
{
    $and = '';
    if ($id > 0) {
        $and .= " AND id <> " . ($id) . " ";
    }

    $stmt = "
    SELECT * FROM mt_address_book
    WHERE
      client_id = " . ($client_id) . "
      AND latitude = " . ($lat) . "
      AND longitude = " . ($lng) . "
      $and
    LIMIT 0,1
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}


public  function getDistanceResultsType($merchant_id='')
    {
      $distance_results_type = $this->functions->getOption('singleapp_distance_results',$merchant_id);
      if(empty($distance_results_type)){
        return 1;
      }
      if(!is_numeric($distance_results_type)){
        return 1;
      }
      return $distance_results_type;
    }


    public  function getLocalDistance($unit='', $lat1='',$lon1='', $lat2='', $lon2='')
    {               
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
       
        $dist = acos($dist);
      $dist = rad2deg($dist);
      $miles = $dist * 60 * 1.1515;
      $unit = strtoupper($unit);
      
      $resp = 0;
      
      if ($unit == "K") {
          $resp = ($miles * 1.609344);
      } else if ($unit == "N") {
          $resp = ($miles * 0.8684);
      } else {
          $resp = $miles;
      }     
      
      if($resp>0){
         $resp = number_format($resp,1,'.','');
      }
      
      return $resp;
    }


 public function getBookAddressByClientID($client_id = '', $street = '', $city = '', $state = '')
{
    if (empty($street)) {
        return false;
    }
    if (empty($city)) {
        return false;
    }
    if (empty($state)) {
        return false;
    }

    $stmt = "
    SELECT * FROM mt_address_book
    WHERE
      client_id = " . ($client_id) . "
      AND street = '" . $street . "'
      AND city = '" . $city . "'
      AND state = '" . $state . "'
    LIMIT 0,1
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}

 public function getVoucherMerchant($client_id = '', $voucher_code = '', $merchant_id = '')
{
    // Sanitize inputs
    $client_id = (int)$client_id;
    $merchant_id = (int)$merchant_id;
    $voucher_code_quoted = $this->db->quote($voucher_code);

    $stmt = "
    SELECT a.*,

    (
        SELECT COUNT(*) 
        FROM mt_order
        WHERE voucher_code = {$voucher_code_quoted}
        AND client_id = {$client_id}
    ) AS found,

    (
        SELECT COUNT(*) 
        FROM mt_order
        WHERE voucher_code = {$voucher_code_quoted}
    ) AS number_used

    FROM mt_voucher_new a
    WHERE voucher_name = {$voucher_code_quoted}
    AND merchant_id = {$merchant_id}
    AND status IN ('publish','published')
    LIMIT 1
    ";

    
    $query = $this->db->query($stmt);
    
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res;
    }
    
    return false;
}





public function getVoucherMerchant_pos($client_id = '', $voucher_code = '', $merchant_id = '')
{
    $stmt = "
    SELECT a.*
    FROM mt_voucher_new a
    WHERE
      voucher_name = '" . $voucher_code . "'
      AND merchant_id = " . ($merchant_id) . "
      AND status IN ('publish','published')
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}

    
    public function getVoucherAdmin($client_id = '', $voucher_code = '')
{
    $stmt = "
    SELECT a.*,
    (
      SELECT COUNT(*) FROM mt_order
      WHERE
        voucher_code = '" . $voucher_code . "'
        AND client_id = " . ($client_id) . "
      LIMIT 0,1
    ) as found,

    (
      SELECT COUNT(*) FROM mt_order
      WHERE
        voucher_code = '" . $voucher_code . "'
      LIMIT 0,1
    ) as number_used

    FROM mt_voucher_new a
    WHERE
      voucher_name = '" . $voucher_code . "'
      AND voucher_owner = 'admin'
      AND status IN ('publish','published')
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res;
    }
    return false;
}

public function pointsEarnByMerchant($client_id = '')
{
    $stmt = "
    SELECT SUM(a.total_points_earn) AS total_earn,
    (
      SELECT SUM(total_points)
      FROM mt_points_expenses
      WHERE client_id = " . ($client_id) . "
      AND a.status IN ('active','adjustment')
    ) AS total_expenses
    FROM mt_points_earn a
    WHERE client_id = " . ($client_id) . "
    AND a.status IN ('active','adjustment')
    AND merchant_id > 0
    GROUP BY merchant_id
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    if ($query) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        $total_earn = 0;
        $total_expenses = 0;
        foreach ($res as $val) {
            $total_earn += $val['total_earn'];
            $total_expenses += $val['total_expenses'];
        }
        $total = $total_earn - $total_expenses;
        return $total;
    }
    return 0;
}

public  function paginateLimit()
    {
      return 1000;
    } 

    public  function getMerchantBackground($merchant_id='',$set_image='')
    {     
      
      $image_url = $this->functions->websiteUrl()."/assets_pos/images/default_bg.jpg";
        $merchant_photo_bg = $this->functions->getOption('merchant_photo_bg',$merchant_id);        
      if(!empty($merchant_photo_bg)){               
       
          $image_url = $this->functions->websiteUrl()."/upload/$merchant_photo_bg";
        
      } else {
        if(!empty($set_image)){
          $image_url = $this->functions->websiteUrl()."/assets_pos/images/$set_image";
        }
      }     
      return $this->functions->prettyUrl($image_url);
    }
  

  public  function BookingTabs()
    {    
      $data =array();
      $data[]=array(
        'tab'=>"all",
        'label'=>"All"
      );
      $data[]=array(
        'tab'=>"pending",
        'label'=>"Pending"
      );
      $data[]=array(
        'tab'=>"approved",
        'label'=>"Approved"
      );
      $data[]=array(
        'tab'=>"denied",
        'label'=>"Denied"
      );
      return $data;
    }
    
    public  function OrderTabs()
    {    
      $data =array();
      $data[]=array(
        'tab'=>"all",
        'label'=>"All"
      );
      $data[]=array(
        'tab'=>"processing",
        'label'=>"Processing"
      );
      $data[]=array(
        'tab'=>"completed",
        'label'=>"Completed"
      );
      $data[]=array(
        'tab'=>"cancelled",
        'label'=>"Cancelled"
      );
      return $data;
    }
    
    public  function getOrderTabsStatus($merchant_id,$tab='')
  {
    $status = ''; $and='';
    switch ($tab) {
      case "processing":          
          $status=$this->functions->getOption('singleapp_order_processing',$merchant_id);
        break;
    
      case "completed":       
          $status=$this->functions->getOption('singleapp_order_completed',$merchant_id); 
        break;
        
      case "cancelled":       
          $status=$this->functions->getOption('singleapp_order_cancelled',$merchant_id); 
        break;
            
      default:
        break;
    } 
    
    if(!empty($status)){
      $status = json_decode($status,true);      
      if(is_array($atus) && count((array)$status)>=1){
        foreach ($status as $val) {
          $and .= "'$val'," ;

        }
        $and = subr($and,0,-1);
        $and = "AND a.status IN ($and)";
      }
    }
    return $and;
  }



public function orderDetails($order_id = '')
{
    $stmt = "
    SELECT 
        a.order_id,
        a.merchant_id,
        a.client_id,
        a.trans_type,
        a.status,
        a.status as status_raw,
        a.payment_type,
        a.payment_type as payment_type_raw,
        b.restaurant_name as merchant_name,
        b.logo,
        c.review,
        c.rating,
        c.as_anonymous
    FROM mt_order a
    LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id
    LEFT JOIN mt_review c
        ON a.order_id = c.order_id
    WHERE a.order_id = $order_id
    LIMIT 0,1
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $stmt = $this->db->query($stmt);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optionally log error here
    }
    return false;
}


public function getReviewReplied($review_id = '', $merchant_id = '')
{ 
    if ($merchant_id > 0) {
        // keep merchant_id as is
    } else {
        $merchant_id = -1;
    }

    $data = [];

    $stmt = "
        SELECT 
            a.merchant_id,
            a.review,
            a.parent_id,
            a.reply_from,
            a.date_created,
            ( 
                SELECT logo 
                FROM mt_merchant
                WHERE merchant_id = $merchant_id
                LIMIT 0,1
            ) AS logo
        FROM mt_review a
        WHERE a.parent_id = $review_id
        AND a.status = 'publish'
        ORDER BY a.id ASC
        LIMIT 0,10
    ";

    try {
      $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $query = $this->db->query($stmt);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        foreach ($res as $val) {
            $val['logo'] = $this->getImage($val['logo']);
            $pretty_date = $val['date_created'];
            $pretty_date = $this->functions->translateDate($pretty_date);
            $val['date_posted'] = $pretty_date;

            $val['customer_name'] = "Replied By " . $val['reply_from'];

            unset($val['merchant_id']);
            unset($val['reply_from']);
            unset($val['date_created']);

            $data[] = $val;
        }
    } catch (Exception $e) {
        // Optionally handle or log the error
    }

    return $data;
}


public function GetBookingDetails($booking_id = '', $client_id = '')
{
    $stmt = "
        SELECT * 
        FROM mt_bookingtable
        WHERE client_id = $client_id
        AND booking_id = $booking_id
        LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $query = $this->db->query($stmt);
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optionally log the error
    }

    return false;
}

public function getCustomerByID($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_client
        WHERE client_id = $client_id
        LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $query = $this->db->query($stmt);
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}
       
    
    public function isItemFavorite($client_id = '', $item_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_favorite_item
        WHERE client_id = $client_id
        AND item_id = $item_id
        LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $query = $this->db->query($stmt);
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}


 public  function addItemFavorite($client_id='',$item_id='', $category_id='')
    {
      if(empty($client_id)){
        return false;
      }
      
      
      $params = array(
        'client_id'=>$client_id,
        'item_id'=>$item_id,
        'category_id'=>$category_id,
        'date_created'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR']
      );
      if(!$this->isItemFavorite($client_id,$item_id)){
        $this->functions->insertData("mt_favorite_item",$params);
      }
      unset($db);
    }
    
   public function removeItemFavorite($client_id = '', $item_id = '')
{
    if (empty($client_id)) {
        return false;
    }
    if (empty($item_id)) {
        return false;
    }

    $stmt = "
        DELETE FROM mt_favorite_item
        WHERE client_id = $client_id
        AND item_id = $item_id
    ";
  
    try {
        $this->db->exec($stmt);
    } catch (Exception $e) {
        // Optional: log error
    }
}

public function removeItemFavoriteByID($client_id = '', $id = '')
{
    if (empty($client_id)) {
        return false;
    }
    if (empty($id)) {
        return false;
    }

    $stmt = "
        DELETE FROM mt_favorite_item
        WHERE client_id = $client_id
        AND id = $id
    ";

    try {
        $this->db->exec($stmt);
    } catch (Exception $e) {
        // Optional: log error
    }
}

    
    public function getItemFavorite($client_id = '', $id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_favorite_item
        WHERE client_id = $client_id
        AND id = $id
        LIMIT 0,1
    ";

    try {
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $res = $this->db->query($stmt)->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}

public  function getLangList()
  {
    $lang=array();
         
    
    return $lang;
  }


   public function getTitlePages($merchant_id = '')
{
    $titles = "page_id, title, icon";

    $stmt = "
        SELECT $titles FROM mt_singleapp_pages
        WHERE status = 'publish'
        AND merchant_id = $merchant_id
    ";

    try {
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}
  
  
  
  public  function searchMode()
  {
    $search_mode = $this->functions->getOptionAdmin('home_search_mode');
    $location_mode = $this->functions->getOptionAdmin('admin_zipcode_searchtype');
    if(empty($search_mode)){
       $search_mode = 'address';  
    } elseif ($search_mode=="postcode"){
      $search_mode='location';
    }
    return array(
      'search_mode'=>$search_mode,
      'location_mode'=>$location_mode,
    );
  }


  public  function isLocation()
  {
    $mode = $this->searchMode();
    if($mode=="location"){
      return true;
    }
    return false;
  }

 public function getLastOrderSMS($mobile = '')
{
    $stmt = "
        SELECT * FROM mt_order_sms
        WHERE mobile = $mobile
        ORDER BY id DESC
        LIMIT 0,1
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res[0];
        }
    } catch (Exception $e) {
        // Optionally log error
    }

    return false;
}

  
  public function clearCartByCustomerID($client_id = '')
{
    $stmt = "
        DELETE FROM mt_pos_cart
        WHERE device_id IN (
            SELECT device_uiid FROM mt_singleapp_device_reg
            WHERE client_id = " . (int)$client_id . "
        )
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $this->db->query($stmt);
    } catch (Exception $e) {
        // Optionally handle or log error
    }
}


 public  function ContactUsData($merchant_id='')
    {           
      $contact_field = $this->functions->getOption('singleapp_contactus_fields',$merchant_id);
      if(!empty($contact_field)){
        $contact_field = json_decode($contact_field,true);
      } else {
        $contact_field = array('name','email');
      }    
      return array(      
       'contact_field'=>$contact_field
      );
    }
    
    public  function prettyBadge($status='')
  {
    $$status=strtolower(trim($status));
    if($status=="pending"){
       return '<span class="badge badge-primary">'.($status).'</span>';
    } elseif ( $status=="process" ){
      return '<span class="badge badge-success">'.($status).'</span>';
    } elseif ( preg_match("/properly set in/i", $status)){
      return '<span class="badge badge-danger">'.($status).'</span>';
    } elseif ( preg_match("/caught/i", $status)){
      return '<span class="badge badge-danger">'.($status).'</span>'; 
    } elseif ( preg_match("/error/i", $status)){
      return '<span class="badge badge-danger">'.($status).'</span>';     
    } elseif ( preg_match("/failed/i", $status)){
      return '<span class="badge badge-danger">'.($status).'</span>';   
    } elseif ( preg_match("/no/i", $status)){
      return '<span class="badge badge-secondary">'.($status).'</span>';      
    } else {      
       return '<span class="badge badge-success">'.($status).'</span>';
    }
  }

   public  function locationAccuracyList()
    {
      return array(
        //'REQUEST_PRIORITY_NO_POWER'=>self::t("REQUEST_PRIORITY_NO_POWER"),
        'REQUEST_PRIORITY_LOW_POWER'=>"REQUEST_PRIORITY_LOW_POWER",
        'REQUEST_PRIORITY_BALANCED_POWER_ACCURACY'=>"REQUEST_PRIORITY_BALANCED_POWER_ACCURACY",
        'REQUEST_PRIORITY_HIGH_ACCURACY'=>"REQUEST_PRIORITY_HIGH_ACCURACY",
      );
    } 
    
    public  function MenuType()
    {
      return array(
        1=>"Menu 1",
        2=>"Menu 2 - Classic menu", 
        3=>"Menu 3 - column",        
      );
    }

    public  function trackingTheme()
  {
    return array(
      1 => "Theme 1",
      2 => "Theme 2",
    );
  }
  
  public function getMaxPage($merchant_id = '')
{
    $stmt = "
        SELECT MAX(sequence) as max  
        FROM mt_singleapp_pages   
        WHERE merchant_id = " . ($merchant_id) . "
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $res = $this->db->query($stmt)->fetch(PDO::FETCH_ASSOC);
        if ($res && $res['max'] >= 1) {
            return $res['max'] + 1;
        } else {
            return 1;
        }
    } catch (Exception $e) {
        // Optionally handle/log the error
    }

    return false;
}

public function getPageByTitle($merchant_id = '', $title = "")
{
    if (empty($title)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_singleapp_pages
        WHERE title = '" . addslashes($title) . "'
        AND merchant_id = " . ($merchant_id) . "
        LIMIT 0,1
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res[0];
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}

  
  public function getPageByID($page_id = "")
{
    if (empty($page_id)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_singleapp_pages
        WHERE page_id = " . ($page_id) . "
        LIMIT 0,1
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $res = $this->db->query($stmt)->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}
 
  
  public function getMerchantList()
{
    $stmt = "
        SELECT merchant_id, restaurant_name
        FROM mt_merchant
        WHERE status IN ('active')
        ORDER BY restaurant_name ASC
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $data = [];
            foreach ($res as $val) {
                $data[$val['merchant_id']] = $this->functions->clearString($val['restaurant_name']);
            }
            return $data;
        }
    } catch (Exception $e) {
        // Optional: log error
    }

    return false;
}

public function getMerchantNames($merchant_id = array())
{
    $in_merchant_id = '';
    if (is_array($merchant_id) && count($merchant_id) >= 1) {
        foreach ($merchant_id as $id) {
            $in_merchant_id .= "'$id',";
        }
        $in_merchant_id = substr($in_merchant_id, 0, -1);
    }

    $stmt = "
        SELECT 
        group_concat(restaurant_name SEPARATOR '<br/>') as merchant_name
        FROM mt_merchant
        WHERE
        merchant_id IN ($in_merchant_id)
    ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $command = $this->db->prepare($stmt);
        $command->execute();
        $res = $command->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $this->functions->clearString($res['merchant_name']);
        }
    } catch (Exception $e) {
        // Optional: log or handle error
    }

    return '';
}

  
  public  function getStartUpBanner($merchant_id='')
  {
    $data = array();
    $banner = $this->functions->getOption('singleapp_startup_banner',$merchant_id); 
    $banner = !empty($banner)?json_decode($banner,true):array();
    if(is_array($banner) && count($banner)>=1){
      foreach ($banner as $val) {
        $data[] = $this->getImage($val);
      }
    }
    return $data;
  }


   public function getAddressBookDefault($client_id = '')
{
    if ($client_id > 0) {
        $stmt = "
            SELECT a.*, b.contact_phone           
            FROM mt_address_book a
            LEFT JOIN mt_client b ON a.client_id = b.client_id
            WHERE a.client_id = $client_id
            AND a.as_default = '2'
            LIMIT 0,1
        ";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        try {
            $command = $this->db->prepare($stmt);
            $command->execute();
            $res = $command->fetch(PDO::FETCH_ASSOC);
            if ($res) {
                return $res;
            }
        } catch (Exception $e) {
            // Optional: log or handle error
        }
    }
    return false;
}


public function getShippingRate($merchant_id = '', $default_fee = '', $distance = '', $unit = '')
{
    $distance = is_numeric($distance) ? number_format($distance, 3) : 0;
    $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
    $charge = $default_fee;

    if ($shipping_enabled == 2) {
        if ($unit == "ft" || $unit == "mm" || $unit == "mt") {
            // do nothing
        } else {
            switch (strtolower($unit)) {
                case "miles":
                case "mi":
                    $unit = 'mi';
                    break;
                case "kilometers":
                case "km":
                    $unit = 'km';
                    break;
                case "ft":
                    $unit = 'mi';
                    $distance = 1;
                    break;
            }

            $stmt = "
                SELECT * FROM mt_shipping_rate
                WHERE merchant_id = $merchant_id
                AND shipping_units = '$unit'
                AND distance_from <= $distance
                AND distance_to >= $distance
                LIMIT 0,1
            ";

            try {
                $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
                $cmd = $this->db->prepare($stmt);
                $cmd->execute();
                $resp = $cmd->fetch(PDO::FETCH_ASSOC);
            } catch (Exception $e) {
                $resp = false;
            }

            if (!$resp) {
                $stmt2 = "
                    SELECT * FROM mt_shipping_rate
                    WHERE merchant_id = $merchant_id
                    AND shipping_units = '$unit'
                    ORDER BY distance_to DESC
                    LIMIT 0,1
                ";
                try {
                  $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
                    $cmd2 = $this->db->prepare($stmt2);
                    $cmd2->execute();
                    $res = $cmd2->fetch(PDO::FETCH_ASSOC);
                    if ($res && $distance >= $res['distance_to']) {
                        $resp = $res;
                    }
                } catch (Exception $e) {
                    $resp = false;
                }
            }

            if (is_array($resp) && count($resp) >= 1) {
                if ($resp['distance_price'] >= 0.0001) {
                    return $resp['distance_price'];
                }
            }
        }
    }

    if ($charge > 0.0001) {
        return $charge;
    }

    return false;
}

public  function settingsMenu()
  {
    $menu[] = array(
      'label'=>"API Settings",
      'link'=>Config::$baseUrl."/pos/index/merchant_settings",
      'id'=>'merchant_settings'
    );    
    $menu[] = array(
      'label'=>"Application Settings",
      'link'=>Config::$baseUrl."/pos/index/settings_application",
      'id'=>'settings_application'
    );    
    
    /*$menu[] = array(
      'label'=>"App startup",
      'link'=>APP_FOLDER."/index/settings_startup",
      'id'=>'settings_startup'
    );
    $menu[] = array(
      'label'=>"Home banner",
      'link'=>APP_FOLDER."/index/settings_homebanner",
      'id'=>'settings_homebanner'
    );
    $menu[] = array(
      'label'=>"Social login",
      'link'=>APP_FOLDER."/index/settings_social",
      'id'=>'settings_social'
    );
    $menu[] = array(
      'label'=>"Android Settings",
      'link'=>APP_FOLDER."/index/settings_android",
      'id'=>'settings_android'
    );
    $menu[] = array(
      'label'=>"FCM",
      'link'=>APP_FOLDER."/index/settings_fcm",
      'id'=>'settings_fcm'
    );
    $menu[] = array(
      'label'=>"Pages",
      'link'=>APP_FOLDER."/index/settings_pages",
      'id'=>'settings_pages'
    );
    $menu[] = array(
      'label'=>"Contact us",
      'link'=>APP_FOLDER."/index/settings_contactus",
      'id'=>'settings_contactus'
    );
    */
    
    return $menu;
  }


  public  function settingsMenu_merchant()
  {
    $menu[] = array(
      'label'=>"API Settings",
      'link'=>Config::$baseUrl."/pos/index/merchant_settings_for_merchant",
      'id'=>'merchant_settings'
    );    
    $menu[] = array(
      'label'=>"Application Settings",
      'link'=>Config::$baseUrl."/pos/index/settings_application_for_merchant",
      'id'=>'settings_application'
    );    
    
   
    
    return $menu;
  }




public function registeredDevice($data = array(), $status = 'active')
{
    $client_id = isset($data['client_id']) ? $data['client_id'] : '';
    $device_id = isset($data['device_id']) ? $data['device_id'] : '';
    $device_platform = isset($data['device_platform']) ? $data['device_platform'] : '';
    $device_uiid = isset($data['device_uiid']) ? $data['device_uiid'] : '';
    $code_version = isset($data['code_version']) ? $data['code_version'] : '';
    $device_platform = strtolower($device_platform);
    $merchant_id = isset($data['merchant_id']) ? $data['merchant_id'] : '';

    $params = array(
        'merchant_id'     => $merchant_id,
        'device_id'       => $device_id,
        'device_platform' => $device_platform,
        'device_uiid'     => $device_uiid,
        'status'          => $status,
        'code_version'    => $code_version,
        'date_created'    => $this->functions->dateNow(),
        'ip_address'      => $_SERVER['REMOTE_ADDR']
    );

    if ($client_id > 0) {
        $params['client_id'] = (int)$client_id;
    }

    if (!empty($device_uiid)) {
        $stmt = "
        SELECT * FROM mt_singleapp_device_reg
        WHERE device_uiid = '$device_uiid'
        LIMIT 0,1
        ";
        try {
          $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            $cmd = $this->db->prepare($stmt);
            $cmd->execute();
            $res = $cmd->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                unset($params['date_created']);
                $params['date_modified'] = $this->functions->dateNow();
                $this->functions->updateData("mt_singleapp_device_reg", $params, 'id', (int)$res['id']);
            } else {
                $this->functions->insertData("mt_singleapp_device_reg", $params);
            }
        } catch (Exception $e) {
            // Optional: handle exception, log error, etc.
        }
    }
}



  public  function timePastByTransaction($transaction_type='')
  {
    $error = '';
    switch ($transaction_type)
    {
      case "delivery":
      case "pickup":
      case "dinein":
        

        $error = "Sorry but you have selected ".$transaction_type." time that already past";
        break;
              
      default:    
          $error = "Sorry but you have selected time that already past";
          break;  
    }
    
    return $error;
  } 


  public function getReceiptByID($order_id = 0, $client_id = 0)
{
    $and = '';
    $order_id = (int)$order_id;
    $client_id = (int)$client_id;

    if ($client_id > 0) {
        $and = " AND a.client_id = " . $client_id . " ";
    }

    $stmt = "
    SELECT a.*,
    concat(b.first_name,' ',b.last_name) as full_name,
    b.location_name,
    concat(b.street,' ',b.area_name,' ',b.city,' ',b.state,' ',b.zipcode) as full_address,
    b.contact_phone,
    b.contact_phone as customer_phone,
    b.opt_contact_delivery,
    b.contact_email as email_address,
    b.contact_email as customer_email,

    c.restaurant_name as merchant_name,
    c.contact_phone as merchant_contact_phone,

    (
        select concat(street,' ',city,' ',state,' ',post_code)
        from mt_merchant
        where merchant_id = a.merchant_id
        limit 0,1
    ) as merchant_address

    FROM mt_order a
    LEFT JOIN mt_order_delivery_address b
        ON a.order_id = b.order_id
    LEFT JOIN mt_merchant c
        ON a.merchant_id = c.merchant_id

    WHERE a.order_id = $order_id
    $and
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // FIXED OLD DATA
        if (empty(trim($res['full_name']))) {
            $stmt2 = "
            SELECT 
                concat(first_name,' ',last_name) as full_name,
                contact_phone
            FROM mt_client
            WHERE client_id = " . $res['client_id'];
            $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            $query2 = $this->db->query($stmt2);
            $res2 = $query2->fetch(PDO::FETCH_ASSOC);

            if ($res2) {
                $res['full_name'] = $res2['full_name'];
                $res['contact_phone'] = $res2['contact_phone'];
            }
        }

        return $res;
    }

    return false;
}


public function ReOrderGetInfo($order_id = '')
{
    $order_id = (int)$order_id;

    $stmt = "
    SELECT a.*,
    b.restaurant_name,
    b.status as merchant_status,
    b.is_ready,
    b.service
    FROM mt_order a
    LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id
    WHERE a.order_id = $order_id
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public  function canCancel($date_created='', $days=0, $hours=0, $minutes=0)
  {
    if(!empty($date_created)){
        $date_created = date("Y-m-d g:i:s a",strtotime($date_created));     
      $date_now=date('Y-m-d g:i:s a');      
      $time_diff=$this->functions->dateDifference($date_created,$date_now);      
      if(is_array($time_diff) && count($time_diff)>=1){       
        if($days>$time_diff['days']){         
          return true;
        } elseif ( $hours>$time_diff['hours'] ) {
          return true;          
        } elseif ( $hours>=$time_diff['hours']){          
          if($minutes<$time_diff['minutes']){           
            return false;
          } else return true;
        } elseif ( $minutes>=$time_diff['minutes'] ){         
          return true;          
        }
                
      } else return true;
    }
    return false;
  } 


  public function getDeviceByUIID($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "
    SELECT * FROM mt_singleapp_device_reg
    WHERE device_uiid = '$device_uiid'
    LIMIT 0,1
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

public function getDeviceByID($id = '')
{
    if (empty($id)) {
        return false;
    }

    $stmt = "
    SELECT a.*,
    b.first_name,
    b.last_name
    FROM mt_singleapp_device_reg a
    LEFT JOIN mt_client b
        ON a.client_id = b.client_id
    WHERE a.id = $id
    LIMIT 0,1
    ";
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

public  function consumeUrl($url='')
  { 
      
    $is_curl_working = true;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {        
        $is_curl_working = false;
    }
    curl_close($ch);
    
    if(!$is_curl_working){
       $response = @file_get_contents($url);       
       if (isset($http_response_header)) {
        if (!in_array('HTTP/1.1 200 OK',(array)$http_response_header) && !in_array('HTTP/1.0 200 OK',(array)$http_response_header)) {
          //
        }
       }
    }
  }


  public  function inventoryEnabled($merchant_id='')
    {       
        if(empty($merchant_id)){
            return false;
        }   
        if(!is_numeric($merchant_id)){
            return false;
        }   
        
        $inv_enabled = false; 
        
            
                $inventory_live = $this->functions->getOption('inventory_live',$merchant_id);
                if($inventory_live==1){
                    $inv_enabled = true;
                     
                }
            
        
        return $inv_enabled;
    }  


    public  function getMerchantServices($services_id=0)
  {   
    switch ($services_id) {
      case 2:
        return array(
               'delivery'=>$this->functions->translation("default","Delivery"),
            );
        break;
      case 3:
        return array(
                'pickup'=>$this->functions->translation("default","Pickup")          
            );
        break;
        
      case 4: 
         return array(
               'delivery'=>$this->functions->translation("default","Delivery"),
               'pickup'=>$this->functions->translation("default","Pickup"),
               'dinein'=>"Dinein"
            );
         break;
         
      case 5: 
         return array(
               'delivery'=>$this->functions->translation("default","Delivery"),                 
               'dinein'=>"Dinein"
            );
         break;
         
      case 6: 
         return array(
               'pickup'=>$this->functions->translation("default","Pickup"),
               'dinein'=>"Dinein"
            );
         break;   
        
      case 7: 
         return array(                 
               'dinein'=>"Dinein"
            );
         break;       
            
      default:
        return array(
               'delivery'=>$this->functions->translation("default","Delivery"),
               'pickup'=>$this->functions->translation("default","Pickup") 
            );
        break;
    } 
  }


    


    









    
       

        

  






  
    
  


      
     
  

  







    

    

	
  			
	    
}
/*END CLASS*/