<div class="uk-width-1">
<a href="<?php echo Config::$baseUrl; ?>/admin/packagesAdd" class="uk-button"><i class="fa fa-plus"></i> <?php echo $this->functions->translation("default","Add New")?></a>
<a href="<?php echo Config::$baseUrl; ?>/admin/packages" class="uk-button"><i class="fa fa-list"></i> <?php echo $this->functions->translation("default","List")?></a>
</div>

<?php 

if (isset($_GET['id'])){
    if (!$data=$this->functions->getPackagesById($_GET['id'])){
        echo "<div class=\"uk-alert uk-alert-danger\">".
        $this->functions->translation("default","Sorry but we cannot find what your are looking for.")."</div>";
        return ;
    }
}
?>                                   

<div class="spacer"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">

    <input type="hidden" name="action" value="packagesAdd">
    <input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
    <?php if (!isset($_GET['id'])): ?>
        <input type="hidden" name="redirect" id="redirect" value="<?php echo Config::$baseUrl; ?>/admin/packagesAdd">
    <?php endif; ?>



<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Title")?></label>
    <input type="text" name="title" 
           value="<?php echo isset($data['title']) ? $data['title'] : ''; ?>" 
           class="uk-form-width-large" 
           data-validation="required">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Description")?></label>
    <textarea name="description" 
              class="uk-form-width-large" 
              data-validation="required"><?php echo isset($data['description']) ? $data['description'] : ''; ?></textarea>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Price")?></label>
    <input type="text" name="price" 
           value="<?php echo isset($data['price']) ? $this->functions->standardPrettyFormat($data['price']) : ''; ?>" 
           class="uk-form-width-medium numeric_only" 
           data-validation="required">
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Promo Price")?></label>
  <input type="text" name="promo_price" 
         value="<?php echo isset($data['promo_price']) ? $this->functions->standardPrettyFormat($data['promo_price']) : ''; ?>" 
         class="uk-form-width-medium numeric_only">
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Type")?></label>
  <select name="expiration_type" data-validation="required">
    <?php foreach ($this->functions->ExpirationType() as $key => $value) : ?>
      <option value="<?php echo $key; ?>" <?php echo isset($data['expiration_type']) && $data['expiration_type'] == $key ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Expiration (no. of days or Year)")?></label>
  <input type="text" name="expiration" 
         value="<?php echo isset($data['expiration']) ? $data['expiration'] : ''; ?>" 
         class="uk-form-width-medium numeric_only" 
         data-validation="required">
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Usage")?></label>
  <select name="unlimited_post" class="unlimited_post" data-validation="required">
    <?php foreach ($this->functions->ListlimitedPost() as $key => $value) : ?>
      <option value="<?php echo $key; ?>" <?php echo isset($data['unlimited_post']) && $data['unlimited_post'] == $key ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>

<div class="uk-form-row post_limit_wrap">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Number of Food Item Can Add")?></label>
  <input type="text" name="post_limit" 
         value="<?php echo isset($data['post_limit']) ? $data['post_limit'] : ''; ?>" 
         class="uk-form-width-medium numeric_only">
</div>


<?php 
$limit_sell=isset($data['sell_limit'])?$data['sell_limit']:"";
$limit_sell=$limit_sell<=0?"":$limit_sell;
?>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Limit merchant by sell")?></label>
  <input type="text" name="sell_limit" 
         value="<?php echo $limit_sell; ?>" 
         class="uk-form-width-medium numeric_only">
  <?php echo $this->functions->translation("default","Per month")?>
</div>





<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Status")?></label>
  <select name="status" class="uk-form-width-large" data-validation="required">
    <?php foreach ($this->functions->statusList() as $key => $value) : ?>
      <option value="<?php echo $key; ?>" <?php echo isset($data['status']) && $data['status'] == $key ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>





<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>