<?php 
$mtid=$this->functions->getMerchantID();
$wd_paypal_minimum=$this->functions->getOptionAdmin('wd_paypal_minimum');
$wd_bank_minimum=$this->functions->getOptionAdmin('wd_bank_minimum');

$query_date = date('c');					
$end_date=date('t F Y', strtotime($query_date));



$counrty_list=$this->functions->CountryList();

$default_country=$this->functions->getOptionAdmin("merchant_default_country");
$default_payout['paypal']=$this->functions->getOption("merchant_payout_account",$mtid);

$request_status=array(
  'pending','processing','approved'
);

$wd_enabled_paypal=$this->functions->getOptionAdmin('wd_enabled_paypal');
$wd_bank_deposit=$this->functions->getOptionAdmin('wd_bank_deposit');

$wd_bank_fields=$this->functions->getOptionAdmin('wd_bank_fields');

$bank_info='';
$merchant_payout_bank_account=$this->functions->getOption('merchant_payout_bank_account',$mtid);
if (!empty($merchant_payout_bank_account)){
	$bank_info=json_decode($merchant_payout_bank_account,true);
}
?>
<div class="withdrawals">

<div class="uk-panel uk-panel-box">

<div class="box-line-bottom">

  <h3 class="left"><?php echo ("Pending withdrawals")?></h3>



  <a href="<?php echo Config::$baseUrl; ?>/merchant/withdrawalshistory" class="right"><?php echo ("View withdrawal history")?></a>
  <div class="clear"></div>
</div>

<?php if ( $peding_request=$this->functions->getMerchantWithdrawal($mtid,$request_status)):?>
<table id="" class="uk-table uk-table-hover uk-table-striped uk-table-condensed">  
   <thead>
        <tr>            
            <th><?php echo $this->functions->translation('default',"Request Date")?></th>
            <th><?php echo $this->functions->translation('default',"Amount")?></th>
            <th><?php echo $this->functions->translation('default',"Payment Type")?></th>
            <th><?php echo $this->functions->translation('default',"Payment Method")?></th>
            <th><?php echo $this->functions->translation('default',"Account")?></th>
            <th><?php echo $this->functions->translation('default',"Date to process")?></th>
        </tr>
   <?php foreach ($peding_request as $val):?>  
        <?php 
        $account=$val['account'];
        if ( $val['payment_method']=="bank"){
        	$account=$val['bank_account_number'];
        }
        ?>      
        <tr>            
            <td><?php echo $this->functions->FormatDateTime($val['date_created'],false)?></td>
            <td><?php echo $this->functions->formatNumber($val['amount'])?></td>
            <td><?php echo $val['payment_type']?></td>
            <td><?php echo $val['payment_method']?></td>
            <td><?php echo $account?></td>
            <td><?php echo $this->functions->FormatDateTime($val['date_to_process'],false)?></td>
        </tr>
   <?php endforeach;?>     
    </thead>
    <tbody> 
    </tbody>
</table>
<?php else :?>
 <p><?php echo ("You currently have no withdrawals pending or queued for processing.")?></p>
<?php endif;?>
 
 <a class="uk-button uk-button-primary togle-withdrawal" href="javascript:;" class="make-withdrawal"><?php echo ("Make a withdrawal")?></a>

</div> <!--box-->

<div class="withdrawal-info"  >
<div class="box-line-bottom">
  <h3 class="left"><?php echo ("New withdrawal")?></h3>
  <p class="right"><?php echo ("You can withdraw up to")?>: <span class="merchant_total_balance"></span></p>
  <div class="clear"></div>
</div>

<div style="height:20px;"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="requestPayout">
<input type="hidden" name="payment_type" id="payment_type">
<input type="hidden" name="payment_method" id="payment_method">
<input type="hidden" name="redirect" id="redirect" value="<?php echo Config::$baseUrl; ?>/merchant/withdrawalstep2">
<input type="hidden" name="minimum_amount" id="minimum_amount">


<h2>1. Select a payment type</h2>
<ul class="withdrawals-ul">
   <li class="child-li li-click" data-id="single" data-type="payment-type">   
     <div class="box-grey payment">
       <h4><?php echo ("Single Payment")?></h4>
       <div class="inner">
       <span style="padding-right:10px;"><?php echo $this->functions->adminCurrencySymbol();?></span>
       <input type="text" name="amount" id="amount" class="numeric_only" value="">

       <p class="uk-text-muted">Minimum values apply</p>
       </div>
     </div> <!--box-->   
   </li>
   
   <li class="child-li li-click" data-id="all-earnings" data-type="payment-type">  
     <div class="box-grey payment">
       <h4><?php echo ("Single Payment")?></h4>
       <div class="inner">
       <?php echo ("All Earnings")?>
       <p class="uk-text-muted" style="margin-top:25px;"><?php echo ("As of")?> <?php echo $end_date;?> 23:59:59 </p>
       </div>
     </div> <!--box-->    
   </li>   
</ul>
<div class="clear"></div>

<h2>2. Select a payment method</h2>

<ul class="withdrawals-ul">

  <?php if ($wd_enabled_paypal==2):?>
  <li class="child-li li-click2" data-id="paypal" data-type="payment-method" data-minimum="<?php echo $wd_paypal_minimum?>">  
     <div class="box-grey">
       <h4><?php echo ("Paypal")?></h4>
       <div class="inner">
       <p><?php echo ("Minimum")?> <?php echo $this->functions->displayPrice($this->functions->getCurrencyCode(),$this->functions->standardPrettyFormat($wd_paypal_minimum))?></p>
       </div>
     </div> <!--box-->   
             
          
     
    <div class="paypal-account-wrap">

    <input 
        type="text" 
        name="account" 
        id="account" 
        class="uk-width-1-1" 
        placeholder="<?php echo ('Email address'); ?>" 
        value="<?php echo htmlspecialchars($default_payout['paypal'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
    >

    <div style="height:5px;"></div>

    <input 
        type="text" 
        name="account_confirm" 
        id="account_confirm" 
        class="uk-width-1-1" 
        placeholder="<?php echo ('Confirm Email address'); ?>" 
        value="<?php echo htmlspecialchars($default_payout['paypal'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
    >

    <div style="height:5px;"></div>

    <input 
        type="checkbox" 
        name="default_account_paypal" 
        id="default_account_paypal" 
        class="icheck" 
        value="2" 
        <?php echo (count($default_payout) >= 1) ? 'checked' : ''; ?>
    >
    
    <?php echo ("Make this my new default withdrawal account"); ?>

</div>
   
     
   </li>
   <?php endif;?>
   
   <?php if ( $wd_bank_deposit==2):?>
   <li class="child-li li-click2" data-id="bank" data-type="payment-method" data-minimum="<?php echo $wd_bank_minimum?>">  
     <div class="box-grey">
       <h4><?php echo ("Bank")?></h4>
       <div class="inner">
       <p><?php echo ("Minimum")?> <?php echo $this->functions->displayPrice($this->functions->getCurrencyCode(),$this->functions->standardPrettyFormat($wd_bank_minimum))?></p>
       </div>
     </div> <!--box-->  
                    
   </li>
   <?php endif;?>
</ul>
<div class="clear"></div>


<div class="bank-info-wrap">

<?php if ( $wd_bank_fields=="au"):?>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "BSB"); ?>
    <span class="required">*</span>
  </label>
  
  <input 
    type="text" 
    name="swift_code" 
    id="swift_code" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['swift_code']) ? htmlspecialchars($bank_info['swift_code'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Account Number"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="bank_account_number" 
    id="bank_account_number" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['bank_account_number']) ? htmlspecialchars($bank_info['bank_account_number'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Account Name"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="account_name" 
    id="account_name" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['account_name']) ? htmlspecialchars($bank_info['account_name'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>


<div style="height:5px;"></div>
 <input 
  type="checkbox" 
  name="default_account_bank" 
  id="default_account_bank" 
  class="icheck" 
  value="2" 
  <?php echo is_array($bank_info) ? 'checked' : ''; ?>
>

 <?php echo ("Make this my new default withdrawal account")?>
 </div>     
 


<?php else :?>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Bank Account Holder's Name"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="account_name" 
    id="account_name" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['account_name']) ? htmlspecialchars($bank_info['account_name'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Bank Account Number/IBAN"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="bank_account_number" 
    id="bank_account_number" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['bank_account_number']) ? htmlspecialchars($bank_info['bank_account_number'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "SWIFT Code"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="swift_code" 
    id="swift_code" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['swift_code']) ? htmlspecialchars($bank_info['swift_code'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Bank Name in Full"); ?>
    <span class="required">*</span>
  </label>

  <input 
    type="text" 
    name="bank_name" 
    id="bank_name" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['bank_name']) ? htmlspecialchars($bank_info['bank_name'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Bank Branch City"); ?>
  </label>

  <input 
    type="text" 
    name="bank_branch" 
    id="bank_branch" 
    class="uk-form-width-large" 
    value="<?php echo isset($bank_info['bank_branch']) ? htmlspecialchars($bank_info['bank_branch'], ENT_QUOTES, 'UTF-8') : ''; ?>"
  >
</div>


<?php 
if (isset($bank_info['bank_country'])){
	if (!empty($bank_info['bank_country'])){
	    $default_country=$bank_info['bank_country'];
	}
}
?>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Bank Branch Country"); ?>
    <span class="required">*</span>
  </label>

  <select 
    name="bank_country" 
    id="bank_country" 
    class="uk-form-width-large"
  >
    <?php foreach ($counrty_list as $key => $label): ?>
      <option 
        value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>" 
        <?php echo ($key == $default_country) ? 'selected' : ''; ?>
      >
        <?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>




<div style="height:5px;"></div>
 <input 
  type="checkbox" 
  name="default_account_bank" 
  id="default_account_bank" 
  class="icheck" 
  value="2"
>

 <?php echo ("Make this my new default withdrawal account")?>
 </div>     
 

<?php endif;?>




<div style="height:20px;"></div>

<div class="uk-form-row" style="margin-left:30px;">
<input type="submit" value="<?php echo $this->functions->translation("default","Submit Request")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</div> <!--bank-info-wrap-->

</form>


</div> <!--withdrawal-info-->

</div> <!--withdrawals-->