/*
 Highcharts JS v8.0.4 (2020-03-10)

 Sonification module

 (c) 2012-2019 ystein Moseng

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(n){b(n);b.Highcharts=n;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function n(e,b,d,p){e.hasOwnProperty(b)||(e[b]=p.apply(null,d))}b=b?b._modules:{};n(b,"modules/sonification/Instrument.js",[b["parts/Globals.js"],b["parts/Utilities.js"]],function(e,b){function d(c){this.init(c)}
var p=b.error,m=b.merge,g=b.pick,q=b.uniqueKey,k={type:"oscillator",playCallbackInterval:20,oscillator:{waveformShape:"sine"}};d.prototype.init=function(c){this.initAudioContext()?(this.options=m(k,c),this.id=this.options.id=c&&c.id||q(),c=e.audioContext,this.gainNode=c.createGain(),this.setGain(0),(this.panNode=c.createStereoPanner&&c.createStereoPanner())?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(c.destination)):this.gainNode.connect(c.destination),"oscillator"===
this.options.type&&this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):p(29)};d.prototype.copy=function(c){return new d(m(this.options,{id:null},c))};d.prototype.initAudioContext=function(){var c=e.win.AudioContext||e.win.webkitAudioContext,a=!!e.audioContext;return c?(e.audioContext=e.audioContext||new c,!a&&e.audioContext&&"running"===e.audioContext.state&&e.audioContext.suspend(),!!(e.audioContext&&e.audioContext.createOscillator&&e.audioContext.createGain)):!1};d.prototype.initOscillator=
function(c){this.oscillator=e.audioContext.createOscillator();this.oscillator.type=c.waveformShape;this.oscillator.connect(this.gainNode);this.oscillatorStarted=!1};d.prototype.setPan=function(c){this.panNode&&this.panNode.pan.setValueAtTime(c,e.audioContext.currentTime)};d.prototype.setGain=function(c,a){this.gainNode&&(1.2<c&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),c=1.2),a?(this.gainNode.gain.setValueAtTime(this.gainNode.gain.value,e.audioContext.currentTime),
this.gainNode.gain.linearRampToValueAtTime(c,e.audioContext.currentTime+a/1E3)):this.gainNode.gain.setValueAtTime(c,e.audioContext.currentTime))};d.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)};d.prototype.getValidFrequency=function(c,a,f){var h=this.options.allowedFrequencies,e=g(f,Infinity),b=g(a,-Infinity);return h&&h.length?h.reduce(function(a,f){return Math.abs(f-c)<Math.abs(a-c)&&f<e&&f>b?f:a},Infinity):c};d.prototype.clearPlayCallbackTimers=
function(){this.playCallbackTimers.forEach(function(c){clearInterval(c)});this.playCallbackTimers=[]};d.prototype.setFrequency=function(c,a){a=a||{};c=this.getValidFrequency(c,a.min,a.max);"oscillator"===this.options.type&&this.oscillatorPlay(c)};d.prototype.oscillatorPlay=function(c){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0);this.oscillator.frequency.setValueAtTime(c,e.audioContext.currentTime)};d.prototype.preparePlay=function(){this.setGain(.001);"suspended"===
e.audioContext.state&&e.audioContext.resume();this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)};d.prototype.play=function(c){var a=this,f=c.duration||0,h=function(f,h,e){var b=c.duration,d=0,k=a.options.playCallbackInterval;if("function"===typeof f){var g=setInterval(function(){d++;var c=d*k/b;if(1<=c)a[h](f(1),e),clearInterval(g);else a[h](f(c),e)},k);a.playCallbackTimers.push(g)}else a[h](f,e)};if(a.id)if("suspended"===e.audioContext.state||this.oscillator&&
!this.oscillatorStarted)a.preparePlay(),setTimeout(function(){a.play(c)},10);else{a.playCallbackTimers.length&&a.clearPlayCallbackTimers();a.cancelGainRamp();a.stopOscillatorTimeout&&(clearTimeout(a.stopOscillatorTimeout),delete a.stopOscillatorTimeout);a.stopTimeout&&(clearTimeout(a.stopTimeout),delete a.stopTimeout,a.stopCallback&&(a._play=a.play,a.play=function(){},a.stopCallback("cancelled"),a.play=a._play));var b=f<e.sonification.fadeOutDuration+20;a.stopCallback=c.onEnd;var d=function(){delete a.stopTimeout;
a.stop(b)};f?(a.stopTimeout=setTimeout(d,b?f:f-e.sonification.fadeOutDuration),h(c.frequency,"setFrequency",{minFrequency:c.minFrequency,maxFrequency:c.maxFrequency}),h(g(c.volume,1),"setGain",4),h(g(c.pan,0),"setPan")):d()}};d.prototype.mute=function(){this.setGain(.0001,.8*e.sonification.fadeOutDuration)};d.prototype.stop=function(c,a,f){var h=this,b=function(){h.stopOscillatorTimeout&&delete h.stopOscillatorTimeout;try{h.oscillator.stop()}catch(t){}h.oscillator.disconnect(h.gainNode);h.initOscillator(h.options.oscillator);
a&&a(f);h.stopCallback&&h.stopCallback(f)};h.playCallbackTimers.length&&h.clearPlayCallbackTimers();h.stopTimeout&&clearTimeout(h.stopTimeout);c?(h.setGain(0),b()):(h.mute(),h.stopOscillatorTimeout=setTimeout(b,e.sonification.fadeOutDuration+100))};return d});n(b,"modules/sonification/musicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,
29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,
164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,
880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]});n(b,"modules/sonification/utilities.js",
[b["modules/sonification/musicalFrequencies.js"],b["parts/Utilities.js"]],function(e,b){function d(b){this.init(b||[])}var p=b.clamp;d.prototype.init=function(b){this.supportedSignals=b;this.signals={}};d.prototype.registerSignalCallbacks=function(b){var e=this;e.supportedSignals.forEach(function(d){var k=b[d];k&&(e.signals[d]=e.signals[d]||[]).push(k)})};d.prototype.clearSignalCallbacks=function(b){var e=this;b?b.forEach(function(b){e.signals[b]&&delete e.signals[b]}):e.signals={}};d.prototype.emitSignal=
function(b,e){var d;this.signals[b]&&this.signals[b].forEach(function(b){b=b(e);d="undefined"!==typeof b?b:d});return d};return{musicalFrequencies:e,SignalHandler:d,getMusicalScale:function(b){return e.filter(function(e,d){var k=d%12+1;return b.some(function(c){return c===k})})},calculateDataExtremes:function(b,e){return b.series.reduce(function(b,d){d.points.forEach(function(c){c="undefined"!==typeof c[e]?c[e]:c.options[e];b.min=Math.min(b.min,c);b.max=Math.max(b.max,c)});return b},{min:Infinity,
max:-Infinity})},virtualAxisTranslate:function(b,e,d){var k=e.max-e.min;b=d.min+(d.max-d.min)*(b-e.min)/k;return 0<k?p(b,d.min,d.max):d.min}}});n(b,"modules/sonification/instrumentDefinitions.js",[b["modules/sonification/Instrument.js"],b["modules/sonification/utilities.js"]],function(b,l){var e={};["sine","square","triangle","sawtooth"].forEach(function(d){e[d]=new b({oscillator:{waveformShape:d}});e[d+"Musical"]=new b({allowedFrequencies:l.musicalFrequencies,oscillator:{waveformShape:d}});e[d+"Major"]=
new b({allowedFrequencies:l.getMusicalScale([1,3,5,6,8,10,12]),oscillator:{waveformShape:d}})});return e});n(b,"modules/sonification/Earcon.js",[b["parts/Globals.js"],b["parts/Utilities.js"]],function(b,l){function e(b){this.init(b||{})}var p=l.error,m=l.merge,g=l.pick,q=l.uniqueKey;e.prototype.init=function(b){this.options=b;this.options.id||(this.options.id=this.id=q());this.instrumentsPlaying={}};e.prototype.sonify=function(e){var c=m(this.options,e),a=g(c.volume,1),f=c.pan,d=this,k=e&&e.onEnd,
t=d.options.onEnd;c.instruments.forEach(function(c){var e="string"===typeof c.instrument?b.sonification.instruments[c.instrument]:c.instrument,h=m(c.playOptions),r="";if(e&&e.play){if(c.playOptions){"function"!==typeof c.playOptions.volume&&(h.volume=g(a,1)*g(c.playOptions.volume,1));h.pan=g(f,h.pan);var l=h.onEnd;h.onEnd=function(){delete d.instrumentsPlaying[r];l&&l.apply(this,arguments);Object.keys(d.instrumentsPlaying).length||(k&&k.apply(this,arguments),t&&t.apply(this,arguments))};c=e.copy();
r=c.id;d.instrumentsPlaying[r]=c;c.play(h)}}else p(30)})};e.prototype.cancelSonify=function(b){var c=this.instrumentsPlaying,a=c&&Object.keys(c);a&&a.length&&(a.forEach(function(a){c[a].stop(!b,null,"cancelled")}),this.instrumentsPlaying={})};return e});n(b,"modules/sonification/pointSonify.js",[b["parts/Globals.js"],b["parts/Utilities.js"],b["modules/sonification/utilities.js"]],function(b,l,d){var e=l.error,m=l.merge,g=l.pick,q={minDuration:20,maxDuration:2E3,minVolume:.1,maxVolume:1,minPan:-1,
maxPan:1,minFrequency:220,maxFrequency:2200};return{pointSonify:function(k){var c=this,a=c.series.chart,f=k.dataExtremes||{},h=function(a,b,e){return"function"===typeof a?b?function(b){return a(c,f,b)}:a(c,f):"string"===typeof a?(f[a]=f[a]||d.calculateDataExtremes(c.series.chart,a),d.virtualAxisTranslate(g(c[a],c.options[a]),f[a],e)):a};a.sonification.currentlyPlayingPoint=c;c.sonification=c.sonification||{};c.sonification.instrumentsPlaying=c.sonification.instrumentsPlaying||{};var r=c.sonification.signalHandler=
c.sonification.signalHandler||new d.SignalHandler(["onEnd"]);r.clearSignalCallbacks();r.registerSignalCallbacks({onEnd:k.onEnd});!c.isNull&&c.visible&&c.series.visible?k.instruments.forEach(function(f){var d="string"===typeof f.instrument?b.sonification.instruments[f.instrument]:f.instrument,k=f.instrumentMapping||{},g=m(q,f.instrumentOptions),l=d.id,p=function(b){f.onEnd&&f.onEnd.apply(this,arguments);a.sonification&&a.sonification.currentlyPlayingPoint&&delete a.sonification.currentlyPlayingPoint;
c.sonification&&c.sonification.instrumentsPlaying&&(delete c.sonification.instrumentsPlaying[l],Object.keys(c.sonification.instrumentsPlaying).length||r.emitSignal("onEnd",b))};d&&d.play?(c.sonification.instrumentsPlaying[d.id]=d,d.play({frequency:h(k.frequency,!0,{min:g.minFrequency,max:g.maxFrequency}),duration:h(k.duration,!1,{min:g.minDuration,max:g.maxDuration}),pan:h(k.pan,!0,{min:g.minPan,max:g.maxPan}),volume:h(k.volume,!0,{min:g.minVolume,max:g.maxVolume}),onEnd:p,minFrequency:g.minFrequency,
maxFrequency:g.maxFrequency})):e(30)}):r.emitSignal("onEnd")},pointCancelSonify:function(b){var c=this.sonification&&this.sonification.instrumentsPlaying,a=c&&Object.keys(c);a&&a.length&&(a.forEach(function(a){c[a].stop(!b,null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}});n(b,"modules/sonification/chartSonify.js",[b["parts/Globals.js"],b["parts/Point.js"],b["parts/Utilities.js"],b["modules/sonification/utilities.js"]],
function(b,l,d,p){function e(a,b){return"function"===typeof b?b(a):w(a[b],a.options[b])}function g(a,b){return a.points.reduce(function(a,c){c=e(c,b);a.min=Math.min(a.min,c);a.max=Math.max(a.max,c);return a},{min:Infinity,max:-Infinity})}function q(a,b,c){return(b||[]).reduce(function(b,c){Object.keys(c.instrumentMapping||{}).forEach(function(e){e=c.instrumentMapping[e];"string"!==typeof e||b[e]||(b[e]=p.calculateDataExtremes(a,e))});return b},v(c))}function k(a,c){return c.reduce(function(c,e){var d=
e.earcon;e.condition?(e=e.condition(a),e instanceof b.sonification.Earcon?c.push(e):e&&c.push(d)):e.onPoint&&a.id===e.onPoint&&c.push(d);return c},[])}function c(a){return a.map(function(a){var c=a.instrument;c=("string"===typeof c?b.sonification.instruments[c]:c).copy();return v(a,{instrument:c})})}function a(a,d){var f=d.timeExtremes||g(a,d.pointPlayTime),h=q(a.chart,d.instruments,d.dataExtremes),C=c(d.instruments),D=a.points.reduce(function(a,c){var g=k(c,d.earcons||[]),x=p.virtualAxisTranslate(e(c,
d.pointPlayTime),f,{min:0,max:d.duration});return a.concat(new b.sonification.TimelineEvent({eventObject:c,time:x,id:c.id,playOptions:{instruments:C,dataExtremes:h}}),g.map(function(a){return new b.sonification.TimelineEvent({eventObject:a,time:x})}))},[]);return new b.sonification.TimelinePath({events:D,onStart:function(){if(d.onStart)d.onStart(a)},onEventStart:function(a){var b=a.options&&a.options.eventObject;if(b instanceof l){if(!b.series.visible&&!b.series.chart.series.some(function(a){return a.visible}))return a.timelinePath.timeline.pause(),
a.timelinePath.timeline.resetCursor(),!1;if(d.onPointStart)d.onPointStart(a,b)}},onEventEnd:function(a){var b=a.event&&a.event.options&&a.event.options.eventObject;if(b instanceof l&&d.onPointEnd)d.onPointEnd(a.event,b)},onEnd:function(){if(d.onEnd)d.onEnd(a)}})}function f(a,b,c){var e=c.seriesOptions||{};return v({dataExtremes:b,timeExtremes:g(a,c.pointPlayTime),instruments:c.instruments,onStart:c.onSeriesStart,onEnd:c.onSeriesEnd,earcons:c.earcons},B(e)?A(e,function(b){return b.id===w(a.id,a.options.id)})||
{}:e,{pointPlayTime:c.pointPlayTime})}function h(a,c,e){if("sequential"===a||"simultaneous"===a){var d=c.series.reduce(function(a,b){b.visible&&a.push({series:b,seriesOptions:e(b)});return a},[]);"simultaneous"===a&&(d=[d])}else d=a.reduce(function(a,d){d=u(d).reduce(function(a,d){var f;if("string"===typeof d){var h=c.get(d);h.visible&&(f={series:h,seriesOptions:e(h)})}else d instanceof b.sonification.Earcon&&(f=new b.sonification.TimelinePath({events:[new b.sonification.TimelineEvent({eventObject:d})]}));
d.silentWait&&(f=new b.sonification.TimelinePath({silentWait:d.silentWait}));f&&a.push(f);return a},[]);d.length&&a.push(d);return a},[]);return d}function r(a,c){return c?a.reduce(function(d,e,f){e=u(e);d.push(e);f<a.length-1&&e.some(function(a){return a.series})&&d.push(new b.sonification.TimelinePath({silentWait:c}));return d},[]):a}function t(a){return a.reduce(function(a,b){b=u(b);return a+(1===b.length&&b[0].options&&b[0].options.silentWait||0)},0)}function n(a){var c=a.reduce(function(a,b){(b=
b.events)&&b.length&&(a.min=Math.min(b[0].time,a.min),a.max=Math.max(b[b.length-1].time,a.max));return a},{min:Infinity,max:-Infinity});a.forEach(function(a){var d=a.events,e=d&&d.length,f=[];e&&d[0].time<=c.min||f.push(new b.sonification.TimelineEvent({time:c.min}));e&&d[d.length-1].time>=c.max||f.push(new b.sonification.TimelineEvent({time:c.max}));f.length&&a.addTimelineEvents(f)})}function y(a){return a.reduce(function(a,b){return a+u(b).reduce(function(a,b){return(b=b.series&&b.seriesOptions&&
b.seriesOptions.timeExtremes)?Math.max(a,b.max-b.min):a},0)},0)}function z(c,d){var e=Math.max(d-t(c),0),f=y(c);return c.reduce(function(c,d){d=u(d).reduce(function(c,d){d instanceof b.sonification.TimelinePath?c.push(d):d.series&&(d.seriesOptions.duration=d.seriesOptions.duration||p.virtualAxisTranslate(d.seriesOptions.timeExtremes.max-d.seriesOptions.timeExtremes.min,{min:0,max:f},{min:0,max:e}),c.push(a(d.series,d.seriesOptions)));return c},[]);c.push(d);return c},[])}"";var A=d.find,B=d.isArray,
v=d.merge,w=d.pick,u=d.splat;return{chartSonify:function(a){var c=v(this.options.sonification,a);if(!1!==c.enabled){this.sonification.timeline&&this.sonification.timeline.pause();this.sonification.duration=c.duration;var d=q(this,c.instruments,c.dataExtremes);a=h(c.order,this,function(a){return f(a,d,c)});a=r(a,c.afterSeriesWait||0);a=z(a,c.duration);a.forEach(function(a){n(a)});this.sonification.timeline=new b.sonification.Timeline({paths:a,onEnd:c.onEnd});this.sonification.timeline.play()}},seriesSonify:function(c){var d=
a(this,c),e=this.chart.sonification;e.timeline&&e.timeline.pause();e.duration=c.duration;e.timeline=new b.sonification.Timeline({paths:[d]});e.timeline.play()},pause:function(a){this.sonification.timeline?this.sonification.timeline.pause(w(a,!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(a)},resume:function(a){this.sonification.timeline&&this.sonification.timeline.play(a)},rewind:function(a){this.sonification.timeline&&this.sonification.timeline.rewind(a)},
cancel:function(a){this.pauseSonify(a);this.resetSonifyCursor()},getCurrentPoints:function(){if(this.sonification.timeline){var a=this.sonification.timeline.getCursor();return Object.keys(a).map(function(b){return a[b].eventObject}).filter(function(a){return a instanceof l})}return[]},setCursor:function(a){var b=this.sonification.timeline;b&&u(a).forEach(function(a){b.setCursor(a.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&
this.sonification.timeline.resetCursorEnd()}}});n(b,"modules/sonification/Timeline.js",[b["parts/Globals.js"],b["parts/Utilities.js"],b["modules/sonification/utilities.js"]],function(b,l,d){function e(a){this.init(a||{})}function m(a){this.init(a)}function g(a){this.init(a||{})}var n=l.merge,k=l.splat,c=l.uniqueKey;e.prototype.init=function(a){this.options=a;this.time=a.time||0;this.id=this.options.id=a.id||c()};e.prototype.play=function(a){var b=this.options.eventObject,c=this.options.onEnd,d=a&&
a.onEnd,e=this.options.playOptions&&this.options.playOptions.onEnd;a=n(this.options.playOptions,a);b&&b.sonify?(a.onEnd=c||d||e?function(){var a=arguments;[c,d,e].forEach(function(b){b&&b.apply(this,a)})}:void 0,b.sonify(a)):(d&&d(),c&&c())};e.prototype.cancel=function(a){this.options.eventObject.cancelSonify(a)};m.prototype.init=function(a){this.options=a;this.id=this.options.id=a.id||c();this.cursor=0;this.eventsPlaying={};this.events=a.silentWait?[new e({time:0}),new e({time:a.silentWait})]:this.options.events;
this.sortEvents();this.updateEventIdMap();this.signalHandler=new d.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]);this.signalHandler.registerSignalCallbacks(n(a,{masterOnEnd:a.onEnd}))};m.prototype.sortEvents=function(){this.events=this.events.sort(function(a,b){return a.time-b.time})};m.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(a,b,c){a[b.id]=c;return a},{})};m.prototype.addTimelineEvents=function(a){this.events=this.events.concat(a);
this.sortEvents();this.updateEventIdMap()};m.prototype.getCursor=function(){return this.events[this.cursor]};m.prototype.setCursor=function(a){a=this.eventIdMap[a];return"undefined"!==typeof a?(this.cursor=a,!0):!1};m.prototype.play=function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(1)};m.prototype.rewind=function(a){this.pause();this.signalHandler.emitSignal("onStart");
this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(-1)};m.prototype.resetCursor=function(){this.cursor=0};m.prototype.resetCursorEnd=function(){this.cursor=this.events.length-1};m.prototype.pause=function(a){var b=this;clearTimeout(b.nextScheduledPlay);Object.keys(b.eventsPlaying).forEach(function(c){b.eventsPlaying[c]&&b.eventsPlaying[c].cancel(a)});b.eventsPlaying={}};m.prototype.playEvents=function(a){var b=this,c=b.events[this.cursor],
d=b.events[this.cursor+a],e=function(a){b.signalHandler.emitSignal("masterOnEnd",a);b.signalHandler.emitSignal("playOnEnd",a)};c.timelinePath=b;if(!1===b.signalHandler.emitSignal("onEventStart",c))e({event:c,cancelled:!0});else if(b.eventsPlaying[c.id]=c,c.play({onEnd:function(a){a={event:c,cancelled:!!a};delete b.eventsPlaying[c.id];b.signalHandler.emitSignal("onEventEnd",a);d||e(a)}}),d){var g=Math.abs(d.time-c.time);1>g?(b.cursor+=a,b.playEvents(a)):this.nextScheduledPlay=setTimeout(function(){b.cursor+=
a;b.playEvents(a)},g)}};g.prototype.init=function(a){this.options=a;this.cursor=0;this.paths=a.paths;this.pathsPlaying={};this.signalHandler=new d.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]);this.signalHandler.registerSignalCallbacks(n(a,{masterOnEnd:a.onEnd}))};g.prototype.play=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(1)};g.prototype.rewind=function(a){this.pause();
this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(-1)};g.prototype.playPaths=function(a){var c=k(this.paths[this.cursor]),d=this.paths[this.cursor+a],e=this,g=this.signalHandler,l=0,m=function(b){g.emitSignal("onPathStart",b);e.pathsPlaying[b.id]=b;b[0<a?"play":"rewind"](function(f){f=f&&f.cancelled;var h={path:b,cancelled:f};delete e.pathsPlaying[b.id];g.emitSignal("onPathEnd",h);l++;l>=c.length&&(d&&!f?(e.cursor+=a,k(d).forEach(function(b){b[0<
a?"resetCursor":"resetCursorEnd"]()}),e.playPaths(a)):(g.emitSignal("playOnEnd",h),g.emitSignal("masterOnEnd",h)))})};c.forEach(function(a){a&&(a.timeline=e,setTimeout(function(){m(a)},b.sonification.fadeOutDuration))})};g.prototype.pause=function(a){var b=this;Object.keys(b.pathsPlaying).forEach(function(c){b.pathsPlaying[c]&&b.pathsPlaying[c].pause(a)});b.pathsPlaying={}};g.prototype.resetCursor=function(){this.paths.forEach(function(a){k(a).forEach(function(a){a.resetCursor()})});this.cursor=0};
g.prototype.resetCursorEnd=function(){this.paths.forEach(function(a){k(a).forEach(function(a){a.resetCursorEnd()})});this.cursor=this.paths.length-1};g.prototype.setCursor=function(a){return this.paths.some(function(b){return k(b).some(function(b){return b.setCursor(a)})})};g.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(a,b){a[b.id]=b.getCursor();return a},{})};g.prototype.atStart=function(){return!this.getCurrentPlayingPaths().some(function(a){return a.cursor})};
g.prototype.getCurrentPlayingPaths=function(){return k(this.paths[this.cursor])};return{TimelineEvent:e,TimelinePath:m,Timeline:g}});n(b,"modules/sonification/options.js",[],function(){return{sonification:{enabled:!1,duration:2E3,afterSeriesWait:1E3,order:"sequential",pointPlayTime:"x",instruments:[{instrument:"sineMusical",instrumentMapping:{duration:400,frequency:"y",volume:.7},instrumentOptions:{minFrequency:392,maxFrequency:1046}}]}}});n(b,"modules/sonification/sonification.js",[b["parts/Globals.js"],
b["parts/Point.js"],b["parts/Utilities.js"],b["modules/sonification/Instrument.js"],b["modules/sonification/instrumentDefinitions.js"],b["modules/sonification/Earcon.js"],b["modules/sonification/pointSonify.js"],b["modules/sonification/chartSonify.js"],b["modules/sonification/utilities.js"],b["modules/sonification/Timeline.js"],b["modules/sonification/options.js"]],function(b,l,d,n,m,g,q,k,c,a,f){var e=d.addEvent,p=d.extend,t=d.merge;b.sonification={fadeOutDuration:20,utilities:c,Instrument:n,instruments:m,
Earcon:g,TimelineEvent:a.TimelineEvent,TimelinePath:a.TimelinePath,Timeline:a.Timeline};t(!0,b.defaultOptions,f);l.prototype.sonify=q.pointSonify;l.prototype.cancelSonify=q.pointCancelSonify;b.Series.prototype.sonify=k.seriesSonify;p(b.Chart.prototype,{sonify:k.chartSonify,pauseSonify:k.pause,resumeSonify:k.resume,rewindSonify:k.rewind,cancelSonify:k.cancel,getCurrentSonifyPoints:k.getCurrentPoints,setSonifyCursor:k.setCursor,resetSonifyCursor:k.resetCursor,resetSonifyCursorEnd:k.resetCursorEnd});
e(b.Chart,"init",function(){this.sonification={}});e(b.Chart,"update",function(a){(a=a.options.sonification)&&t(!0,this.options.sonification,a)})});n(b,"masters/modules/sonification.src.js",[],function(){})});
//# sourceMappingURL=sonification.js.map