<?php
class CheckoutWrapper
{

    public function __construct() {
       
        //$model = new Model();
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions

    $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

       $this->MapsWrapper = new MapsWrapper();
    
        

    }


	public  function verifyCanPlaceOrder_wrng($client_id = '')
{
    // Get the option for restricting order by status
    $restrict_order_by_status = $this->functions->getOptionAdmin('restrict_order_by_status');


    
    if (!empty($restrict_order_by_status)) {            
        if ($json = json_decode($restrict_order_by_status, true)) {
            // Collect statuses into a comma-separated string
            $order_stats = implode(",", array_map('intval', $json));
              // Sanitize values as integers

            print_r($order_stats);die(); 
            if (!empty($order_stats)) {
                echo"gfh".$order_stats;die();
                $stmt = "
                    SELECT order_id, status
                    FROM mt_order
                    WHERE client_id = :client_id
                    AND status IN ($order_stats)
                    ORDER BY order_id DESC
                    LIMIT 1
                ";

                // Prepare the PDO statement
                $query = $this->db->prepare($stmt);
                $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
                $query->execute();

                if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
                    

                    throw new Exception("You have previous orders with status".$res['status']."You cannot place another order until your last order is processed.");

                }
            }
        }
    }

    return true;
}


public  function verifyCanPlaceOrder($client_id = '')
{
    $restrict_order_by_status = $this->functions->getOptionAdmin('restrict_order_by_status');

    if (!empty($restrict_order_by_status)) {            
        if ($json = json_decode($restrict_order_by_status, true)) {
            $order_stats = ''; 
            foreach ($json as $val) {
               $order_stats .= "'" . addslashes($val) . "',";                   
            }   


                
            if (!empty($order_stats)) {
                $order_stats = substr($order_stats, 0, -1);

                $stmt = "SELECT order_id, status
                        FROM mt_order                   
                        WHERE 
                        client_id = :client_id
                        AND
                        status IN ($order_stats)
                        ORDER BY order_id DESC
                        LIMIT 1";
                
                $query = $this->db->prepare($stmt);
                $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
                $query->execute();

                if ($res = $query->fetch(PDO::FETCH_ASSOC)) {                        
                    throw new Exception("You have previous orders with status".$res['status']. "You cannot place another order until your last order is processed.");
                }
            }
        }
    }
    return true;
}

	
public  function verifyLocation($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0)
{
    $stmt = "
        SELECT merchant_id, latitude, lontitude, minimum_order
        FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";
    
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();
    
    $resp = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $provider = $this->functions->getMapProvider();
        $this->MapsWrapper->init($provider);
        $unit = $this->functions->getMerchantDistanceType($merchant_id);
        $mode = isset($provider['mode']) ? $provider['mode'] : 'driving';

        // Get Merchant Delivery Distance
        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);
        
        // Get Delivery Fee
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);
        
        $resp_distance = array();

        if ($merchant_delivery_distance > 0) {
            // Get Distance from Map Provider
            $resp_distance = $this->MapsWrapper->getDistance($resp['latitude'], $resp['lontitude'], $lat, $lng, $unit, $mode);

            $distance = $resp_distance['distance'];
            if ($merchant_delivery_distance > 0) {
                if ($distance > $merchant_delivery_distance) {
                   

                    $pretty_distance = $merchant_delivery_distance . " " . $this->MapsWrapper->prettyUnit($unit);


                    

                    $error = $this->functions->translation("default", "Sorry but this merchant delivers only within ".$pretty_distance." your current distance is".$resp_distance['pretty_distance']) ;


                    throw new Exception($error);
                }
            }

            /* MINIMUM ORDER TABLE */
            $min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, $resp_distance['distance'], $resp_distance['unit'], $resp['minimum_order']
                );
                if ($min_order > $order_subtotal) {
                   

                    $error = "Sorry but minimum order is ".$this->functions->prettyPrice($min_order)." for distance ". $resp_distance['pretty_distance'] ;

                    throw new Exception($error);
                }
            }

            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {
                $delivery_fee = $this->getShippingFee($merchant_id, $resp_distance['distance'], $resp_distance['unit'], $delivery_fee);
            }
        }

        return array_merge((array) $resp_distance, array('delivery_fee' => $delivery_fee));
    } else {
        throw new Exception("Merchant not found");
    }
}

	
	/* PARAMETERS 
	array
		(
		    [merchant_id] => 1
		    [provider] => Array
		        (
		            [provider] => google.maps
		            [token] => AIzaSyBp5olQaiXZfnlRqsUGehhtBRId2rWcj8A
		            [map_api] => AIzaSyBAD37tZZ5mOqmkgV66o0_6tZ2-rhdZSmE
		            [map_distance_results] => 2
		            [mode] => driving
		        )
		
		    [from_lat] => 14.561682215800909
		    [from_lng] => 121.04538871772155
		    [to_lat] => 14.5437996
		    [to_lng] => 121.0115282
		    [delivery_charges] => 1.50000
		    [unit] => mi
		    [delivery_distance_covered] => 5.00
		    [order_subtotal] => 0,
		    ['minimum_order] => 10
		)
	*/
	public  function getDeliveryDetails($data=array())
	{											
		$merchant_id = $data['merchant_id'];
		$delivery_fee = $data['delivery_charges'];
		$unit = $this->unit($data['unit']);		
		$mode = $data['provider']['mode'];		
		$merchant_delivery_distance = (float)$data['delivery_distance_covered'];		
		
		$resp_distance = $this->MapsWrapper->getDistance($data['from_lat'],$data['from_lng'],$data['to_lat'],$data['to_lng'],$unit,$mode);
		if($resp_distance){			
			$distance = $resp_distance['distance'];			
			
			if($merchant_delivery_distance>0){
	        	if($distance>$merchant_delivery_distance){	        		
	    		   

	    		   

                   $pretty_distance = $merchant_delivery_distance." ".$this->MapsWrapper->prettyUnit($unit);


	        		

	        		

                    $error = $this->functions->translation("default", "Sorry but this merchant delivers only within ".$pretty_distance." your current distance is".$resp_distance['pretty_distance']) ;

	        		$resp_distance['distance_error']=$error;
	        	} 
			}
        	
        	/*MINIMUM ORDER TABLE*/
        	$resp_distance['min_order']=0;
        	$min_tables_enabled = $this->functions->getOption('min_tables_enabled',$merchant_id);        	
        	if($min_tables_enabled==1){	        			        		
        		$min_order = $this->getMinimumOrderTable(
        		$merchant_id,$resp_distance['distance'],$resp_distance['unit'],$data['minimum_order']);	
        		$resp_distance['min_order']=$min_order;
        	} else {
        		$resp_distance['min_order']=isset($data['minimum_order'])?$data['minimum_order']:0;
        	}
        	                
        	/*SHIPPING FEE*/
        	$shipping_enabled = $this->functions->getOption('shipping_enabled',$merchant_id);
        	if($shipping_enabled==2){	        		
        		$delivery_fee = $this->getShippingFee($merchant_id,$resp_distance['distance'],$resp_distance['unit'],$delivery_fee);
        	}     	
        	
        	return array_merge((array)$resp_distance, array('delivery_fee'=>$delivery_fee));
		}
	}
	
	/*UNIT = M*/
public  function getShippingFee($merchant_id = '', $distance = 0, $unit = '', $delivery_fee = 0)
{
    // Determine unit and initial fee
    $_unit = $unit == "M" ? "mi" : "km";
    $_fee = $delivery_fee;

    // Prepare the SQL statement
    $stmt = "
        SELECT distance_from, distance_to, distance_price
        FROM mt_shipping_rate
        WHERE merchant_id = :merchant_id AND shipping_units = :shipping_units
        ORDER BY distance_from ASC
    ";
    
    // Execute the prepared statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':shipping_units', $_unit, PDO::PARAM_STR);
    $query->execute();

    // Fetch all results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $last_record = array();
        $found = false;
        
        // Loop through each shipping rate
        foreach ($resp as $val) {
            if ($val['distance_from'] <= $distance && $val['distance_to'] >= $distance) {
                $_fee = $val['distance_price'];
                $found = true;
                break; // Found a matching range, no need to continue
            }
            $last_record = $val;
        }

        // If no specific range was found, use the last record price for out-of-range distances
        if (!$found && $distance > $last_record['distance_to']) {
            $_fee = $last_record['distance_price'];
        }
    }

    return $_fee;
}

	
	 public  function unit($unit='')
    {    	
    	$type='';
    	$unit=strtolower($unit);        
        switch ($unit) {
        	case "mi":
        		$type="M";
        		break;        
        	case "km":	
        	    $type="K";
        	    break;
        	default:
        		$type="M";
        		break;
        }
        return $type;
    }
    
    /*UNIT = M*/
	public  function getMinimumOrderTable($merchant_id = '', $distance = 0, $unit = '', $min_fee = 0)
{
    // Determine unit and initial fee
    $_unit = $unit == "M" ? "mi" : "km";
    $_fee = $min_fee;

    // Prepare the SQL statement
    $stmt = "
        SELECT distance_from, distance_to, min_order
        FROM mt_minimum_table
        WHERE merchant_id = :merchant_id AND shipping_units = :shipping_units
        ORDER BY distance_from ASC
    ";
    
    // Execute the prepared statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':shipping_units', $_unit, PDO::PARAM_STR);
    $query->execute();

    // Fetch all results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $last_record = array();
        $found = false;
        
        // Loop through each minimum order rate
        foreach ($resp as $val) {
            if ($val['distance_from'] <= $distance && $val['distance_to'] >= $distance) {
                $_fee = $val['min_order'];
                $found = true;
                break; // Matching range found, break loop
            }
            $last_record = $val;
        }

        // If no matching range, use the last record's min_order for out-of-range distances
        if (!$found && $distance > $last_record['distance_to']) {
            $_fee = $last_record['min_order'];
        }
    }

    return $_fee;
}

	
	
	public function verifyOrderTimeManagement($merchant_id = '', $trans_type = '', $delivery_date = '', $delivery_time = '') {
    if (empty($merchant_id) || empty($trans_type) || empty($delivery_date) || empty($delivery_time)) {
        return true;
    }

    $date = "$delivery_date $delivery_time";
    $date_date = date("Y-m-d", strtotime($date));
    $date_day = strtolower(date("l", strtotime($date)));
    $date_time = date("H:i", strtotime($date));

    $order_status = '';
    $and = '';

    /* FIRST QUERY */
    $stmtc = "
        SELECT id, number_order_allowed, order_status 
        FROM mt_order_time_management a
        WHERE 
        transaction_type = :trans_type
        AND days = :date_day
        AND merchant_id = :merchant_id
        AND CAST(:date_time AS TIME) BETWEEN CAST(start_time AS TIME) AND CAST(end_time AS TIME)
    ";

    $query = $this->db->prepare($stmtc);
    $query->execute([
        ':trans_type' => $trans_type,
        ':date_day' => $date_day,
        ':merchant_id' => $merchant_id,
        ':date_time' => $date_time
    ]);

    if ($resc = $query->fetch(PDO::FETCH_ASSOC)) {
        $orderstatus = !empty($resc['order_status']) ? json_decode($resc['order_status'], true) : false;
        if (is_array($orderstatus) && count($orderstatus) >= 1) {
            $order_status = implode(",", array_map(function ($val) {
                return "'" . $val . "'";
            }, $orderstatus));
            $and = " AND status IN ($order_status) ";
        } else {
            $and = " AND status NOT IN ('initial_order') ";
        }
    }

    /* SECOND QUERY */
    $stmt = "
        SELECT id, number_order_allowed,
        (
            SELECT COUNT(*) FROM mt_order
            WHERE trans_type = :trans_type
            AND delivery_date = :date_date
            AND merchant_id = :merchant_id
            AND CAST(delivery_time AS TIME) BETWEEN CAST(a.start_time AS TIME) AND CAST(a.end_time AS TIME)
            $and
        ) AS total
        FROM mt_order_time_management a
        WHERE 
        transaction_type = :trans_type
        AND days = :date_day
        AND merchant_id = :merchant_id
        AND CAST(:date_time AS TIME) BETWEEN CAST(start_time AS TIME) AND CAST(end_time AS TIME)
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':trans_type' => $trans_type,
        ':date_date' => $date_date,
        ':merchant_id' => $merchant_id,
        ':date_time' => $date_time,
        ':date_day' => $date_day
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        if ($res['total'] >= $res['number_order_allowed']) {
            throw new Exception(
                "For this time " . $this->functions->prettyTime($date_time) . " there is no longer the possibility of " . $trans_type
            );
        }
    }

    return true;
}


	
}
/*end class;*/
