<?php
class Item_menu
{
	
	public  $language='';
	public  $currency_code ='';	
	
	public  $multi_currency = false;
	public  $multi_field = false;
	public  $table_item_translation = false;
	public  $table_view_item_cat = false;
	public  $table_category_translation = false;
	public  $table_size_translation = false;
	public  $table_view_item_stocks_status = false;
	public  $table_item_relationship_size = false;
	
	public  $enabled_category_sked = false;
    public  $food_option_not_available = false;
    public  $paginated = false;
    public  $inventory_enabled = false;
    
    public  $hide_empty_category = false;
    public  $enabled_category_sked_time = false;
    public  $time_now='';
    public  $todays_day='';


    
    public function __construct() {
       	
        //$model = new Model();
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
		$this->functions = new Functions(); // Create an instance of Functions

        $this->InventoryWrapper=new InventoryWrapper();

    $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

       
	
		

    }

	
	public  function init( $merchant_id = 0 )
	{
		
		$this->multi_field= false;
		 $this->multi_currency =false;

		 $this->table_item_translation = false;
		$this->table_view_item_cat = $this->getTableSchema("mt_view_item_cat");



		$this->table_category_translation = false;
		$this->table_size_translation = false;
		$this->table_view_item_stocks_status = $this->getTableSchema("mt_view_item_stocks_status");


		$this->table_item_relationship_size = $this->getTableSchema("mt_item_relationship_size");
		
		$this->enabled_category_sked = $this->functions->getOption('enabled_category_sked',$merchant_id);   
		$this->food_option_not_available = $this->functions->getOption('food_option_not_available',$merchant_id);   		
		$this->inventory_enabled = false;
		$this->paginated = false;
		
		$this->hide_empty_category = $this->functions->getOptionAdmin('mobile2_hide_empty_category');
		$this->enabled_category_sked_time = $this->functions->getOption('enabled_category_sked_time',$merchant_id); 

		$this->language = 'en';    
		$this->currency_code = isset($_SESSION['currency']) ? $_SESSION['currency'] : '';
		$this->time_now = date("H:i");
		$this->todays_day = strtolower(date("l"));

       
       

	}

	public  function getTableSchema($tableName) {


        // Execute a query to describe the table
        $stmt = $this->db->query("DESCRIBE " . $tableName);
        
        // Fetch the schema as an associative array
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

public function getCategory($merchant_id = '', $todays_day = '')
{
    $and = '';
    $todays_day = strtolower($todays_day);

    // Check enabled category schedule
    if ($this->enabled_category_sked == 1) {
        $and .= " AND $todays_day = '1' ";
    }

    // Check enabled category schedule time
    if ($this->enabled_category_sked_time == 1) {
        $and .= "
        AND CAST(:time_now AS TIME)
        BETWEEN CAST({$todays_day}_start AS TIME) AND CAST({$todays_day}_end AS TIME)
        ";
    }

    // Check if category table exists and hide empty categories
    if ($this->table_view_item_cat && $this->hide_empty_category) {
        $and .= "
        AND a.cat_id IN (
            SELECT cat_id
            FROM mt_view_item_cat
            WHERE
                cat_id = a.cat_id
                AND not_available = 1
        )
        ";
    }

    // Construct the main query
    $stmt = "
    SELECT
        a.cat_id AS category_id,
        a.merchant_id,
        a.photo,
        a.dish,
        a.category_name_trans,
        a.category_description_trans,
        a.category_name,
        a.category_description
    FROM mt_category a
    WHERE
        a.merchant_id = :merchant_id
        AND a.status IN ('publish', 'published')
        AND a.web_available =2
        $and
    ORDER BY a.sequence ASC
    ";

    try {
        // Prepare the PDO statement
        $query = $this->db->prepare($stmt);

        // Bind parameters
        $merchant_id = (int)$merchant_id; // Ensure merchant_id is an integer
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Bind :time_now only if enabled_category_sked_time is true
        if ($this->enabled_category_sked_time == 1) {
            $query->bindParam(':time_now', $this->time_now, PDO::PARAM_STR);
        }

        // Execute the query
        $query->execute();

        // Fetch results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        return $res ?: false;
    } catch (PDOException $e) {
        // Log the error for debugging
        echo $e->getMessage();die();
        error_log("Error in getCategory: " . $e->getMessage());
        return false;
    }
}



	
	
public  function getCategory_xtest($merchant_id = '', $todays_day = '')
{
    $and = '';
    $todays_day = strtolower($todays_day);
    
    // Check enabled category schedule
    if ($this->enabled_category_sked == 1) {
        $and .= " AND $todays_day = '1' ";
    }

    // Check enabled category schedule time
    if ($this->enabled_category_sked_time == 1 ) {

        
        /*$and .= "
        AND CAST(" . $this->time_now . " AS TIME)
        BETWEEN CAST(" . $todays_day . "_start AS TIME) AND CAST(" . $todays_day . "_end AS TIME)
        ";*/
    }

    // Check if category table exists and hide empty category
    if ($this->table_view_item_cat && $this->hide_empty_category) {
        $and .= "
        AND a.cat_id IN (
            SELECT cat_id
            FROM mt_view_item_cat
            WHERE
            cat_id = a.cat_id
            AND not_available = 1
        )
        ";
    }



   

    if ($this->multi_field && $this->table_category_translation) {
        // Handle translation logic if necessary

    } else {

        $stmt = "
        SELECT
            a.cat_id AS category_id,
            a.merchant_id,
            a.photo,
            a.dish,
            a.category_name_trans,
            a.category_description_trans,
            a.category_name,
            a.category_description
        FROM mt_category a
        WHERE
            a.merchant_id = :merchant_id
            AND a.status IN ('publish', 'published')
            $and
        ORDER BY a.sequence ASC
        ";

        // Prepare the statement using  db
        $query = $this->db->prepare($stmt);

        // Bind parameters to avoid SQL injection
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query and fetch the result
        $query->execute();

        // Return the results if available
        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }

    return false;
}


public  function sendNotifications($order_id='',$not_sending_emails)
    {
        $_GET['backend']=true; $print=array();
        if ( $data=$this->functions->getOrder2($order_id)){
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            if ( $json_details !=false){
               $displayOrderHTML= $this->functions->displayOrderHTML(array(
                  'order_id'=>$order_id,
                  'merchant_id'=>$data['merchant_id'],
                  'delivery_type'=>$data['trans_type'],
                  'delivery_charge'=>$data['delivery_charge'],
                  'packaging'=>$data['packaging'],
                  'cart_tip_value'=>$data['cart_tip_value'],
                  'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
                  'card_fee'=>$data['card_fee'],
                  'tax'=>$data['tax'],
                  'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
                  'voucher_amount'=>$data['voucher_amount'],
                  'voucher_type'=>$data['voucher_type']
                  ),$json_details,true);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>"ABN",
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>"Telephone",'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];

            $print[]=array('label'=>"Address",'value'=>$full_merchant_address);
            
            $print[]=array('label'=>"TRN Type",'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>"Payment Type",
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>"Card#",'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>"Paypal Transaction ID",
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>"Reference #",
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>"Payment Ref",
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>"Card #",
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>"TRN Date",
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>"Delivery Date",
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>"Delivery Time",
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?("Yes"):'';
                        $print[]=array(
                         'label'=>"Deliver ASAP",
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>"Deliver to",
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>"Delivery Instruction",
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>"Location Name",
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            $to=isset($data['email_address'])?$data['email_address']:'';
            
            /*CHECK IF EURO TAX*/
            if($data['apply_food_tax']==1){             
                $new_total = $this->functions->computeWithTax($displayOrderHTML['raw'], $merchant_id);
                $displayOrderHTML['raw']['total']=$new_total;                                                                          
                $receipt=$this->functions->salesReceiptTax($print,$displayOrderHTML['raw']);
                
                /* custom code starts */
                $receipt1=$this->functions->salesReceiptM($full_merchant_address,$data,$print,$displayOrderHTML['raw']);
                /* custom code ends */          
                
            } else {$receipt=$this->functions->salesReceipt($print,$displayOrderHTML['raw']);
            
            /* custom code starts */
            $receipt1=$this->functions->salesReceiptM($full_merchant_address,$data,$print,$displayOrderHTML['raw']);
            /* custom code ends */
            }
            
            
            //FunctionsV3::notifyMerchant($data,Yii::app()->functions->additional_details,$receipt);
            
            /* Custom code starts */
           $this->functions->notifyMerchant2_notsendingEmails($data,'',$receipt,$receipt1,$not_sending_emails);   
            /* Custom code ends */     
            
            
                        
           // FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processemail"));
            //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processsms"));     
                       
            /*PRINTER ADDON*/
       
                  
        }
    }   





	
	public  function getItem($category_id = '', $merchant_id = 0)
{
    $data = array();
    $select = '';
    $and = '';
    $limit = '';

    // Add merchant ID condition if provided
    if ($merchant_id > 0) {
        $and .= " AND merchant_id = :merchant_id";
    }

    // Check inventory and food options
    $inventory_enabled=$this->functions->inventoryEnabled($merchant_id);
        
    if($inventory_enabled ){

        if($this->InventoryWrapper->hideItemOutStocks($merchant_id)){
                $and.="
                AND a.item_id IN (
                      select item_id from mt_view_item_stocks_status
                      where available ='1'
                      and track_stock='1'
                      and stock_status not in ('Out of stocks')     
                      and item_id = a.item_id                 
                    )       
                ";
            } else {
                if($this->food_option_not_available==1 ){
                    $and.="
                    AND a.item_id IN (
                       select item_id from mt_item_relationship_size
                       where available ='1'                 
                       and item_id = a.item_id         
                    )       
                    ";
                }
            }

    } else {
        if ($this->food_option_not_available == 1) {
            $and .= " AND not_available = 1";
        }
    }

    // Handle multi-field and table translation logic
    if ($this->multi_field && $this->table_item_translation) {
        // Multi-field translation logic (if required)
    } else {
        $select = "
        a.item_name, a.item_description,
        ";
    }

    // Check if table view for item category exists
    if ($this->table_view_item_cat) {
        $stmt = "
        SELECT 
        DISTINCT a.item_id,
        $select        
        a.discount, a.photo, a.spicydish, a.dish,
        a.item_name_trans, a.item_description_trans, a.not_available,
        a.cat_id, a.item_token,
        a.cooking_ref, a.ingredients, a.item_sequence,

        (
          SELECT IF(count(*) > 1, 1, 2) 
          FROM mt_view_item_cat
          WHERE item_id = a.item_id
          AND cat_id = a.cat_id
        ) AS single_item,

        (
          SELECT count(*) 
          FROM mt_item_relationship_subcategory
          WHERE item_id = a.item_id
        ) AS addon_count,

        (
          SELECT CONCAT_WS(';', price, size_id, size_name, item_size_token)
          FROM mt_view_item_cat
          WHERE item_id = a.item_id
          AND cat_id = a.cat_id
          LIMIT 0,1
        ) AS single_details

        FROM mt_view_item_cat a
        WHERE
        a.cat_id = :category_id
        AND a.status IN ('publish', 'published')
        $and
        ORDER BY a.item_sequence, a.item_id ASC
        ";
    } else {
        return false;
    }

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind parameters to avoid SQL injection
    $query->bindParam(':category_id', $category_id, PDO::PARAM_INT);
    if ($merchant_id > 0) {
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    }

    // Execute the query and fetch the result
    $query->execute();

    // Fetch results
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $single_details = array();

            // Logic for setting single_item based on various conditions
            if (!empty($val['cooking_ref']) || !empty($val['ingredients']) || $val['addon_count'] > 0) {
                $val['single_item'] = 1;
            }

            if ($val['single_item'] == 2) {
                $single_price = !empty($val['single_details']) ? explode(";", $val['single_details']) : false;
                if ($single_price != false) {
                    $single_details['price'] = isset($single_price[0]) ? (float) $single_price[0] : '';
                    $single_details['size_id'] = isset($single_price[1]) ? (integer) $single_price[1] : '';
                    $single_details['size'] = isset($single_price[2]) ? $single_price[2] : '';
                    $single_details['item_size_token'] = isset($single_price[3]) ? $single_price[3] : '';
                }
            }

            // Build the result array
            $data[] = array(
                'item_id' => (integer) $val['item_id'],
                'item_token' => $val['item_token'],
                'item_name' => $this->functions->clearString($val['item_name']),
                'item_description' => $this->functions->clearString($val['item_description']),
                'discount' => $val['discount'],
                'photo' => $val['photo'],
                'photo_url' => $this->functions->getFoodDefaultImage($val['photo'], false),
                'spicydish' => $val['spicydish'],
                'dish' => $val['dish'],
                'item_name_trans' => !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '',
                'item_description_trans' => !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : '',
                'not_available' => $val['not_available'],
                'single_item' => (integer) $val['single_item'],
                'single_details' => $single_details,
                'prices' => $this->getPrice($val['item_id'], $val['cat_id'])
            );
        }
        return $data;
    }

    return false;
}

	
	public  function getPrice($item_id = '', $cat_id = '')
{
    $data = array();
    $and = '';
    $and_sizename = '';

    if ($this->multi_currency) {
        // Handle multi-currency logic if needed
    }

    if ($this->multi_field && $this->table_size_translation) {
        // Handle multi-field and size translation logic if needed
    } else {
        $and_sizename = "
            a.size_name,
        ";
    }

    if ($this->table_view_item_cat) {

        $stmt = "
            SELECT 
                a.price, 
                a.item_size_token,
                $and_sizename
                a.size_id,		
                IF(a.discount > 0, (a.price - a.discount), 0) as discount_price
            $and
            FROM mt_view_item_cat a
            WHERE 
                a.item_id = :item_id
                AND a.cat_id = :cat_id
        ";

        // Prepare the statement and bind parameters
        $query = $this->db->prepare($stmt);
        $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        $query->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);

        // Execute the query
        if ($query->execute()) {
            $res = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach ($res as $val) {
                $exchange_discount_price = 0;
                if ($val['discount_price'] > 0) {
                    $exchange_discount_price = $val['discount_price'];
                }

                $data[] = array(
                    'item_size_token' => $val['item_size_token'],
                    'price' => $val['price'],
                    'size_name' => $val['size_name'],
                    'size_id' => $val['size_id'],
                    'discount_price' => $val['discount_price'],
                    'exchange_rate' => isset($val['exchange_rate']) ? $val['exchange_rate'] : 1,
                    'exchange_price' => isset($val['exchange_price']) ? $val['exchange_price'] : $val['price'],
                    'exchange_discount_price' => isset($val['exchange_discount_price']) ? $val['exchange_discount_price'] : $exchange_discount_price,
                    'exchange_price1' => isset($val['exchange_price']) ? $this->functions->formatNumber($val['exchange_price']) : $this->functions->formatNumber($val['price']),
                    'exchange_discount_price1' => isset($val['exchange_discount_price']) ? $this->functions->formatNumber($val['exchange_discount_price']) : $this->functions->formatNumber($exchange_discount_price),
                );
            }
            return $data;
        }
    }
    return false;
}

	
	public  function getMenu($merchant_id='', $todays_day ='')
	{		

		$data = array();			
	
		if ( $res_category = $this->getCategory($merchant_id, $todays_day ) ){

           

			foreach ($res_category as $key=>$val) {

				$data[] = array(
				  'category_id'=> (integer) $val['category_id'],
				  'category_name'=>  $this->functions->clearString($val['category_name']),
				  'category_description'=>  $this->functions->clearString($val['category_description']),
				  'category_name_trans'=>  !empty($val['category_name_trans'])?json_decode($val['category_name_trans'],true):'',
				  'category_description_trans'=>  !empty($val['category_description_trans'])?json_decode($val['category_description_trans'],true):'',
				  'dish'=>$val['dish'],
				  'photo'=>$val['photo'],
				  'item'=> $this->getItem( $val['category_id'], $val['merchant_id'])
				);
			}
			return $data;
		}
		return false;
	}
	
	public  function getItemPrice($item_id = 0, $size_id = 0)
{
    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT price, discount, not_available, size_name, size_id
        FROM mt_view_item_cat
        WHERE item_id = :item_id
        AND size_id = :size_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind parameters to the placeholders
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->bindParam(':size_id', $size_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }
    return false;
}

	
	public  function getItemPriceAndVerify($item_id = 0, $size_id = 0)
{
    $and_cat = '';
    $and = '';

    if ($this->enabled_category_sked == 1 || $this->enabled_category_sked_time == 1) {
        $and_cat = '';

        if ($this->enabled_category_sked == 1 && !empty($this->todays_day)) {
            $and_cat = " AND " . $this->todays_day . " = 1 ";
        }

        if ($this->enabled_category_sked_time == 1 && !empty($this->time_now) && !empty($this->todays_day)) {
            $and_cat .= "
                AND CAST(" . $this->time_now . " AS TIME)
                BETWEEN CAST(" . $this->todays_day . "_start AS TIME) AND CAST(" . $this->todays_day . "_end AS TIME)
            ";
        }

        $and .= "
            AND a.cat_id IN (  
                SELECT cat_id 
                FROM mt_category
                WHERE cat_id = a.cat_id
                AND merchant_id = a.merchant_id
                AND status = 'publish'
                $and_cat
            )
        ";
    }

    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT price, discount, not_available, size_name, size_id
        FROM mt_view_item_cat a
        WHERE item_id = :item_id
        AND size_id = :size_id
        AND status = 'publish'
        $and
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind parameters to the placeholders
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->bindParam(':size_id', $size_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }
    return false;
}

	
	public  function getAddonPrice($sub_item_id = 0)
{
    // Prepare the SQL statement with a placeholder
    $stmt = "
        SELECT price
        FROM mt_subcategory_item
        WHERE sub_item_id = :sub_item_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the sub_item_id to the placeholder
    $query->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res['price'];
        }
    }
    return false;
}

	
	public  function getCategoryLazyLoad($merchant_id = '', $todays_day = '')
{
    $and = '';
    $todays_day = strtolower($todays_day);

    if ($this->enabled_category_sked == 1) {
        $and .= " AND $todays_day = '1' ";
    }

    $and_category = '';
    if ($this->food_option_not_available == 1) {
        $and_category = " AND not_available = 1 ";
    }

    if ($this->enabled_category_sked_time == 1) {
        $and .= "
            AND CAST(" . $this->time_now . " AS TIME)
            BETWEEN CAST(" . $todays_day . "_start AS TIME) AND CAST(" . $todays_day . "_end AS TIME)
        ";
    }

    if ($this->table_view_item_cat && $this->hide_empty_category) {

        $and .= "
            AND a.cat_id IN (
                SELECT cat_id
                FROM mt_view_item_cat
                WHERE cat_id = a.cat_id
                AND not_available = 1
            )
        ";
    }

    $paginate = 10;

    $and_name = '';
    if ($this->multi_field && $this->table_category_translation) {
        // Translation handling code (if needed)
    } else {
        $and_name = " a.category_name, a.category_description ,";
    }

    // SQL query with placeholders for binding parameters
    $stmt = "
        SELECT
            a.cat_id AS category_id,
            a.photo,
            a.dish,
            a.category_name_trans,
            a.category_description_trans,
            $and_name
            (
                SELECT COUNT(*)
                FROM mt_item
                WHERE merchant_id = :merchant_id
                AND status IN ('publish', 'published')
            ) AS total_item,
            (
                SELECT COUNT(*)
                FROM mt_view_rs_category
                WHERE cat_id = a.cat_id
                $and_category
            ) AS total_item_in_category
        FROM
            mt_category a
        WHERE
            merchant_id = :merchant_id
            AND a.status IN ('publish', 'published')
            $and
        ORDER BY sequence ASC
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the merchant_id parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $data = [];
        // Fetch the results
        while ($val = $query->fetch(PDO::FETCH_ASSOC)) {
            $total_cat_paginate = $val['total_item_in_category'] > 0 ? ceil($val['total_item_in_category'] / $paginate) : 0;
            $total_item = $val['total_item'] > 0 ? ceil($val['total_item'] / $paginate) : 0;
            $data[] = array(
                'category_id' => $val['category_id'],
                'category_name' => $this->functions->clearString($val['category_name']),
                'category_description' => $this->functions->clearString($val['category_description']),
                'category_name_trans' => !empty($val['category_name_trans']) ? json_decode($val['category_name_trans'], true) : '',
                'photo' => $val['photo'],
                'category_description_trans' => !empty($val['category_description_trans']) ? json_decode($val['category_description_trans'], true) : '',
                'dish' => $val['dish'],
                'item' => array(),
                'total_item_in_category' => $val['total_item_in_category'],
                'total_cat_paginate' => $total_cat_paginate,
                'total_item' => $total_item + 1
            );
        }
        return $data;
    }

    return false;
}

		
	public  function getCategoryByID($merchant_id = 0, $category_id = 0)
{
    if ($this->multi_field && $this->table_category_translation) {
        // Translation handling code (if needed)
    } else {
        // SQL query with placeholders for binding parameters
        $stmt = "
            SELECT
                a.cat_id AS category_id,
                a.photo,
                a.dish,
                a.category_name,
                a.category_description
            FROM mt_category a
            WHERE
                a.merchant_id = :merchant_id
                AND a.cat_id = :category_id
        ";

        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the parameters
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':category_id', $category_id, PDO::PARAM_INT);

        // Execute the query
        if ($query->execute()) {
            // Fetch the result
            $res = $query->fetch(PDO::FETCH_ASSOC);
            if ($res) {
                // Apply additional transformations
                $res['category_name'] = $this->functions->clearString($res['category_name']);
                $res['photo_url'] = $this->functions->getFoodDefaultImage($res['photo'], false);
                $res['category_description'] = $this->functions->clearString($res['category_description']);
                return $res;
            }
        }
    }

    return false;
}

	
	public  function itemQueryStatment()
{
    $stmt = '';
    $select = '';

    if ($this->multi_field && $this->table_item_translation) {
        // Translation handling (if needed)
    } else {
        $select = "
            a.item_name, a.item_description,
            a.category_name, a.category_description,
        ";
    }

    // Check if the `$this->table_view_item_cat` is enabled
    if ($this->table_view_item_cat) {
        $stmt = "
            SELECT 
                DISTINCT a.item_id, a.item_sequence,

                $select

                a.discount, a.photo, a.spicydish, a.dish,
                a.not_available,
                a.cat_id, a.cat_id AS category_id, a.item_token,
                a.cooking_ref, a.ingredients,

                (
                    SELECT IF(COUNT(*) > 1, 1, 2)
                    FROM mt_view_item_cat
                    WHERE item_id = a.item_id
                    AND cat_id = a.cat_id
                ) AS single_item,

                (
                    SELECT COUNT(*) 
                    FROM mt_item_relationship_subcategory
                    WHERE item_id = a.item_id
                ) AS addon_count,

                (
                    SELECT CONCAT_WS(';', price, size_id, size_name, item_size_token)
                    FROM mt_view_item_cat
                    WHERE item_id = a.item_id
                    AND cat_id = a.cat_id
                    LIMIT 0, 1
                ) AS single_details

            FROM mt_view_item_cat a
        ";
        return $stmt;
    } else {
        return false;
    }
}


	public  function getItemLazyLoadAll($merchant_id=0, $page = 0, $page_limit=0)
	{		
		$stmt = ''; $and='';
				
		$inventory_enabled=$this->functions->inventoryEnabled($merchant_id);
        
        if($inventory_enabled ){


            if($this->InventoryWrapper->hideItemOutStocks($merchant_id)){
                $and.="
                AND a.item_id IN (
                      select item_id from mt_view_item_stocks_status
                      where available ='1'
                      and track_stock='1'
                      and stock_status not in ('Out of stocks')     
                      and item_id = a.item_id                 
                    )       
                ";
            } else {
                if($this->food_option_not_available==1){
                    $and.="
                    AND a.item_id IN (
                       select item_id from mt_item_relationship_size
                       where available ='1'                 
                       and item_id = a.item_id         
                    )       
                    ";
                }
            }

			
		} else {		
			if($this->food_option_not_available==1){
				$and.= " AND not_available=1 ";
			}
		}
		
		if($this->enabled_category_sked==1 && $this->enabled_category_sked_time==1){
    		$and.="
    		AND a.cat_id IN (
    		  select cat_id from mt_category
    		  where ".$this->todays_day."='1'
    		  and CAST(".($this->time_now)." AS TIME)
	          BETWEEN CAST(".$this->todays_day."_start AS TIME) and CAST(".$this->todays_day."_end AS TIME)
    		)
    		";
    	} elseif ( $this->enabled_category_sked==1 ) {
    		$and.="
    		AND a.cat_id IN (
    		  select cat_id from mt_category
    		  where ".$this->todays_day."='1'    		  
    		)
    		";
    	} elseif ( $this->enabled_category_sked_time==1 ) {
    		$and.="
    		AND a.cat_id IN (
    		  select cat_id from mt_category    		  
    		  where CAST(".($this->time_now)." AS TIME)
	          BETWEEN CAST(".$this->todays_day."_start AS TIME) and CAST(".$this->todays_day."_end AS TIME)
    		)
    		";
    	}
		
		if ( $stmt = $this->itemQueryStatment()){
			$stmt.="
		    WHERE			
			a.merchant_id = ".( (integer) $merchant_id )."
			AND a.status IN ('publish','published')			
			$and	
			ORDER BY category_sequence,cat_id,item_id ASC
			LIMIT $page,$page_limit
			";			
		} else return false;		
		
		return $this->processLazyQuery($stmt);
	}
	
	public  function getItemLazyLoad($category_id='', $merchant_id=0, $page = 0, $page_limit=0)
	{		
		
		$stmt = ''; $and='';

       $inventory_enabled=$this->functions->inventoryEnabled($merchant_id);
		
		if($inventory_enabled ){


            if($this->InventoryWrapper->hideItemOutStocks($merchant_id)){
                $and.="
                AND a.item_id IN (
                      select item_id from mt_view_item_stocks_status
                      where available ='1'
                      and track_stock='1'
                      and stock_status not in ('Out of stocks')     
                      and item_id = a.item_id                 
                    )       
                ";
            } else {
                if($this->food_option_not_available==1){
                    $and.="
                    AND a.item_id IN (
                       select item_id from mt_item_relationship_size
                       where available ='1'                 
                       and item_id = a.item_id         
                    )       
                    ";
                }
            }

			
		} else {		
			if($this->food_option_not_available==1){
				$and.= " AND not_available=1 ";
			}
		}
		

		      
		if ( $stmt = $this->itemQueryStatment()){
			$stmt.="
			WHERE
			a.cat_id = ".( (integer) $category_id )."
			AND a.merchant_id = ".( (integer) $merchant_id )."
			AND a.status IN ('publish','published')			
			$and	
			ORDER BY item_sequence,item_id ASC
			LIMIT $page,$page_limit		    
			";
		} else return false;					
		


		return $this->processLazyQuery_lazy($stmt);
	}



    public  function processLazyQuery_lazy($stmt = '')
{
    $data = [];
    
    // Execute the query using PDO
    $stmt = $this->db->prepare($stmt);
    $stmt->execute();
    
    // Fetch all results as associative arrays
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $single_details = [];

            // Check for single item based on conditions
            if (!empty($val['cooking_ref'])) {
                $val['single_item'] = 1;
            }
            if (!empty($val['ingredients'])) {
                $val['single_item'] = 1;
            }
            if ($val['addon_count'] > 0) {
                $val['single_item'] = 1;
            }

            // Handle case for single item with details
            if ($val['single_item'] == 2) {
                $single_price = !empty($val['single_details']) ? explode(";", $val['single_details']) : false;
                if ($single_price !== false) {
                    $single_details['price'] = isset($single_price[0]) ? (float)$single_price[0] : '';
                    $single_details['size_id'] = isset($single_price[1]) ? (int)$single_price[1] : '';
                    $single_details['size'] = isset($single_price[2]) ? $single_price[2] : '';
                    $single_details['item_size_token'] = isset($single_price[3]) ? $single_price[3] : '';
                }
            }

            // Add item details to the result array
            $data[] = [
                'item_id' => (int)$val['item_id'],
                'item_token' => $val['item_token'],
                'item_name' => $this->functions->clearString($val['item_name']),
                'item_description' => $this->functions->clearString($val['item_description']),
                'category_id' => $val['category_id'],
                'category_name' => $this->functions->clearString($val['category_name']),
                'category_description' => $this->functions->clearString($val['category_description']),
                'discount' => $val['discount'],
                'photo' => $val['photo'],
                'photo_url' => $this->functions->getFoodDefaultImage($val['photo'], false),
                'spicydish' => $val['spicydish'],
                'dish' => $val['dish'],
                'not_available' => $val['not_available'],
                'single_item' => (int)$val['single_item'],
                'single_details' => $single_details,
                'prices' => $this->getPrice($val['item_id'], $val['cat_id'])
            ];
        }
        return $data;
    }

    return false;
}

	
		
	public function searchByItem($search_string = '', $merchant_id = 0, $page = 0, $page_limit = 0)
{        
    $stmt = ''; 
    $and = '';

    if ($this->food_option_not_available == 1) {
        $and = " AND not_available=1 ";
    }

    if ($this->enabled_category_sked == 1 || $this->enabled_category_sked_time == 1) {            
        $and_cat = '';            
        if ($this->enabled_category_sked == 1 && !empty($this->todays_day)) {
            $and_cat = " AND " . $this->todays_day . " = 1 ";
        }
        if ($this->enabled_category_sked_time == 1 && !empty($this->time_now) && !empty($this->todays_day)) {
            $and_cat .= " 
            AND CAST(:time_now AS TIME)
            BETWEEN CAST(" . $this->todays_day . "_start AS TIME) 
            AND CAST(" . $this->todays_day . "_end AS TIME)
            ";
        }
        $and .= "
         AND cat_id IN (  
           SELECT cat_id 
           FROM mt_category
           WHERE
           cat_id = a.cat_id
           AND merchant_id = a.merchant_id               
           AND status='publish'
           $and_cat
        )        
        ";
    } else {                    
        $and .= "
         AND cat_id IN (  
           SELECT cat_id 
           FROM mt_category
           WHERE
           cat_id = a.cat_id
           AND merchant_id = a.merchant_id           
           AND status='publish'
        )        
        ";
    }
            
    if ($stmt = $this->itemQueryStatment()) {
        
        $where = "WHERE a.item_name LIKE :search_string";
        
        $stmt .= "
        $where
        AND a.merchant_id = :merchant_id
        AND a.status IN ('publish', 'published')        
        $and        
        LIMIT :page, :page_limit             
        ";            
    } else {
        return false;
    }



    return $this->processLazyQuery($stmt, $search_string, $merchant_id, $page, $page_limit);



}

	
public function processLazyQuery($stmt = '', $search_string = '', $merchant_id = 0, $page = 0, $page_limit = 0)
{
    $data = [];

     

    // Prepare the query
   $query = $this->db->prepare("
    SELECT DISTINCT a.* 
    FROM mt_item a 
    WHERE a.item_name LIKE :search_string 
    AND a.merchant_id = :merchant_id 
    AND a.status IN ('publish', 'published') 
    AND EXISTS (
        SELECT 1 
        FROM mt_category c
        WHERE c.web_available = '2'
        AND JSON_CONTAINS(a.category, CONCAT('\"', c.cat_id, '\"'))
    )
    GROUP BY a.item_id 
    LIMIT :page, :page_limit
");

    // Bind parameters
    $query->bindValue(':search_string', "%$search_string%", PDO::PARAM_STR);
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    $query->bindValue(':page', (int)$page, PDO::PARAM_INT);
    $query->bindValue(':page_limit', (int)$page_limit, PDO::PARAM_INT);
    
    if ($this->enabled_category_sked_time == 1 && !empty($this->time_now)) {
        $query->bindValue(':time_now', $this->time_now, PDO::PARAM_STR);
    }

    // Debugging output (uncomment to test)
    // echo $query->queryString; die();

    // Execute the query
    $query->execute();

    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $single_details = [];

            // Check for single item based on conditions
            if (!empty($val['cooking_ref']) || !empty($val['ingredients']) || $val['addon_count'] > 0) {
                $val['single_item'] = 1;
            }

           $item_id=(int)$val['item_id'];


//+++was custom code
          $query = $this->db->prepare("
    SELECT * 
    FROM mt_item 
    WHERE item_id = :item_id
    LIMIT 1
");

// Bind the parameter
$query->bindValue(':item_id', (int)$item_id, PDO::PARAM_INT);

// Execute the query
$query->execute();

// Fetch the result
$item_det = $query->fetch(PDO::FETCH_ASSOC);

$cat_id=$item_det['category'];
$cat_id_array = json_decode($cat_id, true); // Convert JSON string to array
$first_cat_id = isset($cat_id_array[0]) ? (int)$cat_id_array[0] : 0;

 $query = $this->db->prepare("
    SELECT * 
    FROM mt_category 
    WHERE cat_id = :first_cat_id
    LIMIT 1
");

// Bind the parameter
$query->bindValue(':first_cat_id', (int)$first_cat_id, PDO::PARAM_INT);

// Execute the query
$query->execute();

// Fetch the result
$cat_det = $query->fetch(PDO::FETCH_ASSOC);

$val['cat_id']=$cat_det['cat_id'];
$val['category_name']=$cat_det['category_name'];
$val['category_description']=$cat_det['category_description']; 





// Should output 4


// Output: 4 (if ["4","6","10"])
//---was custom code



            // Handle case for single item with details
            if ($val['single_item'] == 2) {
                $single_price = !empty($val['single_details']) ? explode(";", $val['single_details']) : false;
                if ($single_price !== false) {
                    $single_details['price'] = isset($single_price[0]) ? (float)$single_price[0] : '';
                    $single_details['size_id'] = isset($single_price[1]) ? (int)$single_price[1] : '';
                    $single_details['size'] = isset($single_price[2]) ? $single_price[2] : '';
                    $single_details['item_size_token'] = isset($single_price[3]) ? $single_price[3] : '';
                }
            }

            // Add item details to the result array
            $data[] = [
                'item_id' => (int)$val['item_id'],
                'item_token' => $val['item_token'],
                'item_name' => $this->functions->clearString($val['item_name']),
                'item_description' => $this->functions->clearString($val['item_description']),
                'category_id' => $val['category_id'],
                'category_name' => $this->functions->clearString($val['category_name']),
                'category_description' => $this->functions->clearString($val['category_description']),
                'discount' => $val['discount'],
                'photo' => $val['photo'],
                'photo_url' => $this->functions->getFoodDefaultImage($val['photo'], false),
                'spicydish' => $val['spicydish'],
                'dish' => $val['dish'],
                'not_available' => $val['not_available'],
                'single_item' => (int)$val['single_item'],
                'single_details' => $single_details,
                'prices' => $this->getPrice($val['item_id'], $val['cat_id'])
            ];
        }
        return $data;
    }

    return false;
}


public function processLazyQuery_bkup25feb($stmt = '', $search_string = '', $merchant_id = 0, $page = 0, $page_limit = 0)
{
    $data = [];

     

    // Prepare the query
    $query = $this->db->prepare("
        SELECT DISTINCT a.* 
        FROM mt_item a 
        WHERE a.item_name LIKE :search_string 
        AND a.merchant_id = :merchant_id 
        AND a.status IN ('publish', 'published') 
        GROUP BY a.item_id 
        LIMIT :page, :page_limit
    ");

    // Bind parameters
    $query->bindValue(':search_string', "%$search_string%", PDO::PARAM_STR);
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    $query->bindValue(':page', (int)$page, PDO::PARAM_INT);
    $query->bindValue(':page_limit', (int)$page_limit, PDO::PARAM_INT);
    
    if ($this->enabled_category_sked_time == 1 && !empty($this->time_now)) {
        $query->bindValue(':time_now', $this->time_now, PDO::PARAM_STR);
    }

    // Debugging output (uncomment to test)
    // echo $query->queryString; die();

    // Execute the query
    $query->execute();

    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $single_details = [];

            // Check for single item based on conditions
            if (!empty($val['cooking_ref']) || !empty($val['ingredients']) || $val['addon_count'] > 0) {
                $val['single_item'] = 1;
            }

           $item_id=(int)$val['item_id'];


//+++was custom code
          $query = $this->db->prepare("
    SELECT * 
    FROM mt_item 
    WHERE item_id = :item_id
    LIMIT 1
");

// Bind the parameter
$query->bindValue(':item_id', (int)$item_id, PDO::PARAM_INT);

// Execute the query
$query->execute();

// Fetch the result
$item_det = $query->fetch(PDO::FETCH_ASSOC);

$cat_id=$item_det['category'];
$cat_id_array = json_decode($cat_id, true); // Convert JSON string to array
$first_cat_id = isset($cat_id_array[0]) ? (int)$cat_id_array[0] : 0;

 $query = $this->db->prepare("
    SELECT * 
    FROM mt_category 
    WHERE cat_id = :first_cat_id
    LIMIT 1
");

// Bind the parameter
$query->bindValue(':first_cat_id', (int)$first_cat_id, PDO::PARAM_INT);

// Execute the query
$query->execute();

// Fetch the result
$cat_det = $query->fetch(PDO::FETCH_ASSOC);

$val['cat_id']=$cat_det['cat_id'];
$val['category_name']=$cat_det['category_name'];
$val['category_description']=$cat_det['category_description']; 





// Should output 4


// Output: 4 (if ["4","6","10"])
//---was custom code



            // Handle case for single item with details
            if ($val['single_item'] == 2) {
                $single_price = !empty($val['single_details']) ? explode(";", $val['single_details']) : false;
                if ($single_price !== false) {
                    $single_details['price'] = isset($single_price[0]) ? (float)$single_price[0] : '';
                    $single_details['size_id'] = isset($single_price[1]) ? (int)$single_price[1] : '';
                    $single_details['size'] = isset($single_price[2]) ? $single_price[2] : '';
                    $single_details['item_size_token'] = isset($single_price[3]) ? $single_price[3] : '';
                }
            }

            // Add item details to the result array
            $data[] = [
                'item_id' => (int)$val['item_id'],
                'item_token' => $val['item_token'],
                'item_name' => $this->functions->clearString($val['item_name']),
                'item_description' => $this->functions->clearString($val['item_description']),
                'category_id' => $val['category_id'],
                'category_name' => $this->functions->clearString($val['category_name']),
                'category_description' => $this->functions->clearString($val['category_description']),
                'discount' => $val['discount'],
                'photo' => $val['photo'],
                'photo_url' => $this->functions->getFoodDefaultImage($val['photo'], false),
                'spicydish' => $val['spicydish'],
                'dish' => $val['dish'],
                'not_available' => $val['not_available'],
                'single_item' => (int)$val['single_item'],
                'single_details' => $single_details,
                'prices' => $this->getPrice($val['item_id'], $val['cat_id'])
            ];
        }
        return $data;
    }

    return false;
}





	
	
public  function searchByFoodName($item_name = '')
{
    $select = '';
    $where = '';
    $and_cat = '';

    // Category scheduling logic
    if ($this->enabled_category_sked == 1 || $this->enabled_category_sked_time == 1) {
        $andcat = '';
        if ($this->enabled_category_sked == 1 && !empty($this->todays_day)) {
            $andcat = " AND " . $this->todays_day . " = 1 ";
        }
        if ($this->enabled_category_sked_time == 1 && !empty($this->time_now) && !empty($this->todays_day)) {
            $andcat .= "
                AND CAST(" . $this->time_now . " AS TIME)
                BETWEEN CAST(" . $this->todays_day . "_start AS TIME) AND CAST(" . $this->todays_day . "_end AS TIME)
            ";
        }
        $and_cat .= "
            AND a.cat_id IN (  
                SELECT cat_id 
                FROM mt_category
                WHERE
                cat_id = a.cat_id
                AND merchant_id = a.merchant_id
                AND status = 'publish'
                $andcat
            )        
        ";
    }

    // Query for item translation or single field search
    if ($this->multi_field && $this->table_item_translation) {
        // Implement multi-field translation logic here if necessary
    } else {
        $select = "item_name AS name";
        $where = "
        WHERE item_name LIKE :item_name
        AND not_available = 1
        $and_cat
        ";
    }

    // Prepare the query statement
    $stmt = "
    SELECT DISTINCT $select
    FROM mt_view_item_cat a
    $where
    AND status = 'publish'
    ORDER BY item_name ASC
    ";

    // Prepare and execute the statement using PDO
    $stmt = $this->db->prepare($stmt);
    $stmt->bindValue(':item_name', "%$item_name%", PDO::PARAM_STR);
    $stmt->execute();

    // Fetch results and process them
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        $data = [];
        foreach ($resp as $key => $val) {
            $data[]['name'] = $this->functions->clearString($val['name']);
        }
        return $data;
    }

    return false;
}

	
	public  function searchByCuisine($name = '')
{
    $select = '';
    $where = '';

    // Query for cuisine search
    if ($this->multi_field && $this->table_item_translation) {
        // Implement multi-field translation logic here if necessary
    } else {
        $select = "cuisine_name AS name";
        $where = "
        WHERE cuisine_name LIKE :name
        ";
    }

    // Prepare the query statement
    $stmt = "
    SELECT $select 
    FROM mt_cuisine a
    $where
    AND status = 'publish'
    ORDER BY cuisine_name ASC
    ";

    // Prepare and execute the statement using PDO
    $stmt = $this->db->prepare($stmt);
    $stmt->bindValue(':name', "%$name%", PDO::PARAM_STR);
    $stmt->execute();

    // Fetch results and process them
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        $data = [];
        foreach ($resp as $key => $val) {
            $data[]['name'] = $this->functions->clearString($val['name']);
        }
        return $data;
    }

    return false;
}

}
/*end class*/