<?php
require_once __DIR__ . '/../Client.php';
require_once __DIR__ . '/../Service.php';
require_once __DIR__ . '/Resource.php'; 
require_once __DIR__ . '/../Model.php';

class Google_Service_Oauth2 extends Google_Service
{
  /** View your email address. */
  const USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";
  /** See your personal info, including any personal info you've made publicly available. */
  const USERINFO_PROFILE = "https://www.googleapis.com/auth/userinfo.profile";
  /** See your primary Google Account email address. */
  const OPENID = "openid";

  public $userinfo;

  public function __construct(Google_Client $client)
  {
    parent::__construct($client);
    $this->rootUrl = 'https://www.googleapis.com/';
    $this->servicePath = '';
    $this->version = 'v2';
    $this->serviceName = 'oauth2';

    $this->userinfo = new Google_Service_Oauth2_Userinfo(
      $this,
      $this->serviceName,
      'userinfo',
      array(
        'methods' => array(
          'get' => array(
            'path' => 'oauth2/v2/userinfo',
            'httpMethod' => 'GET',
            'parameters' => array(),
          ),
        )
      )
    );
  }
}

class Google_Service_Oauth2_Userinfo extends Google_Service_Resource
{
  public function get($optParams = array())
  {
    return $this->call('get', array($optParams), "Google_Service_Oauth2_UserinfoData");
  }
}

class Google_Service_Oauth2_UserinfoData extends Google_Model
{
  public $email;
  public $family_name;
  public $gender;
  public $given_name;
  public $hd;
  public $id;
  public $link;
  public $locale;
  public $name;
  public $picture;
  public $verified_email;

  public function setEmail($email) { $this->email = $email; }
  public function getEmail() { return $this->email; }

  public function setFamilyName($family_name) { $this->family_name = $family_name; }
  public function getFamilyName() { return $this->family_name; }

  public function setGender($gender) { $this->gender = $gender; }
  public function getGender() { return $this->gender; }

  public function setGivenName($given_name) { $this->given_name = $given_name; }
  public function getGivenName() { return $this->given_name; }

  public function setHd($hd) { $this->hd = $hd; }
  public function getHd() { return $this->hd; }

  public function setId($id) { $this->id = $id; }
  public function getId() { return $this->id; }

  public function setLink($link) { $this->link = $link; }
  public function getLink() { return $this->link; }

  public function setLocale($locale) { $this->locale = $locale; }
  public function getLocale() { return $this->locale; }

  public function setName($name) { $this->name = $name; }
  public function getName() { return $this->name; }

  public function setPicture($picture) { $this->picture = $picture; }
  public function getPicture() { return $this->picture; }

  public function setVerifiedEmail($verified_email) { $this->verified_email = $verified_email; }
  public function getVerifiedEmail() { return $this->verified_email; }
}
