<?php
class MY_Controller extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');

        // If merchantInfo not set in session, fetch from API and set
        if (!$this->session->userdata('merchantInfo')) {
            $merchantInfo = apiCall('GetMerchantAbout');
            if (isset($merchantInfo['code']) && $merchantInfo['code'] == 1) {
                $this->session->set_userdata('merchantInfo', $merchantInfo['details']['data']);
            }
        }

        // If settings not set in session, fetch from API and set
        if (!$this->session->userdata('settings')) {
            $settings = apiCall('GetSettings');
            if (isset($settings['code']) && $settings['code'] == 1) {
                $this->session->set_userdata('settings', $settings['details']);
            }
        }
    }
}
