<?php
    $restaurantInfo = apicall('getRestaurantInfo');
    // p($restaurantInfo);
?>
<style>
    body {
        font-family: sans-serif;
        background: #f8f8f8;
        margin: 0;
        padding: 0;
    }
    h2 {
        margin-bottom: 10px;
    }
    p {
        font-size: 14px;
        margin-bottom: 20px;
        color: #555;
    }
    input[type="text"], input[type="email"] {
        width: 100%;
        padding: 12px;
        margin-bottom: 16px;
        border: 1px solid #ccc;
        border-radius: 6px;
    }
    button {
        background-color: #d9534f;
        color: white;
        padding: 12px 20px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        width: 100%;
    }
    .alert {
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }
    .alert-success {
        background: #d4edda;
        color: #155724;
    }
    .container-delete {
        max-width: 500px;
        margin: 0 auto;
        padding: 20px;
    }

</style>

<div id="parallax-wrap" class="parallax-search" data-parallax="scroll" data-position="top" data-bleed="10" data-image-src="/munch/assets/images/b-2.jpg">

    <div class="search-wraps contact-banner">
        <h1>Delete Account</h1>

        <p><i class="ion-ios-location"></i>  Delete Account</p>



    </div> <!--search-wraps-->

</div>

<div class="container-delete">
    <h2>Delete Your Account</h2>

    <p>
        This form is for users of the <strong><?php echo $restaurantInfo['details']['data']['restaurant_name']; ?></strong> mobile app.  
        If you wish to permanently delete your account and associated data, please fill out the form below.  
        Our team at <strong>NexusTech</strong> will process your request within 3 business days.
    </p>

    <?php
      $success = $this->session->flashdata('success');
      $error = $this->session->flashdata('error');
    ?>
    
    <?php if ($this->session->flashdata('success')): ?>
      <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
      <?php $this->session->unset_userdata('success'); ?>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('error')): ?>
      <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
      <?php $this->session->unset_userdata('error'); ?>
    <?php endif; ?>
    
    <form method="POST" action="<?= base_url('delete-account'); ?>">
      <input type="text" name="name" placeholder="Your Name" required>
      <input type="email" name="email" placeholder="Your Email" required>
      
      <!-- Add reCAPTCHA token field -->
      <input type="hidden" name="recaptcha_response" value="" id="recaptchaResponse">
      
      <button type="submit">Send Delete Account Request</button>
</form>
</div>
<script src="https://www.google.com/recaptcha/api.js?render=<?= @$this->session->merchantInfo['recaptcha_site_key']; ?>"></script>
<script>
    grecaptcha.ready(function () {
        grecaptcha.execute('<?= @$this->session->merchantInfo['recaptcha_site_key']; ?>', { action: 'delete_account' }).then(function (token) {
            document.getElementById('recaptchaResponse').value = token;
        });
    });
</script>