<?php




class IndexController extends Controller {


    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->MerchantMenu = new MerchantMenu();

        $this->MerchantWrapper = new MerchantWrapper();

       $this->htmlWrapper = new htmlWrapper();

       $this->OrderWrapper = new OrderWrapper();

       

        
        

        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
    //}
      //echo $_REQUEST['url'];die();

     if (!$this->functions->isAdminLogin() && $_REQUEST['url']!='admin/login'){           
       //print_r($_REQUEST);
        //$this->login();
    $bases=Config::$baseUrl;
    header("Location: ".$bases."/admin/login");
exit();
    
        }



   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {

    
        
        //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
   

        $data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"General Settings",
            'tpl'=>"settings_api",
            'data'=>array()
             
            ];
        $this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout'); 
    }


    public function settings() {

    
        
        //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
   

        $data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"General Settings",
            'tpl'=>"settings_api",
            'data'=>array()
             
            ];
        $this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout'); 
    }


    public function application_settings()
	{

		 //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

		 
		
		$data = array();

		//$this->setActiveSettings();
		
		$order_estimated_time = $this->MerchantWrapper->parseTagTify('order_estimated_time');
		$decline_reason_list = $this->MerchantWrapper->parseTagTify('decline_reason_list');
				
		$ref_data = array(
		  'map_api'=>$map_api,
          'provider'=>$provider['provider'],
          'map_type'=>$map_type,
		  'order_unattended_minutes'=>$this->functions->getOptionAdmin('order_unattended_minutes'),
		  'pageTitle' => $this->functions->translation('default', "Settings"),
		  'ready_outgoing_minutes'=>$this->functions->getOptionAdmin('ready_outgoing_minutes'),
		  'ready_unattended_minutes'=>$this->functions->getOptionAdmin('ready_unattended_minutes'),
		  'booking_incoming_unattended_minutes'=>$this->functions->getOptionAdmin('booking_incoming_unattended_minutes'),
		  'booking_cancel_unattended_minutes'=>$this->functions->getOptionAdmin('booking_cancel_unattended_minutes'),
		  'merchantapp_keep_awake'=>$this->functions->getOptionAdmin('merchantapp_keep_awake'),
		  'refresh_order'=>$this->functions->getOptionAdmin('refresh_order'),
		  'refresh_cancel_order'=>$this->functions->getOptionAdmin('refresh_cancel_order'),
		  'refresh_booking'=>$this->functions->getOptionAdmin('refresh_booking'),
		  'refresh_cancel_booking'=>$this->functions->getOptionAdmin('refresh_cancel_booking'),
		  'order_estimated_time'=>$order_estimated_time,
		  'decline_reason_list'=>$decline_reason_list,
		  'interval_ready_order'=>$this->functions->getOptionAdmin('interval_ready_order'),
		  'merchantapp_upload_resize_width'=>$this->functions->getOptionAdmin('merchantapp_upload_resize_width'),
		  'merchantapp_upload_resize_height'=>$this->functions->getOptionAdmin('merchantapp_upload_resize_height'),
		  'merchantapp_upload_resize_enabled'=>$this->functions->getOptionAdmin('merchantapp_upload_resize_enabled'),
		  'number_of_alert'=>$this->functions->getOptionAdmin('number_of_alert'),
		  'settings_title'=>"Application Settings",
		  'tpl'=>"application_settings",
		  
		);	

		

		$this->view('merchantapp/general_settings', $ref_data, 'layouts_merchantapp/layout'); 	
		
		/*$this->render('general_settings',array(
		  'settings_title'=>translate("Application Settings"),
		  'tpl'=>"application_settings",
		  'data'=>$data
		));*/
	}


		public function order_settings()
	{


		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

		
		$country_list=$this->functions->CountryList();
		$mobile_country_list=$this->functions->getOptionAdmin('mobile_country_list');
		if (!empty($mobile_country_list)){
			$mobile_country_list=json_decode($mobile_country_list);
		} else $mobile_country_list=array();
		
		$search_options = array();
		
		$order_incoming_status = $this->functions->getOptionAdmin('order_incoming_status');
		$order_outgoing_status = $this->functions->getOptionAdmin('order_outgoing_status');
		$order_ready_status = $this->functions->getOptionAdmin('order_ready_status');
		
		$order_failed_status = $this->functions->getOptionAdmin('order_failed_status');
		$order_successful_status = $this->functions->getOptionAdmin('order_successful_status');
		
		$order_status_list = $this->MerchantWrapper->dropdownFormat((array)$this->OrderWrapper->AllOrderStatus(),
		'description','description');		
		
		$options = $this->MerchantWrapper->getOptions(array(
		  'order_action_accepted_status',
		  'order_action_decline_status','order_action_cancel_status','order_action_food_done_status',
		  'order_action_delayed_status','order_action_completed_status','order_action_approved_cancel_order',
		  'order_action_decline_cancel_order','accepted_based_time'
		));
						
		$data = array(		
		  'map_api'=>$map_api,
          'provider'=>$provider['provider'],
          'map_type'=>$map_type,
		  'order_status_list'=>$order_status_list,
		  'order_incoming_status'=>!empty($order_incoming_status)?json_decode($order_incoming_status,true):'',
		  'order_outgoing_status'=>!empty($order_outgoing_status)?json_decode($order_outgoing_status,true):'',
		  'order_ready_status'=>!empty($order_ready_status)?json_decode($order_ready_status,true):'',
		  'order_failed_status'=>!empty($order_failed_status)?json_decode($order_failed_status,true):'',
		  'order_successful_status'=>!empty($order_successful_status)?json_decode($order_successful_status,true):'',
		  'settings_title'=>"Order Settings",
		  'tpl'=>"order_settings"
		);
		
		if(is_array($options) && count($options)>=1){
			foreach ($options as $val) {
				$data[$val['option_name']]=$val['option_value'];
			}
		}
					
		
		
		

		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');



	}


	public function auto_order()
	{
		

		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

		
		$data = array();
		
		
		$order_status_list = $this->MerchantWrapper->dropdownFormat((array)$this->OrderWrapper->AllOrderStatus(),
		'description','description');		
								
		$data = array(		
		  'map_api'=>$map_api,
          'provider'=>$provider['provider'],
          'map_type'=>$map_type,  
          'settings_title'=>"Auto update order status",
          'tpl'=>"auto_order",
		  'order_status_list'=>$order_status_list,
		  'merchantapp_enabled_auto_status_enabled'=>$this->functions->getOptionAdmin('merchantapp_enabled_auto_status_enabled'),
		  'merchantapp_enabled_auto_status_time'=>$this->functions->getOptionAdmin('merchantapp_enabled_auto_status_time'),
		  'merchantapp_enabled_auto_status'=>$this->functions->getOptionAdmin('merchantapp_enabled_auto_status'),
		  'merchantapp_enabled_auto_status_readyin'=>$this->functions->getOptionAdmin('merchantapp_enabled_auto_status_readyin')
		);

		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');
		
		
	}


	public function booking_settings()
	{
		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
		$data = array();
		
		
		$order_status_list = $this->functions->bookingStatus();		
		
		$booking_incoming_status = $this->functions->getOptionAdmin('booking_incoming_status');
		$booking_cancel_status = $this->functions->getOptionAdmin('booking_cancel_status');
		$booking_done_status = $this->functions->getOptionAdmin('booking_done_status');	
		
		$data = array(	
		  'map_api'=>$map_api,

          'provider'=>$provider['provider'],
          'map_type'=>$map_type,  
          'tpl'=>"booking_settings",
          'settings_title'=>"Booking Settings",	  
		  'order_status_list'=>$order_status_list,		  
		  'booking_incoming_status'=>!empty($booking_incoming_status)?json_decode($booking_incoming_status,true):'',
		  'booking_cancel_status'=>!empty($booking_cancel_status)?json_decode($booking_cancel_status,true):'',
		  'booking_done_status'=>!empty($booking_done_status)?json_decode($booking_done_status,true):'',
		);
		
		

		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');

	}


	public function settings_fcm()
	{

		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
		
		$data = array();
		
		/*$image_limit_size=FunctionsV3::imageLimitSize();		
		RegisterScriptWrapper::registerScript(array(
		 "var image_limit_size='". CJavaScript::quote($image_limit_size) ."';",		 
		),'image_limit_size');*/
		
		
		

		$data = array(	
		  'map_api'=>$map_api,

          'provider'=>$provider['provider'],
          'map_type'=>$map_type,  
          'tpl'=>"settings_fcm",
          'settings_title'=>"FCM Settings",	  
		  
		);


		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');

	}



	public function settings_printer()
	{

		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

		
		
		$data = array();
						
		$data = array(		  		
		);


		$data = array(	
		  'map_api'=>$map_api,

          'provider'=>$provider['provider'],
          'map_type'=>$map_type,  
          'tpl'=>"settings_printer",
          'settings_title'=>"Printer",	  
		  
		);
		
		

		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');



	}



    public function privacy_policy()
	{

		//+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call


		
		
		$data = array();
		
				
								
		$data = array(	
			'map_api'=>$map_api,

          'provider'=>$provider['provider'],
          'map_type'=>$map_type,
		  'merchantapp_privacy_policy_link'=>$this->functions->getOptionAdmin('merchantapp_privacy_policy_link'),
		  'settings_title'=>"Privacy policy",
		  'tpl'=>"privacy_policy"
		);

		$this->view('merchantapp/general_settings', $data, 'layouts_merchantapp/layout');

		
		
	}

	public function device_list()
	{
		

		 $ref_data = [
            
            'pageTitle' => "Device List"
            
             
            ];

		$this->view('merchantapp/device_list', $ref_data, 'layouts_merchantapp/layout');		
        
		
	


	}

	public function push_broadcast()
	{
		 

		$ref_data = [
            
            'pageTitle' => "Broadcast"
            
             
            ];

		$this->view('merchantapp/push_broadcast_list', $ref_data, 'layouts_merchantapp/layout');	

	}


	public function push_logs()
	{
		

		$ref_data = [
            
            'pageTitle' => "Push Logs"
            
             
            ];

		$this->view('merchantapp/push_logs', $ref_data, 'layouts_merchantapp/layout');	
	}


	public function order_trigger()
	{
		 


		$ref_data = [
            
            'pageTitle' => "Order trigger notification"
            
             
            ];

		$this->view('merchantapp/order_trigger_list', $ref_data, 'layouts_merchantapp/layout');
	}


	public function others()
	{
		$app_folder='/merchantappv2';

		
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/processpush", 
		  'notes'=>("run this every 1 minute")
		);
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/processbroadcast",
		  'notes'=>("run this every 1 minute")
		);
		
		/*$cron[] = array(
		  'link'=>FunctionsV3::getHostURL().Yii::app()->createUrl(APP_FOLDER."/cron/trigger_order"),
		  'notes'=>translate("run this every 1 minute")
		);
		
		$cron[] = array(
		  'link'=>FunctionsV3::getHostURL().Yii::app()->createUrl(APP_FOLDER."/cron/trigger_order_booking"),
		  'notes'=>translate("run this every 2 minute")
		);*/
		
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/unattented_order",
		  'notes'=>("run this every 1 minute")
		);
		
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/autoupdatestatus",
		  'notes'=>("run this every 1 minute")
		);
				
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/unattented_booking",
		  'notes'=>("run this every 2 minute")
		);
				
		
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/clear_logs",
		  'notes'=>("run this every end of the month. this will clear all logs with record past 2months")
		);
		
		$cron[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/nearexpiration",
		  'notes'=>("run this once a day")
		);
		
		$update_db =Config::$baseUrl.$app_folder."/update";
		
		$cron_min[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/runall",
		  'notes'=>("run this every 1 minute")
		);
		
		$cron_min[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/clear_logs",
		  'notes'=>("run this every end of the month. this will clear all logs with record past 2months")
		);
		
		$cron_min[] = array(
		  'link'=>Config::$baseUrl.$app_folder."/cron/nearexpiration",
		  'notes'=>("run this once a day")
		);
		
		

		$ref_data = [
            
            'pageTitle' => "Others",
            'cron'=>$cron,
		  'cron_sample'=>$cron[0]['link'],
		  'update_db'=>$update_db,
		  'cron_min'=>$cron_min
            
             
            ];

		$this->view('merchantapp/others', $ref_data, 'layouts_merchantapp/layout');


	}
    




  






  
}
