<?php
class BootstrapWrapper
{

	


    public function formRadio($field_name = '', $label = '', $selected = false, $options = [])
{
    ob_start();
    ?>
    <div class="radio">
        <label>
            <input type="radio"
                   name="<?php echo htmlspecialchars($field_name); ?>"
                   value="<?php echo isset($options['value']) ? htmlspecialchars($options['value']) : ''; ?>"
                   class="<?php echo isset($options['class']) ? htmlspecialchars($options['class']) : ''; ?>"
                   <?php echo $selected ? 'checked' : ''; ?>
                   <?php
                   foreach ($options as $key => $val) {
                       if (!in_array($key, ['value', 'class'])) {
                           echo htmlspecialchars($key) . '="' . htmlspecialchars($val) . '" ';
                       }
                   }
                   ?>>
            <span class="bmd-radio"><div class="ripple-container"></div></span>
            <?php echo htmlspecialchars($label); ?>
        </label>
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}



 public function checkboxInline($field_name = '', $label = '', $selected = false, $options = [])
{
    ob_start();
    ?>
    <label class="checkbox-inline">
        <input type="checkbox"
               name="<?php echo htmlspecialchars($field_name); ?>"
               value="<?php echo isset($options['value']) ? htmlspecialchars($options['value']) : '1'; ?>"
               class="<?php echo isset($options['class']) ? htmlspecialchars($options['class']) : ''; ?>"
               <?php echo $selected ? 'checked' : ''; ?>
               <?php
               foreach ($options as $key => $val) {
                   if (!in_array($key, ['value', 'class'])) {
                       echo htmlspecialchars($key) . '="' . htmlspecialchars($val) . '" ';
                   }
               }
               ?>>
        <span class="checkbox-decorator">
            <span class="check"></span>
            <div class="ripple-container"></div>
        </span>
        <?php echo htmlspecialchars($label); ?>
    </label>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}

public function formSwitch($field_name = '', $label = '', $selected = false, $options = [])
{
    ob_start();
    ?>    
    <div class="switch">
        <label>
            <input type="checkbox"
                   name="<?php echo htmlspecialchars($field_name); ?>"
                   value="<?php echo isset($options['value']) ? htmlspecialchars($options['value']) : '1'; ?>"
                   class="<?php echo isset($options['class']) ? htmlspecialchars($options['class']) : ''; ?>"
                   <?php echo $selected ? 'checked' : ''; ?>
                   <?php
                   foreach ($options as $key => $val) {
                       if (!in_array($key, ['value', 'class'])) {
                           echo htmlspecialchars($key) . '="' . htmlspecialchars($val) . '" ';
                       }
                   }
                   ?>>
            <span class="bmd-switch-track">
                <div class="ripple-container"></div>
            </span>
            &nbsp;<?php echo htmlspecialchars($label); ?>
        </label>
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}



    











	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/