<?php
class MerchantWrapper
{

    public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();

        
    }


    public  function paginateLimit()
    {
        return 10;
    }
    
    public  function dropdownFormat($data=array(),$value='', $label='')
    {
        $list = array();
        $list['']='';
        if(is_array($data) && count($data)>=1){
            foreach ($data as $val) {
                if(isset($val[$value]) && isset($val[$label])){
                   $list[ $val[$value] ] = ($val[$label]);
                }
            }
        }
        return $list;
    }
    
  public function getMerchantInformation($merchant_id = 0)
{
    if ($merchant_id > 0) {
        $stmt = "
            SELECT * 
            FROM mt_merchant
            WHERE merchant_id = :merchant_id
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([':merchant_id' => $merchant_id]);

        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            return $resp;
        }
    }

    throw new Exception("Merchant not found");
}


public  function udapteMerchantInfo($params=array(), $merchant_id=0 )
    {
        if(is_array($params) && count($params)>=1 && $merchant_id>0){

           

            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', $merchant_id);


            if($up){
                return true;
            } else throw new Exception( "Failed cannot update records" );   
        }
        throw new Exception( "Invalid parameters" );    
    }


 public function insertCuisine($merchant_id = '', $cuisine = array())
{       
    $merchant_id = (integer)$merchant_id;

    // Delete existing records for the merchant
    $stmt = $this->db->prepare("DELETE FROM mt_cuisine_merchant WHERE merchant_id = :merchant_id");
    $stmt->execute([':merchant_id' => $merchant_id]);
            
    if (is_array($cuisine) && count($cuisine) >= 1) {
        foreach ($cuisine as $cuisine_id) {
            $params = array(    
                'merchant_id' => (integer)$merchant_id,
                'cuisine_id' => (integer)$cuisine_id  
            );  

            // Use existing insertData function
            $this->functions->insertData('mt_cuisine_merchant', $params);
        }
    }
}


public  function dashboardMenu()
    {
        $is_location = false;
        if ($this->functions->isSearchByLocation()){
            $is_location = true;
        }
        $data = array();
        $data[] = array(
         'icon'=>"1.png",
         'label'=>"Info",
         'page'=>"info.html",
         'access_id'=>'Merchant'
        );
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Settings",
         'page'=>"merchant_settings.html",
         'access_id'=>'Settings'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Opening",
         'page'=>"store_hours.html",
         'access_id'=>'Settings'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"All Orders",
         'page'=>"all_orders.html",
         'access_id'=>'allorder'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Time",
         'page'=>"order_time_management_list.html",
         'access_id'=>'order_settings'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Status",
         'page'=>"orders_status_list.html",
         'access_id'=>'orderstatus'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Cancel",
         'page'=>"cancel_orders.html",
         'access_id'=>'allorder'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Booking",
         'page'=>"all_booking.html",
         'access_id'=>'tablebooking'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Category",
         'page'=>"category.html",
         'access_id'=>'CategoryList'
        );
        $data[] = array(
         'icon'=>"4.png",
         'label'=>"Addon",
         'page'=>"addon_list.html",
         'access_id'=>'AddOnCategory'
        );
        $data[] = array(
         'icon'=>"5.png",
         'label'=>"Addon item",
         'page'=>"addon_item_list.html",
         'access_id'=>'AddOnItem'
        );
        $data[] = array(
         'icon'=>"6.png",
         'label'=>"Items",
         'page'=>"item_list.html",
         'access_id'=>'FoodItem'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Invoice",
         'page'=>"invoice_list.html",
         'access_id'=>'invoice'
        );
        
        $data[] = array(
         'icon'=>"7.png",
         'label'=>"Ingredients",
         'page'=>"ingredients_list.html",
         'access_id'=>'ingredients'
        );
        $data[] = array(
         'icon'=>"8.png",
         'label'=>"Cooking",
         'page'=>"cooking_list.html",
         'access_id'=>'CookingRef'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Sizes",
         'page'=>"size_list.html",
         'access_id'=>'Size'
        );
        
        if(!$is_location):
        $data[] = array(
         'icon'=>"10.png",
         'label'=>"Fee",
         'page'=>"shipping_list.html",
         'access_id'=>'shippingrate'
        );              
        $data[] = array(
         'icon'=>"9.png",
         'label'=>"Min. Table",
         'page'=>"mintable_list.html",
         'access_id'=>'mintable'
        );
        endif;
        
        $data[] = array(
         'icon'=>"10.png",
         'label'=>"Offers",
         'page'=>"offers_list.html",
         'access_id'=>'offers'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Gallery",
         'page'=>"gallery_settings.html",
         'access_id'=>'gallerysettings'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Banner",
         'page'=>"banner_settings.html",
         'access_id'=>'banner_settings'
        );
        
        
        
        $data[] = array(
         'icon'=>"10.png",
         'label'=>"Voucher",
         'page'=>"voucher_list.html",
         'access_id'=>'voucher'
        );
        $data[] = array(
         'icon'=>"5.png",
         'label'=>"Scheduler",
         'page'=>"scheduler_list.html",
         'access_id'=>'category_sked'
        );
        $data[] = array(
         'icon'=>"9.png",
         'label'=>"Payment",
         'page'=>"payment_list.html",
         'access_id'=>'payment-gateway'
        );
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Reviews",
         'page'=>"reviews.html",
         'access_id'=>'review'
        );
        
        $data[] = array(
         'icon'=>"6.png",
         'label'=>"Social",
         'page'=>"social_settings.html",
         'access_id'=>'SocialSettings'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Alert",
         'page'=>"alert_settings.html",
         'access_id'=>'AlertSettings'
        );
        
        $data[] = array(
         'icon'=>"3.png",
         'label'=>"Reports",
         'page'=>"reports_menu.html",
         'access_id'=>'reports'
        );
        
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"SMS alert",
         'page'=>"sms_alert.html",
         'access_id'=>'smsSettings'
        );
        
        $merchantapp_disabled_broadcast = $this->functions->getOptionAdmin('merchantapp_disabled_broadcast');
        if($merchantapp_disabled_broadcast!=1):
        $data[] = array(
         'icon'=>"2.png",
         'label'=>"Push",
         'page'=>"broadcast_list.html",
         'access_id'=>''
        );
        endif;
        
        return $data;
    }


    public  function twoFlavorOptions()
    {
        return array(
          1=>"Highest price",
          2=>"Sumup and divided by 2"
        );
    }
    
    public  function tipList()
    {
        return array(
               ''=>"None",
               '0.1'=>"10%",
               '0.15'=>"15%",
               '0.2'=>"20%",
               '0.25'=>"25%"           
            );
    }
    
    public  function voucherType()
    {
        return array(
          'fixed amount'=>"fixed amount",
          'percentage'=>"percentage",
        );
    }
    
    public  function parseTagTify($options_name='')
    {
        $format='';
        $options = $this->functions->getOptionAdmin($options_name);
        if( $json = json_decode($options,true)){
            foreach ($json as $val) {
                $format.=$val['value'].",";
            }
            $format= substr($format,0,-1);
        }
        return $format;
    }


    public  function timeListReady()
    {
        $data = array(); $order_estimated_time = array();
        $time = $this->functions->getOptionAdmin('order_estimated_time');
        if ( $json = json_decode($time,true)){
            foreach ($json as $val) {               
                $data[]=array(
                  'value'=>$val['value'],
                  'label'=>"MIN ".$val['value'],
                );
            }
        }
                    
        if(count((array)$data)<=0){
            $data[] = array(
              'value'=>10,
              'label'=>"10 MIN"
            );
            $data[] = array(
              'value'=>20,
              'label'=>"20 MIN"
            );
            $data[] = array(
              'value'=>30,
              'label'=>"30 MIN"
            );
        }
        
        return $data;
    }
    
    public  function reasonDeclineList()
    {
        $data = array(); $order_estimated_time = array();
        $time = $this->functions->getOptionAdmin('decline_reason_list');
        if ( $json = json_decode($time,true)){
            foreach ($json as $val) {               
                $data[]=array(
                  'value'=>$val['value'],
                  'label'=>($val['value']),
                );
            }
        }
        
        if(count((array)$data)<=0){
            $data[] = array(
              'value'=>"Closing early",
              'label'=>"Closing early"
            );
            $data[] = array(
              'value'=>"Problem with merchant",
              'label'=>"Problem with merchant"
            );
            $data[] = array(
              'value'=>"Out of stock",
              'label'=>"Out of stock"
            );
        }
        return $data;
    }


    public  function merchantSettingsOption()
    {
        $options = array(
              'order_verification','order_sms_code_waiting','food_option_not_available',
              'disabled_food_gallery','food_viewing_private','merchant_two_flavor_option',
              'merchant_tax_number','printing_receipt_width','printing_receipt_size',
              'free_delivery_above_price','merchant_close_store','merchant_show_time',
              'merchant_disabled_ordering','merchant_extenal','merchant_enabled_voucher',
              'merchant_required_delivery_time','merchant_minimum_order','merchant_required_delivery_time',
              'merchant_minimum_order','merchant_maximum_order','merchant_minimum_order_pickup',
              'merchant_maximum_order_pickup','merchant_minimum_order_dinein','merchant_maximum_order_dinein',
              'merchant_packaging_wise','merchant_packaging_charge','merchant_packaging_increment',
              'merchant_tax','merchant_delivery_charges','merchant_tax_charges',
              'merchant_opt_contact_delivery','merchant_delivery_estimation','merchant_tax',
              'merchant_distance_type','merchant_enabled_tip','merchant_tip_default',
              'merchant_timezone','website_merchant_time_picker_interval','merchant_delivery_miles',
              'merchant_photo','merchant_photo_bg'
            );
        return $options;
    }

    public function getMerchantSettings($merchant_id = 0, $options = array())
{
    if ($merchant_id > 0) {
        $options_in = '';
        foreach ($options as $val) {
            $options_in .= $this->db->quote($val) . ','; 
        }
        $options_in = rtrim($options_in, ',');

        $stmt = "
            SELECT option_name, option_value
            FROM mt_option 
            WHERE merchant_id = :merchant_id
            AND option_name IN ($options_in)
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([':merchant_id' => $merchant_id]);

        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    }
    return false;
}

public function getAllBankDeposit($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND b.first_name LIKE " . $this->db->quote("$search_string%") . " ";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.id, 
        CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
        a.branch_code, a.date_of_deposit, a.time_of_deposit, a.amount,
        a.scanphoto, a.status, a.date_created
        FROM mt_bank_deposit a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE a.merchant_id = :merchant_id
        $and
        ORDER BY id DESC
        LIMIT :start, :total_rows
    ";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    $query->bindValue(':start', (int)$start, PDO::PARAM_INT);
    $query->bindValue(':total_rows', (int)$total_rows, PDO::PARAM_INT);
    $query->execute();

    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}

public  function setMerchantTimezone($merchant_id=''){        
        if($merchant_id>0){         
            $mt_timezone=$this->functions->getOption("merchant_timezone",$merchant_id);            
            if (!empty($mt_timezone)){
                date_default_timezone_set($mt_timezone);
            }       
        }
    }

    public function getAllNotification($list_type = '', $device_uiid = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    $order_by = 'ORDER BY id DESC';

    if (!empty($search_string)) {
        $and .= " AND (
            a.push_title LIKE " . $this->db->quote("%$search_string%") . " 
            OR a.push_message LIKE " . $this->db->quote("%$search_string%") . "
        ) ";
    }

    if (!empty($list_type)) {
        switch ($list_type) {
            case "unread":
                // Add specific condition for unread if required.
                break;
        }
    }

    $stmt = "
        SELECT a.id, a.push_title, a.push_message, a.date_created, a.is_read
        FROM mt_merchantapp_push_logs a
        WHERE a.device_uiid = " . (int)$device_uiid . "
        $and
        $order_by
        LIMIT $start, $total_rows
    ";

    $query = $this->db->query($stmt);
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}

public function getViewNotification($list_type = '', $device_uiid = 0, $merchant_id = '', $start = 0, $total_rows = 10, $search_string = '')
{
    $and = " AND is_remove='0' ";
    $order_by = 'ORDER BY date_created DESC';

    if (!empty($search_string)) {
        $and .= " AND (
            push_title LIKE " . $this->db->quote("%$search_string%") . "
            OR push_message LIKE " . $this->db->quote("%$search_string%") . "
        ) ";
    }

    if (!empty($list_type)) {
        switch ($list_type) {
            case "unread":
                $and .= " AND is_read='0'";
                break;
        }
    }

    $stmt = "
        SELECT * FROM mt_merchantapp_view_notification
        WHERE key_id IN (" . (int)$device_uiid . ", " . $this->db->quote($merchant_id) . ")
        $and
        $order_by
        LIMIT $start, $total_rows
    ";

    $query = $this->db->query($stmt);
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}


public function MarkReadNotification($merchant_id = '', $device_uiid = '')
{
    $up = true;
    $params = array(
        'is_read' => 1,
        'date_modified' => $this->functions->dateNow(),
        'ip_address' => $_SERVER['REMOTE_ADDR']
    );

    $stmt1 = $this->db->query("SELECT id FROM mt_merchantapp_push_logs WHERE device_uiid=" . $this->db->quote($device_uiid));
    if ($stmt1->fetch(PDO::FETCH_ASSOC)) {
        $up = $this->functions->updateData("mt_merchantapp_push_logs", $params, 'device_uiid', $device_uiid);
    }

    $stmt2 = $this->db->query("SELECT broadcast_id FROM mt_merchantapp_broadcast WHERE merchant_id=" . $this->db->quote($merchant_id));
    if ($stmt2->fetch(PDO::FETCH_ASSOC)) {
        $up = $this->functions->updateData("mt_merchantapp_broadcast", $params, 'merchant_id', $merchant_id);
    }

    if ($up) {
        return true;
    }

    throw new Exception("Failed cannot update record");
}


public  function MarkReadNotificationByID($record_type='',$device_uiid='',$id='')
    {       
        $params = array(
          'is_read'=>1, 
          'date_modified'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        
        if($record_type=="push_logs"){

           

            $up = $this->functions->updateData("mt_merchantapp_push_logs", $params, 'device_uiid', $id);



        } else {

            

             $up = $this->functions->updateData("mt_merchantapp_broadcast", $params, 'broadcast_id', $id);

        }
        if($up){
            return true;
        }
        throw new Exception( "Failed cannot update record" );   
    }


   public function PushRemoveAll($merchant_id = '', $device_uiid = '')
{       
    $up = true;
    $params = array(
        'is_remove' => 1,
        'date_modified' => $this->functions->dateNow(),
        'ip_address' => $_SERVER['REMOTE_ADDR']
    );

    $stmt1 = $this->db->query("SELECT id FROM mt_merchantapp_push_logs WHERE device_uiid=" . $this->db->quote($device_uiid));
    if ($stmt1->fetch(PDO::FETCH_ASSOC)) {
        $up = $this->functions->updateData("mt_merchantapp_push_logs", $params, 'device_uiid', $device_uiid);   
    }

    $stmt2 = $this->db->query("SELECT broadcast_id FROM mt_merchantapp_broadcast WHERE merchant_id=" . $this->db->quote($merchant_id));
    if ($stmt2->fetch(PDO::FETCH_ASSOC)) {
        $up = $this->functions->updateData("mt_merchantapp_broadcast", $params, 'merchant_id', $merchant_id);
    }               

    if ($up) {                        
        return true;
    }               

    throw new Exception("Failed cannot delete records."); 
}

public  function PushRemoveByID($record_type='',$device_uiid='',$id='')
    {
        $params = array(
          'is_remove'=>1,
          'date_modified'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        if($record_type=="push_logs"){ 

           
            $up = $this->functions->updateData("mt_merchantapp_push_logs", $params, 'device_uiid', $id);

            return true; 
        } else {                        
             

            $up = $this->functions->updateData("mt_merchantapp_broadcast", $params, 'broadcast_id', $id);

            return true;
        }
        throw new Exception( "Failed cannot delete records." ); 
    }


    public function getOptions_x($options_name = array(), $merchant_id = 0)
{
    $que = '';
    if (is_array($options_name) && count($options_name) >= 1) {
        foreach ($options_name as $key => $val) {
            $que .= $this->db->quote($val) . ",";
        }
        $que = substr($que, 0, -1);
    }

    $stmt = "
        SELECT option_name, option_value
        FROM mt_option     
        WHERE option_name IN ($que)
        AND merchant_id = " . $this->db->quote($merchant_id) . "
    ";

    $query = $this->db->query($stmt);
    if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


    public function getOptions($options_name = array(), $merchant_id = 0)
{
    $que = '';
    if (is_array($options_name) && count($options_name) >= 1) {
        foreach ($options_name as $key => $val) {
            $que .= "'" . addslashes($val) . "',";
        }
        $que = substr($que, 0, -1);
    }

    

    $stmt = "
        SELECT option_name, option_value
        FROM mt_option     
        WHERE option_name IN ($que)
        AND merchant_id = " . (int)$merchant_id . "
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->execute();
    $resp = $cmd->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        //print_r($resp);die();
        return $resp;
    }
    return false;
}




public  function getOptionsSettings()
    {
        $data = array();
        $name = array(
         'order_unattended_minutes','ready_outgoing_minutes','ready_unattended_minutes',
         'booking_incoming_unattended_minutes','booking_cancel_unattended_minutes','merchantapp_keep_awake',
         'refresh_order','refresh_cancel_order','refresh_booking','refresh_cancel_booking',
         'order_failed_status','order_successful_status',
         'order_incoming_status','order_outgoing_status','order_ready_status','merchant_status_disabled',
         'merchantapp_enabled_booking','interval_ready_order',
         'merchantapp_upload_resize_enabled','merchantapp_upload_resize_width','merchantapp_upload_resize_height',
         'print_enabled_printer','merchantapp_privacy_policy_link','number_of_alert','merchantapp_remove_accepting_time',
         'merchantapp_remove_cancel_status'
        );
        if($resp = $this->getOptions($name)){
            foreach ($resp as $val) {
                
                switch ($val['option_name']) {

                  

                    case "order_failed_status":                     
                    case "order_successful_status":
                    case "order_incoming_status":
                    case "order_outgoing_status":
                    case "order_ready_status":
                        $data[$val['option_name']] = !empty($val['option_value'])? json_decode( stripslashes($val['option_value']) ,true):'';
                        break;
                
                    default:
                        $data[$val['option_name']] = trim($val['option_value']);
                        break;
                }
                
            }
        }
        
        return $data;
    }


    public  function prettyBadge($status='')
    {
        $status=strtolower(trim($status));
        if($status=="pending"){
           return '<span class="badge badge-primary">'.($status).'</span>';
        } elseif ( $status=="process" ){
            return '<span class="badge badge-success">'.($status).'</span>';
        } elseif ( preg_match("/properly set in/i", $status)){
            return '<span class="badge badge-danger">'.($status).'</span>';
        } elseif ( preg_match("/caught/i", $status)){
            return '<span class="badge badge-danger">'.($status).'</span>';    
        } elseif ( preg_match("/error/i", $status)){
            return '<span class="badge badge-danger">'.($status).'</span>';            
        } elseif ( preg_match("/failed/i", $status)){
            return '<span class="badge badge-danger">'.($status).'</span>';        
        } elseif ( preg_match("/no/i", $status)){
            return '<span class="badge badge-secondary">'.($status).'</span>';         
        } else {            
           return '<span class="badge badge-success">'.($status).'</span>';
        }
    } 


    public  function acceptedBasedTime()
    {
        return array(
          1=>$this->functions->translation("default","based on delivery date"),
          2=>$this->functions->translation("default","based on current time"),
        );
    }
    
    public function getTimeOpening($merchant_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_opening_hours
        WHERE merchant_id = :merchant_id
        ORDER BY id ASC
    ");

    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->execute();
    
    if ($resp = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public function getAllReview($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {                         
        $and = " AND (
            a.review LIKE :search_string
            OR b.first_name LIKE :search_string
            OR b.last_name LIKE :search_string
        )";
    }

    $stmt = $this->db->prepare("
        SELECT SQL_CALC_FOUND_ROWS 
        a.id, a.client_id, a.review, a.rating, a.status,
        CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
        a.date_created,
        (
            SELECT COUNT(*)
            FROM mt_review
            WHERE parent_id = a.id
        ) AS total_comments
        FROM mt_review a                
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE a.merchant_id = :merchant_id
        $and
        ORDER BY a.id DESC
        LIMIT :start, :total_rows
    ");

    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':start', $start, PDO::PARAM_INT);
    $stmt->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search_param = "%$search_string%";
        $stmt->bindParam(':search_string', $search_param, PDO::PARAM_STR);
    }

    $stmt->execute();
    if ($resp = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public  function addReview($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){  

             
              $up = $this->functions->updateData("mt_review", $params, 'id', $id);


              if($up){
                 return true;
              } else throw new Exception( "Failed cannot update records" );         
        } else { 

            if($this->functions->insertData('mt_review', $params)){
                return true;
            } else throw new Exception( "Failed cannot insert records" );
        }       
        
        throw new Exception( "an error has occurred" );
    }


    public function deleteReview($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion");
    }

    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    $stmt = $this->db->prepare("
        DELETE FROM mt_review 
        WHERE merchant_id = ? 
        AND id IN ($placeholders)
    ");

    $params = array_merge([$merchant_id], $ids);

    if ($stmt->execute($params)) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}

public  function addCards($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){  

             

              $up = $this->functions->updateData("mt_merchant_cc", $params, 'mt_id', $id);

              if($up){
                 return true;
              } else throw new Exception( "Failed cannot update records" );         
        } else {  

            if($this->functions->insertData('mt_merchant_cc', $params) ){
                return true;
            } else throw new Exception( "Failed cannot insert records" );
        }       
        
        throw new Exception( "an error has occurred" );
    } 



   public function getAllCards($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    $params = [':merchant_id' => (int)$merchant_id, ':start' => (int)$start, ':total_rows' => (int)$total_rows];

    if (!empty($search_string)) {
        $and = " AND card_name LIKE :search_string ";
        $params[':search_string'] = "$search_string%";
    }

    $stmt = $this->db->prepare("
        SELECT SQL_CALC_FOUND_ROWS 
        mt_id, card_name, credit_card_number, expiration_month, expiration_yr, billing_address, date_created, encrypted_card
        FROM mt_merchant_cc
        WHERE merchant_id = :merchant_id
        $and
        ORDER BY mt_id DESC
        LIMIT :start, :total_rows
    ");

    $stmt->bindValue(':merchant_id', $params[':merchant_id'], PDO::PARAM_INT);
    if (isset($params[':search_string'])) {
        $stmt->bindValue(':search_string', $params[':search_string'], PDO::PARAM_STR);
    }
    $stmt->bindValue(':start', $params[':start'], PDO::PARAM_INT);
    $stmt->bindValue(':total_rows', $params[':total_rows'], PDO::PARAM_INT);

    $stmt->execute();

    if ($resp = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}
 
    
    public function deleteCard($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion");
    }

    $placeholders = rtrim(str_repeat('?,', count($ids)), ',');
    $sql = "DELETE FROM mt_merchant_cc WHERE merchant_id = ? AND mt_id IN ($placeholders)";

    $stmt = $this->db->prepare($sql);

    $params = array_merge([$merchant_id], $ids);

    $resp = $stmt->execute($params);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}


public  function addBroadcast($merchant_id='',$params=array(), $id='')
    {   
        
        
        if($id>0){                        
             

              $up = $this->functions->updateData("mt_mobile2_broadcast", $params, 'broadcast_id', $id);


              if($up){
                 return true;
              } else throw new Exception( "Failed cannot update records" ); 
        } else {   

            if($this->functions->insertData('mt_mobile2_broadcast', $params) ){
                return true;
            } else throw new Exception( "Failed cannot insert records" );
        }       
        
        throw new Exception( "an error has occurred" );
    }  


    public function PushBroadcastList($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {             
        $and = " AND ( 
            push_title LIKE ? 
            OR
            push_message LIKE ?
        )";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        broadcast_id, push_title, push_message, status, date_created
        FROM mt_mobile2_broadcast
        WHERE merchant_id = ? 
        $and
        ORDER BY broadcast_id DESC
        LIMIT ?, ?
    ";

    $query = $this->db->prepare($stmt);

    $params = [$merchant_id, $start, $total_rows];

    if (!empty($search_string)) {
        array_splice($params, 1, 0, ["%$search_string%", "%$search_string%"]);
    }

    $query->execute($params);
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}
  
    
    public function verifyLastBroadcast($merchant_id = '')
{
    $stmt = "SELECT merchant_id, date_created 
             FROM mt_mobile2_broadcast
             WHERE merchant_id = ?
             ORDER BY broadcast_id DESC
             LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->execute([$merchant_id]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        $date_created = date("Y-m-d g:i:s a", strtotime($res['date_created']));
        $date_now = date('Y-m-d g:i:s a');
        $time_diff = $this->functions->dateDifference($date_created, $date_now);

        if (is_array($time_diff) && count($time_diff) >= 1) {
            if ($time_diff['days'] <= 0 && $time_diff['hours'] <= 0) {
                if ($time_diff['minutes'] <= 20) {
                    throw new Exception("Please wait " . (20 - $time_diff['minutes']) . " minutes to send push again");
                }
            }
        }
    }
    return true;
}


public  function inventoryEnabled($merchant_id='')
    {       
        if(empty($merchant_id)){
            return false;
        }   
        if(!is_numeric($merchant_id)){
            return false;
        }   
        
        $inv_enabled = false; 
           
                $inventory_live = $this->functions->getOption('inventory_live',$merchant_id);
                if($inventory_live==1){
                    $inv_enabled = true;                    
                }
         
        return $inv_enabled;
    }
    
    public  function replaceTags($tpl='', $data=array())
    {
        if(is_array($data) && count($data)>=1){
            foreach ($data as $key=>$val) {             
                $tpl = $this->functions->smarty($key,$val,$tpl);
            }
        }
        return $tpl;
    }   

public function AcessFineLocationMessage()
{
    $data = array();
    $title = $this->functions->getOptionAdmin('website_title');

    $data = array(
        'title' => "Allow " . $title . " to access this device location?",
        'content' => "This app collects location data to improve location accuracy when finding nearby Bluetooth printers. Your location can be accessed at any time even when the app is closed or not in use."
    );

    return $data;
}

    
    public  function dayList()
    {
        return array(
          'monday'=>"monday",
          'tuesday'=>"tuesday",
          'wednesday'=>"wednesday",
          'thursday'=>"thursday",
          'friday'=>"friday",
          'saturday'=>"saturday",
          'sunday'=>"sunday"
        );
    }   
 


       






    









    

    
          
}
/*END CLASS*/