<?php
class ReportsWrapper_merchantapp
{

    public function __construct() {
         $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions
       
   
        

    }

public function salesReport($merchant_id = 0, $start = 0, $total_rows = 10,
                            $search_string = '', $start_date = '', $end_date = '', $order_status = '')
{
    $and = '';

    if (!empty($search_string)) {
        $and .= " AND a.size_name LIKE '" . addslashes($search_string) . "%' ";
    }

    if (!empty($start_date) && !empty($end_date)) {
        $and .= " AND CAST(a.date_created as DATE) BETWEEN '" . addslashes($start_date) . "' AND '" . addslashes($end_date) . "' ";
    }

    if (is_array($order_status) && count($order_status) >= 1) {
        $in = '';
        foreach ($order_status as $order_status_val) {
            $in .= "'" . addslashes($order_status_val) . "',";
        }
        $in = rtrim($in, ',');
        $and .= " AND a.status IN ($in) ";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS
            a.order_id, a.customer_name, a.contact_phone, a.profile_customer_name,
            a.trans_type, a.trans_type AS trans_type_raw, 
            a.payment_type, a.payment_type AS payment_type_raw, a.total_amount,
            a.status, a.status AS status_raw, a.date_created,
            a.used_currency,
            (
                SELECT GROUP_CONCAT(item_name)
                FROM mt_order_details
                WHERE order_id = a.order_id
            ) AS item
        FROM mt_view_order a
        WHERE
            merchant_id = " . intval($merchant_id) . "
            AND a.status NOT IN ('initial_order')
            $and
        ORDER BY a.order_id DESC
        LIMIT " . intval($start) . ", " . intval($total_rows) . "
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }

    return false;
}
  



public function salesSummaryReport($merchant_id = 0, $start = 0, $total_rows = 10,
                                   $search_string = '', $start_date = '', $end_date = '', $order_status = '')
{
    $and = '';

    if (!empty($search_string)) {
        $and .= " AND a.item_name LIKE '" . addslashes($search_string) . "%' ";
    }

    if (!empty($start_date) && !empty($end_date)) {
        $and .= " AND CAST(a.date_created as DATE) BETWEEN '" . addslashes($start_date) . "' AND '" . addslashes($end_date) . "' ";
    }

    if (is_array($order_status) && count($order_status) >= 1) {
        $in = '';
        foreach ($order_status as $order_status_val) {
            $in .= "'" . addslashes($order_status_val) . "',";
        }
        $in = rtrim($in, ',');
        $and .= " AND a.status IN ($in) ";
    }

    $select = "a.item_name, a.size, a.size as size_raw,";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS SUM(a.qty) as total_qty,
        a.item_id,
        $select
        IFNULL((
            SELECT price - discount
            FROM mt_view_item_cat
            WHERE item_id = a.item_id
              AND size_id = a.size_id
              AND cat_id = a.cat_id
            LIMIT 0,1
        ),0) as price_raw
        FROM mt_view_order_details a
        WHERE
            merchant_id = " . intval($merchant_id) . "
            AND status NOT IN ('initial_order')
            $and
        GROUP BY item_id, size
        ORDER BY a.item_name ASC
        LIMIT " . intval($start) . ", " . intval($total_rows) . "
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }

    return false;
}
  


public function bookingSummary($merchant_id = 0, $start = 0, $total_rows = 10,
    $search_string = '', $start_date = '', $end_date = '', $order_status = '')
{
    $and = '';

    // Handle search string
    if (!empty($search_string)) {
        $and .= " AND a.item_name LIKE :search_string ";
    }

    // Handle date range
    if (!empty($start_date) && !empty($end_date)) {
        $and .= " AND CAST(a.date_created AS DATE) BETWEEN :start_date AND :end_date ";
    }

    // Handle order status
    if (is_array($order_status) && count($order_status) >= 1) {
        $in = '';
        foreach ($order_status as $order_status_val) {
            $in .= ":order_status_" . $order_status_val . ",";
        }
        $in = rtrim($in, ",");
        $and .= " AND a.status IN ($in) ";
    }

    // SQL query for fetching booking summary
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS SUM(a.number_guest) AS total_approved,
               (
                   SELECT SUM(number_guest)
                   FROM mt_bookingtable
                   WHERE merchant_id = :merchant_id
                   AND status = 'denied'
                   $and
               ) AS total_denied,
               (
                   SELECT SUM(number_guest)
                   FROM mt_bookingtable
                   WHERE merchant_id = :merchant_id
                   AND status = 'pending'
                   $and
               ) AS total_pending
        FROM mt_bookingtable a
        WHERE merchant_id = :merchant_id
        AND status = 'approved'
        $and
        LIMIT :start, :total_rows
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':start', $start, PDO::PARAM_INT);
    $query->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    // Bind additional parameters if they are provided
    if (!empty($search_string)) {
        $search_string_param = $search_string . '%';
        $query->bindParam(':search_string', $search_string_param, PDO::PARAM_STR);
    }
    if (!empty($start_date) && !empty($end_date)) {
        $query->bindParam(':start_date', $start_date, PDO::PARAM_STR);
        $query->bindParam(':end_date', $end_date, PDO::PARAM_STR);
    }

    // Bind order status if available
    if (is_array($order_status) && count($order_status) >= 1) {
        foreach ($order_status as $key => $status) {
            $query->bindValue(":order_status_" . $key, $status, PDO::PARAM_STR);
        }
    }

    // Execute the query
    $query->execute();

    // Fetch and return results
    if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }

    return false;
}

  



    










    
      
}
/*END CLASS*/